/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.etricegen.impl;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.etrice.core.genmodel.etricegen.ETriceGenPackage;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortKind;
import org.eclipse.etrice.core.genmodel.etricegen.SAPInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ServiceImplInstance;
import org.eclipse.etrice.core.genmodel.etricegen.impl.InstanceBaseImpl;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;

public class InterfaceItemInstanceImpl
extends InstanceBaseImpl
implements InterfaceItemInstance {
    protected EList<InterfaceItemInstance> peers;

    protected InterfaceItemInstanceImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ETriceGenPackage.Literals.INTERFACE_ITEM_INSTANCE;
    }

    @Override
    public ProtocolClass getProtocol() {
        ProtocolClass protocol = this.basicGetProtocol();
        return protocol != null && protocol.eIsProxy() ? (ProtocolClass)this.eResolveProxy((InternalEObject)protocol) : protocol;
    }

    public ProtocolClass basicGetProtocol() {
        InterfaceItem item = this.getInterfaceItem();
        if (item instanceof SAPRef) {
            return ((SAPRef)this.getInterfaceItem()).getProtocol();
        }
        if (item instanceof SPPRef) {
            return ((SPPRef)item).getProtocol();
        }
        if (item instanceof Port && ((Port)item).getProtocol() instanceof ProtocolClass) {
            return (ProtocolClass)((Port)item).getProtocol();
        }
        return null;
    }

    @Override
    public EList<InterfaceItemInstance> getPeers() {
        if (this.peers == null) {
            this.peers = new EObjectResolvingEList(InterfaceItemInstance.class, (InternalEObject)this, 6);
        }
        return this.peers;
    }

    @Override
    public boolean isReplicated() {
        if (this instanceof PortInstance) {
            PortInstance pi = (PortInstance)((Object)this);
            if (pi.getKind() == PortKind.RELAY) {
                return false;
            }
            return pi.getPort().getMultiplicity() != 1;
        }
        if (this instanceof SAPInstance) {
            return false;
        }
        if (this instanceof ServiceImplInstance) {
            return true;
        }
        assert (false) : "unexpected sub class";
        return false;
    }

    @Override
    public boolean isSimple() {
        if (this instanceof PortInstance && ((PortInstance)((Object)this)).getKind() == PortKind.RELAY) {
            return false;
        }
        return !this.isReplicated();
    }

    @Override
    public boolean isRelay() {
        return this instanceof PortInstance && ((PortInstance)((Object)this)).getKind() == PortKind.RELAY;
    }

    @Override
    public InterfaceItem getInterfaceItem() {
        if (this instanceof PortInstance) {
            return ((PortInstance)((Object)this)).getPort();
        }
        if (this instanceof SAPInstance) {
            return ((SAPInstance)((Object)this)).getSap();
        }
        if (this instanceof ServiceImplInstance) {
            return ((ServiceImplInstance)((Object)this)).getSvcImpl().getSpp();
        }
        assert (false) : "unexpected sub class";
        return null;
    }

    @Override
    public int getNObjIDs() {
        int n = this.getPeers().size();
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                if (resolve) {
                    return this.getProtocol();
                }
                return this.basicGetProtocol();
            }
            case 6: {
                return this.getPeers();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.getPeers().clear();
                this.getPeers().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.getPeers().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.basicGetProtocol() != null;
            }
            case 6: {
                return this.peers != null && !this.peers.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

