/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.linking;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.scoping.PlatformRelativeUriResolver;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;

public class ImportAwareHyperlinkHelper
extends HyperlinkHelper {
    @Inject
    protected Provider<XtextHyperlink> hyperlinkProvider;
    @Inject
    protected PlatformRelativeUriResolver uriResolver;

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        RuleCall rc;
        AbstractRule rule;
        ILeafNode leaf;
        EObject grammarElement;
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null && parseResult.getRootNode() != null && (grammarElement = (leaf = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)offset)).getParent().getGrammarElement()) instanceof RuleCall && (rule = (rc = (RuleCall)grammarElement).getRule()).getName().equals("Import")) {
            String text = leaf.getText().substring(1, leaf.getText().length() - 1);
            XtextHyperlink result = (XtextHyperlink)this.hyperlinkProvider.get();
            result.setHyperlinkRegion(new Region(leaf.getOffset() + 1, leaf.getLength() - 2));
            String uritext = this.uriResolver.resolve(text, resource.getURI());
            URI uri = URI.createURI((String)uritext);
            result.setURI(uri);
            result.setHyperlinkText(text);
            acceptor.accept((IHyperlink)result);
        }
        super.createHyperlinksByOffset(resource, offset, acceptor);
    }
}

