/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.outline;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.ui.outline.ExtraOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;

public class RoomOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    private static final String STATE_MACHINE_LABEL = "StateMachine";
    private static final String BEHAVIOR_LABEL = "Behavior";
    private static final String STRUCTURE_LABEL = "Structure";
    private static final String INTERFACE_LABEL = "Interface";
    private static final Object INCOMING_LABEL = "incoming";
    private static final Object OUTGOING_LABEL = "outgoing";
    private static final Object REG_PORT_CLASS_LABEL = "regular port class";
    private static final Object CONJ_PORT_CLASS_LABEL = "conjugated port class";

    protected boolean _isLeaf(ActorClass ac) {
        if (ac.getIfPorts().size() > 0 || ac.getIfSPPs().size() > 0) {
            return false;
        }
        if (ac.getIntPorts().size() > 0 || ac.getServiceImplementations().size() > 0 || ac.getStrSAPs().size() > 0 || ac.getAttributes().size() > 0 || ac.getActorRefs().size() > 0) {
            return false;
        }
        return ac.getOperations().size() <= 0 && ac.getStateMachine() == null;
    }

    protected void _createChildren(IOutlineNode parentNode, ActorClass ac) {
        if (ac.getIfPorts().size() > 0 || ac.getIfSPPs().size() > 0) {
            new ExtraOutlineNode((EObject)ac, parentNode, INTERFACE_LABEL);
        }
        if (ac.getIntPorts().size() > 0 || ac.getExtPorts().size() > 0 || ac.getServiceImplementations().size() > 0 || ac.getStrSAPs().size() > 0 || ac.getAttributes().size() > 0 || ac.getActorRefs().size() > 0) {
            new ExtraOutlineNode((EObject)ac, parentNode, STRUCTURE_LABEL);
        }
        if (ac.getOperations().size() > 0 || ac.getStateMachine() != null) {
            new ExtraOutlineNode((EObject)ac, parentNode, BEHAVIOR_LABEL);
        }
    }

    protected void _createChildren(ExtraOutlineNode parentNode, ActorClass ac) {
        block12: {
            block14: {
                block13: {
                    block11: {
                        if (!parentNode.getText().equals(INTERFACE_LABEL)) break block11;
                        for (Port port : ac.getIfPorts()) {
                            this.createNode((IOutlineNode)parentNode, (EObject)port);
                        }
                        for (SPPRef spp : ac.getIfSPPs()) {
                            this.createNode((IOutlineNode)parentNode, (EObject)spp);
                        }
                        break block12;
                    }
                    if (!parentNode.getText().equals(STRUCTURE_LABEL)) break block13;
                    for (Port port : ac.getIntPorts()) {
                        this.createNode((IOutlineNode)parentNode, (EObject)port);
                    }
                    for (Port port : ac.getExtPorts()) {
                        this.createNode((IOutlineNode)parentNode, (EObject)port.getIfport());
                    }
                    for (ServiceImplementation svc : ac.getServiceImplementations()) {
                        this.createNode((IOutlineNode)parentNode, (EObject)svc);
                    }
                    for (SAPRef sap : ac.getStrSAPs()) {
                        this.createNode((IOutlineNode)parentNode, (EObject)sap);
                    }
                    for (Attribute attr : ac.getAttributes()) {
                        this.createNode((IOutlineNode)parentNode, (EObject)attr);
                    }
                    for (ActorRef ar : ac.getActorRefs()) {
                        this.createNode((IOutlineNode)parentNode, (EObject)ar);
                    }
                    break block12;
                }
                if (!parentNode.getText().equals(BEHAVIOR_LABEL)) break block14;
                for (Operation op : ac.getOperations()) {
                    this.createNode((IOutlineNode)parentNode, (EObject)op);
                }
                if (ac.getStateMachine() == null) break block12;
                new ExtraOutlineNode((EObject)ac, (IOutlineNode)parentNode, STATE_MACHINE_LABEL);
                break block12;
            }
            if (parentNode.getText().equals(STATE_MACHINE_LABEL)) {
                for (State s : ac.getStateMachine().getStates()) {
                    this.createNode((IOutlineNode)parentNode, (EObject)s);
                }
            }
        }
    }

    protected boolean _isLeaf(SubSystemClass ssc) {
        return ssc.getActorRefs().isEmpty();
    }

    protected void _createChildren(IOutlineNode parentNode, SubSystemClass ssc) {
        for (ActorRef aref : ssc.getActorRefs()) {
            this.createNode(parentNode, (EObject)aref);
        }
    }

    protected void _createChildren(IOutlineNode parentNode, State s) {
        if (s.getSubgraph() != null) {
            for (State state : s.getSubgraph().getStates()) {
                this.createNode(parentNode, (EObject)state);
            }
        }
    }

    protected boolean _isLeaf(State s) {
        return s.getSubgraph() == null || s.getSubgraph().getStates().isEmpty();
    }

    protected void _createChildren(IOutlineNode parentNode, ProtocolClass pc) {
        if (pc.getIncomingMessages().size() > 0) {
            new ExtraOutlineNode((EObject)pc, parentNode, INCOMING_LABEL);
        }
        if (pc.getOutgoingMessages().size() > 0) {
            new ExtraOutlineNode((EObject)pc, parentNode, OUTGOING_LABEL);
        }
        if (pc.getRegular() != null) {
            new ExtraOutlineNode((EObject)pc, parentNode, REG_PORT_CLASS_LABEL);
        }
        if (pc.getConjugate() != null) {
            new ExtraOutlineNode((EObject)pc, parentNode, CONJ_PORT_CLASS_LABEL);
        }
    }

    protected void _createChildren(ExtraOutlineNode parentNode, ProtocolClass pc) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (!parentNode.getText().equals(INCOMING_LABEL)) break block6;
                        for (Message m : pc.getIncomingMessages()) {
                            this.createNode((IOutlineNode)parentNode, (EObject)m);
                        }
                        break block7;
                    }
                    if (!parentNode.getText().equals(OUTGOING_LABEL)) break block8;
                    for (Message m : pc.getOutgoingMessages()) {
                        this.createNode((IOutlineNode)parentNode, (EObject)m);
                    }
                    break block7;
                }
                if (!parentNode.getText().equals(REG_PORT_CLASS_LABEL)) break block9;
                for (Attribute att : pc.getRegular().getAttributes()) {
                    this.createNode((IOutlineNode)parentNode, (EObject)att);
                }
                for (PortOperation op : pc.getRegular().getOperations()) {
                    this.createNode((IOutlineNode)parentNode, (EObject)op);
                }
                break block7;
            }
            if (!parentNode.getText().equals(CONJ_PORT_CLASS_LABEL)) break block7;
            for (Attribute att : pc.getConjugate().getAttributes()) {
                this.createNode((IOutlineNode)parentNode, (EObject)att);
            }
            for (PortOperation op : pc.getConjugate().getOperations()) {
                this.createNode((IOutlineNode)parentNode, (EObject)op);
            }
        }
    }

    protected boolean _isLeaf(Message m) {
        return true;
    }

    protected boolean _isLeaf(Operation o) {
        return true;
    }

    protected boolean _isLeaf(Attribute ac) {
        return true;
    }
}

