/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.scoping;

import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;

public class PlatformRelativeUriResolver
extends ImportUriResolver {
    private Map<String, String> env = System.getenv();

    public String resolve(EObject object) {
        String resolve = super.resolve(object);
        if (resolve == null || resolve.trim().isEmpty()) {
            return null;
        }
        URI baseUri = object.eResource() == null ? null : object.eResource().getURI();
        resolve = this.resolve(resolve, baseUri);
        return resolve;
    }

    public String resolve(String resolve, URI baseUri) {
        resolve = this.substituteEnvVars(resolve);
        resolve = resolve.replaceAll("\\\\", "/");
        resolve = resolve.replaceAll("//", "/");
        if (baseUri != null) {
            resolve = this.resolveUriAgainstBase(resolve, baseUri);
        }
        return resolve;
    }

    public String substituteEnvVars(String text) {
        String pattern = "\\$\\{([A-Za-z0-9_]+)\\}";
        Pattern expr = Pattern.compile(pattern);
        Matcher matcher = expr.matcher(text);
        while (matcher.find()) {
            String envValue = this.env.get(matcher.group(1));
            envValue = envValue == null ? "" : envValue.replace("\\", "\\\\");
            Pattern subexpr = Pattern.compile(Pattern.quote(matcher.group(0)));
            text = subexpr.matcher(text).replaceAll(envValue);
        }
        return text;
    }

    private String resolveUriAgainstBase(String resolve, URI baseUri) {
        if (resolve == null || resolve.trim().isEmpty()) {
            return null;
        }
        URI uri = URI.createURI((String)resolve);
        if (uri.isRelative()) {
            URI base = baseUri.trimSegments(1);
            if (base.isPlatformResource()) {
                Path basePath = new Path(base.toPlatformString(true));
                if (basePath.segmentCount() < 2) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(basePath.lastSegment());
                    String abs = project.getRawLocationURI().toString();
                    base = URI.createURI((String)abs);
                } else {
                    IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)basePath);
                    String abs = folder.getRawLocationURI().toString();
                    base = URI.createURI((String)abs);
                }
            } else if (base.isRelative()) {
                base = URI.createFileURI((String)new File(base.toString()).getAbsolutePath());
            }
            base = base.appendSegment("");
            try {
                uri = uri.resolve(base);
            }
            catch (IllegalArgumentException basePath) {
                // empty catch block
            }
            resolve = uri.toString();
            File file = new File(uri.toFileString());
            if (file.isDirectory()) {
                return "path/to/directory";
            }
        }
        return resolve;
    }
}

