/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.scoping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.ChoicepointTerminal;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.InMessageHandler;
import org.eclipse.etrice.core.room.InSemanticsRule;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.OutMessageHandler;
import org.eclipse.etrice.core.room.OutSemanticsRule;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RefinedTransition;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.SemanticsRule;
import org.eclipse.etrice.core.room.SimpleState;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateTerminal;
import org.eclipse.etrice.core.room.SubProtocol;
import org.eclipse.etrice.core.room.SubStateTrPointTerminal;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.TrPointTerminal;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class RoomScopeProvider
extends AbstractDeclarativeScopeProvider {
    public static final String STATE_PATH_DELIMITER = ".";

    private StateGraph getStateGraph(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof StateGraph) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof StateGraph) {
            return (StateGraph)ctx;
        }
        return null;
    }

    private ActorClass getActorClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof ActorClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof ActorClass) {
            return (ActorClass)ctx;
        }
        return null;
    }

    private ActorContainerClass getActorContainerClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof ActorContainerClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof ActorContainerClass) {
            return (ActorContainerClass)ctx;
        }
        return null;
    }

    private boolean isContained(Port p, EList<ExternalPort> ports) {
        for (ExternalPort port : ports) {
            if (port.getIfport() != p) continue;
            return true;
        }
        return false;
    }

    private QualifiedName getStatePath(State bs) {
        State target;
        EObject parent = bs.eContainer().eContainer();
        if (parent instanceof SimpleState) {
            return this.getStatePath((SimpleState)parent).append(bs.getName());
        }
        if (parent instanceof RefinedState && (target = ((RefinedState)parent).getTarget()) != null) {
            return this.getStatePath(target).append(bs.getName());
        }
        return QualifiedName.create((String)bs.getName());
    }

    private LinkedList<ActorClass> getBaseClasses(ActorClass ac) {
        LinkedList<ActorClass> classes = new LinkedList<ActorClass>();
        if (ac != null) {
            classes.addFirst(ac);
            while (ac.getBase() != null) {
                if (ac == ac.getBase()) break;
                ac = ac.getBase();
                classes.addFirst(ac);
            }
        }
        return classes;
    }

    private LinkedList<ProtocolClass> getBaseClasses(ProtocolClass pc) {
        LinkedList<ProtocolClass> classes = new LinkedList<ProtocolClass>();
        classes.addFirst(pc);
        while (pc.getBase() != null) {
            pc = pc.getBase();
            classes.addFirst(pc);
        }
        return classes;
    }

    public IScope scope_StateTerminal_state(StateTerminal st, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        StateGraph parent = this.getStateGraph(st);
        this.getStateScopes(parent, scopes);
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    private void getStateScopes(StateGraph parent, List<IEObjectDescription> scopes) {
        List<State> states = RoomHelpers.getAllStates(parent);
        HashMap<String, SimpleState> name2state = new HashMap<String, SimpleState>();
        for (State state : states) {
            name2state.put(state.getName(), RoomHelpers.getBaseState(state));
        }
        for (Map.Entry entry : name2state.entrySet()) {
            scopes.add(EObjectDescription.create((String)((String)entry.getKey()), (EObject)((EObject)entry.getValue())));
        }
    }

    public IScope scope_TrPointTerminal_trPoint(TrPointTerminal ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        StateGraph parent = this.getStateGraph(ep);
        List<TrPoint> tps = RoomHelpers.getAllTrPoints(parent);
        for (TrPoint tp : tps) {
            scopes.add(EObjectDescription.create((String)tp.getName(), (EObject)tp));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SubStateTrPointTerminal_trPoint(SubStateTrPointTerminal ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        StateGraph parent = this.getStateGraph(ep);
        if (ep.getState() != null) {
            State epState = ep.getState();
            if ((epState = RoomHelpers.getRefinedStateFor(parent, epState)).getSubgraph() != null) {
                List<TrPoint> tps = RoomHelpers.getAllTrPoints(epState.getSubgraph());
                for (TrPoint tp : tps) {
                    scopes.add(EObjectDescription.create((String)tp.getName(), (EObject)tp));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SubStateTrPointTerminal_state(SubStateTrPointTerminal st, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        StateGraph parent = this.getStateGraph(st);
        this.getStateScopes(parent, scopes);
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_ChoicepointTerminal_cp(ChoicepointTerminal ct, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        StateGraph parent = this.getStateGraph(ct);
        List<ChoicePoint> choicePoints = RoomHelpers.getAllChoicePoints(parent);
        for (ChoicePoint cp : choicePoints) {
            scopes.add(EObjectDescription.create((String)cp.getName(), (EObject)cp));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_MessageFromIf_message(MessageFromIf mfi, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        InterfaceItem item = mfi.getFrom();
        if (item != null) {
            ProtocolClass protocol = null;
            boolean conjugated = false;
            if (item instanceof Port && ((Port)item).getProtocol() instanceof ProtocolClass) {
                protocol = (ProtocolClass)((Port)item).getProtocol();
                conjugated = ((Port)item).isConjugated();
            } else if (item instanceof SAPRef) {
                protocol = ((SAPRef)item).getProtocol();
                conjugated = true;
            } else if (item instanceof SPPRef) {
                protocol = ((SPPRef)item).getProtocol();
                conjugated = false;
            }
            if (protocol != null) {
                for (Message msg : conjugated ? protocol.getOutgoingMessages() : protocol.getIncomingMessages()) {
                    scopes.add(EObjectDescription.create((String)msg.getName(), (EObject)msg));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_MessageFromIf_port(MessageFromIf mfi, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(mfi);
        for (Object p : ac.getIntPorts()) {
            scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
        }
        for (Object p : ac.getExtPorts()) {
            scopes.add(EObjectDescription.create((String)p.getIfport().getName(), (EObject)p.getIfport()));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_MessageFromIf_from(MessageFromIf mfi, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(mfi);
        List<InterfaceItem> items = RoomHelpers.getAllInterfaceItems(ac);
        for (InterfaceItem item : items) {
            scopes.add(EObjectDescription.create((String)item.getName(), (EObject)item));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_BindingEndPoint_actorRef(BindingEndPoint ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorContainerClass sc = this.getActorContainerClass(ep);
        if (sc instanceof ActorClass) {
            LinkedList<ActorClass> classes = this.getBaseClasses((ActorClass)sc);
            for (ActorClass a : classes) {
                for (ActorRef ar : a.getActorRefs()) {
                    scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
                }
            }
        } else {
            for (ActorRef ar : sc.getActorRefs()) {
                scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_BindingEndPoint_port(BindingEndPoint ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes;
        block9: {
            block8: {
                scopes = new ArrayList<IEObjectDescription>();
                ActorContainerClass acc = this.getActorContainerClass(ep);
                if (ep.getActorRef() != null) break block8;
                if (!(acc instanceof ActorClass)) break block9;
                ActorClass ac = (ActorClass)acc;
                LinkedList<ActorClass> classes = this.getBaseClasses(ac);
                for (ActorClass a : classes) {
                    for (Port p : a.getIntPorts()) {
                        scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                    }
                    for (Port p : a.getIfPorts()) {
                        if (this.isContained(p, a.getExtPorts())) continue;
                        scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                    }
                }
                break block9;
            }
            if (ep.getActorRef() instanceof ActorRef) {
                ActorClass ac = ((ActorRef)ep.getActorRef()).getType();
                LinkedList<ActorClass> classes = this.getBaseClasses(ac);
                for (ActorClass a : classes) {
                    for (Port p : a.getIfPorts()) {
                        scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                    }
                }
            } else {
                SubSystemClass ssc = ((SubSystemRef)ep.getActorRef()).getType();
                for (Port p : ssc.getRelayPorts()) {
                    scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_BindingEndPoint_sub(BindingEndPoint ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        if (ep.getPort() != null && ep.getPort().getProtocol() instanceof CompoundProtocolClass) {
            CompoundProtocolClass pc = (CompoundProtocolClass)ep.getPort().getProtocol();
            for (SubProtocol sub : pc.getSubProtocols()) {
                scopes.add(EObjectDescription.create((String)sub.getName(), (EObject)sub));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_RefinedState_target(RefinedState rs, EReference ref) {
        ArrayList<IEObjectDescription> scopes;
        block5: {
            StateGraph sg;
            block4: {
                scopes = new ArrayList<IEObjectDescription>();
                ActorClass ac = this.getActorClass(rs);
                sg = this.getStateGraph(rs);
                if (!(sg.eContainer() instanceof ActorClass)) break block4;
                if (ac.getBase() == null) break block5;
                ac = ac.getBase();
                HashSet<State> covered = new HashSet<State>();
                ArrayList<State> states = new ArrayList<State>();
                while (ac != null) {
                    this.recursivelyAddStates(ac.getStateMachine(), covered, states);
                    ac = ac.getBase();
                }
                for (State s : states) {
                    scopes.add(EObjectDescription.create((QualifiedName)this.getStatePath(s), (EObject)s));
                }
                break block5;
            }
            if (sg.eContainer() instanceof RefinedState && (sg = ((RefinedState)sg.eContainer()).getTarget().getSubgraph()) != null) {
                for (State s : sg.getStates()) {
                    scopes.add(EObjectDescription.create((String)s.getName(), (EObject)s));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_RefinedTransition_target(RefinedTransition trans, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(trans);
        ac = ac.getBase();
        while (ac != null) {
            if (ac.getStateMachine() != null) {
                TreeIterator it = ac.getStateMachine().eAllContents();
                while (it.hasNext()) {
                    EObject obj = (EObject)it.next();
                    if (!(obj instanceof Transition)) continue;
                    scopes.add(EObjectDescription.create((String)((Transition)obj).getName(), (EObject)obj));
                }
            }
            ac = ac.getBase();
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    private void recursivelyAddStates(StateGraph sg, HashSet<State> covered, ArrayList<State> states) {
        for (State s : sg.getStates()) {
            if (s instanceof SimpleState && !covered.contains(s)) {
                states.add(s);
                continue;
            }
            if (!(s instanceof RefinedState) || covered.contains(s)) continue;
            states.add(s);
            covered.add(((RefinedState)s).getTarget());
        }
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.recursivelyAddStates(s.getSubgraph(), covered, states);
        }
    }

    public IScope scope_SemanticsRule_msg(SemanticsRule sr, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ProtocolClass pc = RoomHelpers.getProtocolClass(sr);
        LinkedList<ProtocolClass> classes = this.getBaseClasses(pc);
        for (ProtocolClass bpc : classes) {
            if (sr instanceof InSemanticsRule) {
                for (Message m : bpc.getIncomingMessages()) {
                    scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
                }
            }
            if (!(sr instanceof OutSemanticsRule)) continue;
            for (Message m : bpc.getOutgoingMessages()) {
                scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_RefSAPoint_ref(RefSAPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorContainerClass acc = this.getActorContainerClass(pt);
        if (acc instanceof ActorClass) {
            LinkedList<ActorClass> classes = this.getBaseClasses((ActorClass)acc);
            for (ActorClass a : classes) {
                for (ActorRef ar : a.getActorRefs()) {
                    scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
                }
            }
        } else {
            for (ActorRef ar : acc.getActorRefs()) {
                scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_RelaySAPoint_relay(RelaySAPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(pt);
        LinkedList<ActorClass> classes = this.getBaseClasses(ac);
        for (ActorClass a : classes) {
            for (SPPRef spp : a.getIfSPPs()) {
                scopes.add(EObjectDescription.create((String)spp.getName(), (EObject)spp));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SPPoint_actorRef(SPPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorContainerClass acc = this.getActorContainerClass(pt);
        if (acc instanceof ActorClass) {
            LinkedList<ActorClass> classes = this.getBaseClasses((ActorClass)acc);
            for (ActorClass a : classes) {
                for (ActorRef ar : a.getActorRefs()) {
                    scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
                }
            }
        } else {
            for (ActorRef ar : acc.getActorRefs()) {
                scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SPPoint_service(SPPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes;
        block3: {
            block4: {
                scopes = new ArrayList<IEObjectDescription>();
                if (pt.getRef() == null) break block3;
                if (!(pt.getRef() instanceof ActorRef)) break block4;
                ActorClass ac = ((ActorRef)pt.getRef()).getType();
                LinkedList<ActorClass> classes = this.getBaseClasses(ac);
                for (ActorClass a : classes) {
                    for (SPPRef spp : a.getIfSPPs()) {
                        scopes.add(EObjectDescription.create((String)spp.getName(), (EObject)spp));
                    }
                }
                break block3;
            }
            if (!(pt.getRef() instanceof SubSystemRef)) break block3;
            SubSystemClass ssc = ((SubSystemRef)pt.getRef()).getType();
            for (SPPRef spp : ssc.getIfSPPs()) {
                scopes.add(EObjectDescription.create((String)spp.getName(), (EObject)spp));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_MessageHandler_msg(MessageHandler handler, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ProtocolClass pc = RoomHelpers.getProtocolClass(handler);
        if (pc != null) {
            if (handler instanceof InMessageHandler) {
                for (Message m : pc.getIncomingMessages()) {
                    scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
                }
            }
            if (handler instanceof OutMessageHandler) {
                for (Message m : pc.getOutgoingMessages()) {
                    scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_PortOperation_sendsMsg(PortOperation op, EReference ref) {
        ArrayList<IEObjectDescription> scopes;
        block4: {
            scopes = new ArrayList<IEObjectDescription>();
            PortClass pcls = (PortClass)op.eContainer();
            ProtocolClass pc = RoomHelpers.getProtocolClass(op);
            if (pc == null) break block4;
            if (pcls == pc.getConjugate()) {
                for (Message m : pc.getIncomingMessages()) {
                    scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
                }
            } else {
                for (Message m : pc.getOutgoingMessages()) {
                    scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_ExternalPort_ifport(ExternalPort ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(ep);
        for (Port ip : ac.getIfPorts()) {
            scopes.add(EObjectDescription.create((String)ip.getName(), (EObject)ip));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }
}

