/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorInstancePath;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Import;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RefinedTransition;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SimpleState;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.validation.AbstractRoomJavaValidator;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.validation.Check;

public class RoomJavaValidator
extends AbstractRoomJavaValidator {
    @Inject
    ImportUriResolver importUriResolver;

    @Check
    public void checkImportedNamespace(Import imp) {
        if (imp.getImportedNamespace() == null) {
            return;
        }
        if (imp.getImportURI() == null) {
            return;
        }
        String uriString = this.importUriResolver.resolve((EObject)imp);
        URI uri = URI.createURI((String)uriString);
        ResourceSetImpl rs = new ResourceSetImpl();
        try {
            Resource res = rs.getResource(uri, true);
            if (res == null) {
                return;
            }
            if (res.getContents().isEmpty()) {
                this.error("referenced model is empty", (EStructuralFeature)RoomPackage.Literals.IMPORT__IMPORT_URI);
                return;
            }
            if (!(res.getContents().get(0) instanceof RoomModel)) {
                if (uri.lastSegment().endsWith(".room")) {
                    this.error("referenced model is no ROOM model (but has .room extension)", (EStructuralFeature)RoomPackage.Literals.IMPORT__IMPORT_URI);
                } else {
                    this.warning("referenced model is no ROOM model", (EStructuralFeature)RoomPackage.Literals.IMPORT__IMPORT_URI);
                }
                return;
            }
            RoomModel model = (RoomModel)res.getContents().get(0);
            if (!imp.getImportedNamespace().equals(String.valueOf(model.getName()) + ".*")) {
                this.error("the imported namespace should be '" + model.getName() + ".*'", (EStructuralFeature)RoomPackage.Literals.IMPORT__IMPORTED_NAMESPACE);
            }
        }
        catch (RuntimeException re) {
            this.warning("could not load referenced model", (EStructuralFeature)RoomPackage.Literals.IMPORT__IMPORT_URI);
            return;
        }
    }

    @Check
    public void checkTypeNameStartsWithCapital(RoomClass type) {
        if (type instanceof PrimitiveType || type instanceof ExternalType) {
            return;
        }
        if (!Character.isUpperCase(type.getName().charAt(0))) {
            this.warning("Name should start with a capital", (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
        }
    }

    @Check
    public void checkActorRefIsNotCircular(ActorRef ar) {
        if (ar.eContainer() instanceof ActorClass) {
            ActorClass ac = (ActorClass)ar.eContainer();
            if (ValidationUtil.isReferencing(ar.getType(), ac)) {
                this.error("Actor reference is circular", (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_Type());
            }
        }
    }

    @Check
    public void checkRefHasFixedMultiplicityPorts(ActorRef ar) {
        if (ar.getSize() > 1) {
            ActorClass ac = ar.getType();
            if (ar != null) {
                for (Port p : ac.getIfPorts()) {
                    if (p.getMultiplicity() >= 0) continue;
                    int idx = ((ActorContainerClass)ar.eContainer()).getActorRefs().indexOf((Object)ar);
                    this.error("replicated actor must not have replicated port with arbitrary multiplicity", (EStructuralFeature)RoomPackage.Literals.ACTOR_CONTAINER_CLASS__ACTOR_REFS, idx);
                }
            }
        }
    }

    @Check
    public void checkLayerConnectiontarget(LayerConnection lc) {
        if (lc.getTo().getRef() instanceof ActorRef && ((ActorRef)lc.getTo().getRef()).getSize() > 1) {
            int idx = ((StructureClass)lc.eContainer()).getConnections().indexOf((Object)lc);
            this.error("layer connection must not connect to replicated actor", (EStructuralFeature)RoomPackage.Literals.STRUCTURE_CLASS__CONNECTIONS, idx);
        }
    }

    @Check
    public void checkBaseClassesNotCircular(DataClass dc) {
        if (dc == null) {
            return;
        }
        if (ValidationUtil.isCircularClassHierarchy(dc)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getDataClass_Base());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Check
    public void checkAttributeNotCircular(Attribute att) {
        if (att.eContainer() instanceof ActorClass) {
            return;
        }
        if (att.eContainer() instanceof PortClass) {
            return;
        }
        if (!(att.eContainer() instanceof DataClass)) {
            if (!RoomJavaValidator.$assertionsDisabled) {
                throw new AssertionError((Object)"unexpected parent class");
            }
            return;
        }
        dc = (DataClass)att.eContainer();
        if (!ValidationUtil.isCircularClassHierarchy(dc)) ** GOTO lbl15
        return;
lbl-1000:
        // 1 sources

        {
            if (att.getRefType().getType() == dc) {
                this.error("Attribute type must not refer to own class or a super class", (EStructuralFeature)RoomPackage.Literals.ATTRIBUTE__REF_TYPE);
            }
            dc = dc.getBase();
lbl15:
            // 2 sources

            ** while (dc != null)
        }
lbl16:
        // 1 sources

    }

    @Check
    public void checkBaseClassesNotCircular(ProtocolClass pc) {
        if (pc == null) {
            return;
        }
        if (ValidationUtil.isCircularClassHierarchy(pc)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getProtocolClass_Base());
        }
    }

    @Check
    public void checkBaseClassesNotCircular(ActorClass ac) {
        if (ac == null) {
            return;
        }
        if (ValidationUtil.isCircularClassHierarchy(ac)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_Base());
        }
    }

    @Check
    public void checkExecModelConsistent(ActorClass ac) {
        if (ValidationUtil.isCircularClassHierarchy(ac)) {
            return;
        }
        ActorCommunicationType commType = ac.getCommType();
        while (ac.getBase() != null) {
            if (commType == (ac = ac.getBase()).getCommType()) continue;
            this.error("data_driven attribute not consistent in inheritance hierarchy", (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_CommType());
        }
    }

    @Check
    public void checkTopLevelRefinedStates(ActorClass ac) {
        List<ValidationUtil.Result> errors = ValidationUtil.checkTopLevelRefinedStates(ac);
        for (ValidationUtil.Result err : errors) {
            this.error(err);
        }
    }

    @Check
    public void checkRefinedStateUnique(RefinedState rs) {
        StateGraph sg = (StateGraph)rs.eContainer();
        TreeIterator it = sg.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj == rs || !(obj instanceof RefinedState) || rs.getTarget() != ((RefinedState)obj).getTarget()) continue;
            if (rs.eContainer().eContainer() instanceof ActorClass) {
                this.error("refined state conflicts with nested refined state with same target", (EStructuralFeature)RoomPackage.Literals.REFINED_STATE__TARGET);
                continue;
            }
            this.error("refined state not unique", (EStructuralFeature)RoomPackage.Literals.REFINED_STATE__TARGET);
        }
    }

    @Check
    public void checkStateNameUnique(SimpleState s) {
        ValidationUtil.Result result = ValidationUtil.isUniqueName(s, s.getName());
        if (!result.isOk()) {
            this.error(result.getMsg(), (EStructuralFeature)RoomPackage.Literals.SIMPLE_STATE__NAME);
        }
    }

    private SubSystemClass getSubSystemClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof SubSystemClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof SubSystemClass) {
            return (SubSystemClass)ctx;
        }
        return null;
    }

    @Check
    public void checkSubSystem(SubSystemClass ssc) {
        if (ssc.getActorRefs().isEmpty()) {
            this.warning("SubSystemClass must contain at least one ActorRef", (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_ActorRefs());
        }
    }

    @Check
    public void checkLogicalSystem(LogicalSystem ls) {
        if (ls.getSubSystems().isEmpty()) {
            this.error("LogicalSystem must contain at least one SubSystemRef", (EStructuralFeature)RoomPackage.eINSTANCE.getLogicalSystem_SubSystems());
        }
    }

    @Check
    public void checkInstancePath(ActorInstancePath ai) {
        ActorContainerClass acc = this.getSubSystemClass(ai);
        for (String seg : ai.getSegments()) {
            boolean found = false;
            for (ActorRef ar : acc.getActorRefs()) {
                if (!ar.getName().equals(seg)) continue;
                acc = ar.getType();
                found = true;
                break;
            }
            if (found) continue;
            this.error("wrong actor instance path (segment number " + ai.getSegments().indexOf((Object)seg) + ")", (EStructuralFeature)RoomPackage.eINSTANCE.getActorInstancePath_Segments());
        }
    }

    @Check
    public void checkPortCompatibility(Binding bind) {
        ValidationUtil.Result result = ValidationUtil.isValid(bind);
        if (!result.isOk()) {
            EObject sc = bind.eContainer();
            int idx = ((List)sc.eGet(bind.eContainingFeature())).indexOf(bind);
            this.error(result.getMsg(), sc, bind.eContainingFeature(), idx);
        }
    }

    @Check
    public void checkServiceCompatibility(LayerConnection conn) {
        ValidationUtil.Result result = ValidationUtil.isValid(conn);
        if (!result.isOk()) {
            this.error(result.getMsg(), (EStructuralFeature)RoomPackage.eINSTANCE.getLayerConnection_From());
        }
    }

    @Check
    public void checkTrPoint(TrPoint tp) {
        ValidationUtil.Result result = ValidationUtil.isValid(tp);
        if (!result.isOk()) {
            this.error(result);
        }
    }

    @Check
    public void checkChoicePoint(ChoicePoint cp) {
        if (!ValidationUtil.isUniqueName(cp, cp.getName()).isOk()) {
            this.error("name is not unique", (EStructuralFeature)RoomPackage.Literals.CHOICE_POINT__NAME);
        }
    }

    @Check
    public void checkInterfaceItemUniqueName(InterfaceItem item) {
        ValidationUtil.Result result = ValidationUtil.isUniqueName(item);
        if (!result.isOk()) {
            this.error(result.getMsg(), (EStructuralFeature)RoomPackage.eINSTANCE.getInterfaceItem_Name());
        }
    }

    @Check
    public void checkTransition(Transition trans) {
        ValidationUtil.Result result = ValidationUtil.checkTransition(trans);
        if (!result.isOk()) {
            this.error(result);
        }
        if (!(result = trans instanceof InitialTransition ? ValidationUtil.isConnectable(null, trans.getTo(), trans, (StateGraph)trans.eContainer()) : ValidationUtil.isConnectable(((NonInitialTransition)trans).getFrom(), trans.getTo(), trans, (StateGraph)trans.eContainer())).isOk()) {
            this.error(result);
        }
    }

    @Check
    public void checkState(State state) {
        ValidationUtil.Result result = ValidationUtil.checkState(state);
        if (!result.isOk()) {
            this.error(result);
        }
    }

    @Check
    public void checkPort(Port port) {
        if (port.getMultiplicity() == 0) {
            this.error("multiplicity must not be 0", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
        if (port.getMultiplicity() < -1) {
            this.error("multiplicity must be -1 or positive", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
        if (port.getProtocol() instanceof ProtocolClass && ((ProtocolClass)port.getProtocol()).getCommType() == CommunicationType.DATA_DRIVEN && port.getMultiplicity() != 1) {
            this.error("multiplicity must be 1 for data driven ports", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
    }

    @Check
    public void checkProtocol(ProtocolClass pc) {
        switch (pc.getCommType()) {
            case DATA_DRIVEN: {
                if (pc.getBase() != null && pc.getBase().getCommType() != CommunicationType.DATA_DRIVEN) {
                    this.error("super protocol has to have same communication type", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
                }
                if (RoomHelpers.getAllMessages(pc, true).isEmpty()) {
                    this.error("at least one incoming message must be defined", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__INCOMING_MESSAGES);
                }
                if (RoomHelpers.getAllMessages(pc, false).isEmpty()) break;
                this.error("data driven protocols must have no outgoing messages", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__OUTGOING_MESSAGES);
                break;
            }
            case EVENT_DRIVEN: {
                if (pc.getBase() != null && pc.getBase().getCommType() != CommunicationType.EVENT_DRIVEN) {
                    this.error("super protocol has to have same communication type", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
                }
                if (!RoomHelpers.getAllMessages(pc, true).isEmpty() || !RoomHelpers.getAllMessages(pc, false).isEmpty()) break;
                this.error("at least one message (incoming or outgoing) must be defined", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__INCOMING_MESSAGES);
                break;
            }
            case SYNCHRONOUS: {
                this.error("synchronous communication type not supported yet", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
            }
        }
    }

    @Check
    public void checkMessage(Message msg) {
        ProtocolClass pc = (ProtocolClass)msg.eContainer();
        if (pc.getCommType() == CommunicationType.DATA_DRIVEN && msg.getData() == null) {
            this.error("Messages of data driven protocols must carry data", (EStructuralFeature)RoomPackage.Literals.MESSAGE__DATA);
        }
    }

    @Check
    public void checkOperation(StandardOperation op) {
        if (RoomHelpers.isConstructor(op)) {
            if (!op.getArguments().isEmpty()) {
                this.error("Constructor must have no arguments", (EStructuralFeature)RoomPackage.Literals.OPERATION__ARGUMENTS);
            }
            if (op.getReturntype() != null) {
                this.error("Constructor must have no return type", (EStructuralFeature)RoomPackage.Literals.OPERATION__RETURNTYPE);
            }
        } else if (RoomHelpers.isDestructor(op)) {
            if (!op.getArguments().isEmpty()) {
                this.error("Destructor must have no arguments", (EStructuralFeature)RoomPackage.Literals.OPERATION__ARGUMENTS);
            }
            if (op.getReturntype() != null) {
                this.error("Destructor must have no return type", (EStructuralFeature)RoomPackage.Literals.OPERATION__RETURNTYPE);
            }
        } else if (op.isDestructor()) {
            this.error("Destructor must have class name", (EStructuralFeature)RoomPackage.Literals.OPERATION__RETURNTYPE);
        }
    }

    @Check
    public void checkRefinedTransition(RefinedTransition rt) {
        if (!(rt.eContainer().eContainer() instanceof ActorClass)) {
            StateGraph sg = (StateGraph)rt.eContainer();
            int idx = sg.getRefinedTransitions().indexOf((Object)rt);
            this.error("RefinedTransition only allowed in top level state graph of an actor", sg, (EStructuralFeature)RoomPackage.Literals.STATE_GRAPH__REFINED_TRANSITIONS, idx);
        }
    }

    private void error(ValidationUtil.Result result) {
        this.error(result.getMsg(), result.getSource(), result.getFeature(), result.getIndex());
    }
}

