/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.etunit.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.etrice.etunit.converter.Etunit.DocumentRoot;
import org.eclipse.etrice.etunit.converter.Etunit.EtunitFactory;
import org.eclipse.etrice.etunit.converter.Etunit.EtunitPackage;
import org.eclipse.etrice.etunit.converter.Etunit.FailureType;
import org.eclipse.etrice.etunit.converter.Etunit.TestcaseType;
import org.eclipse.etrice.etunit.converter.Etunit.TestsuiteType;
import org.eclipse.etrice.etunit.converter.Etunit.TestsuitesType;
import org.eclipse.etrice.etunit.converter.Etunit.util.EtunitResourceFactoryImpl;

public class EtUnitReportConverter {
    private static final String TC_END = "tc end";
    private static final String TC_FAIL = "tc fail";
    private static final String TC_START = "tc start";
    private static final String TS_START = "ts start: ";
    public static final String ETU_EXTENSION = ".etu";
    public static final String OPTION_COMBINED = "-combined";
    public static final String OPTION_ONLY_COMBINED = "-only_combined";
    public static final String OPTION_TEX_OUTPUT = "-tex";
    public static final String OPTION_SUITE_NAME = "-suite";

    private static void printUsage() {
        System.err.println("usage: EtUnitReportConverter [(-combined|-only_combined) <combined file>] [-tex <tex file>] [-suite <name>] <*.etu files>\n    -combined <combined file>: also save a combined result for all tests to the specified file\n    -only_combined <combined file>: don't create reports for every single test, only combined one to the specified file\n    -tex <tex file>: produce tex output to specified file\n    -suite <name>: replace the suite name in the result\n");
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        combinedResults = false;
        replaceSuiteName = false;
        onlyCombinedResults = false;
        combinedFile = null;
        suiteName = null;
        texOutput = false;
        texFile = null;
        files = new ArrayList<String>();
        i = 0;
        while (i < args.length) {
            block19: {
                block22: {
                    block23: {
                        block20: {
                            block21: {
                                block17: {
                                    block18: {
                                        if (!args[i].equals("-combined")) break block17;
                                        combinedResults = true;
                                        if (++i >= args.length) break block18;
                                        combinedFile = args[i];
                                        break block19;
                                    }
                                    System.err.println("Error: -combined must be followed by filename");
                                    EtUnitReportConverter.printUsage();
                                    return;
                                }
                                if (!args[i].equals("-suite")) break block20;
                                replaceSuiteName = true;
                                if (++i >= args.length) break block21;
                                suiteName = args[i];
                                break block19;
                            }
                            System.err.println("Error: -suite must be followed by a suite name");
                            EtUnitReportConverter.printUsage();
                            return;
                        }
                        if (!args[i].equals("-only_combined")) break block22;
                        combinedResults = true;
                        onlyCombinedResults = true;
                        if (++i >= args.length) break block23;
                        combinedFile = args[i];
                        break block19;
                    }
                    System.err.println("Error: -only_combined must be followed by filename");
                    EtUnitReportConverter.printUsage();
                    return;
                }
                if (!args[i].equals("-tex")) ** GOTO lbl50
                texOutput = true;
                if (++i < args.length) {
                    texFile = args[i];
                } else {
                    System.err.println("Error: -tex must be followed by filename");
                    EtUnitReportConverter.printUsage();
                    return;
lbl50:
                    // 1 sources

                    if (args[i].startsWith("-")) {
                        System.err.println("Error: unknown option " + args[i]);
                        EtUnitReportConverter.printUsage();
                        return;
                    }
                    if (args[i].endsWith(".etu")) {
                        files.add(args[i]);
                    } else {
                        System.err.println("Error: invalid file name '" + args[i] + "' (only *" + ".etu" + " files allowed)");
                        EtUnitReportConverter.printUsage();
                        return;
                    }
                }
            }
            ++i;
        }
        if (files.isEmpty()) {
            System.err.println("Error: no reports specified");
            EtUnitReportConverter.printUsage();
            return;
        }
        EtUnitReportConverter.doEMFRegistration();
        rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new EtunitResourceFactoryImpl());
        for (String file : files) {
            report = new File(file);
            if (report.exists()) {
                root = EtUnitReportConverter.createParseTree(report);
                if (root != null && replaceSuiteName && root.getTestsuites() != null) {
                    if (root.getTestsuites().getTestsuite().size() == 1) {
                        ((TestsuiteType)root.getTestsuites().getTestsuite().get(0)).setName(suiteName);
                    } else {
                        i = 0;
                        for (TestsuiteType suite : root.getTestsuites().getTestsuite()) {
                            suite.setName(String.valueOf(suiteName) + i);
                            ++i;
                        }
                    }
                }
                if (root == null) continue;
                EtUnitReportConverter.saveJUnitReport(root, report, (ResourceSet)rs, onlyCombinedResults == false);
                continue;
            }
            System.err.println("Error: report " + file + " does not exist");
        }
        if (combinedResults || texOutput) {
            root = EtunitFactory.eINSTANCE.createDocumentRoot();
            testsuites = EtunitFactory.eINSTANCE.createTestsuitesType();
            root.setTestsuites(testsuites);
            for (Resource res : rs.getResources()) {
                r = (DocumentRoot)res.getContents().get(0);
                testsuites.getTestsuite().addAll(r.getTestsuites().getTestsuite());
            }
            EtUnitReportConverter.computeAndSetInfo(testsuites);
            if (combinedResults) {
                report = new File(combinedFile);
                EtUnitReportConverter.saveJUnitReport(root, report, (ResourceSet)rs, true);
            }
            if (texOutput) {
                report = new File(texFile);
                EtUnitReportConverter.saveTexReport(root, report);
            }
        }
    }

    private static void computeAndSetInfo(TestsuitesType testsuites) {
        for (TestsuiteType ts : testsuites.getTestsuite()) {
            int failures = 0;
            BigDecimal time = new BigDecimal(0);
            for (TestcaseType tc : ts.getTestcase()) {
                if (tc.getTime() != null) {
                    time = time.add(tc.getTime());
                }
                if (tc.getFailure() == null) continue;
                ++failures;
            }
            ts.setTests(ts.getTestcase().size());
            ts.setFailures(failures);
            ts.setTime(time);
        }
    }

    private static void saveJUnitReport(DocumentRoot root, File report, ResourceSet rs, boolean save) {
        URI uri = URI.createFileURI((String)report.toString());
        uri = uri.trimFileExtension();
        uri = uri.appendFileExtension("xml");
        Resource resource = rs.createResource(uri);
        resource.getContents().add((Object)root);
        if (save) {
            try {
                resource.save(Collections.EMPTY_MAP);
                System.out.println("saved " + uri);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Error: file " + uri + " could not be saved (" + e.getMessage() + ")");
            }
        }
    }

    private static String doEscape(String x) {
        int index = 0;
        String c = "azAZ";
        String ret = x;
        while (index < x.length() - 2) {
            if (ret.charAt(index) >= c.charAt(0) && ret.charAt(index) <= c.charAt(1) && ret.charAt(index + 1) >= c.charAt(2) && ret.charAt(index + 1) <= c.charAt(3)) {
                ret = String.valueOf(ret.substring(0, index + 1)) + "\\-" + ret.substring(index + 1);
            }
            ++index;
        }
        return ret.replaceAll("_", "\\\\-\\\\_");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void saveTexReport(DocumentRoot root, File report) {
        StringBuilder contents = new StringBuilder();
        contents.append("\\newcommand{\\ForAllTestCases}{}%\n");
        contents.append("\\newcounter{FailCount}%\n");
        contents.append("\\newcommand{\\ForAllSuites}{%\n");
        contents.append("    %\\DoSuite{name}{nTests}{nPassed}{nFail}{time}%\n");
        for (TestsuiteType ts : root.getTestsuites().getTestsuite()) {
            contents.append("    \\setcounter{FailCount}{" + ts.getFailures() + "}%\n");
            contents.append("    \\renewcommand{\\ForAllTestCases}{%\n");
            contents.append("        %\\DoCase{name}{time}{status}{msg}{short}{long}%\n");
            for (TestcaseType tc : ts.getTestcase()) {
                String status = tc.getFailure() != null ? "fail" : "pass";
                String msg = tc.getFailure() != null ? "expected " + tc.getFailure().getExpected() + " but was " + tc.getFailure().getActual() : "";
                String combinedName = String.valueOf(ts.getName()) + tc.getName();
                contents.append("        \\DoCase{" + tc.getName() + "}{" + EtUnitReportConverter.doEscape(tc.getName()) + "}{" + tc.getTime() + "}{" + status + "}{" + msg + "}{\\" + combinedName + "shortdesc}{\\" + combinedName + "longdesc}%\n");
            }
            contents.append("    }%\n");
            int nPassed = ts.getTests() - ts.getFailures();
            contents.append("    \\DoSuite{" + ts.getName() + "}{" + EtUnitReportConverter.doEscape(ts.getName()) + "}{" + ts.getTests() + "}{" + nPassed + "}{" + ts.getFailures() + "}{" + ts.getTime() + "}%\n");
        }
        contents.append("}%\n");
        FileWriter fos = null;
        try {
            try {
                fos = new FileWriter(report);
                fos.append(contents.toString());
                return;
            }
            catch (FileNotFoundException e) {
                System.err.println("Error: file " + report.toString() + " could not be saved (" + e.getMessage() + ")");
                e.printStackTrace();
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException e2) {
                    System.err.println("Error: file " + report.toString() + " could not be closed (" + e2.getMessage() + ")");
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                System.err.println("Error: file " + report.toString() + " could not be written (" + e.getMessage() + ")");
                e.printStackTrace();
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException e3) {
                    System.err.println("Error: file " + report.toString() + " could not be closed (" + e3.getMessage() + ")");
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    System.err.println("Error: file " + report.toString() + " could not be closed (" + e.getMessage() + ")");
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DocumentRoot createParseTree(File report) {
        int count = 0;
        try {
            FileReader input = new FileReader(report.toString());
            BufferedReader bufRead = new BufferedReader(input);
            HashMap<Integer, TestcaseType> id2case = new HashMap<Integer, TestcaseType>();
            TestsuiteType currentSuite = null;
            String line = bufRead.readLine();
            ++count;
            if (!line.equals("etUnit report")) {
                System.err.println("Error: file " + report + ", line " + line + " is missing header line - no etunit file");
                bufRead.close();
                input.close();
                return null;
            }
            DocumentRoot root = EtunitFactory.eINSTANCE.createDocumentRoot();
            TestsuitesType testsuites = EtunitFactory.eINSTANCE.createTestsuitesType();
            root.setTestsuites(testsuites);
            line = bufRead.readLine();
            ++count;
            while (true) {
                int id;
                int pos;
                if (line == null) {
                    bufRead.close();
                    EtUnitReportConverter.computeAndSetInfo(testsuites);
                    return root;
                }
                if (line.startsWith(TS_START)) {
                    currentSuite = EtunitFactory.eINSTANCE.createTestsuiteType();
                    currentSuite.setName(line.substring(TS_START.length(), line.length()));
                    testsuites.getTestsuite().add((Object)currentSuite);
                } else if (line.startsWith(TC_START)) {
                    pos = line.indexOf(58);
                    id = Integer.parseInt(line.substring(9, pos));
                    TestcaseType tc = EtunitFactory.eINSTANCE.createTestcaseType();
                    tc.setName(line.substring(pos + 2));
                    id2case.put(id, tc);
                    currentSuite.getTestcase().add((Object)tc);
                } else if (line.startsWith(TC_FAIL)) {
                    pos = line.indexOf(58);
                    id = Integer.parseInt(line.substring(8, pos));
                    TestcaseType tc = (TestcaseType)id2case.get(id);
                    if (tc == null) {
                        System.err.println("Error: in file " + report + ", line " + count + " - unknown test case id");
                        bufRead.close();
                        input.close();
                        return null;
                    }
                    FailureType fail = EtunitFactory.eINSTANCE.createFailureType();
                    pos = line.indexOf(35) + 1;
                    int end = line.indexOf(35, pos);
                    if (end > pos) {
                        fail.setExpected(line.substring(pos, end));
                    }
                    if ((end = line.indexOf(35, pos = end + 1)) > pos) {
                        fail.setActual(line.substring(pos, end));
                    }
                    String loc = (end = line.indexOf(35, pos = end + 1)) > pos ? line.substring(pos, end) : null;
                    pos = line.lastIndexOf(35);
                    String trace = line.substring(pos + 1);
                    if (loc != null) {
                        trace = String.valueOf(trace) + "\n at " + loc;
                    }
                    FeatureMapUtil.addText((FeatureMap)fail.getMixed(), (String)trace);
                    tc.setFailure(fail);
                } else if (line.startsWith(TC_END)) {
                    pos = line.indexOf(58);
                    id = Integer.parseInt(line.substring(7, pos));
                    int time = Integer.parseInt(line.substring(pos + 2));
                    TestcaseType tc = (TestcaseType)id2case.get(id);
                    if (tc == null) {
                        System.err.println("Error: in file " + report + ", line " + count + " - unknown test case id");
                        bufRead.close();
                        input.close();
                        return null;
                    }
                    tc.setTime(BigDecimal.valueOf(time));
                }
                line = bufRead.readLine();
                ++count;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.err.println("Error: file " + report + " could not be read (" + e.getMessage() + ")");
            return null;
        }
        catch (IOException e) {
            System.err.println("Error: file " + report + " could not be read (" + e.getMessage() + ")");
            e.printStackTrace();
            return null;
        }
        catch (NumberFormatException e) {
            System.err.println("Error: in file " + report + ", line " + count + " - could not read number");
        }
        return null;
    }

    private static void doEMFRegistration() {
        if (!EPackage.Registry.INSTANCE.containsKey((Object)"platform:/resource/org.eclipse.etrice.etunit.converter/model/etunit.xsd")) {
            EPackage.Registry.INSTANCE.put((Object)"platform:/resource/org.eclipse.etrice.etunit.converter/model/etunit.xsd", (Object)EtunitPackage.eINSTANCE);
        }
    }
}

