package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;

@Singleton
@SuppressWarnings("all")
public class DataClassGen {
  @Inject
  private JavaIoFileSystemAccess fileAccess;
  
  @Inject
  private CExtensions _cExtensions;
  
  @Inject
  private RoomExtensions _roomExtensions;
  
  @Inject
  private ProcedureHelpers _procedureHelpers;
  
  @Inject
  private ILogger logger;
  
  public void doGenerate(final Root root) {
    EList<DataClass> _usedDataClasses = root.getUsedDataClasses();
    for (final DataClass dc : _usedDataClasses) {
      {
        String _generationTargetPath = this._roomExtensions.getGenerationTargetPath(dc);
        String _path = this._roomExtensions.getPath(dc);
        String path = (_generationTargetPath + _path);
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName(dc);
        String _plus = ("generating DataClass header \'" + _cHeaderFileName);
        String _plus_1 = (_plus + "\' in \'");
        String _plus_2 = (_plus_1 + path);
        String _plus_3 = (_plus_2 + "\'");
        this.logger.logInfo(_plus_3);
        this.fileAccess.setOutputPath(path);
        String _cHeaderFileName_1 = this._cExtensions.getCHeaderFileName(dc);
        CharSequence _generateHeaderFile = this.generateHeaderFile(root, dc);
        this.fileAccess.generateFile(_cHeaderFileName_1, _generateHeaderFile);
        String _cSourceFileName = this._cExtensions.getCSourceFileName(dc);
        String _plus_4 = ("generating DataClass source \'" + _cSourceFileName);
        String _plus_5 = (_plus_4 + "\' in \'");
        String _plus_6 = (_plus_5 + path);
        String _plus_7 = (_plus_6 + "\'");
        this.logger.logInfo(_plus_7);
        this.fileAccess.setOutputPath(path);
        String _cSourceFileName_1 = this._cExtensions.getCSourceFileName(dc);
        CharSequence _generateSourceFile = this.generateSourceFile(root, dc);
        this.fileAccess.generateFile(_cSourceFileName_1, _generateSourceFile);
      }
    }
  }
  
  public CharSequence generateHeaderFile(final Root root, final DataClass dc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Header File of DataClass ");
    String _name = dc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    String _name_1 = dc.getName();
    CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(_name_1);
    _builder.append(_generateIncludeGuardBegin, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"etDatatypes.h\"");
    _builder.newLine();
    _builder.newLine();
    {
      HashSet<DataClass> _referencedDataClasses = root.getReferencedDataClasses(dc);
      for(final DataClass dataClass : _referencedDataClasses) {
        _builder.append("#include \"");
        String _name_2 = dataClass.getName();
        _builder.append(_name_2, "");
        _builder.append(".h\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    CharSequence _userCode = this._procedureHelpers.userCode(dc, 1);
    _builder.append(_userCode, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("typedef struct {");
    _builder.newLine();
    _builder.append("\t");
    List<Attribute> _allAttributes = this._roomExtensions.getAllAttributes(dc);
    CharSequence _attributes = this._procedureHelpers.attributes(_allAttributes);
    _builder.append(_attributes, "	");
    _builder.newLineIfNotEmpty();
    _builder.append("} ");
    String _name_3 = dc.getName();
    _builder.append(_name_3, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      List<Attribute> _allAttributes_1 = this._roomExtensions.getAllAttributes(dc);
      for(final Attribute a : _allAttributes_1) {
        {
          String _defaultValueLiteral = a.getDefaultValueLiteral();
          boolean _notEquals = (!Objects.equal(_defaultValueLiteral, null));
          if (_notEquals) {
            String _name_4 = dc.getName();
            String _plus = (_name_4 + " ");
            String _name_5 = a.getName();
            String _plus_1 = (_plus + _name_5);
            String _plus_2 = (_plus_1 + ": Attribute initialization not supported in C");
            this.logger.logInfo(_plus_2);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    _builder.newLine();
    EList<StandardOperation> _operations = dc.getOperations();
    String _name_6 = dc.getName();
    CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration(_operations, _name_6);
    _builder.append(_operationsDeclaration, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/* deep copy */");
    _builder.newLine();
    _builder.append("void ");
    String _name_7 = dc.getName();
    _builder.append(_name_7, "");
    _builder.append("_deepCopy(");
    String _name_8 = dc.getName();
    _builder.append(_name_8, "");
    _builder.append("* source, ");
    String _name_9 = dc.getName();
    _builder.append(_name_9, "");
    _builder.append("* target);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _userCode_1 = this._procedureHelpers.userCode(dc, 2);
    _builder.append(_userCode_1, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _name_10 = dc.getName();
    CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(_name_10);
    _builder.append(_generateIncludeGuardEnd, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateSourceFile(final Root root, final DataClass dc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Source File of DataClass ");
    String _name = dc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _cHeaderFileName = this._cExtensions.getCHeaderFileName(dc);
    _builder.append(_cHeaderFileName, "");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <string.h>");
    _builder.newLine();
    _builder.newLine();
    CharSequence _userCode = this._procedureHelpers.userCode(dc, 3);
    _builder.append(_userCode, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.newLine();
    EList<StandardOperation> _operations = dc.getOperations();
    String _name_1 = dc.getName();
    CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation(_operations, _name_1);
    _builder.append(_operationsImplementation, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// deep copy");
    _builder.newLine();
    _builder.append("void ");
    String _name_2 = dc.getName();
    _builder.append(_name_2, "");
    _builder.append("_deepCopy(");
    String _name_3 = dc.getName();
    _builder.append(_name_3, "");
    _builder.append("* source, ");
    String _name_4 = dc.getName();
    _builder.append(_name_4, "");
    _builder.append("* target) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("memcpy(target, source, sizeof(");
    String _name_5 = dc.getName();
    _builder.append(_name_5, "	");
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
}
