/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;

@Singleton
public class CExtensions
implements ILanguageExtension {
    @Inject
    private IDiagnostician diagnostician;
    @Inject
    private RoomExtensions _roomExtensions;

    public String getTypedDataDefinition(Message m) {
        VarDecl _data = m.getData();
        String[] _generateArglistAndTypedData = this.generateArglistAndTypedData(_data);
        String _get = (String)((List)Conversions.doWrapArray((Object)_generateArglistAndTypedData)).get(1);
        return _get;
    }

    public String accessLevelPrivate() {
        return "static ";
    }

    public String accessLevelProtected() {
        return "static ";
    }

    public String accessLevelPublic() {
        return "";
    }

    public String memberAccess() {
        return "self->";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        String _xifexpression = null;
        _xifexpression = hasArgs ? "* self, " : "* self";
        String _plus = String.valueOf(classname) + _xifexpression;
        return _plus;
    }

    public String selfPointer(boolean hasArgs) {
        String _xifexpression = null;
        _xifexpression = hasArgs ? "self, " : "self";
        return _xifexpression;
    }

    public String operationScope(String classname, boolean isDeclaration) {
        String _plus = String.valueOf(classname) + "_";
        return _plus;
    }

    public String memberInDeclaration(String namespace, String member) {
        String _plus = String.valueOf(namespace) + "_";
        return String.valueOf(_plus) + member;
    }

    public String memberInUse(String namespace, String member) {
        String _plus = String.valueOf(namespace) + "_";
        return String.valueOf(_plus) + member;
    }

    public String getCHeaderFileName(RoomClass rc) {
        String _name = rc.getName();
        return String.valueOf(_name) + ".h";
    }

    public String getCSourceFileName(RoomClass rc) {
        String _name = rc.getName();
        return String.valueOf(_name) + ".c";
    }

    public String getInstSourceFileName(RoomClass rc) {
        String _name = rc.getName();
        return String.valueOf(_name) + "_Inst.h";
    }

    public String getDispSourceFileName(RoomClass rc) {
        String _name = rc.getName();
        return String.valueOf(_name) + "_Disp.h";
    }

    public CharSequence getIncludeGuardString(String filename) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"_");
        String _upperCase = filename.toUpperCase();
        _builder.append((Object)_upperCase, "");
        _builder.append((Object)"_H_");
        return _builder;
    }

    public CharSequence generateIncludeGuardBegin(String filename) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#ifndef ");
        CharSequence _includeGuardString = this.getIncludeGuardString(filename);
        _builder.append((Object)_includeGuardString, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#define ");
        CharSequence _includeGuardString_1 = this.getIncludeGuardString(filename);
        _builder.append((Object)_includeGuardString_1, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateIncludeGuardEnd(String filename) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#endif /* ");
        CharSequence _includeGuardString = this.getIncludeGuardString(filename);
        _builder.append((Object)_includeGuardString, "");
        _builder.append((Object)" */");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public boolean usesInheritance() {
        return false;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        String _string;
        String _xblockexpression = null;
        boolean _isEmpty = entries.isEmpty();
        if (_isEmpty) {
            return "/* empty enum not generated */";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"enum ");
        _builder.append((Object)name, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        boolean _hasElements = false;
        for (Pair<String, String> entry : entries) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            String _first = (String)entry.getFirst();
            _builder.append((Object)_first, "\t");
            _builder.append((Object)" = ");
            String _second = (String)entry.getSecond();
            _builder.append((Object)_second, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _string = _builder.toString();
        return _xblockexpression;
    }

    public String booleanConstant(boolean b) {
        String _xifexpression = null;
        _xifexpression = b ? "TRUE" : "FALSE";
        return _xifexpression;
    }

    public String pointerLiteral() {
        return "*";
    }

    public String nullPointer() {
        return "NULL";
    }

    public String voidPointer() {
        return "void*";
    }

    public String arrayDeclaration(String type, int size, String name, boolean isRef) {
        String _xifexpression = null;
        if (isRef) {
            String _plus_4;
            String _plus = String.valueOf(type) + "* ";
            String _plus_1 = String.valueOf(_plus) + name;
            String _plus_2 = String.valueOf(_plus_1) + "[";
            String _plus_3 = String.valueOf(_plus_2) + Integer.valueOf(size);
            _xifexpression = _plus_4 = String.valueOf(_plus_3) + "]";
        } else {
            String _plus_9;
            String _plus_5 = String.valueOf(type) + " ";
            String _plus_6 = String.valueOf(_plus_5) + name;
            String _plus_7 = String.valueOf(_plus_6) + "[";
            String _plus_8 = String.valueOf(_plus_7) + Integer.valueOf(size);
            _xifexpression = _plus_9 = String.valueOf(_plus_8) + "]";
        }
        return _xifexpression;
    }

    public String constructorName(String cls) {
        return "ctor";
    }

    public String destructorName(String cls) {
        return "dtor";
    }

    public String constructorReturnType() {
        return "void";
    }

    public String destructorReturnType() {
        return "void";
    }

    public String toCharArrayExpr(String s) {
        String _plus = "\"" + s;
        String _plus_1 = String.valueOf(_plus) + "\"";
        return _plus_1;
    }

    public String superCall(String baseClassName, String method, String args) {
        return "";
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("TODO Config for C");
        throw _unsupportedOperationException;
    }

    public String defaultValue(DataType dt) {
        String _xifexpression = null;
        if (dt instanceof PrimitiveType) {
            return ((PrimitiveType)dt).getDefaultValueLiteral();
        }
        String _xifexpression_1 = null;
        if (dt instanceof ExternalType) {
            String _name = dt.getName();
            String _plus = "cannot initialize external type " + _name;
            EObject _eContainer = dt.eContainer();
            EStructuralFeature _eContainingFeature = dt.eContainingFeature();
            this.diagnostician.error(_plus, _eContainer, _eContainingFeature);
            String _name_1 = dt.getName();
            return "cannot instantiate external data type " + _name_1;
        }
        String _xblockexpression = null;
        DataClass dc = (DataClass)dt;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        List _allAttributes = this._roomExtensions.getAllAttributes(dc);
        boolean _hasElements = false;
        for (Attribute att : _allAttributes) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            String _initializationWithDefaultValues = this.initializationWithDefaultValues(att);
            _builder.append((Object)_initializationWithDefaultValues, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _xifexpression = _xifexpression_1 = (_xblockexpression = _builder.toString());
        return _xifexpression;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        String _initializer;
        String _xblockexpression = null;
        String dv = this.defaultValue(dt);
        _xblockexpression = _initializer = this.initializer(dv, size);
        return _xblockexpression;
    }

    private String initializer(String dv, int size) {
        boolean _greaterThan;
        String _xifexpression = null;
        boolean bl = _greaterThan = size > 1;
        if (_greaterThan) {
            String _plus;
            boolean _lessThan;
            String _xblockexpression = null;
            String res = "{";
            int i = 0;
            boolean _while = _lessThan = i < size;
            while (_while) {
                boolean _lessThan_1;
                boolean _lessThan_12;
                String _plus2;
                res = _plus2 = String.valueOf(res) + dv;
                int _plus_1 = i + 1;
                boolean bl2 = _lessThan_12 = (i = _plus_1) < size;
                if (_lessThan_12) {
                    String _plus_2;
                    res = _plus_2 = String.valueOf(res) + ",";
                }
                _while = _lessThan_1 = i < size;
            }
            _xifexpression = _xblockexpression = (_plus = String.valueOf(res) + "}");
        } else {
            _xifexpression = dv;
        }
        return _xifexpression;
    }

    public String initializationWithDefaultValues(Attribute att) {
        boolean _notEquals;
        String _xblockexpression = null;
        String dv = att.getDefaultValueLiteral();
        String _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)dv, null);
        if (_notEquals) {
            String _xifexpression_1 = null;
            boolean _startsWith = dv.startsWith("{");
            if (_startsWith) {
                _xifexpression_1 = dv;
            } else {
                String _initializer;
                int _size = att.getSize();
                _xifexpression_1 = _initializer = this.initializer(dv, _size);
            }
            _xifexpression = _xifexpression_1;
        } else {
            String _initializationWithDefaultValues;
            RefableType _refType = att.getRefType();
            DataType _type = _refType.getType();
            int _size_1 = att.getSize();
            _xifexpression = _initializationWithDefaultValues = this.initializationWithDefaultValues(_type, _size_1);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String[] generateArglistAndTypedData(VarDecl data) {
        String _plus;
        boolean _not;
        boolean _equals = Objects.equal((Object)data, null);
        if (_equals) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        String _xifexpression = null;
        RefableType _refType = data.getRefType();
        DataType _type = _refType.getType();
        if (_type instanceof PrimitiveType) {
            String _targetName;
            RefableType _refType_1 = data.getRefType();
            DataType _type_1 = _refType_1.getType();
            _xifexpression = _targetName = ((PrimitiveType)_type_1).getTargetName();
        } else {
            String _name;
            RefableType _refType_2 = data.getRefType();
            DataType _type_2 = _refType_2.getType();
            _xifexpression = _name = _type_2.getName();
        }
        String typeName = _xifexpression;
        String _xifexpression_1 = null;
        RefableType _refType_3 = data.getRefType();
        DataType _type_3 = _refType_3.getType();
        if (_type_3 instanceof PrimitiveType) {
            boolean _notEquals;
            String _xblockexpression = null;
            RefableType _refType_4 = data.getRefType();
            DataType _type_4 = _refType_4.getType();
            String ct = ((PrimitiveType)_type_4).getCastName();
            String _xifexpression_2 = null;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)ct, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _isEmpty = ct.isEmpty();
                _not = !_isEmpty;
                _and = _notEquals && _not;
            }
            _xifexpression_2 = _and ? ct : typeName;
            _xifexpression_1 = _xblockexpression = _xifexpression_2;
        } else {
            _xifexpression_1 = typeName;
        }
        String castTypeName = _xifexpression_1;
        castTypeName = _plus = String.valueOf(castTypeName) + "*";
        String deRef = "*";
        RefableType _refType_4 = data.getRefType();
        boolean isRef = _refType_4.isRef();
        RefableType _refType_5 = data.getRefType();
        DataType _type_4 = _refType_5.getType();
        boolean isPrim = _type_4 instanceof PrimitiveType;
        if (isRef) {
            String _plus_2;
            String _plus_1;
            typeName = _plus_1 = String.valueOf(typeName) + "*";
            castTypeName = _plus_2 = String.valueOf(castTypeName) + "*";
        } else {
            boolean bl = _not = !isPrim;
            if (_not) {
                String _plus_3;
                typeName = _plus_3 = String.valueOf(typeName) + "*";
                deRef = "";
            }
        }
        String _plus_4 = String.valueOf(typeName) + " ";
        String _name_1 = data.getName();
        String _plus_5 = String.valueOf(_plus_4) + _name_1;
        String _plus_6 = String.valueOf(_plus_5) + " = ";
        String _plus_7 = String.valueOf(_plus_6) + deRef;
        String _plus_8 = String.valueOf(_plus_7) + "((";
        String _plus_9 = String.valueOf(_plus_8) + castTypeName;
        String typedData = String.valueOf(_plus_9) + ") generic_data);\n";
        String _name_2 = data.getName();
        String dataArg = ", " + _name_2;
        String _plus_10 = ", " + typeName;
        String _plus_11 = String.valueOf(_plus_10) + " ";
        String _name_3 = data.getName();
        String typedArgList = String.valueOf(_plus_11) + _name_3;
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{dataArg, typedData, typedArgList}), String.class);
    }
}

