/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.generator.base.ITranslationProvider;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.RoomExtensions;

public class CTranslationProvider
implements ITranslationProvider {
    @Inject
    private RoomExtensions roomExt;
    @Inject
    ILogger logger;
    @Inject
    ILanguageExtension langExt;

    public void setActorClass(ActorClass ac) {
    }

    public boolean translateMembers() {
        return true;
    }

    public String getAttributeGetter(Attribute att, String index, String orig) {
        if (index == null) {
            return "self->" + att.getName() + this.getOrigComment(orig);
        }
        return "self->" + att.getName() + "[" + index + "]" + this.getOrigComment(orig);
    }

    public String getAttributeSetter(Attribute att, String index, String value, String orig) {
        if (index == null) {
            return "self->" + att.getName() + " = " + value + this.getOrigComment(orig);
        }
        return "self->" + att.getName() + "[" + index + "] = " + value + this.getOrigComment(orig);
    }

    public String getOperationText(Operation op, ArrayList<String> args, String orig) {
        StringBuilder result = new StringBuilder();
        result.append(String.valueOf(this.langExt.memberInUse(((RoomClass)op.eContainer()).getName(), op.getName())) + "(self");
        for (String arg : args) {
            result.append(", " + arg);
        }
        result.append(")" + this.getOrigComment(orig));
        return result.toString();
    }

    public String getInterfaceItemMessageText(InterfaceItem item, Message msg, ArrayList<String> args, String index, String orig) {
        StringBuilder argtext = new StringBuilder();
        for (String arg : args) {
            argtext.append(", " + arg);
        }
        String result = orig;
        if (item instanceof Port) {
            Port p = (Port)item;
            if (p.getProtocol() instanceof ProtocolClass) {
                ProtocolClass pc = (ProtocolClass)p.getProtocol();
                if (pc.getCommType() == CommunicationType.EVENT_DRIVEN) {
                    result = p.getMultiplicity() == 1 ? String.valueOf(this.roomExt.getPortClassName((EObject)p)) + "_" + msg.getName() + "(&self->constData->" + item.getName() + argtext + ")" : (index == null ? String.valueOf(this.roomExt.getPortClassName((EObject)p)) + "_" + msg.getName() + "_broadcast(&self->constData->" + item.getName() + argtext + ")" : String.valueOf(this.roomExt.getPortClassName((EObject)p)) + "_" + msg.getName() + "(&self->constData->" + item.getName() + ", " + index + argtext + ")");
                    result = String.valueOf(result) + this.getOrigComment(orig);
                } else if (pc.getCommType() == CommunicationType.DATA_DRIVEN) {
                    result = p.isConjugated() ? String.valueOf(this.roomExt.getPortClassName((EObject)p)) + "_" + msg.getName() + "_set(&(self->" + item.getName() + ")" + argtext + ")" : String.valueOf(this.roomExt.getPortClassName((EObject)p)) + "_" + msg.getName() + "_get(&(self->constData->" + item.getName() + "))";
                    result = String.valueOf(result) + this.getOrigComment(orig);
                }
            }
        } else if (item instanceof SAPRef) {
            result = String.valueOf(this.roomExt.getPortClassName((EObject)((SAPRef)item))) + "_" + msg.getName() + "(&self->constData->" + item.getName() + argtext + ")";
            result = String.valueOf(result) + this.getOrigComment(orig);
        } else if (item instanceof SPPRef) {
            result = index == null ? String.valueOf(this.roomExt.getPortClassName((EObject)((SPPRef)item))) + "_" + msg.getName() + "_broadcast(&self->constData->" + item.getName() + argtext + ")" : String.valueOf(this.roomExt.getPortClassName((EObject)((SPPRef)item))) + "_" + msg.getName() + "(&self->constData->" + item.getName() + ", " + index + argtext + ")";
            result = String.valueOf(result) + this.getOrigComment(orig);
        }
        return result;
    }

    public String getInterfaceItemMessageValue(InterfaceItem item, Message msg, String orig) {
        String result = orig;
        if (item instanceof Port) {
            Port p = (Port)item;
            result = String.valueOf(this.roomExt.getPortClassName((EObject)p)) + "_" + msg.getName() + "_get(&(self->constData->" + item.getName() + "))";
            result = String.valueOf(result) + this.getOrigComment(orig);
        }
        return result;
    }

    public boolean translateTags() {
        return true;
    }

    public String translateTag(String tag, DetailCode code) {
        if (tag.equals("ifitem.index")) {
            return "((etReplSubPort*)ifitem)->index";
        }
        if (tag.equals("MODEL_LOCATION")) {
            return RoomNameProvider.getDetailCodeLocation((DetailCode)code);
        }
        this.logger.logInfo("unrecognized tag '" + tag + "' in " + RoomNameProvider.getDetailCodeLocation((DetailCode)code) + " of " + RoomNameProvider.getClassLocation((RoomClass)RoomNameProvider.getModelClass((EObject)code)));
        return "<|?" + tag + "?" + "|>";
    }

    private String getOrigComment(String orig) {
        return " /* ORIG: " + orig + " */";
    }
}

