/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;

@Singleton
public class DataClassGen {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private CExtensions _cExtensions;
    @Inject
    private RoomExtensions _roomExtensions;
    @Inject
    private ProcedureHelpers _procedureHelpers;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _usedDataClasses = root.getUsedDataClasses();
        for (DataClass dc : _usedDataClasses) {
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)dc);
            String _path = this._roomExtensions.getPath((RoomClass)dc);
            String path = String.valueOf(_generationTargetPath) + _path;
            String _cHeaderFileName = this._cExtensions.getCHeaderFileName((RoomClass)dc);
            String _plus = "generating DataClass header '" + _cHeaderFileName;
            String _plus_1 = String.valueOf(_plus) + "' in '";
            String _plus_2 = String.valueOf(_plus_1) + path;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.logger.logInfo(_plus_3);
            this.fileAccess.setOutputPath(path);
            String _cHeaderFileName_1 = this._cExtensions.getCHeaderFileName((RoomClass)dc);
            CharSequence _generateHeaderFile = this.generateHeaderFile(root, dc);
            this.fileAccess.generateFile(_cHeaderFileName_1, _generateHeaderFile);
            String _cSourceFileName = this._cExtensions.getCSourceFileName((RoomClass)dc);
            String _plus_4 = "generating DataClass source '" + _cSourceFileName;
            String _plus_5 = String.valueOf(_plus_4) + "' in '";
            String _plus_6 = String.valueOf(_plus_5) + path;
            String _plus_7 = String.valueOf(_plus_6) + "'";
            this.logger.logInfo(_plus_7);
            this.fileAccess.setOutputPath(path);
            String _cSourceFileName_1 = this._cExtensions.getCSourceFileName((RoomClass)dc);
            CharSequence _generateSourceFile = this.generateSourceFile(root, dc);
            this.fileAccess.generateFile(_cSourceFileName_1, _generateSourceFile);
        }
    }

    public CharSequence generateHeaderFile(Root root, DataClass dc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of DataClass ");
        String _name = dc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        String _name_1 = dc.getName();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(_name_1);
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"etDatatypes.h\"");
        _builder.newLine();
        _builder.newLine();
        HashSet _referencedDataClasses = root.getReferencedDataClasses(dc);
        for (DataClass dataClass : _referencedDataClasses) {
            _builder.append((Object)"#include \"");
            String _name_2 = dataClass.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(dc, 1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"typedef struct {");
        _builder.newLine();
        _builder.append((Object)"\t");
        List _allAttributes = this._roomExtensions.getAllAttributes(dc);
        CharSequence _attributes = this._procedureHelpers.attributes(_allAttributes);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"} ");
        String _name_3 = dc.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        List _allAttributes_1 = this._roomExtensions.getAllAttributes(dc);
        for (Attribute a : _allAttributes_1) {
            boolean _notEquals;
            String _defaultValueLiteral = a.getDefaultValueLiteral();
            boolean bl = _notEquals = !Objects.equal((Object)_defaultValueLiteral, null);
            if (!_notEquals) continue;
            String _name_4 = dc.getName();
            String _plus = String.valueOf(_name_4) + " ";
            String _name_5 = a.getName();
            String _plus_1 = String.valueOf(_plus) + _name_5;
            String _plus_2 = String.valueOf(_plus_1) + ": Attribute initialization not supported in C";
            this.logger.logInfo(_plus_2);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.newLine();
        EList _operations = dc.getOperations();
        String _name_6 = dc.getName();
        CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration((List)_operations, _name_6);
        _builder.append((Object)_operationsDeclaration, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* deep copy */");
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_7 = dc.getName();
        _builder.append((Object)_name_7, "");
        _builder.append((Object)"_deepCopy(");
        String _name_8 = dc.getName();
        _builder.append((Object)_name_8, "");
        _builder.append((Object)"* source, ");
        String _name_9 = dc.getName();
        _builder.append((Object)_name_9, "");
        _builder.append((Object)"* target);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode_1 = this._procedureHelpers.userCode(dc, 2);
        _builder.append((Object)_userCode_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _name_10 = dc.getName();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(_name_10);
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateSourceFile(Root root, DataClass dc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of DataClass ");
        String _name = dc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName((RoomClass)dc);
        _builder.append((Object)_cHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include <string.h>");
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(dc, 3);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        EList _operations = dc.getOperations();
        String _name_1 = dc.getName();
        CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation((List)_operations, _name_1);
        _builder.append((Object)_operationsImplementation, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"// deep copy");
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_2 = dc.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"_deepCopy(");
        String _name_3 = dc.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"* source, ");
        String _name_4 = dc.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)"* target) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"memcpy(target, source, sizeof(");
        String _name_5 = dc.getName();
        _builder.append((Object)_name_5, "\t");
        _builder.append((Object)"));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

