/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ProtocolClassGen
extends GenericProtocolClassGenerator {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private CExtensions _cExtensions;
    @Inject
    private RoomExtensions _roomExtensions;
    @Inject
    private ProcedureHelpers _procedureHelpers;
    @Inject
    private TypeHelpers _typeHelpers;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _usedProtocolClasses = root.getUsedProtocolClasses();
        for (ProtocolClass pc : _usedProtocolClasses) {
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)pc);
            String _path = this._roomExtensions.getPath((RoomClass)pc);
            String path = String.valueOf(_generationTargetPath) + _path;
            String _cHeaderFileName = this._cExtensions.getCHeaderFileName((RoomClass)pc);
            String _plus = "generating ProtocolClass header '" + _cHeaderFileName;
            String _plus_1 = String.valueOf(_plus) + "' in '";
            String _plus_2 = String.valueOf(_plus_1) + path;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.logger.logInfo(_plus_3);
            this.fileAccess.setOutputPath(path);
            String _cHeaderFileName_1 = this._cExtensions.getCHeaderFileName((RoomClass)pc);
            CharSequence _generateHeaderFile = this.generateHeaderFile(root, pc);
            this.fileAccess.generateFile(_cHeaderFileName_1, _generateHeaderFile);
            String _cSourceFileName = this._cExtensions.getCSourceFileName((RoomClass)pc);
            String _plus_4 = "generating ProtocolClass source '" + _cSourceFileName;
            String _plus_5 = String.valueOf(_plus_4) + "' in '";
            String _plus_6 = String.valueOf(_plus_5) + path;
            String _plus_7 = String.valueOf(_plus_6) + "'";
            this.logger.logInfo(_plus_7);
            this.fileAccess.setOutputPath(path);
            String _cSourceFileName_1 = this._cExtensions.getCSourceFileName((RoomClass)pc);
            CharSequence _generateSourceFile = this.generateSourceFile(root, pc);
            this.fileAccess.generateFile(_cSourceFileName_1, _generateSourceFile);
        }
    }

    private CharSequence generateHeaderFile(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        String _name_1 = pc.getName();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(_name_1);
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"etDatatypes.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"modelbase/etPort.h\"");
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(pc, 1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        HashSet _referencedDataClasses = root.getReferencedDataClasses(pc);
        for (DataClass dataClass : _referencedDataClasses) {
            _builder.append((Object)"#include \"");
            String _name_2 = dataClass.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CommunicationType _commType = pc.getCommType();
        boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
        if (_equals) {
            _builder.newLine();
            _builder.append((Object)"/* message IDs */");
            _builder.newLine();
            String _genMessageIDs = this.genMessageIDs(pc);
            _builder.append((Object)_genMessageIDs, "");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"/*--------------------- port structs and methods */");
            _builder.newLine();
            CharSequence _portClassHeader = this.portClassHeader(pc, false);
            _builder.append((Object)_portClassHeader, "");
            _builder.newLineIfNotEmpty();
            CharSequence _portClassHeader_1 = this.portClassHeader(pc, true);
            _builder.append((Object)_portClassHeader_1, "");
            _builder.newLineIfNotEmpty();
        } else {
            CommunicationType _commType_1 = pc.getCommType();
            boolean _equals_1 = Objects.equal((Object)_commType_1, (Object)CommunicationType.DATA_DRIVEN);
            if (_equals_1) {
                _builder.append((Object)"/*--------------------- port structs and methods */");
                _builder.newLine();
                CharSequence _genDataDrivenPortHeaders = this.genDataDrivenPortHeaders(pc);
                _builder.append((Object)_genDataDrivenPortHeaders, "");
                _builder.newLineIfNotEmpty();
            } else {
                CommunicationType _commType_2 = pc.getCommType();
                boolean _equals_2 = Objects.equal((Object)_commType_2, (Object)CommunicationType.SYNCHRONOUS);
                if (_equals_2) {
                    _builder.append((Object)"#error \"synchronoue protocols not implemented yet\"");
                    _builder.newLine();
                }
            }
        }
        _builder.newLine();
        _builder.append((Object)"/*--------------------- debug helpers */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* get message string for message id */");
        _builder.newLine();
        _builder.append((Object)"const char* ");
        String _name_3 = pc.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"_getMessageString(int msg_id);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode_1 = this._procedureHelpers.userCode(pc, 2);
        _builder.append((Object)_userCode_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _name_4 = pc.getName();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(_name_4);
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateSourceFile(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName((RoomClass)pc);
        _builder.append((Object)_cHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(pc, 3);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/*--------------------- port methods */");
        _builder.newLine();
        CommunicationType _commType = pc.getCommType();
        boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
        if (_equals) {
            CharSequence _portClassSource = this.portClassSource(pc, false);
            _builder.append((Object)_portClassSource, "");
            _builder.newLineIfNotEmpty();
            CharSequence _portClassSource_1 = this.portClassSource(pc, true);
            _builder.append((Object)_portClassSource_1, "");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"/*--------------------- debug helpers */");
            _builder.newLine();
            CharSequence _generateDebugHelpersImplementation = this.generateDebugHelpersImplementation(root, pc);
            _builder.append((Object)_generateDebugHelpersImplementation, "");
            _builder.newLineIfNotEmpty();
        } else {
            CommunicationType _commType_1 = pc.getCommType();
            boolean _equals_1 = Objects.equal((Object)_commType_1, (Object)CommunicationType.DATA_DRIVEN);
            if (_equals_1) {
                CharSequence _genDataDrivenPortSources = this.genDataDrivenPortSources(pc);
                _builder.append((Object)_genDataDrivenPortSources, "");
                _builder.newLineIfNotEmpty();
            } else {
                CommunicationType _commType_2 = pc.getCommType();
                boolean _equals_2 = Objects.equal((Object)_commType_2, (Object)CommunicationType.SYNCHRONOUS);
                if (_equals_2) {
                    _builder.append((Object)"#error \"synchronous protocols not implemented yet\"");
                    _builder.newLine();
                }
            }
        }
        return _builder;
    }

    private CharSequence portClassHeader(ProtocolClass pc, Boolean conj) {
        boolean _notEquals_2;
        boolean _notEquals;
        List _allOutgoingMessages;
        List _allIncomingMessages;
        StringConcatenation _xblockexpression = null;
        String portClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue());
        String replPortClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue(), true);
        List _xifexpression = null;
        _xifexpression = conj != false ? (_allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc)) : (_allOutgoingMessages = this._roomExtensions.getAllOutgoingMessages(pc));
        List messages = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"typedef etPort ");
        _builder.append((Object)portClassName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef etReplPort ");
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        PortClass _portClass = this._roomExtensions.getPortClass(pc, conj.booleanValue());
        boolean bl = _notEquals = !Objects.equal((Object)_portClass, null);
        if (_notEquals) {
            boolean _not;
            PortClass _portClass_1 = this._roomExtensions.getPortClass(pc, conj.booleanValue());
            EList _attributes = _portClass_1.getAttributes();
            boolean _isEmpty = _attributes.isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"/* variable part of PortClass (RAM) */");
                _builder.newLine();
                _builder.append((Object)"typedef struct ");
                _builder.append((Object)portClassName, "");
                _builder.append((Object)"_var ");
                _builder.append((Object)portClassName, "");
                _builder.append((Object)"_var; ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"struct ");
                _builder.append((Object)portClassName, "");
                _builder.append((Object)"_var {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                PortClass _portClass_2 = this._roomExtensions.getPortClass(pc, conj.booleanValue());
                EList _attributes_1 = _portClass_2.getAttributes();
                CharSequence _attributes_2 = this._procedureHelpers.attributes((List)_attributes_1);
                _builder.append((Object)_attributes_2, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"};");
                _builder.newLine();
                PortClass _portClass_3 = this._roomExtensions.getPortClass(pc, conj.booleanValue());
                EList _attributes_3 = _portClass_3.getAttributes();
                for (Attribute a : _attributes_3) {
                    boolean _notEquals_1;
                    String _defaultValueLiteral = a.getDefaultValueLiteral();
                    boolean bl3 = _notEquals_1 = !Objects.equal((Object)_defaultValueLiteral, null);
                    if (!_notEquals_1) continue;
                    String _plus = String.valueOf(portClassName) + " ";
                    String _name = a.getName();
                    String _plus_1 = String.valueOf(_plus) + _name;
                    String _plus_2 = String.valueOf(_plus_1) + ": Attribute initialization not supported in C";
                    this.logger.logInfo(_plus_2);
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.newLine();
        for (Message message : messages) {
            VarDecl _data = message.getData();
            boolean hasData = !Objects.equal((Object)_data, null);
            _builder.newLineIfNotEmpty();
            String _xifexpression_1 = null;
            if (hasData) {
                String _typeName;
                VarDecl _data_1 = message.getData();
                RefableType _refType = _data_1.getRefType();
                DataType _type = _refType.getType();
                _xifexpression_1 = _typeName = this._typeHelpers.typeName(_type);
            } else {
                _xifexpression_1 = "";
            }
            String typeName = _xifexpression_1;
            _builder.newLineIfNotEmpty();
            String _xifexpression_2 = null;
            boolean _and = false;
            if (!hasData) {
                _and = false;
            } else {
                boolean _not_1;
                boolean _or = false;
                VarDecl _data_2 = message.getData();
                RefableType _refType_1 = _data_2.getRefType();
                DataType _type_1 = _refType_1.getType();
                boolean bl4 = _not_1 = !(_type_1 instanceof PrimitiveType);
                if (_not_1) {
                    _or = true;
                } else {
                    VarDecl _data_3 = message.getData();
                    RefableType _refType_2 = _data_3.getRefType();
                    boolean _isRef = _refType_2.isRef();
                    _or = _not_1 || _isRef;
                }
                _and = hasData && _or;
            }
            _xifexpression_2 = _and ? "*" : "";
            String refp = _xifexpression_2;
            _builder.newLineIfNotEmpty();
            String _xifexpression_3 = null;
            if (hasData) {
                String _plus_5;
                String _plus_3 = ", " + typeName;
                String _plus_4 = String.valueOf(_plus_3) + refp;
                _xifexpression_3 = _plus_5 = String.valueOf(_plus_4) + " data";
            } else {
                _xifexpression_3 = "";
            }
            String data = _xifexpression_3;
            _builder.newLineIfNotEmpty();
            String _name_1 = message.getName();
            String _messageSignature = this.messageSignature(portClassName, _name_1, "", data);
            _builder.append((Object)_messageSignature, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            String _name_2 = message.getName();
            String _messageSignature_1 = this.messageSignature(replPortClassName, _name_2, "_broadcast", data);
            _builder.append((Object)_messageSignature_1, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            String _name_3 = message.getName();
            String _plus_6 = ", int idx" + data;
            String _messageSignature_2 = this.messageSignature(replPortClassName, _name_3, "", _plus_6);
            _builder.append((Object)_messageSignature_2, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        PortClass _portClass_4 = this._roomExtensions.getPortClass(pc, conj.booleanValue());
        boolean bl5 = _notEquals_2 = !Objects.equal((Object)_portClass_4, null);
        if (_notEquals_2) {
            PortClass _portClass_5 = this._roomExtensions.getPortClass(pc, conj.booleanValue());
            EList _operations = _portClass_5.getOperations();
            CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration((List)_operations, portClassName);
            _builder.append((Object)_operationsDeclaration, "");
            _builder.newLineIfNotEmpty();
            PortClass _portClass_6 = this._roomExtensions.getPortClass(pc, conj.booleanValue());
            EList _operations_1 = _portClass_6.getOperations();
            CharSequence _operationsDeclaration_1 = this._procedureHelpers.operationsDeclaration((List)_operations_1, replPortClassName);
            _builder.append((Object)_operationsDeclaration_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _handlesReceive = this._roomExtensions.handlesReceive(pc, conj.booleanValue());
        if (_handlesReceive) {
            List _receiveHandlers = this._roomExtensions.getReceiveHandlers(pc, conj.booleanValue());
            for (MessageHandler h : _receiveHandlers) {
                _builder.append((Object)"void ");
                _builder.append((Object)portClassName, "");
                _builder.append((Object)"_");
                Message _msg = h.getMsg();
                String _name_4 = _msg.getName();
                _builder.append((Object)_name_4, "");
                _builder.append((Object)"_receiveHandler(");
                _builder.append((Object)portClassName, "");
                _builder.append((Object)"* self, const etMessage* msg, void * actor, etActorReceiveMessage receiveMessageFunc);");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"etInt32 ");
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)"_getReplication(const ");
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)"* self);");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence genDataDrivenPortHeaders(ProtocolClass pc) {
        StringConcatenation _xblockexpression = null;
        List _allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc);
        Functions.Function1<Message, Boolean> _function = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                VarDecl _data = m.getData();
                boolean _notEquals = !Objects.equal((Object)_data, null);
                return _notEquals;
            }
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)_allIncomingMessages, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/* data driven send port (conjugated) */");
        _builder.newLine();
        _builder.append((Object)"typedef struct {");
        _builder.newLine();
        for (Message msg : sentMsgs) {
            _builder.append((Object)"\t");
            VarDecl _data = msg.getData();
            RefableType _refType = _data.getRefType();
            DataType _type = _refType.getType();
            String typeName = this._typeHelpers.typeName(_type);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _xifexpression = null;
            VarDecl _data_1 = msg.getData();
            RefableType _refType_1 = _data_1.getRefType();
            boolean _isRef = _refType_1.isRef();
            _xifexpression = _isRef ? "*" : "";
            String refp = _xifexpression;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)typeName, "\t");
            _builder.append((Object)refp, "\t");
            _builder.append((Object)" ");
            String _name = msg.getName();
            _builder.append((Object)_name, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        String _portClassName = this._roomExtensions.getPortClassName(pc, true);
        _builder.append((Object)_portClassName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* data driven receive port (regular) */");
        _builder.newLine();
        _builder.append((Object)"typedef struct {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"const ");
        String _portClassName_1 = this._roomExtensions.getPortClassName(pc, true);
        _builder.append((Object)_portClassName_1, "\t");
        _builder.append((Object)"* peer;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        String _portClassName_2 = this._roomExtensions.getPortClassName(pc, false);
        _builder.append((Object)_portClassName_2, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (Message message : sentMsgs) {
            VarDecl _data_2 = message.getData();
            boolean hasData = !Objects.equal((Object)_data_2, null);
            _builder.newLineIfNotEmpty();
            String _xifexpression_1 = null;
            if (hasData) {
                String _typeName;
                VarDecl _data_3 = message.getData();
                RefableType _refType_2 = _data_3.getRefType();
                DataType _type_1 = _refType_2.getType();
                _xifexpression_1 = _typeName = this._typeHelpers.typeName(_type_1);
            } else {
                _xifexpression_1 = "";
            }
            String typeName_1 = _xifexpression_1;
            _builder.newLineIfNotEmpty();
            String _xifexpression_2 = null;
            boolean _and = false;
            if (!hasData) {
                _and = false;
            } else {
                VarDecl _data_4 = message.getData();
                RefableType _refType_3 = _data_4.getRefType();
                DataType _type_2 = _refType_3.getType();
                boolean _not = !(_type_2 instanceof PrimitiveType);
                _and = hasData && _not;
            }
            _xifexpression_2 = _and ? "*" : "";
            String refp_1 = _xifexpression_2;
            _builder.newLineIfNotEmpty();
            String _xifexpression_3 = null;
            if (hasData) {
                String _plus_2;
                String _plus = ", " + typeName_1;
                String _plus_1 = String.valueOf(_plus) + refp_1;
                _xifexpression_3 = _plus_2 = String.valueOf(_plus_1) + " data";
            } else {
                _xifexpression_3 = "";
            }
            String data = _xifexpression_3;
            _builder.newLineIfNotEmpty();
            String _portClassName_3 = this._roomExtensions.getPortClassName(pc, true);
            String _name_1 = message.getName();
            String _messageSetterSignature = this.messageSetterSignature(_portClassName_3, _name_1, data);
            _builder.append((Object)_messageSetterSignature, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            String _portClassName_4 = this._roomExtensions.getPortClassName(pc, false);
            String _name_2 = message.getName();
            String _messageGetterSignature = this.messageGetterSignature(_portClassName_4, _name_2, typeName_1);
            _builder.append((Object)_messageGetterSignature, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence genDataDrivenPortSources(ProtocolClass pc) {
        StringConcatenation _xblockexpression = null;
        List _allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc);
        Functions.Function1<Message, Boolean> _function = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                VarDecl _data = m.getData();
                boolean _notEquals = !Objects.equal((Object)_data, null);
                return _notEquals;
            }
        };
        Iterable messages = IterableExtensions.filter((Iterable)_allIncomingMessages, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        for (Message message : messages) {
            VarDecl _data = message.getData();
            RefableType _refType = _data.getRefType();
            DataType _type = _refType.getType();
            String typeName = this._typeHelpers.typeName(_type);
            _builder.newLineIfNotEmpty();
            String _xifexpression = null;
            VarDecl _data_1 = message.getData();
            RefableType _refType_1 = _data_1.getRefType();
            DataType _type_1 = _refType_1.getType();
            boolean _not = !(_type_1 instanceof PrimitiveType);
            _xifexpression = _not ? "*" : "";
            String refp = _xifexpression;
            _builder.newLineIfNotEmpty();
            String _plus = ", " + typeName;
            String _plus_1 = String.valueOf(_plus) + refp;
            String data = String.valueOf(_plus_1) + " data";
            _builder.newLineIfNotEmpty();
            String _portClassName = this._roomExtensions.getPortClassName(pc, true);
            String _name = message.getName();
            String _messageSetterSignature = this.messageSetterSignature(_portClassName, _name, data);
            _builder.append((Object)_messageSetterSignature, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"self->");
            String _name_1 = message.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)" = data;");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            String _portClassName_1 = this._roomExtensions.getPortClassName(pc, false);
            String _name_2 = message.getName();
            String _messageGetterSignature = this.messageGetterSignature(_portClassName_1, _name_2, typeName);
            _builder.append((Object)_messageGetterSignature, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return self->peer->");
            String _name_3 = message.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence portClassSource(ProtocolClass pc, Boolean conj) {
        boolean _notEquals_3;
        List _allOutgoingMessages;
        List _allIncomingMessages;
        StringConcatenation _xblockexpression = null;
        String portClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue());
        String replPortClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue(), true);
        List _xifexpression = null;
        _xifexpression = conj != false ? (_allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc)) : (_allOutgoingMessages = this._roomExtensions.getAllOutgoingMessages(pc));
        List messages = _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = conj != false ? "IN_" : "OUT_";
        String dir = _xifexpression_1;
        StringConcatenation _builder = new StringConcatenation();
        for (Message message : messages) {
            boolean _notEquals_2;
            boolean _notEquals_1;
            boolean _notEquals;
            VarDecl _data = message.getData();
            boolean hasData = !Objects.equal((Object)_data, null);
            _builder.newLineIfNotEmpty();
            String _xifexpression_2 = null;
            if (hasData) {
                String _typeName;
                VarDecl _data_1 = message.getData();
                RefableType _refType = _data_1.getRefType();
                DataType _type = _refType.getType();
                _xifexpression_2 = _typeName = this._typeHelpers.typeName(_type);
            } else {
                _xifexpression_2 = "";
            }
            String typeName = _xifexpression_2;
            _builder.newLineIfNotEmpty();
            String _xifexpression_3 = null;
            boolean _and = false;
            if (!hasData) {
                _and = false;
            } else {
                VarDecl _data_2 = message.getData();
                RefableType _refType_1 = _data_2.getRefType();
                boolean _isRef = _refType_1.isRef();
                _and = hasData && _isRef;
            }
            _xifexpression_3 = _and ? "*" : "";
            String refp = _xifexpression_3;
            _builder.newLineIfNotEmpty();
            String _xifexpression_4 = null;
            boolean _and_1 = false;
            if (!hasData) {
                _and_1 = false;
            } else {
                boolean _not;
                boolean _or = false;
                VarDecl _data_3 = message.getData();
                RefableType _refType_2 = _data_3.getRefType();
                DataType _type_1 = _refType_2.getType();
                boolean bl = _not = !(_type_1 instanceof PrimitiveType);
                if (_not) {
                    _or = true;
                } else {
                    VarDecl _data_4 = message.getData();
                    RefableType _refType_3 = _data_4.getRefType();
                    boolean _isRef_1 = _refType_3.isRef();
                    _or = _not || _isRef_1;
                }
                _and_1 = hasData && _or;
            }
            _xifexpression_4 = _and_1 ? "*" : "";
            String refpd = _xifexpression_4;
            _builder.newLineIfNotEmpty();
            String _xifexpression_5 = null;
            boolean _and_2 = false;
            boolean _and_3 = false;
            if (!hasData) {
                _and_3 = false;
            } else {
                VarDecl _data_5 = message.getData();
                RefableType _refType_4 = _data_5.getRefType();
                DataType _type_2 = _refType_4.getType();
                boolean _not_1 = !(_type_2 instanceof PrimitiveType);
                boolean bl = _and_3 = hasData && _not_1;
            }
            if (!_and_3) {
                _and_2 = false;
            } else {
                VarDecl _data_6 = message.getData();
                RefableType _refType_5 = _data_6.getRefType();
                boolean _isRef_2 = _refType_5.isRef();
                boolean _not_2 = !_isRef_2;
                _and_2 = _and_3 && _not_2;
            }
            _xifexpression_5 = _and_2 ? "" : "&";
            String refa = _xifexpression_5;
            _builder.newLineIfNotEmpty();
            String _xifexpression_6 = null;
            if (hasData) {
                String _plus_2;
                String _plus = ", " + typeName;
                String _plus_1 = String.valueOf(_plus) + refpd;
                _xifexpression_6 = _plus_2 = String.valueOf(_plus_1) + " data";
            } else {
                _xifexpression_6 = "";
            }
            String data = _xifexpression_6;
            _builder.newLineIfNotEmpty();
            String _xifexpression_7 = null;
            _xifexpression_7 = hasData ? ", data" : "";
            String dataCall = _xifexpression_7;
            _builder.newLineIfNotEmpty();
            MessageHandler hdlr = this._roomExtensions.getSendHandler(message, conj.booleanValue());
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            String _name = message.getName();
            String _messageSignature = this.messageSignature(portClassName, _name, "", data);
            _builder.append((Object)_messageSignature, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            boolean bl = _notEquals = !Objects.equal((Object)hdlr, null);
            if (_notEquals) {
                _builder.append((Object)"\t");
                DetailCode _detailCode = hdlr.getDetailCode();
                EList _commands = _detailCode.getCommands();
                for (String command : _commands) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)command, "\t");
                    _builder.newLineIfNotEmpty();
                }
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
                _builder.append((Object)portClassName, "\t");
                _builder.append((Object)"\", \"");
                String _name_1 = message.getName();
                _builder.append((Object)_name_1, "\t");
                _builder.append((Object)"\")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                String _name_2 = pc.getName();
                String _name_3 = message.getName();
                String _plus_3 = String.valueOf(dir) + _name_3;
                String _memberInUse = this._cExtensions.memberInUse(_name_2, _plus_3);
                String _plus_4 = String.valueOf(typeName) + refp;
                String _plus_5 = String.valueOf(refa) + "data";
                String _sendMessageCall = this.sendMessageCall(hasData, "self", _memberInUse, _plus_4, _plus_5);
                _builder.append((Object)_sendMessageCall, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
                _builder.newLine();
            }
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            String _name_4 = message.getName();
            String _messageSignature_1 = this.messageSignature(replPortClassName, _name_4, "_broadcast", data);
            _builder.append((Object)_messageSignature_1, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)hdlr, null);
            if (_notEquals_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"int i;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"for (i=0; i<((etReplPort*)self)->size; ++i) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)portClassName, "\t\t");
                _builder.append((Object)"_");
                String _name_5 = message.getName();
                _builder.append((Object)_name_5, "\t\t");
                _builder.append((Object)"((etPort*)&((etReplPort*)self)->ports[i]");
                _builder.append((Object)dataCall, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}\t\t\t\t\t");
                _builder.newLine();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"int i;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
                _builder.append((Object)replPortClassName, "\t");
                _builder.append((Object)"\", \"");
                String _name_6 = message.getName();
                _builder.append((Object)_name_6, "\t");
                _builder.append((Object)"\")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"for (i=0; i<((etReplPort*)self)->size; ++i) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                String _name_7 = pc.getName();
                String _name_8 = message.getName();
                String _plus_6 = String.valueOf(dir) + _name_8;
                String _memberInUse_1 = this._cExtensions.memberInUse(_name_7, _plus_6);
                String _plus_7 = String.valueOf(typeName) + refp;
                String _plus_8 = String.valueOf(refa) + "data";
                String _sendMessageCall_1 = this.sendMessageCall(hasData, "((etPort*)&((etReplPort*)self)->ports[i])", _memberInUse_1, _plus_7, _plus_8);
                _builder.append((Object)_sendMessageCall_1, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
                _builder.newLine();
            }
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            String _name_9 = message.getName();
            String _plus_9 = ", int idx" + data;
            String _messageSignature_2 = this.messageSignature(replPortClassName, _name_9, "", _plus_9);
            _builder.append((Object)_messageSignature_2, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)hdlr, null);
            if (_notEquals_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)portClassName, "\t");
                _builder.append((Object)"_");
                String _name_10 = message.getName();
                _builder.append((Object)_name_10, "\t");
                _builder.append((Object)"((etPort*)&((etReplPort*)self)->ports[idx]");
                _builder.append((Object)dataCall, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
                _builder.append((Object)replPortClassName, "\t");
                _builder.append((Object)"\", \"");
                String _name_11 = message.getName();
                _builder.append((Object)_name_11, "\t");
                _builder.append((Object)"\")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (0<=idx && idx<((etReplPort*)self)->size) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                String _name_12 = pc.getName();
                String _name_13 = message.getName();
                String _plus_10 = String.valueOf(dir) + _name_13;
                String _memberInUse_2 = this._cExtensions.memberInUse(_name_12, _plus_10);
                String _plus_11 = String.valueOf(typeName) + refp;
                String _plus_12 = String.valueOf(refa) + "data";
                String _sendMessageCall_2 = this.sendMessageCall(hasData, "((etPort*)&((etReplPort*)self)->ports[idx])", _memberInUse_2, _plus_11, _plus_12);
                _builder.append((Object)_sendMessageCall_2, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
                _builder.newLine();
            }
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        PortClass _portClass = this._roomExtensions.getPortClass(pc, conj.booleanValue());
        boolean bl = _notEquals_3 = !Objects.equal((Object)_portClass, null);
        if (_notEquals_3) {
            PortClass _portClass_1 = this._roomExtensions.getPortClass(pc, conj.booleanValue());
            EList _operations = _portClass_1.getOperations();
            CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation((List)_operations, portClassName);
            _builder.append((Object)_operationsImplementation, "");
            _builder.newLineIfNotEmpty();
            PortClass _portClass_2 = this._roomExtensions.getPortClass(pc, conj.booleanValue());
            EList _operations_1 = _portClass_2.getOperations();
            CharSequence _operationsImplementation_1 = this._procedureHelpers.operationsImplementation((List)_operations_1, replPortClassName);
            _builder.append((Object)_operationsImplementation_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"// getReplication");
        _builder.newLine();
        _builder.append((Object)"etInt32 ");
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)"_getReplication(const ");
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)"* self) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ((etReplPort*)self)->size;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        boolean _handlesReceive = this._roomExtensions.handlesReceive(pc, conj.booleanValue());
        if (_handlesReceive) {
            CharSequence _genReceiveHandlers = this.genReceiveHandlers(pc, conj);
            _builder.append((Object)_genReceiveHandlers, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String sendMessageCall(boolean hasData, String self, String msg, String typeName, String data) {
        String _xifexpression = null;
        if (hasData) {
            String _plus_7;
            String _plus = "etPort_sendMessage(" + self;
            String _plus_1 = String.valueOf(_plus) + ", ";
            String _plus_2 = String.valueOf(_plus_1) + msg;
            String _plus_3 = String.valueOf(_plus_2) + ", sizeof(";
            String _plus_4 = String.valueOf(_plus_3) + typeName;
            String _plus_5 = String.valueOf(_plus_4) + "), ";
            String _plus_6 = String.valueOf(_plus_5) + data;
            _xifexpression = _plus_7 = String.valueOf(_plus_6) + ");";
        } else {
            String _plus_11;
            String _plus_8 = "etPort_sendMessage(" + self;
            String _plus_9 = String.valueOf(_plus_8) + ", ";
            String _plus_10 = String.valueOf(_plus_9) + msg;
            _xifexpression = _plus_11 = String.valueOf(_plus_10) + ", 0, NULL);";
        }
        return _xifexpression;
    }

    private String messageSignature(String className, String messageName, String methodSuffix, String data) {
        String _plus = "void " + className;
        String _plus_1 = String.valueOf(_plus) + "_";
        String _plus_2 = String.valueOf(_plus_1) + messageName;
        String _plus_3 = String.valueOf(_plus_2) + methodSuffix;
        String _plus_4 = String.valueOf(_plus_3) + "(const ";
        String _plus_5 = String.valueOf(_plus_4) + className;
        String _plus_6 = String.valueOf(_plus_5) + "* self";
        String _plus_7 = String.valueOf(_plus_6) + data;
        String _plus_8 = String.valueOf(_plus_7) + ")";
        return _plus_8;
    }

    private String messageSetterSignature(String className, String messageName, String data) {
        String _plus = "void " + className;
        String _plus_1 = String.valueOf(_plus) + "_";
        String _plus_2 = String.valueOf(_plus_1) + messageName;
        String _plus_3 = String.valueOf(_plus_2) + "_set(";
        String _plus_4 = String.valueOf(_plus_3) + className;
        String _plus_5 = String.valueOf(_plus_4) + "* self";
        String _plus_6 = String.valueOf(_plus_5) + data;
        String _plus_7 = String.valueOf(_plus_6) + ")";
        return _plus_7;
    }

    private String messageGetterSignature(String className, String messageName, String type) {
        String _plus = String.valueOf(type) + " ";
        String _plus_1 = String.valueOf(_plus) + className;
        String _plus_2 = String.valueOf(_plus_1) + "_";
        String _plus_3 = String.valueOf(_plus_2) + messageName;
        String _plus_4 = String.valueOf(_plus_3) + "_get(const ";
        String _plus_5 = String.valueOf(_plus_4) + className;
        String _plus_6 = String.valueOf(_plus_5) + "* const self)";
        return _plus_6;
    }

    private CharSequence genReceiveHandlers(ProtocolClass pc, Boolean conj) {
        StringConcatenation _xblockexpression = null;
        String portClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/* receiver handlers */");
        _builder.newLine();
        List _receiveHandlers = this._roomExtensions.getReceiveHandlers(pc, conj.booleanValue());
        for (MessageHandler h : _receiveHandlers) {
            _builder.append((Object)"void ");
            _builder.append((Object)portClassName, "");
            _builder.append((Object)"_");
            Message _msg = h.getMsg();
            String _name = _msg.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"_receiveHandler(");
            _builder.append((Object)portClassName, "");
            _builder.append((Object)"* self, const etMessage* msg, void * actor, etActorReceiveMessage receiveMessageFunc){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            DetailCode _detailCode = h.getDetailCode();
            CharSequence _userCode = this._procedureHelpers.userCode(_detailCode);
            _builder.append((Object)_userCode, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* hand over the message to the actor:      */");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* (*receiveMessageFunc)(actor, self, msg); */");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateDebugHelpersImplementation(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"/* message names as strings for debugging (generate MSC) */");
        _builder.newLine();
        _builder.append((Object)"static const char* const ");
        String _name = pc.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_messageStrings[] = {\"MIN\", ");
        List _allOutgoingMessages = this._roomExtensions.getAllOutgoingMessages(pc);
        for (Message m : _allOutgoingMessages) {
            _builder.append((Object)"\"");
            String _name_1 = m.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)"\",");
        }
        List _allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc);
        for (Message m_1 : _allIncomingMessages) {
            _builder.append((Object)"\"");
            String _name_2 = m_1.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)"\", ");
        }
        _builder.append((Object)"\"MAX\"};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"const char* ");
        String _name_3 = pc.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"_getMessageString(int msg_id) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (msg_id<");
        String _name_4 = pc.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)"_MSG_MIN || msg_id>");
        String _name_5 = pc.getName();
        _builder.append((Object)_name_5, "\t");
        _builder.append((Object)"_MSG_MAX+1){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"/* id out of range */");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return \"Message ID out of range\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"else{");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_6 = pc.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)"_messageStrings[msg_id];");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }
}

