/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.ConfigExtension;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class SubSystemClassGen {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private CExtensions stdExt;
    @Inject
    private RoomExtensions roomExt;
    @Inject
    private ProcedureHelpers helpers;
    @Inject
    private ConfigExtension _configExtension;
    @Inject
    private ILanguageExtension languageExt;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _subSystemInstances = root.getSubSystemInstances();
        for (SubSystemInstance ssi : _subSystemInstances) {
            String _dispSourceFileName;
            String _instSourceFileName;
            String _cSourceFileName;
            SubSystemClass _subSystemClass = ssi.getSubSystemClass();
            String _generationTargetPath = this.roomExt.getGenerationTargetPath((EObject)_subSystemClass);
            SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
            String _path = this.roomExt.getPath((RoomClass)_subSystemClass_1);
            String path = String.valueOf(_generationTargetPath) + _path;
            SubSystemClass _subSystemClass_2 = ssi.getSubSystemClass();
            String file = this.stdExt.getCHeaderFileName((RoomClass)_subSystemClass_2);
            String _plus = "generating SubSystemClass declaration: '" + file;
            String _plus_1 = String.valueOf(_plus) + "' in '";
            String _plus_2 = String.valueOf(_plus_1) + path;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.logger.logInfo(_plus_3);
            this.fileAccess.setOutputPath(path);
            SubSystemClass _subSystemClass_3 = ssi.getSubSystemClass();
            CharSequence _generateHeaderFile = this.generateHeaderFile(root, ssi, _subSystemClass_3);
            this.fileAccess.generateFile(file, _generateHeaderFile);
            SubSystemClass _subSystemClass_4 = ssi.getSubSystemClass();
            file = _cSourceFileName = this.stdExt.getCSourceFileName((RoomClass)_subSystemClass_4);
            String _plus_4 = "generating SubSystemClass implementation: '" + file;
            String _plus_5 = String.valueOf(_plus_4) + "' in '";
            String _plus_6 = String.valueOf(_plus_5) + path;
            String _plus_7 = String.valueOf(_plus_6) + "'";
            this.logger.logInfo(_plus_7);
            this.fileAccess.setOutputPath(path);
            SubSystemClass _subSystemClass_5 = ssi.getSubSystemClass();
            CharSequence _generateSourceFile = this.generateSourceFile(root, ssi, _subSystemClass_5);
            this.fileAccess.generateFile(file, _generateSourceFile);
            SubSystemClass _subSystemClass_6 = ssi.getSubSystemClass();
            file = _instSourceFileName = this.stdExt.getInstSourceFileName((RoomClass)_subSystemClass_6);
            String _plus_8 = "generating SubSystemClass instance file: '" + file;
            String _plus_9 = String.valueOf(_plus_8) + "' in '";
            String _plus_10 = String.valueOf(_plus_9) + path;
            String _plus_11 = String.valueOf(_plus_10) + "'";
            this.logger.logInfo(_plus_11);
            this.fileAccess.setOutputPath(path);
            SubSystemClass _subSystemClass_7 = ssi.getSubSystemClass();
            CharSequence _generateInstanceFile = this.generateInstanceFile(root, ssi, _subSystemClass_7);
            this.fileAccess.generateFile(file, _generateInstanceFile);
            SubSystemClass _subSystemClass_8 = ssi.getSubSystemClass();
            file = _dispSourceFileName = this.stdExt.getDispSourceFileName((RoomClass)_subSystemClass_8);
            String _plus_12 = "generating SubSystemClass dispatcher file: '" + file;
            String _plus_13 = String.valueOf(_plus_12) + "' in '";
            String _plus_14 = String.valueOf(_plus_13) + path;
            String _plus_15 = String.valueOf(_plus_14) + "'";
            this.logger.logInfo(_plus_15);
            this.fileAccess.setOutputPath(path);
            SubSystemClass _subSystemClass_9 = ssi.getSubSystemClass();
            CharSequence _generateDispatcherFile = this.generateDispatcherFile(root, ssi, _subSystemClass_9);
            this.fileAccess.generateFile(file, _generateDispatcherFile);
        }
    }

    private CharSequence generateHeaderFile(Root root, SubSystemInstance ssi, SubSystemClass ssc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of SubSystemClass ");
        String _name = ssc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        String _name_1 = ssc.getName();
        CharSequence _generateIncludeGuardBegin = this.stdExt.generateIncludeGuardBegin(_name_1);
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        DetailCode _userCode1 = ssc.getUserCode1();
        CharSequence _userCode = this.helpers.userCode(_userCode1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* lifecycle functions");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* init -> start -> run (loop) -> stop -> destroy");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_2 = ssc.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"_init(void);\t\t/* lifecycle init  \t */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"void ");
        String _name_3 = ssc.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"_start(void);\t/* lifecycle start \t */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_4 = ssc.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)"_run(void);\t\t/* lifecycle run \t */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_5 = ssc.getName();
        _builder.append((Object)_name_5, "");
        _builder.append((Object)"_stop(void); \t/* lifecycle stop\t */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"void ");
        String _name_6 = ssc.getName();
        _builder.append((Object)_name_6, "");
        _builder.append((Object)"_destroy(void); \t/* lifecycle destroy */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void SubSysClass_shutdown(void);  /* shutdown the dispatcher loop */");
        _builder.newLine();
        _builder.newLine();
        DetailCode _userCode2 = ssc.getUserCode2();
        CharSequence _userCode_1 = this.helpers.userCode(_userCode2);
        _builder.append((Object)_userCode_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _name_7 = ssc.getName();
        CharSequence _generateIncludeGuardEnd = this.stdExt.generateIncludeGuardEnd(_name_7);
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateSourceFile(Root root, SubSystemInstance ssi, SubSystemClass ssc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of SubSystemClass ");
        String _name = ssc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cHeaderFileName = this.stdExt.getCHeaderFileName((RoomClass)ssc);
        _builder.append((Object)_cHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* include instances for all classes */");
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _instSourceFileName = this.stdExt.getInstSourceFileName((RoomClass)ssc);
        _builder.append((Object)_instSourceFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#include \"");
        String _dispSourceFileName = this.stdExt.getDispSourceFileName((RoomClass)ssc);
        _builder.append((Object)_dispSourceFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"platform/etTimer.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"etRuntimeConfig.h\"");
        _builder.newLine();
        _builder.newLine();
        DetailCode _userCode3 = ssc.getUserCode3();
        CharSequence _userCode = this.helpers.userCode(_userCode3);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* data for SubSysten ");
        String _name_1 = ssc.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef struct ");
        String _name_2 = ssc.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"char *name;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"volatile int shutdownRequest;");
        _builder.newLine();
        _builder.append((Object)"} ");
        String _name_3 = ssc.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"static ");
        String _name_4 = ssc.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)" ");
        String _name_5 = ssc.getName();
        _builder.append((Object)_name_5, "");
        _builder.append((Object)"Inst = {\"");
        String _name_6 = ssc.getName();
        _builder.append((Object)_name_6, "");
        _builder.append((Object)"\",0};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_7 = ssc.getName();
        _builder.append((Object)_name_7, "");
        _builder.append((Object)"_initActorInstances(void);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"void ");
        String _name_8 = ssc.getName();
        _builder.append((Object)_name_8, "");
        _builder.append((Object)"_constructActorInstances(void);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_9 = ssc.getName();
        _builder.append((Object)_name_9, "");
        _builder.append((Object)"_init(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"SubSys\", \"init\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_init\", ");
        String _name_10 = ssc.getName();
        _builder.append((Object)_name_10, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* construct all actors */");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_11 = ssc.getName();
        _builder.append((Object)_name_11, "\t");
        _builder.append((Object)"_constructActorInstances();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* initialization of all message services */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etMessageService_init(&msgService_Thread1, msgBuffer_Thread1, MESSAGE_POOL_MAX, MESSAGE_BLOCK_SIZE, MsgDispatcher_Thread1_receiveMessage);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* init all actors */");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_12 = ssc.getName();
        _builder.append((Object)_name_12, "\t");
        _builder.append((Object)"_initActorInstances();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_13 = ssc.getName();
        _builder.append((Object)_name_13, "");
        _builder.append((Object)"_start(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"SubSys\", \"start\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_start\", ");
        String _name_14 = ssc.getName();
        _builder.append((Object)_name_14, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_15 = ssc.getName();
        _builder.append((Object)_name_15, "");
        _builder.append((Object)"_run(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"SubSys\", \"run\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#ifdef ET_RUNTIME_ENDLESS");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"while(!(");
        String _name_16 = ssc.getName();
        _builder.append((Object)_name_16, "\t\t");
        _builder.append((Object)"Inst.shutdownRequest)){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (etTimer_executeNeeded()){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"etMessageService_execute(&msgService_Thread1);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        CharSequence _generateDatadrivenExecutes = this.generateDatadrivenExecutes(root, ssi);
        _builder.append((Object)_generateDatadrivenExecutes, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#else");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"uint32 loopCounter = 0;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"while(!(");
        String _name_17 = ssc.getName();
        _builder.append((Object)_name_17, "\t\t");
        _builder.append((Object)"Inst.shutdownRequest)){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (etTimer_executeNeeded()){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"etMessageService_execute(&msgService_Thread1);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        CharSequence _generateDatadrivenExecutes_1 = this.generateDatadrivenExecutes(root, ssi);
        _builder.append((Object)_generateDatadrivenExecutes_1, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"etLogger_logInfo(\"Execute\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (loopCounter++ > ET_RUNTIME_MAXLOOP){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#endif");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_18 = ssc.getName();
        _builder.append((Object)_name_18, "");
        _builder.append((Object)"_stop(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"SubSys\", \"stop\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_stop\", ");
        String _name_19 = ssc.getName();
        _builder.append((Object)_name_19, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_20 = ssc.getName();
        _builder.append((Object)_name_20, "");
        _builder.append((Object)"_destroy(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"SubSys\", \"destroy\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_destroy\", ");
        String _name_21 = ssc.getName();
        _builder.append((Object)_name_21, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        EList _allContainedInstances = ssi.getAllContainedInstances();
        List _reverseView = ListExtensions.reverseView((List)_allContainedInstances);
        for (ActorInstance ai : _reverseView) {
            boolean _not;
            Object _function;
            ActorClass _actorClass = ai.getActorClass();
            EList _operations = _actorClass.getOperations();
            Iterable _filter = IterableExtensions.filter((Iterable)_operations, (Functions.Function1)(_function = new Functions.Function1<StandardOperation, Boolean>(){

                public Boolean apply(StandardOperation op) {
                    boolean _isDestructor = op.isDestructor();
                    return _isDestructor;
                }
            }));
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            _builder.append((Object)"\t");
            ActorClass _actorClass_1 = ai.getActorClass();
            String _name_22 = _actorClass_1.getName();
            ActorClass _actorClass_2 = ai.getActorClass();
            String _name_23 = _actorClass_2.getName();
            String _destructorName = this.languageExt.destructorName(_name_23);
            String _memberInUse = this.languageExt.memberInUse(_name_22, _destructorName);
            _builder.append((Object)_memberInUse, "\t");
            _builder.append((Object)"(&");
            String _path = ai.getPath();
            String _pathName = this.roomExt.getPathName(_path);
            _builder.append((Object)_pathName, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void SubSysClass_shutdown(void){");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"SubSys\", \"shutdown\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_shutdown\", ");
        String _name_24 = ssc.getName();
        _builder.append((Object)_name_24, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _name_25 = ssc.getName();
        _builder.append((Object)_name_25, "\t");
        _builder.append((Object)"Inst.shutdownRequest = 1;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_26 = ssc.getName();
        _builder.append((Object)_name_26, "");
        _builder.append((Object)"_constructActorInstances(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        String _name_27 = ssc.getName();
        _builder.append((Object)_name_27, "\t");
        _builder.append((Object)"\", \"constructActorInstances\")");
        _builder.newLineIfNotEmpty();
        EList _allContainedInstances_1 = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_1) {
            boolean _not_1;
            Functions.Function1<StandardOperation, Boolean> _function_1;
            ActorClass _actorClass_3 = ai_1.getActorClass();
            EList _operations_1 = _actorClass_3.getOperations();
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_operations_1, (Functions.Function1)(_function_1 = new Functions.Function1<StandardOperation, Boolean>(){

                public Boolean apply(StandardOperation op) {
                    boolean _isConstructor = RoomHelpers.isConstructor((Operation)op);
                    return _isConstructor;
                }
            }));
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)_filter_1);
            boolean bl = _not_1 = !_isEmpty_1;
            if (!_not_1) continue;
            _builder.append((Object)"\t");
            ActorClass _actorClass_4 = ai_1.getActorClass();
            String _name_28 = _actorClass_4.getName();
            ActorClass _actorClass_5 = ai_1.getActorClass();
            String _name_29 = _actorClass_5.getName();
            String _constructorName = this.languageExt.constructorName(_name_29);
            String _memberInUse_1 = this.languageExt.memberInUse(_name_28, _constructorName);
            _builder.append((Object)_memberInUse_1, "\t");
            _builder.append((Object)"(&");
            String _path_1 = ai_1.getPath();
            String _pathName_1 = this.roomExt.getPathName(_path_1);
            _builder.append((Object)_pathName_1, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_30 = ssc.getName();
        _builder.append((Object)_name_30, "");
        _builder.append((Object)"_initActorInstances(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        String _name_31 = ssc.getName();
        _builder.append((Object)_name_31, "\t");
        _builder.append((Object)"\", \"initActorInstances\")");
        _builder.newLineIfNotEmpty();
        EList _allContainedInstances_2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : _allContainedInstances_2) {
            _builder.append((Object)"\t");
            ActorClass _actorClass_6 = ai_2.getActorClass();
            String _name_32 = _actorClass_6.getName();
            _builder.append((Object)_name_32, "\t");
            _builder.append((Object)"_init(&");
            String _path_2 = ai_2.getPath();
            String _pathName_2 = this.roomExt.getPathName(_path_2);
            _builder.append((Object)_pathName_2, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateInstanceFile(Root root, SubSystemInstance ssi, SubSystemClass ssc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Instance File of SubSystemClass ");
        String _name = ssc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* - instantiation of all actor instances and port instances");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* - configuration of data and connection of ports");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"messaging/etMessageService.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"platform/etMemory.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* instantiation of message services */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* MessageService for Thread1 */");
        _builder.newLine();
        _builder.append((Object)"static uint8 msgBuffer_Thread1[MESSAGE_POOL_MAX*MESSAGE_BLOCK_SIZE];");
        _builder.newLine();
        _builder.append((Object)"static etMessageService msgService_Thread1;");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* include all used ActorClasses */");
        _builder.newLine();
        EList _usedActorClasses = root.getUsedActorClasses();
        for (ActorClass actorClass : _usedActorClasses) {
            _builder.append((Object)"#include \"");
            String _name_1 = actorClass.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* include all used ProtcolClasses */");
        _builder.newLine();
        EList _usedProtocolClasses = root.getUsedProtocolClasses();
        for (ProtocolClass protocolClass : _usedProtocolClasses) {
            _builder.append((Object)"#include \"");
            String _name_2 = protocolClass.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* declarations of all ActorClass instances (const and variable structs) */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* forward declaration of variable actor structs */");
        _builder.newLine();
        EList _allContainedInstances = ssi.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            _builder.append((Object)"static ");
            ActorClass _actorClass = ai.getActorClass();
            String _name_3 = _actorClass.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)" ");
            String _path = ai.getPath();
            String _pathName = this.roomExt.getPathName(_path);
            _builder.append((Object)_pathName, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* forward declaration of variable port structs */\t\t");
        _builder.newLine();
        EList _allContainedInstances_1 = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_1) {
            EList _orderedIfItemInstances = ai_1.getOrderedIfItemInstances();
            boolean _isEmpty = _orderedIfItemInstances.isEmpty();
            if (_isEmpty) {
                _builder.append((Object)"/*nothing to do */");
                _builder.newLine();
                continue;
            }
            EList _orderedIfItemInstances_1 = ai_1.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances_1) {
                boolean _not;
                boolean _isConjugated_1;
                boolean _notEquals;
                boolean _isConjugated;
                ProtocolClass _protocol = pi.getProtocol();
                PortClass _portClass = this.roomExt.getPortClass(_protocol, _isConjugated = this.roomExt.isConjugated(pi));
                boolean bl = _notEquals = !Objects.equal((Object)_portClass, null);
                if (!_notEquals) continue;
                ProtocolClass _protocol_1 = pi.getProtocol();
                PortClass _portClass_1 = this.roomExt.getPortClass(_protocol_1, _isConjugated_1 = this.roomExt.isConjugated(pi));
                EList _attributes = _portClass_1.getAttributes();
                boolean _isEmpty_1 = _attributes.isEmpty();
                boolean bl2 = _not = !_isEmpty_1;
                if (!_not) continue;
                boolean _isReplicated = pi.isReplicated();
                if (_isReplicated) {
                    _builder.append((Object)"static ");
                    ProtocolClass _protocol_2 = pi.getProtocol();
                    boolean _isConjugated_2 = this.roomExt.isConjugated(pi);
                    String _portClassName = this.roomExt.getPortClassName(_protocol_2, _isConjugated_2);
                    _builder.append((Object)_portClassName, "");
                    _builder.append((Object)"_var ");
                    String _path_1 = pi.getPath();
                    String _pathName_1 = this.roomExt.getPathName(_path_1);
                    _builder.append((Object)_pathName_1, "");
                    _builder.append((Object)"_var[");
                    EList _peers = pi.getPeers();
                    int _size = _peers.size();
                    _builder.append((Object)_size, "");
                    _builder.append((Object)"]={");
                    String _genReplPortAttributeInitializer = this.genReplPortAttributeInitializer(pi);
                    _builder.append((Object)_genReplPortAttributeInitializer, "");
                    _builder.append((Object)"};");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"static ");
                ProtocolClass _protocol_3 = pi.getProtocol();
                boolean _isConjugated_3 = this.roomExt.isConjugated(pi);
                String _portClassName_1 = this.roomExt.getPortClassName(_protocol_3, _isConjugated_3);
                _builder.append((Object)_portClassName_1, "");
                _builder.append((Object)"_var ");
                String _path_2 = pi.getPath();
                String _pathName_2 = this.roomExt.getPathName(_path_2);
                _builder.append((Object)_pathName_2, "");
                _builder.append((Object)"_var={");
                CharSequence _genPortAttributeInitializer = this.genPortAttributeInitializer(pi);
                _builder.append((Object)_genPortAttributeInitializer, "");
                _builder.append((Object)"};");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        EList _allContainedInstances_2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : _allContainedInstances_2) {
            _builder.newLine();
            _builder.append((Object)"/* instance ");
            String _path_3 = ai_2.getPath();
            String _pathName_3 = this.roomExt.getPathName(_path_3);
            _builder.append((Object)_pathName_3, "");
            _builder.append((Object)" */");
            _builder.newLineIfNotEmpty();
            EList _orderedIfItemInstances_2 = ai_2.getOrderedIfItemInstances();
            boolean _isEmpty_2 = _orderedIfItemInstances_2.isEmpty();
            if (_isEmpty_2) {
                _builder.append((Object)"/* no ports/saps/services - nothing to initialize statically */");
                _builder.newLine();
                continue;
            }
            CharSequence _genActorInstanceInitializer = this.genActorInstanceInitializer(root, ai_2);
            _builder.append((Object)_genActorInstanceInitializer, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }

    private String genReplPortAttributeInitializer(InterfaceItemInstance pi) {
        boolean _greaterThan;
        int i = 0;
        String retval = "";
        EList _peers = pi.getPeers();
        int _size = _peers.size();
        i = _size;
        boolean _while = _greaterThan = i > 0;
        while (_while) {
            boolean _greaterThan_1;
            boolean _greaterThan_12;
            String _plus_2;
            String _plus = String.valueOf(retval) + "\r\n\t\t\t{";
            CharSequence _genPortAttributeInitializer = this.genPortAttributeInitializer(pi);
            String _plus_1 = String.valueOf(_plus) + _genPortAttributeInitializer;
            retval = _plus_2 = String.valueOf(_plus_1) + "}";
            int _minus = i - 1;
            boolean bl = _greaterThan_12 = (i = _minus) > 0;
            if (_greaterThan_12) {
                String _plus_3;
                retval = _plus_3 = String.valueOf(retval) + ",";
            }
            _while = _greaterThan_1 = i > 0;
        }
        return retval;
    }

    private CharSequence genPortAttributeInitializer(InterfaceItemInstance pi) {
        StringConcatenation _builder = new StringConcatenation();
        ProtocolClass _protocol = pi.getProtocol();
        boolean _isConjugated = this.roomExt.isConjugated(pi);
        PortClass _portClass = this.roomExt.getPortClass(_protocol, _isConjugated);
        EList _attributes = _portClass.getAttributes();
        boolean _hasElements = false;
        for (Attribute attr : _attributes) {
            boolean _notEquals;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            String _defaultValueLiteral = attr.getDefaultValueLiteral();
            boolean bl = _notEquals = !Objects.equal((Object)_defaultValueLiteral, null);
            if (_notEquals) {
                String _defaultValueLiteral_1 = attr.getDefaultValueLiteral();
                _builder.append((Object)_defaultValueLiteral_1, "");
                continue;
            }
            RefableType _refType = attr.getRefType();
            DataType _type = _refType.getType();
            String _defaultValue = this.stdExt.defaultValue(_type);
            _builder.append((Object)_defaultValue, "");
        }
        return _builder;
    }

    private CharSequence genActorInstanceInitializer(Root root, ActorInstance ai) {
        boolean _not;
        String _plus;
        HashMap<InterfaceItemInstance, Integer> _hashMap;
        ArrayList _arrayList_1;
        ArrayList _arrayList;
        StringConcatenation _xblockexpression = null;
        String _path = ai.getPath();
        String instName = this.roomExt.getPathName(_path);
        ArrayList replPorts = _arrayList = new ArrayList();
        EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
        Functions.Function1<InterfaceItemInstance, Boolean> _function = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                boolean _isReplicated = e.isReplicated();
                return _isReplicated;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_orderedIfItemInstances, (Functions.Function1)_function);
        Iterables.addAll(replPorts, (Iterable)_filter);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_1 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                EList _peers = e.getPeers();
                boolean _isEmpty = _peers.isEmpty();
                boolean _not = !_isEmpty;
                return _not;
            }
        };
        InterfaceItemInstance _findFirst = (InterfaceItemInstance)IterableExtensions.findFirst(replPorts, (Functions.Function1)_function_1);
        boolean haveReplSubPorts = !Objects.equal((Object)_findFirst, null);
        EList _orderedIfItemInstances_1 = ai.getOrderedIfItemInstances();
        Functions.Function1<InterfaceItemInstance, Boolean> _function_2 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                boolean _isSimple = e.isSimple();
                return _isSimple;
            }
        };
        Iterable simplePorts = IterableExtensions.filter((Iterable)_orderedIfItemInstances_1, (Functions.Function1)_function_2);
        ArrayList eventPorts = _arrayList_1 = new ArrayList();
        Functions.Function1<InterfaceItemInstance, Boolean> _function_3 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                ProtocolClass _protocol = p.getProtocol();
                CommunicationType _commType = _protocol.getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
                return _equals;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)_function_3);
        Iterable _union = this.roomExt.union(_filter_1, replPorts);
        Iterables.addAll(eventPorts, (Iterable)_union);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_4 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                ProtocolClass _protocol = p.getProtocol();
                CommunicationType _commType = _protocol.getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                return _equals;
            }
        };
        Iterable dataPorts = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)_function_4);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_5 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                boolean _and = false;
                if (!(p instanceof PortInstance)) {
                    _and = false;
                } else {
                    Port _port = ((PortInstance)p).getPort();
                    boolean _isConjugated = _port.isConjugated();
                    boolean _not = !_isConjugated;
                    _and = p instanceof PortInstance && _not;
                }
                return _and;
            }
        };
        Iterable recvPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)_function_5);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_6 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                boolean _and = false;
                if (!(p instanceof PortInstance)) {
                    _and = false;
                } else {
                    Port _port = ((PortInstance)p).getPort();
                    boolean _isConjugated = _port.isConjugated();
                    _and = p instanceof PortInstance && _isConjugated;
                }
                return _and;
            }
        };
        Iterable sendPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)_function_6);
        HashMap<InterfaceItemInstance, Integer> offsets = _hashMap = new HashMap<InterfaceItemInstance, Integer>();
        int offset = 0;
        for (InterfaceItemInstance p : replPorts) {
            int _plus2;
            offsets.put(p, offset);
            EList _peers = p.getPeers();
            int _size = _peers.size();
            offset = _plus2 = offset + _size;
        }
        String _xifexpression = null;
        _xifexpression = haveReplSubPorts ? (_plus = String.valueOf(instName) + "_repl_sub_ports") : "NULL";
        String replSubPortsArray = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        if (haveReplSubPorts) {
            _builder.append((Object)"static const etReplSubPort ");
            _builder.append((Object)replSubPortsArray, "");
            _builder.append((Object)"[");
            _builder.append((Object)offset, "");
            _builder.append((Object)"] = {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* Replicated Sub Ports: {varData, msgService, peerAddress, localId, index} */");
            _builder.newLine();
            Functions.Function1<InterfaceItemInstance, Boolean> _function_7 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

                public Boolean apply(InterfaceItemInstance e) {
                    EList _peers = e.getPeers();
                    boolean _isEmpty = _peers.isEmpty();
                    boolean _not = !_isEmpty;
                    return _not;
                }
            };
            Iterable _filter_2 = IterableExtensions.filter(replPorts, (Functions.Function1)_function_7);
            boolean _hasElements = false;
            for (InterfaceItemInstance pi : _filter_2) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t");
                }
                _builder.append((Object)"\t");
                String _genReplSubPortInitializers = this.genReplSubPortInitializers(root, ai, pi);
                _builder.append((Object)_genReplSubPortInitializers, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"};");
            _builder.newLine();
        }
        boolean _and = false;
        boolean _isEmpty = eventPorts.isEmpty();
        if (!_isEmpty) {
            _and = false;
        } else {
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)recvPorts);
            _and = _isEmpty && _isEmpty_1;
        }
        boolean bl = _not = !_and;
        if (_not) {
            boolean _not_1;
            _builder.append((Object)"static const ");
            ActorClass _actorClass = ai.getActorClass();
            String _name = _actorClass.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"_const ");
            _builder.append((Object)instName, "");
            _builder.append((Object)"_const = {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* Ports: {varData, msgService, peerAddress, localId} */");
            _builder.newLine();
            boolean _hasElements_1 = false;
            for (InterfaceItemInstance pi_1 : eventPorts) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t");
                }
                boolean _isSimple = pi_1.isSimple();
                if (_isSimple) {
                    _builder.append((Object)"\t");
                    String _genPortInitializer = this.genPortInitializer(root, ai, pi_1);
                    _builder.append((Object)_genPortInitializer, "\t");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                EList _peers = pi_1.getPeers();
                int _size = _peers.size();
                _builder.append((Object)_size, "\t");
                _builder.append((Object)", ");
                _builder.append((Object)replSubPortsArray, "\t");
                _builder.append((Object)"+");
                Integer _get = (Integer)offsets.get(pi_1);
                _builder.append((Object)_get, "\t");
                _builder.append((Object)"}");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            boolean _and_1 = false;
            boolean _isEmpty_2 = eventPorts.isEmpty();
            boolean bl2 = _not_1 = !_isEmpty_2;
            if (!_not_1) {
                _and_1 = false;
            } else {
                boolean _isEmpty_3 = IterableExtensions.isEmpty((Iterable)recvPorts);
                boolean _not_2 = !_isEmpty_3;
                boolean bl3 = _and_1 = _not_1 && _not_2;
            }
            if (_and_1) {
                _builder.append((Object)",");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* data receive ports */");
            _builder.newLine();
            boolean _hasElements_2 = false;
            for (InterfaceItemInstance pi_2 : recvPorts) {
                if (!_hasElements_2) {
                    _hasElements_2 = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t");
                }
                _builder.append((Object)"\t");
                String _genRecvPortInitializer = this.genRecvPortInitializer(root, ai, pi_2);
                _builder.append((Object)_genRecvPortInitializer, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"};");
            _builder.newLine();
            _builder.append((Object)"static ");
            ActorClass _actorClass_1 = ai.getActorClass();
            String _name_1 = _actorClass_1.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)" ");
            _builder.append((Object)instName, "");
            _builder.append((Object)" = {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"&");
            _builder.append((Object)instName, "\t");
            _builder.append((Object)"_const,");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* data send ports */");
            _builder.newLine();
            for (InterfaceItemInstance pi_3 : sendPorts) {
                _builder.append((Object)"\t");
                CharSequence _genSendPortInitializer = this.genSendPortInitializer(pi_3);
                _builder.append((Object)_genSendPortInitializer, "\t");
                _builder.append((Object)",");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* attributes */");
            _builder.newLine();
            ActorClass _actorClass_2 = ai.getActorClass();
            List _allAttributes = this.roomExt.getAllAttributes(_actorClass_2);
            for (Attribute att : _allAttributes) {
                boolean _greaterThan;
                _builder.append((Object)"\t");
                String _genAttributeInitializer = this.genAttributeInitializer(ai, att);
                _builder.append((Object)_genAttributeInitializer, "\t");
                _builder.append((Object)",\t/* ");
                String _name_2 = att.getName();
                _builder.append((Object)_name_2, "\t");
                int _size_1 = att.getSize();
                boolean bl4 = _greaterThan = _size_1 > 1;
                if (_greaterThan) {
                    _builder.append((Object)"[");
                    int _size_2 = att.getSize();
                    _builder.append((Object)_size_2, "\t");
                    _builder.append((Object)"]");
                }
                _builder.append((Object)" */");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* state and history are initialized in init fuction */");
            _builder.newLine();
            _builder.append((Object)"};");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String genPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String _plus_10;
        String _xblockexpression = null;
        int _xifexpression = 0;
        EList _peers = pi.getPeers();
        boolean _isEmpty = _peers.isEmpty();
        if (_isEmpty) {
            _xifexpression = 0;
        } else {
            int _objId;
            EList _peers_1 = pi.getPeers();
            InterfaceItemInstance _get = (InterfaceItemInstance)_peers_1.get(0);
            _xifexpression = _objId = _get.getObjId();
        }
        int objId = _xifexpression;
        int _xifexpression_1 = 0;
        EList _peers_2 = pi.getPeers();
        boolean _isEmpty_1 = _peers_2.isEmpty();
        if (_isEmpty_1) {
            _xifexpression_1 = 0;
        } else {
            int _indexOf;
            EList _peers_3 = pi.getPeers();
            InterfaceItemInstance _get_1 = (InterfaceItemInstance)_peers_3.get(0);
            EList _peers_4 = _get_1.getPeers();
            _xifexpression_1 = _indexOf = _peers_4.indexOf((Object)pi);
        }
        int idx = _xifexpression_1;
        String _interfaceItemInstanceData = this.getInterfaceItemInstanceData(pi);
        String _plus = "{" + _interfaceItemInstanceData;
        String _plus_1 = String.valueOf(_plus) + ",";
        String _plus_2 = String.valueOf(_plus_1) + "&msgService_Thread1, ";
        int _plus_3 = objId + idx;
        String _plus_4 = String.valueOf(_plus_2) + Integer.valueOf(_plus_3);
        String _plus_5 = String.valueOf(_plus_4) + ", ";
        ExpandedActorClass _expandedActorClass = root.getExpandedActorClass(ai);
        InterfaceItem _interfaceItem = pi.getInterfaceItem();
        int _interfaceItemLocalId = _expandedActorClass.getInterfaceItemLocalId(_interfaceItem);
        int _plus_6 = _interfaceItemLocalId + 1;
        String _plus_7 = String.valueOf(_plus_5) + Integer.valueOf(_plus_6);
        String _plus_8 = String.valueOf(_plus_7) + "} /* Port ";
        String _name = pi.getName();
        String _plus_9 = String.valueOf(_plus_8) + _name;
        _xblockexpression = _plus_10 = String.valueOf(_plus_9) + " */";
        return _xblockexpression;
    }

    private CharSequence genSendPortInitializer(InterfaceItemInstance pi) {
        StringConcatenation _xblockexpression = null;
        Port _port = ((PortInstance)pi).getPort();
        GeneralProtocolClass _protocol = _port.getProtocol();
        ProtocolClass pc = (ProtocolClass)_protocol;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        EList _incomingMessages = pc.getIncomingMessages();
        boolean _hasElements = false;
        for (Message m : _incomingMessages) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            VarDecl _data = m.getData();
            RefableType _refType = _data.getRefType();
            DataType _type = _refType.getType();
            String _defaultValue = this.stdExt.defaultValue(_type);
            _builder.append((Object)_defaultValue, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String genAttributeInitializer(ActorInstance ai, Attribute att) {
        String _string;
        String _initializationWithDefaultValues;
        String _xblockexpression = null;
        String value = this._configExtension.getInitValueLiteral(att);
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)value, null);
        _xifexpression = _equals ? (_initializationWithDefaultValues = this.stdExt.initializationWithDefaultValues(att)) : (_string = value.toString());
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String getInterfaceItemInstanceData(InterfaceItemInstance pi) {
        boolean _isConjugated_1;
        boolean _isConjugated;
        ProtocolClass _protocol = pi.getProtocol();
        PortClass _portClass = this.roomExt.getPortClass(_protocol, _isConjugated = this.roomExt.isConjugated(pi));
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            return "0";
        }
        ProtocolClass _protocol_1 = pi.getProtocol();
        PortClass _portClass_1 = this.roomExt.getPortClass(_protocol_1, _isConjugated_1 = this.roomExt.isConjugated(pi));
        EList _attributes = _portClass_1.getAttributes();
        boolean _isEmpty = _attributes.isEmpty();
        if (_isEmpty) {
            return "0";
        }
        String _path = pi.getPath();
        String _pathName = this.roomExt.getPathName(_path);
        String _plus = "&" + _pathName;
        return String.valueOf(_plus) + "_var";
    }

    private String genRecvPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String _plus_3;
        String _xblockexpression = null;
        EList _peers = pi.getPeers();
        boolean _isEmpty = _peers.isEmpty();
        if (_isEmpty) {
            return "{NULL}";
        }
        EList _peers_1 = pi.getPeers();
        InterfaceItemInstance peer = (InterfaceItemInstance)_peers_1.get(0);
        EList _peers_2 = pi.getPeers();
        InterfaceItemInstance _get = (InterfaceItemInstance)_peers_2.get(0);
        EObject _eContainer = _get.eContainer();
        ActorInstance peerInst = (ActorInstance)_eContainer;
        String _path = peerInst.getPath();
        String instName = this.roomExt.getPathName(_path);
        String _plus = "{&" + instName;
        String _plus_1 = String.valueOf(_plus) + ".";
        String _name = peer.getName();
        String _plus_2 = String.valueOf(_plus_1) + _name;
        _xblockexpression = _plus_3 = String.valueOf(_plus_2) + "}";
        return _xblockexpression;
    }

    private String genReplSubPortInitializers(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String result = "";
        EList _peers = pi.getPeers();
        for (InterfaceItemInstance p : _peers) {
            String _plus_19;
            EList _peers_1 = pi.getPeers();
            int idx = _peers_1.indexOf((Object)p);
            String _xifexpression = null;
            EList _peers_2 = pi.getPeers();
            int _size = _peers_2.size();
            int _minus = _size - 1;
            boolean _lessThan = idx < _minus;
            _xifexpression = _lessThan ? "," : "";
            String comma = _xifexpression;
            String iiiD = this.getInterfaceItemInstanceData(pi);
            String _xifexpression_1 = null;
            boolean _equals = iiiD.equals("0");
            if (_equals) {
                String _plus;
                _xifexpression_1 = _plus = String.valueOf(iiiD) + ",";
            } else {
                String _plus_3;
                String _plus_1 = String.valueOf(iiiD) + "[";
                String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(idx);
                _xifexpression_1 = _plus_3 = String.valueOf(_plus_2) + "],";
            }
            iiiD = _xifexpression_1;
            String _plus_4 = String.valueOf(result) + "{";
            String _plus_5 = String.valueOf(_plus_4) + iiiD;
            String _plus_6 = String.valueOf(_plus_5) + "&msgService_Thread1, ";
            int _objId = p.getObjId();
            String _plus_7 = String.valueOf(_plus_6) + Integer.valueOf(_objId);
            String _plus_8 = String.valueOf(_plus_7) + ", ";
            ExpandedActorClass _expandedActorClass = root.getExpandedActorClass(ai);
            InterfaceItem _interfaceItem = pi.getInterfaceItem();
            int _interfaceItemLocalId = _expandedActorClass.getInterfaceItemLocalId(_interfaceItem);
            int _plus_9 = _interfaceItemLocalId + 1;
            String _plus_10 = String.valueOf(_plus_8) + Integer.valueOf(_plus_9);
            String _plus_11 = String.valueOf(_plus_10) + ", ";
            String _plus_12 = String.valueOf(_plus_11) + Integer.valueOf(idx);
            String _plus_13 = String.valueOf(_plus_12) + "}";
            String _plus_14 = String.valueOf(_plus_13) + comma;
            String _plus_15 = String.valueOf(_plus_14) + " /* Repl Sub Port ";
            String _name = pi.getName();
            String _plus_16 = String.valueOf(_plus_15) + _name;
            String _plus_17 = String.valueOf(_plus_16) + " idx +";
            String _plus_18 = String.valueOf(_plus_17) + Integer.valueOf(idx);
            result = _plus_19 = String.valueOf(_plus_18) + "*/\n";
        }
        return result;
    }

    private CharSequence generateDispatcherFile(Root root, SubSystemInstance ssi, SubSystemClass ssc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Dispatcher File of SubSystemClass ");
        String _name = ssc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* - one generated dispatcher for each MessageService (Thread)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"messaging/etMessageReceiver.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"static void MsgDispatcher_Thread1_receiveMessage(const etMessage* msg){");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"MsgDispatcher_Thread1\", \"receiveMessage\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"switch(msg->address){");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _allContainedInstances = ssi.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"/* interface items of ");
            String _path = ai.getPath();
            _builder.append((Object)_path, "\t\t");
            _builder.append((Object)" */");
            _builder.newLineIfNotEmpty();
            EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
            Functions.Function1<InterfaceItemInstance, Boolean> _function = new Functions.Function1<InterfaceItemInstance, Boolean>(){

                public Boolean apply(InterfaceItemInstance p) {
                    ProtocolClass _protocol = p.getProtocol();
                    CommunicationType _commType = _protocol.getCommType();
                    boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
                    return _equals;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_orderedIfItemInstances, (Functions.Function1)_function);
            for (InterfaceItemInstance pi : _filter) {
                boolean _isReplicated = pi.isReplicated();
                if (_isReplicated) {
                    EList _peers = pi.getPeers();
                    for (InterfaceItemInstance peer : _peers) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"case ");
                        int _objId = pi.getObjId();
                        EList _peers_1 = pi.getPeers();
                        int _indexOf = _peers_1.indexOf((Object)peer);
                        int _plus = _objId + _indexOf;
                        _builder.append((Object)_plus, "\t\t");
                        _builder.append((Object)":");
                        _builder.newLineIfNotEmpty();
                        ProtocolClass _protocol = pi.getProtocol();
                        boolean _isConjugated = this.roomExt.isConjugated(pi);
                        boolean _handlesReceive = this.roomExt.handlesReceive(_protocol, _isConjugated);
                        if (_handlesReceive) {
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"switch (msg->evtID){");
                            _builder.newLine();
                            ProtocolClass _protocol_1 = pi.getProtocol();
                            boolean _isConjugated_1 = this.roomExt.isConjugated(pi);
                            List _receiveHandlers = this.roomExt.getReceiveHandlers(_protocol_1, _isConjugated_1);
                            for (MessageHandler h : _receiveHandlers) {
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"case ");
                                ProtocolClass _protocol_2 = pi.getProtocol();
                                String _name_1 = _protocol_2.getName();
                                _builder.append((Object)_name_1, "\t\t\t");
                                _builder.append((Object)"_");
                                Message _msg = h.getMsg();
                                String _codeName = this.roomExt.getCodeName(_msg);
                                _builder.append((Object)_codeName, "\t\t\t");
                                _builder.append((Object)":");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t");
                                ProtocolClass _protocol_3 = pi.getProtocol();
                                boolean _isConjugated_2 = this.roomExt.isConjugated(pi);
                                String _portClassName = this.roomExt.getPortClassName(_protocol_3, _isConjugated_2);
                                _builder.append((Object)_portClassName, "\t\t\t\t");
                                _builder.append((Object)"_");
                                Message _msg_1 = h.getMsg();
                                String _name_2 = _msg_1.getName();
                                _builder.append((Object)_name_2, "\t\t\t\t");
                                _builder.append((Object)"_receiveHandler((etPort *)&");
                                String _path_1 = ai.getPath();
                                String _pathName = this.roomExt.getPathName(_path_1);
                                _builder.append((Object)_pathName, "\t\t\t\t");
                                _builder.append((Object)"_const.");
                                String _name_3 = pi.getName();
                                _builder.append((Object)_name_3, "\t\t\t\t");
                                _builder.append((Object)".ports[");
                                EList _peers_2 = pi.getPeers();
                                int _indexOf_1 = _peers_2.indexOf((Object)peer);
                                _builder.append((Object)_indexOf_1, "\t\t\t\t");
                                _builder.append((Object)"],msg,(void*)&");
                                String _path_2 = ai.getPath();
                                String _pathName_1 = this.roomExt.getPathName(_path_2);
                                _builder.append((Object)_pathName_1, "\t\t\t\t");
                                _builder.append((Object)",");
                                ActorClass _actorClass = ai.getActorClass();
                                String _name_4 = _actorClass.getName();
                                _builder.append((Object)_name_4, "\t\t\t\t");
                                _builder.append((Object)"_receiveMessage);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"break;");
                                _builder.newLine();
                            }
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"default: ");
                            ActorClass _actorClass_1 = ai.getActorClass();
                            String _name_5 = _actorClass_1.getName();
                            _builder.append((Object)_name_5, "\t\t\t");
                            _builder.append((Object)"_receiveMessage((void*)&");
                            String _path_3 = ai.getPath();
                            String _pathName_2 = this.roomExt.getPathName(_path_3);
                            _builder.append((Object)_pathName_2, "\t\t\t");
                            _builder.append((Object)",(etPort*)&");
                            String _path_4 = ai.getPath();
                            String _pathName_3 = this.roomExt.getPathName(_path_4);
                            _builder.append((Object)_pathName_3, "\t\t\t");
                            _builder.append((Object)"_const.");
                            String _name_6 = pi.getName();
                            _builder.append((Object)_name_6, "\t\t\t");
                            _builder.append((Object)".ports[");
                            EList _peers_3 = pi.getPeers();
                            int _indexOf_2 = _peers_3.indexOf((Object)peer);
                            _builder.append((Object)_indexOf_2, "\t\t\t");
                            _builder.append((Object)"], msg);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"break;");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"}\t\t\t\t\t\t\t\t\t\t");
                            _builder.newLine();
                        } else {
                            _builder.append((Object)"\t\t");
                            ActorClass _actorClass_2 = ai.getActorClass();
                            String _name_7 = _actorClass_2.getName();
                            _builder.append((Object)_name_7, "\t\t");
                            _builder.append((Object)"_receiveMessage((void*)&");
                            String _path_5 = ai.getPath();
                            String _pathName_4 = this.roomExt.getPathName(_path_5);
                            _builder.append((Object)_pathName_4, "\t\t");
                            _builder.append((Object)",(etPort*)&");
                            String _path_6 = ai.getPath();
                            String _pathName_5 = this.roomExt.getPathName(_path_6);
                            _builder.append((Object)_pathName_5, "\t\t");
                            _builder.append((Object)"_const.");
                            String _name_8 = pi.getName();
                            _builder.append((Object)_name_8, "\t\t");
                            _builder.append((Object)".ports[");
                            EList _peers_4 = pi.getPeers();
                            int _indexOf_3 = _peers_4.indexOf((Object)peer);
                            _builder.append((Object)_indexOf_3, "\t\t");
                            _builder.append((Object)"], msg);");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"break;");
                        _builder.newLine();
                    }
                    continue;
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"case ");
                int _objId_1 = pi.getObjId();
                _builder.append((Object)_objId_1, "\t\t");
                _builder.append((Object)":");
                _builder.newLineIfNotEmpty();
                ProtocolClass _protocol_4 = pi.getProtocol();
                boolean _isConjugated_3 = this.roomExt.isConjugated(pi);
                boolean _handlesReceive_1 = this.roomExt.handlesReceive(_protocol_4, _isConjugated_3);
                if (_handlesReceive_1) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"switch (msg->evtID){");
                    _builder.newLine();
                    ProtocolClass _protocol_5 = pi.getProtocol();
                    boolean _isConjugated_4 = this.roomExt.isConjugated(pi);
                    List _receiveHandlers_1 = this.roomExt.getReceiveHandlers(_protocol_5, _isConjugated_4);
                    for (MessageHandler h_1 : _receiveHandlers_1) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"case ");
                        ProtocolClass _protocol_6 = pi.getProtocol();
                        String _name_9 = _protocol_6.getName();
                        _builder.append((Object)_name_9, "\t\t");
                        _builder.append((Object)"_");
                        Message _msg_2 = h_1.getMsg();
                        String _codeName_1 = this.roomExt.getCodeName(_msg_2);
                        _builder.append((Object)_codeName_1, "\t\t");
                        _builder.append((Object)":");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        ProtocolClass _protocol_7 = pi.getProtocol();
                        boolean _isConjugated_5 = this.roomExt.isConjugated(pi);
                        String _portClassName_1 = this.roomExt.getPortClassName(_protocol_7, _isConjugated_5);
                        _builder.append((Object)_portClassName_1, "\t\t\t");
                        _builder.append((Object)"_");
                        Message _msg_3 = h_1.getMsg();
                        String _name_10 = _msg_3.getName();
                        _builder.append((Object)_name_10, "\t\t\t");
                        _builder.append((Object)"_receiveHandler((etPort *)&");
                        String _path_7 = ai.getPath();
                        String _pathName_6 = this.roomExt.getPathName(_path_7);
                        _builder.append((Object)_pathName_6, "\t\t\t");
                        _builder.append((Object)"_const.");
                        String _name_11 = pi.getName();
                        _builder.append((Object)_name_11, "\t\t\t");
                        _builder.append((Object)",msg,(void*)&");
                        String _path_8 = ai.getPath();
                        String _pathName_7 = this.roomExt.getPathName(_path_8);
                        _builder.append((Object)_pathName_7, "\t\t\t");
                        _builder.append((Object)",");
                        ActorClass _actorClass_3 = ai.getActorClass();
                        String _name_12 = _actorClass_3.getName();
                        _builder.append((Object)_name_12, "\t\t\t");
                        _builder.append((Object)"_receiveMessage);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"break;");
                        _builder.newLine();
                    }
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"default: ");
                    ActorClass _actorClass_4 = ai.getActorClass();
                    String _name_13 = _actorClass_4.getName();
                    _builder.append((Object)_name_13, "\t\t");
                    _builder.append((Object)"_receiveMessage((void*)&");
                    String _path_9 = ai.getPath();
                    String _pathName_8 = this.roomExt.getPathName(_path_9);
                    _builder.append((Object)_pathName_8, "\t\t");
                    _builder.append((Object)",(etPort*)&");
                    String _path_10 = ai.getPath();
                    String _pathName_9 = this.roomExt.getPathName(_path_10);
                    _builder.append((Object)_pathName_9, "\t\t");
                    _builder.append((Object)"_const.");
                    String _name_14 = pi.getName();
                    _builder.append((Object)_name_14, "\t\t");
                    _builder.append((Object)", msg);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t\t");
                    ActorClass _actorClass_5 = ai.getActorClass();
                    String _name_15 = _actorClass_5.getName();
                    _builder.append((Object)_name_15, "\t\t");
                    _builder.append((Object)"_receiveMessage((void*)&");
                    String _path_11 = ai.getPath();
                    String _pathName_10 = this.roomExt.getPathName(_path_11);
                    _builder.append((Object)_pathName_10, "\t\t");
                    _builder.append((Object)",(etPort*)&");
                    String _path_12 = ai.getPath();
                    String _pathName_11 = this.roomExt.getPathName(_path_12);
                    _builder.append((Object)_pathName_11, "\t\t");
                    _builder.append((Object)"_const.");
                    String _name_16 = pi.getName();
                    _builder.append((Object)_name_16, "\t\t");
                    _builder.append((Object)", msg);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"etLogger_logErrorF(\"MessageService_Thread1_receiveMessage: address %d does not exist \", msg->address);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateDatadrivenExecutes(Root root, SubSystemInstance ssi) {
        StringConcatenation _builder = new StringConcatenation();
        EList _allContainedInstances = ssi.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            boolean _or = false;
            ActorClass _actorClass = ai.getActorClass();
            ActorCommunicationType _commType = _actorClass.getCommType();
            boolean _equals = Objects.equal((Object)_commType, (Object)ActorCommunicationType.ASYNCHRONOUS);
            if (_equals) {
                _or = true;
            } else {
                ActorClass _actorClass_1 = ai.getActorClass();
                ActorCommunicationType _commType_1 = _actorClass_1.getCommType();
                boolean _equals_1 = Objects.equal((Object)_commType_1, (Object)ActorCommunicationType.DATA_DRIVEN);
                boolean bl = _or = _equals || _equals_1;
            }
            if (!_or) continue;
            ActorClass _actorClass_2 = ai.getActorClass();
            String _name = _actorClass_2.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"_execute(&");
            String _path = ai.getPath();
            String _pathName = this.roomExt.getPathName(_path);
            _builder.append((Object)_pathName, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }
}

