/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;

@Singleton
public class SubSystemRunnerGen {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private RoomExtensions roomExt;

    public void doGenerate(Root root) {
        EList _subSystemInstances = root.getSubSystemInstances();
        for (SubSystemInstance sc : _subSystemInstances) {
            SubSystemClass _subSystemClass = sc.getSubSystemClass();
            String _generationTargetPath = this.roomExt.getGenerationTargetPath((EObject)_subSystemClass);
            SubSystemClass _subSystemClass_1 = sc.getSubSystemClass();
            String _path = this.roomExt.getPath((RoomClass)_subSystemClass_1);
            String _plus = String.valueOf(_generationTargetPath) + _path;
            this.fileAccess.setOutputPath(_plus);
            String _name = sc.getName();
            String _plus_1 = String.valueOf(_name) + "_Runner.c";
            SubSystemClass _subSystemClass_2 = sc.getSubSystemClass();
            CharSequence _generateSourceFile = this.generateSourceFile(root, sc, _subSystemClass_2);
            this.fileAccess.generateFile(_plus_1, _generateSourceFile);
        }
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance ssi, SubSystemClass ssc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* this class contains the main function running component ");
        String _name = ssi.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* it instantiates ");
        String _name_1 = ssi.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append((Object)" and starts and ends the lifecycle");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _name_2 = ssi.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)".h\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"platform/etPlatform.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* main function");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* creates component and starts and stops the lifecycle");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"int main(void) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etUserEntry(); /* platform specific */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfo(\"***   T H E   B E G I N   ***\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_OPEN(\"main\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* startup sequence  of lifecycle */");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_3 = ssi.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)"_init(); \t\t/* lifecycle init */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _name_4 = ssi.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)"_start(); \t/* lifecycle start */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etUserPreRun(); /* platform specific */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* run Scheduler */");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_5 = ssi.getName();
        _builder.append((Object)_name_5, "\t");
        _builder.append((Object)"_run();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etUserPostRun(); /* platform specific */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* shutdown sequence of lifecycle */");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_6 = ssi.getName();
        _builder.append((Object)_name_6, "\t");
        _builder.append((Object)"_stop(); \t\t/* lifecycle stop */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _name_7 = ssi.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append((Object)"_destroy(); \t/* lifecycle destroy */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_CLOSE");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfo(\"***   T H E   E N D   ***\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etUserExit(); /* platform specific */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return 0;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

