/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.doc.gen.InstanceDiagramGen;
import org.eclipse.etrice.generator.doc.setup.GeneratorModule;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;

public class Main
extends AbstractGenerator {
    public static final String OPTION_LIB = "-lib";
    public static final String OPTION_GEN_INST_DIAG = "-genInstDiag";
    public static final String OPTION_SAVE_GEN_MODEL = "-saveGenModel";
    @Inject
    private IGenerator mainGenerator;
    @Inject
    protected InstanceDiagramGen instanceDiagramGenerator;

    private static void printUsage() {
        output.println(String.valueOf(Main.class.getName()) + " [-saveGenModel <genmodel path>] [-genInstDiag] [-lib] <list of model file paths>");
        output.println("      <list of model file paths>        # model file paths may be specified as");
        output.println("                                        # e.g. C:\\path\\to\\model\\mymodel.room");
        output.println("      -saveGenModel <genmodel path>     # if specified the generator model will be saved to this location");
        output.println("      -genInstDiag                      # if specified an instance diagram is created for each subsystem");
        output.println("      -lib                              # if specified all classes are generated and no instances");
    }

    public static void main(String[] args) {
        int ret = Main.createAndRunGenerator((Module)new GeneratorModule(), (String[])args);
        if (Main.isTerminateOnError() && ret != 0) {
            System.exit(ret);
        }
    }

    public int runGenerator(String[] args) {
        if (args.length == 0) {
            this.logger.logError(String.valueOf(Main.class.getName()) + " - aborting: no arguments!", null);
            Main.printUsage();
            return 1;
        }
        String genModelPath = null;
        ArrayList<String> uriList = new ArrayList<String>();
        boolean genInstDiag = false;
        boolean asLibrary = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(OPTION_SAVE_GEN_MODEL)) {
                if (++i < args.length) {
                    genModelPath = String.valueOf(args[i]) + "/genmodel.egm";
                }
            } else if (args[i].equals(OPTION_GEN_INST_DIAG)) {
                genInstDiag = true;
            } else if (args[i].equals(OPTION_LIB)) {
                asLibrary = true;
            } else {
                uriList.add(args[i]);
            }
            ++i;
        }
        this.setupRoomModel();
        if (!this.runGenerator(uriList, genModelPath, genInstDiag, asLibrary)) {
            return 1;
        }
        return 0;
    }

    protected boolean runGenerator(List<String> uriList, String genModelPath, boolean genInstDiag, boolean asLibrary) {
        ResourceSet rs = (ResourceSet)this.resourceSetProvider.get();
        this.loadModels(uriList, rs);
        if (!this.validateModels(rs)) {
            return false;
        }
        Root genModel = this.createGeneratorModel(rs, asLibrary, genModelPath);
        if (genModel == null) {
            return false;
        }
        this.logger.logInfo("-- starting code generation");
        this.fileAccess.setOutputPath("doc-gen/");
        this.mainGenerator.doGenerate(genModel.eResource(), (IFileSystemAccess)this.fileAccess);
        if (genInstDiag) {
            this.instanceDiagramGenerator.doGenerate(genModel);
        }
        this.logger.logInfo("-- finished code generation");
        return true;
    }
}

