/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.IRoomGenerator;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Singleton
public class InstanceDiagramGen
implements IRoomGenerator {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private RoomExtensions roomExt;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _models = root.getModels();
        for (RoomModel model : _models) {
            String _docGenerationTargetPath = this.roomExt.getDocGenerationTargetPath((EObject)model);
            String path = String.valueOf(_docGenerationTargetPath) + "/images";
            this.fileAccess.setOutputPath(path);
            String file2 = "dot2jpg.bat";
            EList _subSystemInstances = root.getSubSystemInstances();
            for (SubSystemInstance sc : _subSystemInstances) {
                String _name = sc.getName();
                String file = String.valueOf(_name) + "_instanceTree.dot";
                String _plus = "generating LaTeX documentation: '" + file;
                String _plus_1 = String.valueOf(_plus) + "' in '";
                String _plus_2 = String.valueOf(_plus_1) + path;
                String _plus_3 = String.valueOf(_plus_2) + "'";
                this.logger.logInfo(_plus_3);
                SubSystemClass _subSystemClass = sc.getSubSystemClass();
                CharSequence _generate = this.generate(root, sc, _subSystemClass);
                this.fileAccess.generateFile(file, _generate);
            }
            CharSequence _generate2jpg = this.generate2jpg(root);
            this.fileAccess.generateFile(file2, _generate2jpg);
            this.runDot2Jpg();
        }
    }

    public CharSequence generate2jpg(Root root) {
        StringConcatenation _builder = new StringConcatenation();
        EList _subSystemInstances = root.getSubSystemInstances();
        for (SubSystemInstance sc : _subSystemInstances) {
            _builder.append((Object)"dot -Tjpg -o ");
            String _name = sc.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"_instanceTree.jpg ");
            String _name_1 = sc.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)"_instanceTree.dot");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generate(Root root, SubSystemInstance ssi, SubSystemClass ssc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"digraph ");
        String _name = ssi.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"rankdir=LR;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"node [shape=box];");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _path = ssi.getPath();
        String _pathName = this.roomExt.getPathName(_path);
        _builder.append((Object)_pathName, "\t");
        _builder.append((Object)" [label=\"");
        String _name_1 = ssc.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)"\\n(");
        String _name_2 = ssi.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)")\" style=filled color=yellow];");
        _builder.newLineIfNotEmpty();
        EList _instances = ssi.getInstances();
        for (ActorInstance ai : _instances) {
            _builder.append((Object)"\t");
            CharSequence _instance = this.instance(ai);
            _builder.append((Object)_instance, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence instance(ActorInstance ai) {
        StringConcatenation _builder = new StringConcatenation();
        EObject _eContainer = ai.eContainer();
        StructureInstance parent = (StructureInstance)_eContainer;
        _builder.newLineIfNotEmpty();
        String _path = ai.getPath();
        String _pathName = this.roomExt.getPathName(_path);
        _builder.append((Object)_pathName, "");
        _builder.append((Object)" [label=\"");
        String _name = ai.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"\\n(");
        ActorClass _actorClass = ai.getActorClass();
        String _name_1 = _actorClass.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)")\"];");
        _builder.newLineIfNotEmpty();
        String _path_1 = parent.getPath();
        String _pathName_1 = this.roomExt.getPathName(_path_1);
        _builder.append((Object)_pathName_1, "");
        _builder.append((Object)" -> ");
        String _path_2 = ai.getPath();
        String _pathName_2 = this.roomExt.getPathName(_path_2);
        _builder.append((Object)_pathName_2, "");
        _builder.append((Object)";  ");
        _builder.newLineIfNotEmpty();
        EList _instances = ai.getInstances();
        for (ActorInstance sub_ai : _instances) {
            CharSequence _instance = this.instance(sub_ai);
            _builder.append((Object)_instance, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public Process runDot2Jpg() {
        Process _xtrycatchfinallyexpression = null;
        try {
            Process _exec;
            Runtime _runtime = Runtime.getRuntime();
            _xtrycatchfinallyexpression = _exec = _runtime.exec("dot2jpg.bat");
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }
}

