/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class JavaExtensions
implements ILanguageExtension {
    public String getTypedDataDefinition(Message m) {
        VarDecl _data = m.getData();
        String[] _generateArglistAndTypedData = this.generateArglistAndTypedData(_data);
        String _get = (String)((List)Conversions.doWrapArray((Object)_generateArglistAndTypedData)).get(1);
        return _get;
    }

    public String getJavaFileName(RoomClass rc) {
        String _name = rc.getName();
        String _plus = String.valueOf(_name) + ".java";
        return _plus;
    }

    public String toWrapper(String type) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)type, (Object)"int")) {
            _matched = true;
            _switchResult = "Integer";
        }
        if (!_matched && Objects.equal((Object)type, (Object)"char")) {
            _matched = true;
            _switchResult = "Character";
        }
        if (!_matched) {
            String _firstUpper;
            _switchResult = _firstUpper = StringExtensions.toFirstUpper((String)type);
        }
        return _switchResult;
    }

    public String accessLevelPrivate() {
        return "private ";
    }

    public String accessLevelProtected() {
        return "protected ";
    }

    public String accessLevelPublic() {
        return "public ";
    }

    public String memberAccess() {
        return "this.";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        return "";
    }

    public String selfPointer(boolean hasArgs) {
        return "";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        return "";
    }

    public String memberInDeclaration(String namespace, String member) {
        return member;
    }

    public String memberInUse(String namespace, String member) {
        String _plus = String.valueOf(namespace) + ".";
        return String.valueOf(_plus) + member;
    }

    public boolean usesInheritance() {
        return true;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        StringConcatenation _builder = new StringConcatenation();
        for (Pair<String, String> entry : entries) {
            _builder.append((Object)"public static final int ");
            String _first = (String)entry.getFirst();
            _builder.append((Object)_first, "");
            _builder.append((Object)" = ");
            String _second = (String)entry.getSecond();
            _builder.append((Object)_second, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        String _string = _builder.toString();
        return _string;
    }

    public String booleanConstant(boolean b) {
        String _string = Boolean.valueOf(b).toString();
        return _string;
    }

    public String pointerLiteral() {
        return "";
    }

    public String nullPointer() {
        return "null";
    }

    public String voidPointer() {
        return "Object";
    }

    public String arrayDeclaration(String type, int size, String name, boolean isRef) {
        String _plus = String.valueOf(type) + " ";
        String _plus_1 = String.valueOf(_plus) + name;
        String _plus_2 = String.valueOf(_plus_1) + "[]";
        return _plus_2;
    }

    public String constructorName(String cls) {
        return cls;
    }

    public String destructorName(String cls) {
        String _plus = String.valueOf(cls) + "_dtor";
        return _plus;
    }

    public String constructorReturnType() {
        return "";
    }

    public String destructorReturnType() {
        return "void";
    }

    public String toCharArrayExpr(String s) {
        String _plus = "\"" + s;
        String _plus_1 = String.valueOf(_plus) + "\".toCharArray()";
        return _plus_1;
    }

    public String superCall(String baseClassName, String method, String args) {
        String _plus = "super." + method;
        String _plus_1 = String.valueOf(_plus) + "(";
        String _plus_2 = String.valueOf(_plus_1) + args;
        String _plus_3 = String.valueOf(_plus_2) + ");";
        return _plus_3;
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        String _targetName;
        String _switchValue = _targetName = type.getTargetName();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"boolean")) {
            _matched = true;
            return value;
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"byte")) {
            _matched = true;
            return "(byte)" + value;
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"short")) {
            _matched = true;
            return "(short)" + value;
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"int")) {
            _matched = true;
            return value;
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"long")) {
            _matched = true;
            return String.valueOf(value) + "L";
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"float")) {
            _matched = true;
            return String.valueOf(value) + "f";
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"double")) {
            _matched = true;
            return String.valueOf(value) + "d";
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"char")) {
            boolean _equals;
            _matched = true;
            int _length = value.length();
            boolean bl = _equals = _length == 1;
            if (_equals) {
                String _plus = "'" + value;
                return String.valueOf(_plus) + "'";
            }
            return this.toCharArrayExpr(value);
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"String")) {
            _matched = true;
            String _plus_1 = "\"" + value;
            return String.valueOf(_plus_1) + "\"";
        }
        String _targetName_1 = type.getTargetName();
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException(_targetName_1);
        throw _unsupportedOperationException;
    }

    public String defaultValue(DataType dt) {
        if (dt instanceof PrimitiveType) {
            return ((PrimitiveType)dt).getDefaultValueLiteral();
        }
        if (dt instanceof ExternalType) {
            String _targetName = ((ExternalType)dt).getTargetName();
            String _plus = "new " + _targetName;
            return String.valueOf(_plus) + "()";
        }
        String _name = dt.getName();
        String _plus_1 = "new " + _name;
        return String.valueOf(_plus_1) + "()";
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        boolean _greaterThan;
        String _xblockexpression = null;
        String dv = this.defaultValue(dt);
        String _xifexpression = null;
        boolean bl = _greaterThan = size > 1;
        if (_greaterThan) {
            String _plus;
            boolean _lessThan;
            String _xblockexpression_1 = null;
            String res = "{";
            int i = 0;
            boolean _while = _lessThan = i < size;
            while (_while) {
                boolean _lessThan_1;
                boolean _lessThan_12;
                String _plus2;
                res = _plus2 = String.valueOf(res) + dv;
                int _plus_1 = i + 1;
                boolean bl2 = _lessThan_12 = (i = _plus_1) < size;
                if (_lessThan_12) {
                    String _plus_2;
                    res = _plus_2 = String.valueOf(res) + ",";
                }
                _while = _lessThan_1 = i < size;
            }
            _xifexpression = _xblockexpression_1 = (_plus = String.valueOf(res) + "}");
        } else {
            _xifexpression = dv;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String[] generateArglistAndTypedData(VarDecl data) {
        String typeName;
        boolean _equals = Objects.equal((Object)data, null);
        if (_equals) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        RefableType _refType = data.getRefType();
        DataType _type = _refType.getType();
        String castTypeName = typeName = _type.getName();
        RefableType _refType_1 = data.getRefType();
        DataType _type_1 = _refType_1.getType();
        if (_type_1 instanceof PrimitiveType) {
            boolean _notEquals;
            String _targetName;
            RefableType _refType_2 = data.getRefType();
            DataType _type_2 = _refType_2.getType();
            typeName = _targetName = ((PrimitiveType)_type_2).getTargetName();
            RefableType _refType_3 = data.getRefType();
            DataType _type_3 = _refType_3.getType();
            String ct = ((PrimitiveType)_type_3).getCastName();
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)ct, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _isEmpty = ct.isEmpty();
                boolean _not = !_isEmpty;
                boolean bl2 = _and = _notEquals && _not;
            }
            if (_and) {
                castTypeName = ct;
            }
        }
        String _plus = String.valueOf(typeName) + " ";
        String _name = data.getName();
        String _plus_1 = String.valueOf(_plus) + _name;
        String _plus_2 = String.valueOf(_plus_1) + " = (";
        String _plus_3 = String.valueOf(_plus_2) + castTypeName;
        String typedData = String.valueOf(_plus_3) + ") generic_data;\n";
        String _name_1 = data.getName();
        String dataArg = ", " + _name_1;
        String _plus_4 = ", " + typeName;
        String _plus_5 = String.valueOf(_plus_4) + " ";
        String _name_2 = data.getName();
        String typedArgList = String.valueOf(_plus_5) + _name_2;
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{dataArg, typedData, typedArgList}), String.class);
    }
}

