/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.generator.base.DefaultTranslationProvider;

public class JavaTranslationProvider
extends DefaultTranslationProvider {
    @Inject
    ILogger logger;

    public boolean translateMembers() {
        return true;
    }

    public boolean translateTags() {
        return true;
    }

    public String getAttributeSetter(Attribute att, String index, String value, String orig) {
        if (index != null) {
            return String.valueOf(att.getName()) + "[" + index + "] = " + value;
        }
        return String.valueOf(att.getName()) + " = " + value;
    }

    public String getInterfaceItemMessageText(InterfaceItem item, Message msg, ArrayList<String> args, String index, String orig) {
        if (index == null) {
            return orig;
        }
        StringBuilder argtext = new StringBuilder();
        for (String arg : args) {
            argtext.append(", " + arg);
        }
        argtext.delete(0, 2);
        return String.valueOf(item.getName()) + ".get(" + index + ")." + msg.getName() + "(" + argtext.toString() + ")";
    }

    public String translateTag(String tag, DetailCode code) {
        if (tag.equals("ifitem.index")) {
            return "ifitem.getIdx()";
        }
        if (tag.equals("MODEL_LOCATION")) {
            return RoomNameProvider.getDetailCodeLocation((DetailCode)code);
        }
        this.logger.logInfo("unrecognized tag '" + tag + "' in " + RoomNameProvider.getDetailCodeLocation((DetailCode)code) + " of " + RoomNameProvider.getClassLocation((RoomClass)RoomNameProvider.getModelClass((EObject)code)));
        return "<|?" + tag + "?" + "|>";
    }
}

