/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.etrice.generator.java.gen.DataClassGen;
import org.eclipse.etrice.generator.java.gen.Initialization;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;

@Singleton
public class ProtocolClassGen
extends GenericProtocolClassGenerator {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private JavaExtensions _javaExtensions;
    @Inject
    private RoomExtensions _roomExtensions;
    @Inject
    private ProcedureHelpers _procedureHelpers;
    @Inject
    private Initialization _initialization;
    @Inject
    private TypeHelpers _typeHelpers;
    @Inject
    private DataClassGen _dataClassGen;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _usedProtocolClasses = root.getUsedProtocolClasses();
        for (ProtocolClass pc : _usedProtocolClasses) {
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)pc);
            String _path = this._roomExtensions.getPath((RoomClass)pc);
            String path = String.valueOf(_generationTargetPath) + _path;
            String file = this._javaExtensions.getJavaFileName((RoomClass)pc);
            String _plus = "generating ProtocolClass implementation '" + file;
            String _plus_1 = String.valueOf(_plus) + "' in '";
            String _plus_2 = String.valueOf(_plus_1) + path;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.logger.logInfo(_plus_3);
            this.fileAccess.setOutputPath(path);
            CharSequence _generate = this.generate(root, pc);
            this.fileAccess.generateFile(file, _generate);
        }
    }

    public CharSequence generate(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _package = this._roomExtensions.getPackage((RoomClass)pc);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.ArrayList;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.Address;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.Message;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.*;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.debugging.DebuggingService;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(pc, 1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList models = root.getReferencedModels((RoomClass)pc);
        _builder.newLineIfNotEmpty();
        for (RoomModel model : models) {
            _builder.append((Object)"import ");
            String _name = model.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = pc.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// message IDs");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _genMessageIDs = this.genMessageIDs(pc);
        _builder.append((Object)_genMessageIDs, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode(pc, 2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static String messageStrings[] = {\"MIN\", ");
        List _allOutgoingMessages = this._roomExtensions.getAllOutgoingMessages(pc);
        for (Message m : _allOutgoingMessages) {
            _builder.append((Object)"\"");
            String _name_2 = m.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)"\",");
        }
        _builder.append((Object)" ");
        List _allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc);
        for (Message m_1 : _allIncomingMessages) {
            _builder.append((Object)"\"");
            String _name_3 = m_1.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)"\",");
        }
        _builder.append((Object)"\"MAX\"};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getMessageString(int msg_id) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (msg_id<MSG_MIN || msg_id>MSG_MAX+1){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// id out of range");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return \"Message ID out of range\";");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"else{");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return messageStrings[msg_id];");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _portClass = this.portClass(pc, false);
        _builder.append((Object)_portClass, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _portClass_1 = this.portClass(pc, true);
        _builder.append((Object)_portClass_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence portClass(ProtocolClass pc, Boolean conj) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        PortClass pclass = this._roomExtensions.getPortClass(pc, conj.booleanValue());
        String portClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue());
        String replPortClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue(), true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"// port class");
        _builder.newLine();
        _builder.append((Object)"static public class ");
        _builder.append((Object)portClassName, "");
        _builder.append((Object)" extends PortBase {");
        _builder.newLineIfNotEmpty();
        boolean bl = _notEquals = !Objects.equal((Object)pclass, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            DetailCode _userCode = pclass.getUserCode();
            CharSequence _userCode_1 = this._procedureHelpers.userCode(_userCode);
            _builder.append((Object)_userCode_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"// constructors");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)portClassName, "\t");
        _builder.append((Object)"(IEventReceiver actor, String name, int localId, Address addr, Address peerAddress) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this(actor, name, localId, 0, addr, peerAddress);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"DebuggingService.getInstance().addPortInstance(this);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)portClassName, "\t");
        _builder.append((Object)"(IEventReceiver actor, String name, int localId, int idx, Address addr, Address peerAddress) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(actor, name, localId, idx, addr, peerAddress);");
        _builder.newLine();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)pclass, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t\t");
            EList _attributes = pclass.getAttributes();
            CharSequence _attributeInitialization = this._initialization.attributeInitialization((List<Attribute>)_attributes, true);
            _builder.append((Object)_attributeInitialization, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"DebuggingService.getInstance().addPortInstance(this);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void receive(Message m) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (!(m instanceof EventMessage))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"EventMessage msg = (EventMessage) m;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (msg.getEvtId() <= 0 || msg.getEvtId() >= MSG_MAX)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"System.out.println(\"unknown\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (messageStrings[msg.getEvtId()] != \"timerTick\"){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"DebuggingService.getInstance().addMessageAsyncIn(getPeerAddress(), getAddress(), messageStrings[msg.getEvtId()]);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        boolean _handlesReceive = this._roomExtensions.handlesReceive(pc, conj.booleanValue());
        if (_handlesReceive) {
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"switch (msg.getEvtId()) {");
            _builder.newLine();
            List _receiveHandlers = this._roomExtensions.getReceiveHandlers(pc, conj.booleanValue());
            for (MessageHandler hdlr : _receiveHandlers) {
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"case ");
                Message _msg = hdlr.getMsg();
                String _codeName = this._roomExtensions.getCodeName(_msg);
                _builder.append((Object)_codeName, "\t\t\t\t\t");
                _builder.append((Object)":");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                DetailCode _detailCode = hdlr.getDetailCode();
                EList _commands = _detailCode.getCommands();
                for (String command : _commands) {
                    _builder.append((Object)"\t\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)command, "\t\t\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"default:");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"if (msg instanceof EventWithDataMessage)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"getActor().receiveEvent(this, msg.getEvtId(), ((EventWithDataMessage)msg).getData());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"else");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"getActor().receiveEvent(this, msg.getEvtId(), null);");
        _builder.newLine();
        boolean _handlesReceive_1 = this._roomExtensions.handlesReceive(pc, conj.booleanValue());
        if (_handlesReceive_1) {
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)pclass, null);
        if (_notEquals_2) {
            _builder.append((Object)"\t");
            EList _attributes_1 = pclass.getAttributes();
            CharSequence _attributes_2 = this._procedureHelpers.attributes((List)_attributes_1);
            _builder.append((Object)_attributes_2, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"// TODO JH: Avoid collision attr getters/setter <-> user operations");
            _builder.newLine();
            _builder.append((Object)"\t");
            EList _attributes_3 = pclass.getAttributes();
            CharSequence _attributeSettersGettersImplementation = this._procedureHelpers.attributeSettersGettersImplementation((List)_attributes_3, null);
            _builder.append((Object)_attributeSettersGettersImplementation, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList _operations = pclass.getOperations();
            CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation((List)_operations, portClassName);
            _builder.append((Object)_operationsImplementation, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// sent messages");
        _builder.newLine();
        List _outgoing = this._roomExtensions.getOutgoing(pc, conj.booleanValue());
        for (Message m : _outgoing) {
            _builder.append((Object)"\t");
            CharSequence _sendMessage = this.sendMessage(m, conj);
            _builder.append((Object)_sendMessage, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// replicated port class");
        _builder.newLine();
        _builder.append((Object)"static public class ");
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ArrayList<");
        _builder.append((Object)portClassName, "\t");
        _builder.append((Object)"> ports;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private int replication;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)replPortClassName, "\t");
        _builder.append((Object)"(IEventReceiver actor, String name, int localId, Address[] addr,");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"Address[] peerAddress) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"replication = addr==null? 0:addr.length;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"ports = new ArrayList<");
        String _name = pc.getName();
        _builder.append((Object)_name, "\t\t");
        _builder.append((Object)".");
        _builder.append((Object)portClassName, "\t\t");
        _builder.append((Object)">(replication);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (int i=0; i<replication; ++i) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"ports.add(new ");
        _builder.append((Object)portClassName, "\t\t\t");
        _builder.append((Object)"(");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"actor, name+i, localId, i, addr[i], peerAddress[i]));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int getReplication() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return replication;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int getIndexOf(InterfaceItemBase ifitem){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return ifitem.getIdx();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)portClassName, "\t");
        _builder.append((Object)" get(int i) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ports.get(i);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        if (conj.booleanValue()) {
            _builder.append((Object)"\t");
            _builder.append((Object)"// incoming messages");
            _builder.newLine();
            List _allIncomingMessages = this._roomExtensions.getAllIncomingMessages(pc);
            for (Message m_1 : _allIncomingMessages) {
                _builder.append((Object)"\t");
                CharSequence _messageSignature = this.messageSignature(m_1);
                _builder.append((Object)_messageSignature, "\t");
                _builder.append((Object)"{");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"for (int i=0; i<replication; ++i) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"ports.get(i).");
                CharSequence _messageCall = this.messageCall(m_1);
                _builder.append((Object)_messageCall, "\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"// outgoing messages");
            _builder.newLine();
            List _allOutgoingMessages = this._roomExtensions.getAllOutgoingMessages(pc);
            for (Message m_2 : _allOutgoingMessages) {
                _builder.append((Object)"\t");
                CharSequence _messageSignature_1 = this.messageSignature(m_2);
                _builder.append((Object)_messageSignature_1, "\t");
                _builder.append((Object)"{");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"for (int i=0; i<replication; ++i) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"ports.get(i).");
                CharSequence _messageCall_1 = this.messageCall(m_2);
                _builder.append((Object)_messageCall_1, "\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence messageSignature(Message m) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isPriv = m.isPriv();
        if (_isPriv) {
            _builder.append((Object)"private");
        } else {
            _builder.append((Object)"public");
        }
        _builder.append((Object)" void ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (_notEquals) {
            VarDecl _data_1 = m.getData();
            RefableType _refType = _data_1.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            VarDecl _data_2 = m.getData();
            String _name_1 = _data_2.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence messageSignatureExplicit(Message m) {
        StringConcatenation _xblockexpression = null;
        VarDecl _data = m.getData();
        RefableType _refType = _data.getRefType();
        DataType _type = _refType.getType();
        DataClass dc = (DataClass)_type;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public void ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        String _argList = this._dataClassGen.argList(dc);
        _builder.append((Object)_argList, "");
        _builder.append((Object)")");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence messageCall(Message m) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (_notEquals) {
            _builder.append((Object)" ");
            VarDecl _data_1 = m.getData();
            String _name_1 = _data_1.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence sendMessage(Message m, boolean conj) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = conj ? "IN" : "OUT";
        String dir = _xifexpression;
        MessageHandler hdlr = this._roomExtensions.getSendHandler(m, conj);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messageSignature = this.messageSignature(m);
        _builder.append((Object)_messageSignature, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        boolean bl = _notEquals = !Objects.equal((Object)hdlr, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            DetailCode _detailCode = hdlr.getDetailCode();
            EList _commands = _detailCode.getCommands();
            for (String command : _commands) {
                _builder.append((Object)"\t");
                _builder.append((Object)command, "\t");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"if (messageStrings[ ");
            _builder.append((Object)dir, "\t");
            _builder.append((Object)"_");
            String _name = m.getName();
            _builder.append((Object)_name, "\t");
            _builder.append((Object)"] != \"timerTick\"){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService.getInstance().addMessageAsyncOut(getAddress(), getPeerAddress(), messageStrings[");
            _builder.append((Object)dir, "\t");
            _builder.append((Object)"_");
            String _name_1 = m.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)"]);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (getPeerAddress()!=null)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            VarDecl _data = m.getData();
            boolean _equals = Objects.equal((Object)_data, null);
            if (_equals) {
                _builder.append((Object)"getPeerMsgReceiver().receive(new EventMessage(getPeerAddress(), ");
                _builder.append((Object)dir, "\t\t");
                _builder.append((Object)"_");
                String _name_2 = m.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
            } else {
                boolean _not;
                _builder.append((Object)"getPeerMsgReceiver().receive(new EventWithDataMessage(getPeerAddress(), ");
                _builder.append((Object)dir, "\t\t");
                _builder.append((Object)"_");
                String _name_3 = m.getName();
                _builder.append((Object)_name_3, "\t\t");
                _builder.append((Object)", ");
                VarDecl _data_1 = m.getData();
                String _name_4 = _data_1.getName();
                _builder.append((Object)_name_4, "\t\t");
                boolean _and = false;
                VarDecl _data_2 = m.getData();
                RefableType _refType = _data_2.getRefType();
                boolean _isRef = _refType.isRef();
                boolean bl2 = _not = !_isRef;
                if (!_not) {
                    _and = false;
                } else {
                    VarDecl _data_3 = m.getData();
                    RefableType _refType_1 = _data_3.getRefType();
                    DataType _type = _refType_1.getType();
                    boolean _not_1 = !(_type instanceof PrimitiveType);
                    boolean bl3 = _and = _not && _not_1;
                }
                if (_and) {
                    _builder.append((Object)".deepCopy()");
                }
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        boolean _and_1 = false;
        VarDecl _data_4 = m.getData();
        boolean bl4 = _notEquals_1 = !Objects.equal((Object)_data_4, null);
        if (!_notEquals_1) {
            _and_1 = false;
        } else {
            VarDecl _data_5 = m.getData();
            RefableType _refType_2 = _data_5.getRefType();
            DataType _type_1 = _refType_2.getType();
            boolean bl5 = _and_1 = _notEquals_1 && _type_1 instanceof DataClass;
        }
        if (_and_1) {
            CharSequence _messageSignatureExplicit = this.messageSignatureExplicit(m);
            _builder.append((Object)_messageSignatureExplicit, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _name_5 = m.getName();
            _builder.append((Object)_name_5, "\t");
            _builder.append((Object)"(new ");
            VarDecl _data_6 = m.getData();
            RefableType _refType_3 = _data_6.getRefType();
            DataType _type_2 = _refType_3.getType();
            String _name_6 = _type_2.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)"(");
            VarDecl _data_7 = m.getData();
            RefableType _refType_4 = _data_7.getRefType();
            DataType _type_3 = _refType_4.getType();
            String _paramList = this._dataClassGen.paramList((DataClass)_type_3);
            _builder.append((Object)_paramList, "\t");
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

