/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.PortInstanceConfig;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LogicalThread;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.Indexed;
import org.eclipse.etrice.generator.generic.ConfigExtension;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.ConfigGenAddon;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.etrice.generator.java.gen.VariableServiceGen;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class SubSystemClassGen {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private JavaExtensions _javaExtensions;
    @Inject
    private RoomExtensions _roomExtensions;
    @Inject
    private ConfigExtension _configExtension;
    @Inject
    private ConfigGenAddon configAddon;
    @Inject
    private ProcedureHelpers _procedureHelpers;
    @Inject
    private VariableServiceGen varService;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _subSystemInstances = root.getSubSystemInstances();
        for (SubSystemInstance ssi : _subSystemInstances) {
            SubSystemClass _subSystemClass = ssi.getSubSystemClass();
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)_subSystemClass);
            SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
            String _path = this._roomExtensions.getPath((RoomClass)_subSystemClass_1);
            String path = String.valueOf(_generationTargetPath) + _path;
            SubSystemClass _subSystemClass_2 = ssi.getSubSystemClass();
            String file = this._javaExtensions.getJavaFileName((RoomClass)_subSystemClass_2);
            String _plus = "generating SubSystemClass implementation: '" + file;
            String _plus_1 = String.valueOf(_plus) + "' in '";
            String _plus_2 = String.valueOf(_plus_1) + path;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.logger.logInfo(_plus_3);
            this.fileAccess.setOutputPath(path);
            SubSystemClass _subSystemClass_3 = ssi.getSubSystemClass();
            CharSequence _generate = this.generate(root, ssi, _subSystemClass_3);
            this.fileAccess.generateFile(file, _generate);
            SubSystemClass _subSystemClass_4 = ssi.getSubSystemClass();
            boolean _hasVariableService = this._configExtension.hasVariableService(_subSystemClass_4);
            if (!_hasVariableService) continue;
            this.varService.doGenerate(root, ssi);
        }
    }

    public CharSequence generate(Root root, SubSystemInstance comp, SubSystemClass cc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _package = this._roomExtensions.getPackage((RoomClass)cc);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasVariableService = this._configExtension.hasVariableService(cc);
        if (_hasVariableService) {
            _builder.append((Object)"import org.eclipse.etrice.runtime.java.config.VariableService;");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.MessageService;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.RTServices;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.Address;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.RTSystemServicesProtocol.*;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.ActorClassBase;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.SubSystemClassBase;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBase;");
        _builder.newLine();
        _builder.newLine();
        EList models = root.getReferencedModels((RoomClass)cc);
        _builder.newLineIfNotEmpty();
        for (RoomModel model : models) {
            _builder.append((Object)"import ");
            String _name = model.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".*;");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode((ActorContainerClass)cc, 1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = comp.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" extends SubSystemClassBase{");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode((ActorContainerClass)cc, 2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = comp.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)"(String name) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(name);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void receiveEvent(InterfaceItemBase ifitem, int evt, Object data){");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void instantiateMessageServices(){");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"RTServices.getInstance().getMsgSvcCtrl().addMsgSvc(new MessageService(this, new Address(0, 0, 0),\"MessageService_Main\"));");
        _builder.newLine();
        EList _threads = cc.getThreads();
        for (LogicalThread thread : _threads) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"RTServices.getInstance().getMsgSvcCtrl().addMsgSvc(new MessageService(this, new Address(0, ");
            EList _threads_1 = cc.getThreads();
            int _indexOf = _threads_1.indexOf((Object)thread);
            int _plus = _indexOf + 1;
            _builder.append((Object)_plus, "\t\t");
            _builder.append((Object)", 0),\"MessageService_");
            String _name_3 = thread.getName();
            _builder.append((Object)_name_3, "\t\t");
            _builder.append((Object)"\", ");
            int _prio = thread.getPrio();
            _builder.append((Object)_prio, "\t\t");
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void instantiateActors(){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// all addresses");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// Addresses for the Subsystem Systemport");
        _builder.newLine();
        EList _allContainedInstances = comp.getAllContainedInstances();
        int _maxObjId = comp.getMaxObjId();
        Iterable _indexed = Indexed.indexed((Iterable)_allContainedInstances, (int)_maxObjId);
        Iterator _indexOf = _indexed.iterator();
        while (_indexOf.hasNext()) {
            Indexed ai = (Indexed)_indexOf.next();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"Address addr_item_SystemPort_");
            EList _allContainedInstances_1 = comp.getAllContainedInstances();
            ActorInstance _value = (ActorInstance)ai.getValue();
            int _indexOf_1 = _allContainedInstances_1.indexOf((Object)_value);
            _builder.append((Object)_indexOf_1, "\t\t");
            _builder.append((Object)" = new Address(0,0,");
            int _index1 = ai.getIndex1();
            _builder.append((Object)_index1, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        EList _allContainedInstances_2 = comp.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_2) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"// actor instance ");
            String _path = ai_1.getPath();
            _builder.append((Object)_path, "\t\t");
            _builder.append((Object)" itself => Systemport Address");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"Address addr_item_");
            String _path_1 = ai_1.getPath();
            String _pathName = this._roomExtensions.getPathName(_path_1);
            _builder.append((Object)_pathName, "\t\t");
            _builder.append((Object)" = new Address(0,");
            int _threadId = ai_1.getThreadId();
            _builder.append((Object)_threadId, "\t\t");
            _builder.append((Object)",");
            int _objId = ai_1.getObjId();
            _builder.append((Object)_objId, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"// interface items of ");
            String _path_2 = ai_1.getPath();
            _builder.append((Object)_path_2, "\t\t");
            _builder.newLineIfNotEmpty();
            EList _orderedIfItemInstances = ai_1.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances) {
                boolean _isReplicated = pi.isReplicated();
                if (_isReplicated) {
                    EList _peers = pi.getPeers();
                    for (InterfaceItemInstance peer : _peers) {
                        _builder.append((Object)"\t\t");
                        EList _peers_1 = pi.getPeers();
                        int i = _peers_1.indexOf((Object)peer);
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"Address addr_item_");
                        String _path_3 = pi.getPath();
                        String _pathName_1 = this._roomExtensions.getPathName(_path_3);
                        _builder.append((Object)_pathName_1, "\t\t");
                        _builder.append((Object)"_");
                        _builder.append((Object)i, "\t\t");
                        _builder.append((Object)" = new Address(0,");
                        int _threadId_1 = ai_1.getThreadId();
                        _builder.append((Object)_threadId_1, "\t\t");
                        _builder.append((Object)",");
                        int _objId_1 = pi.getObjId();
                        int _plus_1 = _objId_1 + i;
                        _builder.append((Object)_plus_1, "\t\t");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                    }
                    continue;
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"Address addr_item_");
                String _path_4 = pi.getPath();
                String _pathName_2 = this._roomExtensions.getPathName(_path_4);
                _builder.append((Object)_pathName_2, "\t\t");
                _builder.append((Object)" = new Address(0,");
                int _threadId_2 = ai_1.getThreadId();
                _builder.append((Object)_threadId_2, "\t\t");
                _builder.append((Object)",");
                int _objId_2 = pi.getObjId();
                _builder.append((Object)_objId_2, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// instantiate all actor instances");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"instances = new ActorClassBase[");
        EList _allContainedInstances_3 = comp.getAllContainedInstances();
        int _size = _allContainedInstances_3.size();
        _builder.append((Object)_size, "\t\t");
        _builder.append((Object)"];");
        _builder.newLineIfNotEmpty();
        EList _allContainedInstances_4 = comp.getAllContainedInstances();
        for (ActorInstance ai_2 : _allContainedInstances_4) {
            boolean _not_1;
            boolean _not;
            _builder.append((Object)"\t\t");
            _builder.append((Object)"instances[");
            EList _allContainedInstances_5 = comp.getAllContainedInstances();
            int _indexOf_2 = _allContainedInstances_5.indexOf((Object)ai_2);
            _builder.append((Object)_indexOf_2, "\t\t");
            _builder.append((Object)"] = new ");
            ActorClass _actorClass = ai_2.getActorClass();
            String _name_4 = _actorClass.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append((Object)"(");
            _builder.newLineIfNotEmpty();
            EObject _eContainer = ai_2.eContainer();
            if (_eContainer instanceof SubSystemInstance) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"this,");
                _builder.newLine();
            } else {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"instances[");
                EList _allContainedInstances_6 = comp.getAllContainedInstances();
                EObject _eContainer_1 = ai_2.eContainer();
                int _indexOf_3 = _allContainedInstances_6.indexOf((Object)_eContainer_1);
                _builder.append((Object)_indexOf_3, "\t\t\t");
                _builder.append((Object)"],");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"\"");
            String _name_5 = ai_2.getName();
            _builder.append((Object)_name_5, "\t\t\t");
            _builder.append((Object)"\",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"// own interface item addresses");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"new Address[][] {{addr_item_");
            String _path_5 = ai_2.getPath();
            String _pathName_3 = this._roomExtensions.getPathName(_path_5);
            _builder.append((Object)_pathName_3, "\t\t\t");
            _builder.append((Object)"}");
            EList _orderedIfItemInstances_1 = ai_2.getOrderedIfItemInstances();
            boolean _isEmpty = _orderedIfItemInstances_1.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)",");
            }
            _builder.newLineIfNotEmpty();
            EList _orderedIfItemInstances_2 = ai_2.getOrderedIfItemInstances();
            boolean _hasElements = false;
            for (InterfaceItemInstance pi_1 : _orderedIfItemInstances_2) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t\t\t\t");
                }
                boolean _isReplicated_1 = pi_1.isReplicated();
                if (_isReplicated_1) {
                    EList _peers_2 = pi_1.getPeers();
                    boolean _isEmpty_1 = _peers_2.isEmpty();
                    if (_isEmpty_1) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"null");
                        _builder.newLine();
                        continue;
                    }
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    EList _peers_3 = pi_1.getPeers();
                    boolean _hasElements_1 = false;
                    for (InterfaceItemInstance peer_1 : _peers_3) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)",", "\t\t\t\t\t");
                        }
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"addr_item_");
                        String _path_6 = pi_1.getPath();
                        String _pathName_4 = this._roomExtensions.getPathName(_path_6);
                        _builder.append((Object)_pathName_4, "\t\t\t\t\t");
                        _builder.append((Object)"_");
                        EList _peers_4 = pi_1.getPeers();
                        int _indexOf_4 = _peers_4.indexOf((Object)peer_1);
                        _builder.append((Object)_indexOf_4, "\t\t\t\t\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    continue;
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"addr_item_");
                String _path_7 = pi_1.getPath();
                String _pathName_5 = this._roomExtensions.getPathName(_path_7);
                _builder.append((Object)_pathName_5, "\t\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"},");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"// peer interface item addresses");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"new Address[][] {{addr_item_SystemPort_");
            EList _allContainedInstances_7 = comp.getAllContainedInstances();
            int _indexOf_5 = _allContainedInstances_7.indexOf((Object)ai_2);
            _builder.append((Object)_indexOf_5, "\t\t\t");
            _builder.append((Object)"}");
            EList _orderedIfItemInstances_3 = ai_2.getOrderedIfItemInstances();
            boolean _isEmpty_2 = _orderedIfItemInstances_3.isEmpty();
            boolean bl2 = _not_1 = !_isEmpty_2;
            if (_not_1) {
                _builder.append((Object)",");
            }
            _builder.newLineIfNotEmpty();
            EList _orderedIfItemInstances_4 = ai_2.getOrderedIfItemInstances();
            boolean _hasElements_2 = false;
            for (InterfaceItemInstance pi_2 : _orderedIfItemInstances_4) {
                if (!_hasElements_2) {
                    _hasElements_2 = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t\t\t\t");
                }
                boolean _and = false;
                boolean _isReplicated_2 = pi_2.isReplicated();
                if (!_isReplicated_2) {
                    _and = false;
                } else {
                    EList _peers_5 = pi_2.getPeers();
                    boolean _isEmpty_3 = _peers_5.isEmpty();
                    boolean bl3 = _and = _isReplicated_2 && _isEmpty_3;
                }
                if (_and) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"null");
                    _builder.newLine();
                    continue;
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                EList _peers_6 = pi_2.getPeers();
                boolean _isEmpty_4 = _peers_6.isEmpty();
                if (_isEmpty_4) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"null");
                    _builder.newLine();
                } else {
                    EList _peers_7 = pi_2.getPeers();
                    boolean _hasElements_3 = false;
                    for (InterfaceItemInstance pp : _peers_7) {
                        if (!_hasElements_3) {
                            _hasElements_3 = true;
                        } else {
                            _builder.appendImmediate((Object)",", "\t\t\t\t\t");
                        }
                        boolean _isReplicated_3 = pp.isReplicated();
                        if (_isReplicated_3) {
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"addr_item_");
                            String _path_8 = pp.getPath();
                            String _pathName_6 = this._roomExtensions.getPathName(_path_8);
                            _builder.append((Object)_pathName_6, "\t\t\t\t\t");
                            _builder.append((Object)"_");
                            EList _peers_8 = pp.getPeers();
                            int _indexOf_6 = _peers_8.indexOf((Object)pi_2);
                            _builder.append((Object)_indexOf_6, "\t\t\t\t\t");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"addr_item_");
                        String _path_9 = pp.getPath();
                        String _pathName_7 = this._roomExtensions.getPathName(_path_9);
                        _builder.append((Object)_pathName_7, "\t\t\t\t\t");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            List _configAttributes = this._configExtension.getConfigAttributes(ai_2);
            Functions.Function1<AttrInstanceConfig, Boolean> _function = new Functions.Function1<AttrInstanceConfig, Boolean>(){

                public Boolean apply(AttrInstanceConfig c) {
                    boolean _isDynConfig = c.isDynConfig();
                    return _isDynConfig;
                }
            };
            boolean _exists = IterableExtensions.exists((Iterable)_configAttributes, (Functions.Function1)_function);
            if (_exists) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)", variableService");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"); ");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// apply instance attribute configurations");
        _builder.newLine();
        EList _allContainedInstances_8 = comp.getAllContainedInstances();
        for (ActorInstance ai_3 : _allContainedInstances_8) {
            boolean _not_2;
            boolean _and_1 = false;
            List _configAttributes_1 = this._configExtension.getConfigAttributes(ai_3);
            boolean _isEmpty_5 = _configAttributes_1.isEmpty();
            if (!_isEmpty_5) {
                _and_1 = false;
            } else {
                List _configPorts = this._configExtension.getConfigPorts(ai_3);
                boolean _isEmpty_6 = _configPorts.isEmpty();
                _and_1 = _isEmpty_5 && _isEmpty_6;
            }
            boolean bl = _not_2 = !_and_1;
            if (!_not_2) continue;
            _builder.append((Object)"\t\t");
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            ActorClass _actorClass_1 = ai_3.getActorClass();
            String _name_6 = _actorClass_1.getName();
            _builder.append((Object)_name_6, "\t\t\t");
            _builder.append((Object)" inst = (");
            ActorClass _actorClass_2 = ai_3.getActorClass();
            String _name_7 = _actorClass_2.getName();
            _builder.append((Object)_name_7, "\t\t\t");
            _builder.append((Object)") instances[");
            EList _allContainedInstances_9 = comp.getAllContainedInstances();
            int _indexOf_7 = _allContainedInstances_9.indexOf((Object)ai_3);
            _builder.append((Object)_indexOf_7, "\t\t\t");
            _builder.append((Object)"];");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            ActorClass _actorClass_3 = ai_3.getActorClass();
            String _name_8 = _actorClass_3.getName();
            List _configAttributes_2 = this._configExtension.getConfigAttributes(ai_3);
            CharSequence _applyInstanceConfig = this.configAddon.applyInstanceConfig("inst", _name_8, _configAttributes_2);
            _builder.append((Object)_applyInstanceConfig, "\t\t\t");
            _builder.newLineIfNotEmpty();
            List _configPorts_1 = this._configExtension.getConfigPorts(ai_3);
            for (PortInstanceConfig portConfig : _configPorts_1) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                InterfaceItem _item = portConfig.getItem();
                String _name_9 = _item.getName();
                ActorClass _actorClass_4 = ai_3.getActorClass();
                String _name_10 = _actorClass_4.getName();
                CharSequence _invokeGetter = this._procedureHelpers.invokeGetter(_name_9, _name_10);
                String _plus_2 = "inst." + _invokeGetter;
                InterfaceItem _item_1 = portConfig.getItem();
                String _portClassName = this._roomExtensions.getPortClassName((EObject)_item_1);
                EList _attributes = portConfig.getAttributes();
                CharSequence _applyInstanceConfig_1 = this.configAddon.applyInstanceConfig(_plus_2, _portClassName, (List<AttrInstanceConfig>)_attributes);
                _builder.append((Object)_applyInstanceConfig_1, "\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// create the subsystem system port\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"RTSystemPort = new RTSystemServicesProtocolConjPortRepl(this, \"RTSystemPort\",");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"0, //local ID");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"// own addresses");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"new Address[]{");
        _builder.newLine();
        EList _allContainedInstances_10 = comp.getAllContainedInstances();
        boolean _hasElements_4 = false;
        for (ActorInstance ai_4 : _allContainedInstances_10) {
            if (!_hasElements_4) {
                _hasElements_4 = true;
            } else {
                _builder.appendImmediate((Object)",", "\t\t\t\t\t");
            }
            _builder.append((Object)"\t\t\t\t\t");
            _builder.append((Object)"addr_item_SystemPort_");
            EList _allContainedInstances_11 = comp.getAllContainedInstances();
            int _indexOf_8 = _allContainedInstances_11.indexOf((Object)ai_4);
            _builder.append((Object)_indexOf_8, "\t\t\t\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"},");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"// peer addresses");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"new Address[]{");
        _builder.newLine();
        EList _allContainedInstances_12 = comp.getAllContainedInstances();
        boolean _hasElements_5 = false;
        for (ActorInstance ai_5 : _allContainedInstances_12) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate((Object)",", "\t\t\t\t\t");
            }
            _builder.append((Object)"\t\t\t\t\t");
            _builder.append((Object)"addr_item_");
            String _path_10 = ai_5.getPath();
            String _pathName_8 = this._roomExtensions.getPathName(_path_10);
            _builder.append((Object)_pathName_8, "\t\t\t\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        boolean _hasVariableService_1 = this._configExtension.hasVariableService(cc);
        if (_hasVariableService_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"private VariableService variableService;");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public void init(){");
        _builder.newLine();
        boolean _hasVariableService_2 = this._configExtension.hasVariableService(cc);
        if (_hasVariableService_2) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"variableService = new ");
            String _name_11 = comp.getName();
            _builder.append((Object)_name_11, "\t\t\t");
            _builder.append((Object)"VariableService(this);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"super.init();");
        _builder.newLine();
        boolean _hasVariableService_3 = this._configExtension.hasVariableService(cc);
        if (_hasVariableService_3) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"variableService.init();");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public void stop(){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"super.stop();");
        _builder.newLine();
        boolean _hasVariableService_4 = this._configExtension.hasVariableService(cc);
        if (_hasVariableService_4) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"variableService.stop();");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder;
    }
}

