/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.generator.base.ILineOutputLogger;

public class Diagnostician
implements IDiagnostician {
    public static final int INSIGNIFICANT_INDEX = -1;
    private boolean validationFailed = false;
    @Inject
    private ILineOutputLogger logger;

    public void warning(String msg, EObject source, EStructuralFeature feature) {
        this.logger.logInfo("Validation warning: " + this.getMsgTxt(msg, source, feature, -1));
    }

    public void warning(String msg, EObject source, EStructuralFeature feature, int idx) {
        this.logger.logInfo("Validation warning: " + this.getMsgTxt(msg, source, feature, idx));
    }

    public void error(String msg, EObject source, EStructuralFeature feature) {
        this.validationFailed = true;
        this.logger.logInfo("Validation error: " + this.getMsgTxt(msg, source, feature, -1));
    }

    public void error(String msg, EObject source, EStructuralFeature feature, int idx) {
        this.validationFailed = true;
        this.logger.logInfo("Validation error: " + this.getMsgTxt(msg, source, feature, idx));
    }

    public boolean isFailed() {
        return this.validationFailed;
    }

    private String getMsgTxt(String msg, EObject source, EStructuralFeature feature, int idx) {
        if (source == null || feature == null) {
            return msg;
        }
        if (idx == -1) {
            return String.valueOf(msg) + " (" + RoomNameProvider.getName((EObject)source) + ", " + feature.getName() + ")";
        }
        return String.valueOf(msg) + " (" + RoomNameProvider.getName((EObject)source) + ", " + feature.getName() + " at index " + idx + ")";
    }
}

