/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.config.ActorClassConfig;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.config.AttrClassConfig;
import org.eclipse.etrice.core.config.AttrConfig;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.BooleanLiteral;
import org.eclipse.etrice.core.config.DynamicConfig;
import org.eclipse.etrice.core.config.IntLiteral;
import org.eclipse.etrice.core.config.Literal;
import org.eclipse.etrice.core.config.LiteralArray;
import org.eclipse.etrice.core.config.PortClassConfig;
import org.eclipse.etrice.core.config.PortInstanceConfig;
import org.eclipse.etrice.core.config.ProtocolClassConfig;
import org.eclipse.etrice.core.config.RealLiteral;
import org.eclipse.etrice.core.config.RefPath;
import org.eclipse.etrice.core.config.StringLiteral;
import org.eclipse.etrice.core.config.SubSystemConfig;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.ConfigHelper;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ConfigExtension {
    @Inject
    private ILanguageExtension languageExt;

    public String toArrayValueLiteral(PrimitiveType type, String[] values) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            if (!_hasElements) {
                _hasElements = true;
                _builder.append((Object)"{", "");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _valueLiteral = this.languageExt.toValueLiteral(type, v);
            _builder.append((Object)_valueLiteral, "");
            ++n2;
        }
        if (_hasElements) {
            _builder.append((Object)"}", "");
        }
        String _string = _builder.toString();
        return _string;
    }

    public ActorClassConfig getClassConfig(ActorClass ac) {
        ActorClassConfig _get = ConfigHelper.ac2acConfMap.get(ac);
        return _get;
    }

    public ProtocolClassConfig getProtocolConfig(ProtocolClass prc) {
        ProtocolClassConfig _get = ConfigHelper.pc2pcConfMap.get(prc);
        return _get;
    }

    public SubSystemConfig getSubSystemConfig(SubSystemClass ssc) {
        SubSystemConfig _get = ConfigHelper.ssc2ssConfMap.get(ssc);
        return _get;
    }

    public ActorClassConfig getActorClassConfig(ActorInstanceConfig ai) {
        ActorClass _get = ConfigHelper.aiConf2acMap.get(ai);
        ActorClassConfig _get_1 = ConfigHelper.ac2acConfMap.get(_get);
        return _get_1;
    }

    public String getInitValueLiteral(Attribute a) {
        String _defaultValueLiteral;
        boolean _equals;
        String[] configValues = this.getConfigClassValues(a);
        RefableType _refType = a.getRefType();
        DataType type = _refType.getType();
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && (_equals = Objects.equal((Object)configValues, null))) {
            _matched = true;
            _switchResult = null;
        }
        if (!_matched && type instanceof PrimitiveType) {
            String[] _converted_configValues;
            int _size_1;
            boolean _notEquals;
            PrimitiveType _primitiveType = (PrimitiveType)type;
            int _size = a.getSize();
            boolean bl = _notEquals = _size != (_size_1 = ((List)Conversions.doWrapArray((Object)(_converted_configValues = configValues))).size());
            if (_notEquals) {
                String _valueLiteral;
                _matched = true;
                String[] _converted_configValues_1 = configValues;
                String _get = (String)((List)Conversions.doWrapArray((Object)_converted_configValues_1)).get(0);
                _switchResult = _valueLiteral = this.languageExt.toValueLiteral(_primitiveType, _get);
            }
        }
        if (!_matched && type instanceof PrimitiveType) {
            String _arrayValueLiteral;
            PrimitiveType _primitiveType = (PrimitiveType)type;
            _matched = true;
            _switchResult = _arrayValueLiteral = this.toArrayValueLiteral(_primitiveType, configValues);
        }
        String configValue = _switchResult;
        String _xifexpression = null;
        boolean _notEquals = !Objects.equal(configValue, null);
        _xifexpression = _notEquals ? configValue : (_defaultValueLiteral = a.getDefaultValueLiteral());
        return _xifexpression;
    }

    public String[] getConfigClassValues(Attribute attr) {
        EObject _eContainer = attr.eContainer();
        if (_eContainer instanceof DataClass) {
            return null;
        }
        EObject _eContainer_1 = attr.eContainer();
        if (_eContainer_1 instanceof ActorClass) {
            EObject _eContainer_2 = attr.eContainer();
            ActorClass ac = (ActorClass)_eContainer_2;
            ActorClassConfig _classConfig = this.getClassConfig(ac);
            EList _attributes = _classConfig == null ? null : _classConfig.getAttributes();
            return _attributes == null ? null : this.getConfigValue((List<AttrClassConfig>)_attributes, attr);
        }
        EObject _eContainer_3 = attr.eContainer();
        if (_eContainer_3 instanceof PortClass) {
            EObject _eContainer_4 = attr.eContainer();
            PortClass pc = (PortClass)_eContainer_4;
            EObject _eContainer_5 = pc.eContainer();
            ProtocolClass protocol = (ProtocolClass)_eContainer_5;
            ProtocolClassConfig prcConfig = this.getProtocolConfig(protocol);
            PortClass _regular = protocol.getRegular();
            boolean _equals = pc.equals(_regular);
            if (_equals) {
                PortClassConfig _regular_1 = prcConfig == null ? null : prcConfig.getRegular();
                EList _attributes_1 = _regular_1 == null ? null : _regular_1.getAttributes();
                return _attributes_1 == null ? null : this.getConfigValue((List<AttrClassConfig>)_attributes_1, attr);
            }
            PortClassConfig _conjugated = prcConfig == null ? null : prcConfig.getConjugated();
            EList _attributes_2 = _conjugated == null ? null : _conjugated.getAttributes();
            return _attributes_2 == null ? null : this.getConfigValue((List<AttrClassConfig>)_attributes_2, attr);
        }
        return null;
    }

    public String[] getConfigValue(List<AttrClassConfig> attrConfigs, final Attribute attr) {
        Functions.Function1<AttrClassConfig, Boolean> _function = new Functions.Function1<AttrClassConfig, Boolean>(){

            public Boolean apply(AttrClassConfig attrConfig) {
                Attribute _attribute = attrConfig.getAttribute();
                boolean _equals = _attribute.equals(attr);
                return _equals;
            }
        };
        AttrClassConfig _findFirst = (AttrClassConfig)IterableExtensions.findFirst(attrConfigs, (Functions.Function1)_function);
        LiteralArray _value = _findFirst == null ? null : _findFirst.getValue();
        String[] _values = _value == null ? null : this.getValues(_value);
        return _values;
    }

    public String[] getValues(LiteralArray literalArray) {
        ArrayList _arrayList;
        final ArrayList result = _arrayList = new ArrayList();
        EList _literals = literalArray.getLiterals();
        Procedures.Procedure1<Literal> _function = new Procedures.Procedure1<Literal>(){

            public void apply(Literal l) {
                String _value = ConfigExtension.this.getValue(l);
                result.add(_value);
            }
        };
        IterableExtensions.forEach((Iterable)_literals, (Procedures.Procedure1)_function);
        ArrayList _xifexpression = null;
        boolean _isEmpty = result.isEmpty();
        boolean _not = !_isEmpty;
        _xifexpression = _not ? result : null;
        return (String[])Conversions.unwrapArray(_xifexpression, String.class);
    }

    public String getValue(Literal literal) {
        String _valueOf;
        String _valueOf2;
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && literal instanceof BooleanLiteral) {
            BooleanLiteral _booleanLiteral = (BooleanLiteral)literal;
            _matched = true;
            boolean _isIsTrue = _booleanLiteral.isIsTrue();
            _switchResult = _valueOf2 = String.valueOf(_isIsTrue);
        }
        if (!_matched && literal instanceof IntLiteral) {
            IntLiteral _intLiteral = (IntLiteral)literal;
            _matched = true;
            long _value = _intLiteral.getValue();
            _switchResult = _valueOf = String.valueOf(_value);
        }
        if (!_matched && literal instanceof RealLiteral) {
            RealLiteral _realLiteral = (RealLiteral)literal;
            _matched = true;
            double _value = _realLiteral.getValue();
            _switchResult = _valueOf = String.valueOf(_value);
        }
        if (!_matched && literal instanceof StringLiteral) {
            StringLiteral _stringLiteral = (StringLiteral)literal;
            _matched = true;
            String _value = _stringLiteral.getValue();
            _switchResult = _valueOf2 = String.valueOf(_value);
        }
        return _switchResult;
    }

    public List<AttrInstanceConfig> getConfigAttributes(ActorInstance ai) {
        boolean _notEquals;
        String _path = ai.getPath();
        ActorInstanceConfig config = ConfigHelper.path2aiConfMap.get(_path);
        Object _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)config, null);
        if (_notEquals) {
            EList _attributes;
            _xifexpression = _attributes = config.getAttributes();
        } else {
            ArrayList _arrayList = new ArrayList();
            _xifexpression = _arrayList;
        }
        return _xifexpression;
    }

    public List<PortInstanceConfig> getConfigPorts(ActorInstance ai) {
        ArrayList<PortInstanceConfig> _arrayList;
        final ArrayList<PortInstanceConfig> result = _arrayList = new ArrayList<PortInstanceConfig>();
        String _path = ai.getPath();
        ActorInstanceConfig config = ConfigHelper.path2aiConfMap.get(_path);
        EList _ports = config == null ? null : config.getPorts();
        Procedures.Procedure1<PortInstanceConfig> _function = new Procedures.Procedure1<PortInstanceConfig>(){

            public void apply(PortInstanceConfig portConf) {
                result.add(portConf);
            }
        };
        if (_ports != null) {
            IterableExtensions.forEach((Iterable)_ports, (Procedures.Procedure1)_function);
        }
        return result;
    }

    public boolean hasVariableService(SubSystemClass ssc) {
        SubSystemConfig _subSystemConfig = this.getSubSystemConfig(ssc);
        DynamicConfig _dynConfig = _subSystemConfig == null ? null : _subSystemConfig.getDynConfig();
        boolean _notEquals = !Objects.equal((Object)_dynConfig, null);
        return _notEquals;
    }

    public List<AttrClassConfig> getAllAttrConfigFlat(ActorClass ac) {
        boolean _notEquals;
        ArrayList<AttrClassConfig> _arrayList;
        ArrayList<AttrClassConfig> result = _arrayList = new ArrayList<AttrClassConfig>();
        ActorClassConfig _classConfig = this.getClassConfig(ac);
        boolean bl = _notEquals = !Objects.equal((Object)_classConfig, null);
        if (_notEquals) {
            boolean _not;
            LinkedList _linkedList;
            LinkedList stack = _linkedList = new LinkedList();
            ActorClassConfig _classConfig_1 = this.getClassConfig(ac);
            EList _attributes = _classConfig_1.getAttributes();
            stack.addAll(_attributes);
            boolean _isEmpty = stack.isEmpty();
            boolean _while = _not = !_isEmpty;
            while (_while) {
                boolean _not_1;
                AttrClassConfig c = (AttrClassConfig)stack.pop();
                result.add(c);
                EList _attributes_1 = c.getAttributes();
                stack.addAll(_attributes_1);
                boolean _isEmpty_1 = stack.isEmpty();
                _while = _not_1 = !_isEmpty_1;
            }
        }
        return result;
    }

    public Iterable<AttrInstanceConfig> getAttrDynConfigs(SubSystemClass ssc, final boolean read, final boolean write) {
        List<AttrInstanceConfig> _get = ConfigHelper.ssc2attrInstConfMap.get(ssc);
        Functions.Function1<AttrInstanceConfig, Boolean> _function = new Functions.Function1<AttrInstanceConfig, Boolean>(){

            public Boolean apply(AttrInstanceConfig c) {
                boolean _and = false;
                boolean _isDynConfig = c.isDynConfig();
                if (!_isDynConfig) {
                    _and = false;
                } else {
                    boolean _or = false;
                    boolean _and_1 = false;
                    if (!read) {
                        _and_1 = false;
                    } else {
                        boolean _isReadOnly = c.isReadOnly();
                        boolean bl = _and_1 = read && _isReadOnly;
                    }
                    if (_and_1) {
                        _or = true;
                    } else {
                        boolean _and_2 = false;
                        if (!write) {
                            _and_2 = false;
                        } else {
                            boolean _isReadOnly_1 = c.isReadOnly();
                            boolean _not = !_isReadOnly_1;
                            _and_2 = write && _not;
                        }
                        _or = _and_1 || _and_2;
                    }
                    _and = _isDynConfig && _or;
                }
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter(_get, (Functions.Function1)_function);
        return _filter;
    }

    public List<String> getPath(AttrConfig config, boolean ss, boolean actor, boolean dc, boolean attr) {
        Attribute _attribute;
        EObject _eContainer_1;
        LinkedList<String> _linkedList;
        LinkedList<String> result = _linkedList = new LinkedList<String>();
        AttrConfig c = config;
        EObject _eContainer = c.eContainer();
        boolean _while = _eContainer instanceof AttrConfig;
        while (_while) {
            _eContainer_1 = c.eContainer();
            c = (AttrConfig)_eContainer_1;
            if (dc) {
                _attribute = c.getAttribute();
                String _name = _attribute.getName();
                result.addFirst(_name);
            }
            _eContainer_1 = c.eContainer();
            _while = _eContainer_1 instanceof AttrConfig;
        }
        _eContainer_1 = c.eContainer();
        if (_eContainer_1 instanceof ActorInstanceConfig) {
            EObject _eContainer_2 = c.eContainer();
            ActorInstanceConfig aic = (ActorInstanceConfig)_eContainer_2;
            if (actor) {
                RefPath _path = aic.getPath();
                EList _refs = _path.getRefs();
                result.addAll(0, (Collection<String>)_refs);
            }
            if (ss) {
                SubSystemClass _root = aic.getRoot();
                String _name = _root.getName();
                result.addFirst(_name);
            }
        } else {
            EObject _eContainer_3 = c.eContainer();
            if (_eContainer_3 instanceof ActorClassConfig) {
                EObject _eContainer_4 = c.eContainer();
                ActorClassConfig ac = (ActorClassConfig)_eContainer_4;
                if (actor) {
                    ActorClass _actor = ac.getActor();
                    String _name_1 = _actor.getName();
                    result.addFirst(_name_1);
                }
            }
        }
        if (attr) {
            _attribute = config.getAttribute();
            String _name_2 = _attribute.getName();
            result.add(_name_2);
        }
        return result;
    }

    public String toPath(Iterable<String> path, String pathDelim) {
        String _path = ConfigHelper.toPath(path, pathDelim);
        return _path;
    }

    public HashSet<Attribute> getDynConfigAttributes(ActorClass ac, final boolean read, final boolean write) {
        HashSet<Attribute> _hashSet;
        final HashSet<Attribute> result = _hashSet = new HashSet<Attribute>();
        List<ActorInstanceConfig> _get = ConfigHelper.ac2aiConfMap.get(ac);
        Procedures.Procedure1<ActorInstanceConfig> _function = new Procedures.Procedure1<ActorInstanceConfig>(){

            public void apply(ActorInstanceConfig aiConf) {
                EList _attributes = aiConf.getAttributes();
                Functions.Function1<AttrInstanceConfig, Boolean> _function = new Functions.Function1<AttrInstanceConfig, Boolean>(){

                    public Boolean apply(AttrInstanceConfig c) {
                        boolean _and = false;
                        boolean _isDynConfig = c.isDynConfig();
                        if (!_isDynConfig) {
                            _and = false;
                        } else {
                            boolean _or = false;
                            boolean _and_1 = false;
                            if (!read) {
                                _and_1 = false;
                            } else {
                                boolean _isReadOnly = c.isReadOnly();
                                boolean bl = _and_1 = read && _isReadOnly;
                            }
                            if (_and_1) {
                                _or = true;
                            } else {
                                boolean _and_2 = false;
                                if (!write) {
                                    _and_2 = false;
                                } else {
                                    boolean _isReadOnly_1 = c.isReadOnly();
                                    boolean _not = !_isReadOnly_1;
                                    _and_2 = write && _not;
                                }
                                _or = _and_1 || _and_2;
                            }
                            _and = _isDynConfig && _or;
                        }
                        return _and;
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)_attributes, (Functions.Function1)_function);
                Procedures.Procedure1<AttrInstanceConfig> _function_1 = new Procedures.Procedure1<AttrInstanceConfig>(){

                    public void apply(AttrInstanceConfig dynConf) {
                        Attribute _attribute = dynConf.getAttribute();
                        result.add(_attribute);
                    }
                };
                IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
            }
        };
        if (_get != null) {
            IterableExtensions.forEach(_get, (Procedures.Procedure1)_function);
        }
        return result;
    }
}

