/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;

@Singleton
public class PrepareFileSystem {
    @Inject
    private RoomExtensions roomExt;
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private ILogger logger;

    public void prepare(Resource resource) {
        HashSet<String> _hashSet;
        HashSet<String> pathes = _hashSet = new HashSet<String>();
        EList _contents = resource.getContents();
        for (EObject e : _contents) {
            if (!(e instanceof Root)) continue;
            EList _usedRoomModels = ((Root)e).getUsedRoomModels();
            for (RoomModel mdl : _usedRoomModels) {
                String _generationTargetPath = this.roomExt.getGenerationTargetPath((EObject)mdl);
                pathes.add(_generationTargetPath);
            }
        }
        for (String path : pathes) {
            File _file;
            String _plus = "clearing " + path;
            this.logger.logInfo(_plus);
            File f = _file = new File(path);
            this.eraseContents(f);
            this.fileAccess.setOutputPath(path);
            CharSequence _readmeText = this.readmeText();
            this.fileAccess.generateFile("readme.txt", _readmeText);
        }
    }

    public void eraseContents(File f) {
        boolean _isDirectory = f.isDirectory();
        if (_isDirectory) {
            File[] children;
            File[] fileArray = children = f.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.eraseContents(child);
                child.delete();
                ++n2;
            }
        }
    }

    public CharSequence readmeText() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"This directory is an eTrice code generation target.");
        _builder.newLine();
        _builder.append((Object)"It will be erased every time the generator is executed.");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"DO NOT PLACE OTHER FILES HERE!");
        _builder.newLine();
        return _builder;
    }
}

