/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.genmodel.etricegen.ActiveTrigger;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedRefinedState;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SAPInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ServiceImplInstance;
import org.eclipse.etrice.core.genmodel.etricegen.TransitionChain;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.Guard;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.SimpleState;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphNode;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionPoint;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.CodegenHelpers;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class RoomExtensions {
    public <T> List<T> union(List<T> l1, List<T> l2) {
        ArrayList<T> _arrayList;
        ArrayList<T> ret = _arrayList = new ArrayList<T>();
        ret.addAll(l1);
        ret.addAll(l2);
        return ret;
    }

    public <T> Iterable<T> union(Iterable<T> l1, Iterable<T> l2) {
        ArrayList _arrayList;
        ArrayList ret = _arrayList = new ArrayList();
        Iterables.addAll(ret, l1);
        Iterables.addAll(ret, l2);
        return ret;
    }

    public List<Port> punion(List<Port> in1, List<ExternalPort> in2) {
        ArrayList<Port> _arrayList;
        ArrayList<Port> ret = _arrayList = new ArrayList<Port>();
        for (ExternalPort ele : in2) {
            Port _ifport = ele.getIfport();
            ret.add(_ifport);
        }
        ret.addAll(in1);
        return ret;
    }

    public <T> List<T> minus(List<T> l1, List<T> l2) {
        ArrayList<T> _arrayList;
        ArrayList<T> ret = _arrayList = new ArrayList<T>(l1);
        ret.removeAll(l2);
        return ret;
    }

    public String getGenerationPathSegment() {
        return "/src-gen/";
    }

    public String getDocGenerationPathSegment() {
        return "/doc-gen/";
    }

    public String getModelPath(EObject e) {
        Resource res = e.eResource();
        boolean _equals = Objects.equal((Object)res, null);
        if (_equals) {
            return "";
        }
        URI _uRI = res.getURI();
        return _uRI.toFileString();
    }

    public String getPackage(RoomClass rc) {
        EObject _eContainer = rc.eContainer();
        return ((RoomModel)_eContainer).getName();
    }

    public String getPathFromPackage(String packageName) {
        String _replaceAll = packageName.replaceAll("\\.", "/");
        return String.valueOf(_replaceAll) + "/";
    }

    public String getPath(RoomClass rc) {
        String _package = this.getPackage(rc);
        String _pathFromPackage = this.getPathFromPackage(_package);
        return _pathFromPackage;
    }

    public String getProjectPath(EObject e) {
        boolean _and;
        boolean _not;
        File _file;
        Resource res = e.eResource();
        boolean _equals = Objects.equal((Object)res, null);
        if (_equals) {
            return "";
        }
        File tmpf = _file = new File("");
        URI _uRI = res.getURI();
        String _fileString = _uRI.toFileString();
        File _file_1 = new File(_fileString);
        tmpf = _file_1;
        boolean _isFile = tmpf.isFile();
        boolean bl = _not = !_isFile;
        if (_not) {
            return "";
        }
        boolean isProject = false;
        boolean _dowhile = false;
        do {
            boolean _not_1;
            String[] contents;
            File _parentFile;
            tmpf = _parentFile = tmpf.getParentFile();
            String[] stringArray = contents = tmpf.list();
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                boolean _equals_1 = f.equals(".project");
                if (_equals_1) {
                    isProject = true;
                }
                ++n2;
            }
            _and = false;
            boolean bl2 = _not_1 = !isProject;
            if (!_not_1) {
                _and = false;
                continue;
            }
            File _parentFile2 = tmpf.getParentFile();
            boolean _notEquals = !Objects.equal((Object)_parentFile2, null);
            boolean bl3 = _and = _not_1 && _notEquals;
        } while (_dowhile = _and);
        return tmpf.getAbsolutePath();
    }

    public String getGenerationTargetPath(EObject e) {
        String _projectPath = this.getProjectPath(e);
        String _generationPathSegment = this.getGenerationPathSegment();
        return String.valueOf(_projectPath) + _generationPathSegment;
    }

    public String getDocGenerationTargetPath(EObject e) {
        String _projectPath = this.getProjectPath(e);
        String _docGenerationPathSegment = this.getDocGenerationPathSegment();
        return String.valueOf(_projectPath) + _docGenerationPathSegment;
    }

    public List<Port> getEndPorts(ActorClass ac) {
        EList _intPorts = ac.getIntPorts();
        EList _extPorts = ac.getExtPorts();
        List<Port> _punion = this.punion((List<Port>)_intPorts, (List<ExternalPort>)_extPorts);
        return _punion;
    }

    public List<Port> getAllEndPorts(ActorClass ac) {
        List<Port> _union;
        List<Port> _xifexpression = null;
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            return this.getEndPorts(ac);
        }
        ActorClass _base_1 = ac.getBase();
        List<Port> _allEndPorts = this.getAllEndPorts(_base_1);
        List<Port> _endPorts = this.getEndPorts(ac);
        _xifexpression = _union = this.union(_allEndPorts, _endPorts);
        return _xifexpression;
    }

    public List<SAPRef> getAllSAPs(ActorClass ac) {
        List<SAPRef> _union;
        List<SAPRef> _xifexpression = null;
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            return ac.getStrSAPs();
        }
        ActorClass _base_1 = ac.getBase();
        List<SAPRef> _allSAPs = this.getAllSAPs(_base_1);
        EList _strSAPs = ac.getStrSAPs();
        _xifexpression = _union = this.union((List)_allSAPs, (List)_strSAPs);
        return _xifexpression;
    }

    public List<ServiceImplementation> getAllServiceImplementations(ActorClass ac) {
        List<ServiceImplementation> _union;
        List<ServiceImplementation> _xifexpression = null;
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            return ac.getServiceImplementations();
        }
        ActorClass _base_1 = ac.getBase();
        List<ServiceImplementation> _allServiceImplementations = this.getAllServiceImplementations(_base_1);
        EList _serviceImplementations = ac.getServiceImplementations();
        _xifexpression = _union = this.union((List)_allServiceImplementations, (List)_serviceImplementations);
        return _xifexpression;
    }

    public String getPathName(String path) {
        String _replaceAll = path.replaceAll("/", "_");
        return _replaceAll;
    }

    public List<Attribute> getAllAttributes(DataClass dc) {
        List<Attribute> _union;
        List<Attribute> _xifexpression = null;
        DataClass _base = dc.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            return dc.getAttributes();
        }
        DataClass _base_1 = dc.getBase();
        List<Attribute> _allAttributes = this.getAllAttributes(_base_1);
        EList _attributes = dc.getAttributes();
        _xifexpression = _union = this.union((List)_allAttributes, (List)_attributes);
        return _xifexpression;
    }

    public List<Attribute> getAllAttributes(ActorClass ac) {
        List<Attribute> _union;
        List<Attribute> _xifexpression = null;
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            return ac.getAttributes();
        }
        ActorClass _base_1 = ac.getBase();
        List<Attribute> _allAttributes = this.getAllAttributes(_base_1);
        EList _attributes = ac.getAttributes();
        _xifexpression = _union = this.union((List)_allAttributes, (List)_attributes);
        return _xifexpression;
    }

    public ActorClass getContainingActorClass(EObject o) {
        ActorClass _actorClass = RoomHelpers.getActorClass((EObject)o);
        return _actorClass;
    }

    protected String _getPortClassName(Port p) {
        String _xifexpression = null;
        GeneralProtocolClass _protocol = p.getProtocol();
        if (_protocol instanceof ProtocolClass) {
            String _portClassName;
            GeneralProtocolClass _protocol_1 = p.getProtocol();
            boolean _isConjugated = p.isConjugated();
            boolean _isReplicated = p.isReplicated();
            _xifexpression = _portClassName = this.getPortClassName((ProtocolClass)_protocol_1, _isConjugated, _isReplicated);
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    protected String _getPortClassName(SAPRef sap) {
        ProtocolClass _protocol = sap.getProtocol();
        return this.getPortClassName(_protocol, true);
    }

    protected String _getPortClassName(SPPRef spp) {
        ProtocolClass _protocol = spp.getProtocol();
        return this.getPortClassName(_protocol, false, true);
    }

    public String getPortClassName(ProtocolClass p, boolean conj) {
        String _portClassName = this.getPortClassName(p, conj, false);
        return _portClassName;
    }

    public String getPortClassName(ProtocolClass p, boolean conj, boolean repl) {
        String _name = p.getName();
        String _xifexpression = null;
        _xifexpression = conj ? "Conj" : "";
        String _plus = String.valueOf(_name) + _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = repl ? "Repl" : "";
        String _plus_1 = String.valueOf(_plus) + _xifexpression_1;
        String _plus_2 = String.valueOf(_plus_1) + "Port";
        return _plus_2;
    }

    protected String _getPortClassName(ExternalPort p) {
        Port _ifport = p.getIfport();
        return this.getPortClassName((EObject)_ifport);
    }

    protected String _getPortClassName(ServiceImplementation svc) {
        SPPRef _spp = svc.getSpp();
        ProtocolClass _protocol = _spp.getProtocol();
        return this.getPortClassName(_protocol, false, true);
    }

    public List<Message> getAllIncomingMessages(ProtocolClass pc) {
        boolean _notEquals;
        ProtocolClass _base = pc.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            ProtocolClass _base_1 = pc.getBase();
            List<Message> _allIncomingMessages = this.getAllIncomingMessages(_base_1);
            EList _incomingMessages = pc.getIncomingMessages();
            return this.union((List)_allIncomingMessages, (List)_incomingMessages);
        }
        return pc.getIncomingMessages();
    }

    public List<Message> getAllOutgoingMessages(ProtocolClass pc) {
        EList _outgoingMessages_1;
        boolean _notEquals;
        EList _xifexpression = null;
        ProtocolClass _base = pc.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            ProtocolClass _base_1 = pc.getBase();
            List<Message> _allOutgoingMessages = this.getAllOutgoingMessages(_base_1);
            EList _outgoingMessages = pc.getOutgoingMessages();
            return this.union((List)_allOutgoingMessages, (List)_outgoingMessages);
        }
        _xifexpression = _outgoingMessages_1 = pc.getOutgoingMessages();
        return _xifexpression;
    }

    public List<Message> getIncoming(ProtocolClass pc, boolean conj) {
        if (conj) {
            return this.getAllOutgoingMessages(pc);
        }
        return this.getAllIncomingMessages(pc);
    }

    public List<Message> getOutgoing(ProtocolClass pc, boolean conj) {
        if (conj) {
            return this.getAllIncomingMessages(pc);
        }
        return this.getAllOutgoingMessages(pc);
    }

    public PortClass getPortClass(ProtocolClass pc, boolean conj) {
        if (conj) {
            return pc.getConjugate();
        }
        return pc.getRegular();
    }

    public boolean handlesSend(ProtocolClass pc, boolean conj) {
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            return false;
        }
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List<Message> _outgoing = this.getOutgoing(pc, conj);
            boolean _contains = _outgoing.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public boolean handlesReceive(ProtocolClass pc, boolean conj) {
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            return false;
        }
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List<Message> _incoming = this.getIncoming(pc, conj);
            boolean _contains = _incoming.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public boolean isConjugated(InterfaceItemInstance iii) {
        if (iii instanceof PortInstance) {
            Port _port = ((PortInstance)iii).getPort();
            return _port.isConjugated();
        }
        if (iii instanceof SAPInstance) {
            return true;
        }
        if (iii instanceof ServiceImplInstance) {
            return false;
        }
        return false;
    }

    public List<MessageHandler> getReceiveHandlers(ProtocolClass pc, boolean conj) {
        ArrayList<MessageHandler> _arrayList_1;
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            ArrayList<MessageHandler> _arrayList = new ArrayList<MessageHandler>();
            return _arrayList;
        }
        ArrayList<MessageHandler> res = _arrayList_1 = new ArrayList<MessageHandler>();
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List<Message> _incoming = this.getIncoming(pc, conj);
            boolean _contains = _incoming.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            res.add(hdlr);
        }
        return res;
    }

    public List<MessageHandler> getSendHandlers(ProtocolClass pc, boolean conj) {
        ArrayList<MessageHandler> _arrayList_1;
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            ArrayList<MessageHandler> _arrayList = new ArrayList<MessageHandler>();
            return _arrayList;
        }
        ArrayList<MessageHandler> res = _arrayList_1 = new ArrayList<MessageHandler>();
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List<Message> _outgoing = this.getOutgoing(pc, conj);
            boolean _contains = _outgoing.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            res.add(hdlr);
        }
        return res;
    }

    public MessageHandler getSendHandler(final Message m, boolean conj) {
        EObject _eContainer = m.eContainer();
        List<MessageHandler> _sendHandlers = this.getSendHandlers((ProtocolClass)_eContainer, conj);
        Functions.Function1<MessageHandler, Boolean> _function = new Functions.Function1<MessageHandler, Boolean>(){

            public Boolean apply(MessageHandler e) {
                Message _msg = e.getMsg();
                boolean _equals = Objects.equal((Object)_msg, (Object)m);
                return _equals;
            }
        };
        return (MessageHandler)IterableExtensions.findFirst(_sendHandlers, (Functions.Function1)_function);
    }

    public boolean isIncoming(Message m) {
        EObject _eContainer = m.eContainer();
        List<Message> _allIncomingMessages = this.getAllIncomingMessages((ProtocolClass)_eContainer);
        return _allIncomingMessages.contains(m);
    }

    public String getCodeName(Message m) {
        boolean _isIncoming = this.isIncoming(m);
        if (_isIncoming) {
            String _name = m.getName();
            return "IN_" + _name;
        }
        String _name_1 = m.getName();
        return "OUT_" + _name_1;
    }

    public boolean isLeaf(State s) {
        StateGraph _subgraph = s.getSubgraph();
        boolean _equals = Objects.equal((Object)_subgraph, null);
        return _equals;
    }

    public List<State> getLeafStateList(StateGraph sg) {
        boolean _notEquals;
        ArrayList<State> _arrayList;
        ArrayList<State> res = _arrayList = new ArrayList<State>();
        boolean bl = _notEquals = !Objects.equal((Object)sg, null);
        if (_notEquals) {
            EList _states = sg.getStates();
            for (State s : _states) {
                List<State> _leafStateList = this.getLeafStateList(s);
                res.addAll(_leafStateList);
            }
        }
        return res;
    }

    public List<State> getLeafStateList(State s) {
        boolean _isLeaf = this.isLeaf(s);
        if (_isLeaf) {
            ArrayList<State> _arrayList;
            ArrayList<State> res = _arrayList = new ArrayList<State>();
            res.add(s);
            return res;
        }
        StateGraph _subgraph = s.getSubgraph();
        return this.getLeafStateList(_subgraph);
    }

    public List<State> getStateList(StateGraph sg) {
        boolean _notEquals;
        ArrayList<State> _arrayList;
        ArrayList<State> ret = _arrayList = new ArrayList<State>();
        boolean bl = _notEquals = !Objects.equal((Object)sg, null);
        if (_notEquals) {
            EList _states = sg.getStates();
            for (State e : _states) {
                boolean _notEquals_1;
                ret.add(e);
                StateGraph _subgraph = e.getSubgraph();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_subgraph, null);
                if (!_notEquals_1) continue;
                StateGraph _subgraph_1 = e.getSubgraph();
                List<State> _stateList = this.getStateList(_subgraph_1);
                ret.addAll(_stateList);
            }
        }
        return ret;
    }

    public List<State> getBaseStateList(StateGraph sg) {
        boolean _notEquals;
        ArrayList<State> _arrayList;
        ArrayList<State> ret = _arrayList = new ArrayList<State>();
        boolean bl = _notEquals = !Objects.equal((Object)sg, null);
        if (_notEquals) {
            List<State> _stateList = this.getStateList(sg);
            for (State e : _stateList) {
                if (!(e instanceof SimpleState)) continue;
                ret.add(e);
            }
        }
        return ret;
    }

    public ArrayList<State> getLeafStatesLast(List<State> states) {
        ArrayList<State> _arrayList_1;
        ArrayList<State> _arrayList;
        ArrayList<State> leaf = _arrayList = new ArrayList<State>();
        ArrayList<State> nonLeaf = _arrayList_1 = new ArrayList<State>();
        for (State state : states) {
            boolean _isLeaf = this.isLeaf(state);
            if (_isLeaf) {
                leaf.add(state);
                continue;
            }
            nonLeaf.add(state);
        }
        nonLeaf.addAll(leaf);
        return nonLeaf;
    }

    public List<State> getAllBaseStates(ActorClass ac) {
        List<State> _union;
        List<State> _xifexpression = null;
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            StateGraph _stateMachine = ac.getStateMachine();
            return this.getBaseStateList(_stateMachine);
        }
        ActorClass _base_1 = ac.getBase();
        List<State> _allBaseStates = this.getAllBaseStates(_base_1);
        StateGraph _stateMachine_1 = ac.getStateMachine();
        List<State> _baseStateList = this.getBaseStateList(_stateMachine_1);
        _xifexpression = _union = this.union(_allBaseStates, _baseStateList);
        return _xifexpression;
    }

    public List<State> getAllBaseStatesLeavesLast(ActorClass ac) {
        List<State> _union;
        List<State> _xifexpression = null;
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            StateGraph _stateMachine = ac.getStateMachine();
            List<State> _baseStateList = this.getBaseStateList(_stateMachine);
            return this.getLeafStatesLast(_baseStateList);
        }
        ActorClass _base_1 = ac.getBase();
        List<State> _allBaseStates = this.getAllBaseStates(_base_1);
        ArrayList<State> _leafStatesLast = this.getLeafStatesLast(_allBaseStates);
        StateGraph _stateMachine_1 = ac.getStateMachine();
        List<State> _baseStateList_1 = this.getBaseStateList(_stateMachine_1);
        ArrayList<State> _leafStatesLast_1 = this.getLeafStatesLast(_baseStateList_1);
        _xifexpression = _union = this.union((List)_leafStatesLast, (List)_leafStatesLast_1);
        return _xifexpression;
    }

    public List<State> getAllLeafStates(ActorClass ac) {
        List<State> _union;
        List<State> _xifexpression = null;
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            StateGraph _stateMachine = ac.getStateMachine();
            return this.getLeafStateList(_stateMachine);
        }
        ActorClass _base_1 = ac.getBase();
        List<State> _allLeafStates = this.getAllLeafStates(_base_1);
        StateGraph _stateMachine_1 = ac.getStateMachine();
        List<State> _leafStateList = this.getLeafStateList(_stateMachine_1);
        _xifexpression = _union = this.union(_allLeafStates, _leafStateList);
        return _xifexpression;
    }

    public boolean overridesStop(ActorClass ac) {
        Functions.Function1<StandardOperation, Boolean> _function;
        boolean _or = false;
        EList _operations = ac.getOperations();
        boolean _exists = IterableExtensions.exists((Iterable)_operations, (Functions.Function1)(_function = new Functions.Function1<StandardOperation, Boolean>(){

            public Boolean apply(StandardOperation e) {
                boolean _and = false;
                boolean _and_1 = false;
                String _name = e.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)"stop");
                if (!_equals) {
                    _and_1 = false;
                } else {
                    EList _arguments = e.getArguments();
                    boolean _isEmpty = _arguments.isEmpty();
                    boolean bl = _and_1 = _equals && _isEmpty;
                }
                if (!_and_1) {
                    _and = false;
                } else {
                    RefableType _returntype = e.getReturntype();
                    boolean _equals_1 = Objects.equal((Object)_returntype, null);
                    _and = _and_1 && _equals_1;
                }
                return _and;
            }
        }));
        if (_exists) {
            _or = true;
        } else {
            boolean _notEquals;
            boolean _and = false;
            ActorClass _base = ac.getBase();
            boolean bl = _notEquals = !Objects.equal((Object)_base, null);
            if (!_notEquals) {
                _and = false;
            } else {
                ActorClass _base_1 = ac.getBase();
                boolean _overridesStop = this.overridesStop(_base_1);
                _and = _notEquals && _overridesStop;
            }
            _or = _exists || _and;
        }
        return _or;
    }

    public int getNumberOfInheritedStates(ActorClass ac) {
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            return 0;
        }
        ActorClass _base_1 = ac.getBase();
        StateGraph _stateMachine = _base_1.getStateMachine();
        List<State> _stateList = this.getStateList(_stateMachine);
        int _size = _stateList.size();
        ActorClass _base_2 = ac.getBase();
        int _numberOfInheritedStates = this.getNumberOfInheritedStates(_base_2);
        return _size + _numberOfInheritedStates;
    }

    public int getNumberOfInheritedBaseStates(ActorClass ac) {
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            return 0;
        }
        ActorClass _base_1 = ac.getBase();
        StateGraph _stateMachine = _base_1.getStateMachine();
        List<State> _baseStateList = this.getBaseStateList(_stateMachine);
        int _size = _baseStateList.size();
        ActorClass _base_2 = ac.getBase();
        int _numberOfInheritedBaseStates = this.getNumberOfInheritedBaseStates(_base_2);
        return _size + _numberOfInheritedBaseStates;
    }

    public String getStateId(State s) {
        return CodegenHelpers.getGenStateId(s);
    }

    public String getStatePathName(State s) {
        return CodegenHelpers.getGenStatePathName(s);
    }

    public String getChainId(TransitionChain t) {
        return CodegenHelpers.getGenChainId(t);
    }

    public boolean hasGuard(Trigger tr) {
        boolean _notEquals;
        boolean _and = false;
        boolean _and_1 = false;
        Guard _guard = tr.getGuard();
        boolean bl = _notEquals = !Objects.equal((Object)_guard, null);
        if (!_notEquals) {
            _and_1 = false;
        } else {
            Guard _guard_1 = tr.getGuard();
            DetailCode _guard_2 = _guard_1.getGuard();
            boolean _notEquals_1 = !Objects.equal((Object)_guard_2, null);
            boolean bl2 = _and_1 = _notEquals && _notEquals_1;
        }
        if (!_and_1) {
            _and = false;
        } else {
            Guard _guard_3 = tr.getGuard();
            DetailCode _guard_4 = _guard_3.getGuard();
            EList _commands = _guard_4.getCommands();
            int _size = _commands.size();
            boolean _greaterThan = _size > 0;
            _and = _and_1 && _greaterThan;
        }
        return _and;
    }

    public boolean hasGuard(final ExpandedActorClass ac, final ActiveTrigger at) {
        boolean hasGuard = false;
        EList _transitions = at.getTransitions();
        for (TriggeredTransition t : _transitions) {
            Functions.Function1<Trigger, Boolean> _function;
            EList _triggers = t.getTriggers();
            boolean _exists = IterableExtensions.exists((Iterable)_triggers, (Functions.Function1)(_function = new Functions.Function1<Trigger, Boolean>(){

                public Boolean apply(Trigger e) {
                    boolean _and = false;
                    String _trigger = at.getTrigger();
                    boolean _isMatching = ac.isMatching(e, _trigger);
                    if (!_isMatching) {
                        _and = false;
                    } else {
                        boolean _hasGuard = RoomExtensions.this.hasGuard(e);
                        _and = _isMatching && _hasGuard;
                    }
                    return _and;
                }
            }));
            if (!_exists) continue;
            hasGuard = true;
        }
        return hasGuard;
    }

    public boolean empty(DetailCode dc) {
        String _detailCode = RoomHelpers.getDetailCode((DetailCode)dc);
        boolean _equals = Objects.equal((Object)_detailCode, (Object)"");
        return _equals;
    }

    public boolean hasEntryCode(State s) {
        boolean _not;
        DetailCode _entryCode = s.getEntryCode();
        boolean _empty = this.empty(_entryCode);
        boolean bl = _not = !_empty;
        if (_not) {
            return true;
        }
        if (s instanceof ExpandedRefinedState) {
            DetailCode _inheritedEntry = ((ExpandedRefinedState)s).getInheritedEntry();
            boolean _empty_1 = this.empty(_inheritedEntry);
            return !_empty_1;
        }
        return false;
    }

    public boolean hasExitCode(State s) {
        boolean _not;
        DetailCode _exitCode = s.getExitCode();
        boolean _empty = this.empty(_exitCode);
        boolean bl = _not = !_empty;
        if (_not) {
            return true;
        }
        if (s instanceof ExpandedRefinedState) {
            DetailCode _inheritedExit = ((ExpandedRefinedState)s).getInheritedExit();
            boolean _empty_1 = this.empty(_inheritedExit);
            return !_empty_1;
        }
        return false;
    }

    public boolean hasDoCode(State s) {
        boolean _not;
        DetailCode _doCode = s.getDoCode();
        boolean _empty = this.empty(_doCode);
        boolean bl = _not = !_empty;
        if (_not) {
            return true;
        }
        if (s instanceof ExpandedRefinedState) {
            DetailCode _inheritedDo = ((ExpandedRefinedState)s).getInheritedDo();
            boolean _empty_1 = this.empty(_inheritedDo);
            return !_empty_1;
        }
        return false;
    }

    public boolean hasActionCode(Transition t) {
        boolean _notEquals;
        boolean _and = false;
        DetailCode _action = t.getAction();
        boolean bl = _notEquals = !Objects.equal((Object)_action, null);
        if (!_notEquals) {
            _and = false;
        } else {
            DetailCode _action_1 = t.getAction();
            EList _commands = _action_1.getCommands();
            int _size = _commands.size();
            boolean _greaterThan = _size > 0;
            _and = _notEquals && _greaterThan;
        }
        return _and;
    }

    public String getContextId(TransitionChain tc) {
        State _stateContext = tc.getStateContext();
        String _stateId = this.getStateId(_stateContext);
        return _stateId;
    }

    public Transition getInitTransition(StateGraph sg) {
        EList _transitions = sg.getTransitions();
        for (Transition tr : _transitions) {
            if (!(tr instanceof InitialTransition)) continue;
            return tr;
        }
        return null;
    }

    public boolean hasInitTransition(StateGraph sg) {
        EList _transitions = sg.getTransitions();
        for (Transition tr : _transitions) {
            if (!(tr instanceof InitialTransition)) continue;
            return true;
        }
        return false;
    }

    public List<Transition> getTransitionList(State s) {
        boolean _isLeaf = this.isLeaf(s);
        if (_isLeaf) {
            ArrayList<Transition> _arrayList = new ArrayList<Transition>();
            return _arrayList;
        }
        StateGraph _subgraph = s.getSubgraph();
        return this.getTransitionList(_subgraph);
    }

    public List<Transition> getTransitionList(StateGraph sg) {
        ArrayList<Transition> _arrayList;
        EList _transitions = sg.getTransitions();
        ArrayList<Transition> res = _arrayList = new ArrayList<Transition>((Collection<Transition>)_transitions);
        EList _states = sg.getStates();
        for (State s : _states) {
            List<Transition> _transitionList = this.getTransitionList(s);
            res.addAll(_transitionList);
        }
        return res;
    }

    public List<Transition> getOutgoingTransitionsHierarchical(ExpandedActorClass ac, State s) {
        ArrayList<Transition> _arrayList;
        ArrayList<Transition> result = _arrayList = new ArrayList<Transition>();
        EList _outgoingTransitions = ac.getOutgoingTransitions((StateGraphNode)s);
        result.addAll((Collection<Transition>)_outgoingTransitions);
        EObject _eContainer = s.eContainer();
        StateGraph sg = (StateGraph)_eContainer;
        EList _trPoints = sg.getTrPoints();
        for (TrPoint tp : _trPoints) {
            if (!(tp instanceof TransitionPoint)) continue;
            EList _outgoingTransitions_1 = ac.getOutgoingTransitions((StateGraphNode)tp);
            result.addAll((Collection<Transition>)_outgoingTransitions_1);
        }
        EObject _eContainer_1 = sg.eContainer();
        if (_eContainer_1 instanceof State) {
            EObject _eContainer_2 = sg.eContainer();
            List<Transition> _outgoingTransitionsHierarchical = this.getOutgoingTransitionsHierarchical(ac, (State)_eContainer_2);
            result.addAll(_outgoingTransitionsHierarchical);
        }
        return result;
    }

    public String getPortClassName(EObject p) {
        if (p instanceof Port) {
            return this._getPortClassName((Port)p);
        }
        if (p instanceof SAPRef) {
            return this._getPortClassName((SAPRef)p);
        }
        if (p instanceof SPPRef) {
            return this._getPortClassName((SPPRef)p);
        }
        if (p instanceof ExternalPort) {
            return this._getPortClassName((ExternalPort)p);
        }
        if (p instanceof ServiceImplementation) {
            return this._getPortClassName((ServiceImplementation)p);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(p).toString());
    }
}

