/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.naming.RoomFragmentProvider;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.RefinedTransition;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.util.RoomSwitch;
import org.eclipse.etrice.ui.behavior.support.ChoicePointSupport;
import org.eclipse.etrice.ui.behavior.support.DiagramUpdateFeature;
import org.eclipse.etrice.ui.behavior.support.InitialPointSupport;
import org.eclipse.etrice.ui.behavior.support.StateGraphSupport;
import org.eclipse.etrice.ui.behavior.support.StateSupport;
import org.eclipse.etrice.ui.behavior.support.TrPointSupport;
import org.eclipse.etrice.ui.behavior.support.TransitionSupport;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.ISelectionInfo;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.tb.SelectionInfoImpl;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.IColorConstant;

public class ProviderDispatcher {
    private StateGraphSupport stateGraphSupport;
    private TrPointSupport trPointSupport;
    private InitialPointSupport initialPointSupport;
    private ChoicePointSupport choicePointSupport;
    private StateSupport stateSupport;
    private TransitionSupport transitionSupport;
    private FeatureProviderSwitch featureSwitch;
    private ToolBehaviorProviderSwitch behaviorSwitch;
    private DispatchingFeatureProvider dispatchingFP;
    private DispatchingToolBehaviorProvider dispatchingBP;

    public ProviderDispatcher(IDiagramTypeProvider dtp) {
        this.dispatchingFP = new DispatchingFeatureProvider(dtp);
        this.dispatchingBP = new DispatchingToolBehaviorProvider(dtp);
        this.stateGraphSupport = new StateGraphSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.trPointSupport = new TrPointSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.initialPointSupport = new InitialPointSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.choicePointSupport = new ChoicePointSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.stateSupport = new StateSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.transitionSupport = new TransitionSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.featureSwitch = new FeatureProviderSwitch();
        this.behaviorSwitch = new ToolBehaviorProviderSwitch();
    }

    public IFeatureProvider getFeatureProvider() {
        return this.dispatchingFP;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.dispatchingBP;
    }

    private ICreateFeature[] getAllCreateFeatures() {
        return this.featureSwitch.getCreateFeatures();
    }

    private ICreateConnectionFeature[] getAllCreateConnectionFeatures() {
        return this.featureSwitch.getCreateConnectionFeatures();
    }

    private static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        T[][] TArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            T[] array = TArray[n2];
            totalLength += array.length;
            ++n2;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        T[][] TArray2 = rest;
        int n3 = rest.length;
        int n4 = 0;
        while (n4 < n3) {
            T[] array = TArray2[n4];
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
            ++n4;
        }
        return result;
    }

    private class DispatchingFeatureProvider
    extends DefaultFeatureProvider {
        public DispatchingFeatureProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public ICreateFeature[] getCreateFeatures() {
            return ProviderDispatcher.this.getAllCreateFeatures();
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return ProviderDispatcher.this.getAllCreateConnectionFeatures();
        }

        public IAddFeature getAddFeature(IAddContext context) {
            ProviderDispatcher.this.featureSwitch.setParentContainer(context.getTargetContainer());
            IFeatureProvider fp = ProviderDispatcher.this.featureSwitch.doSwitch((EObject)context.getNewObject());
            if (fp == null) {
                return super.getAddFeature(context);
            }
            return fp.getAddFeature(context);
        }

        public ILayoutFeature getLayoutFeature(ILayoutContext context) {
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getLayoutFeature(context);
            }
            return super.getLayoutFeature(context);
        }

        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getMoveShapeFeature(context);
            }
            return super.getMoveShapeFeature(context);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getResizeShapeFeature(context);
            }
            return super.getResizeShapeFeature(context);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            if (context.getPictogramElement() instanceof Diagram) {
                return new DiagramUpdateFeature((IFeatureProvider)this);
            }
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getUpdateFeature(context);
            }
            return super.getUpdateFeature(context);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getDeleteFeature(context);
            }
            return super.getDeleteFeature(context);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getRemoveFeature(context);
            }
            return super.getRemoveFeature(context);
        }

        public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
            IFeatureProvider fp = this.getFeatureProvider(context);
            if (fp != null) {
                return fp.getReconnectionFeature(context);
            }
            return super.getReconnectionFeature(context);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            IFeatureProvider fp = ProviderDispatcher.this.featureSwitch.doSwitch(this.getBusinessObject(context));
            if (fp != null) {
                return fp.getCustomFeatures(context);
            }
            return super.getCustomFeatures(context);
        }

        private EObject getBusinessObject(IPictogramElementContext context) {
            PictogramElement pictogramElement = context.getPictogramElement();
            EObject bo = (EObject)this.getBusinessObjectForPictogramElement(pictogramElement);
            return bo;
        }

        private EObject getBusinessObject(ICustomContext context) {
            PictogramElement[] pes = context.getPictogramElements();
            if (pes.length > 0) {
                PictogramElement pe = pes[0];
                if (pe instanceof ConnectionDecorator) {
                    pe = (PictogramElement)pe.eContainer();
                }
                EObject bo = (EObject)this.getBusinessObjectForPictogramElement(pe);
                return bo;
            }
            return null;
        }

        private IFeatureProvider getFeatureProvider(IPictogramElementContext context) {
            EObject eco = context.getPictogramElement().eContainer();
            if (eco instanceof ContainerShape) {
                ProviderDispatcher.this.featureSwitch.setParentContainer((ContainerShape)eco);
                IFeatureProvider fp = ProviderDispatcher.this.featureSwitch.doSwitch(this.getBusinessObject(context));
                if (fp != null) {
                    return fp;
                }
            }
            return null;
        }

        private IFeatureProvider getFeatureProvider(IReconnectionContext context) {
            return ProviderDispatcher.this.featureSwitch.doSwitch((EObject)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection()));
        }
    }

    private class DispatchingToolBehaviorProvider
    extends DefaultToolBehaviorProvider {
        public DispatchingToolBehaviorProvider(IDiagramTypeProvider diagramTypeProvider) {
            super(diagramTypeProvider);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(pe);
            if (bp == null) {
                return super.getClickArea(pe);
            }
            return bp.getClickArea(pe);
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(pe);
            if (bp == null) {
                return super.getSelectionBorder(pe);
            }
            return bp.getSelectionBorder(pe);
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(context.getPictogramElements()[0]);
            if (bp == null) {
                return super.getDoubleClickFeature(context);
            }
            return bp.getDoubleClickFeature(context);
        }

        protected IToolBehaviorProvider getToolBehaviorProvider(PictogramElement pe) {
            IToolBehaviorProvider bp;
            EObject bo;
            IFeatureProvider fp = this.getFeatureProvider();
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            if ((bo = (EObject)fp.getBusinessObjectForPictogramElement(pe)) == null) {
                return null;
            }
            EObject eco = pe.eContainer();
            if (eco instanceof ContainerShape) {
                ProviderDispatcher.this.behaviorSwitch.setParentContainer((ContainerShape)eco);
                bp = ProviderDispatcher.this.behaviorSwitch.doSwitch(bo);
                if (bp != null) {
                    return bp;
                }
            }
            bp = ProviderDispatcher.this.behaviorSwitch.doSwitch(bo);
            return bp;
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(context.getPictogramElement());
            if (bp == null) {
                return super.getContextButtonPad(context);
            }
            return bp.getContextButtonPad(context);
        }

        public ISelectionInfo getSelectionInfoForShape(Shape shape) {
            SelectionInfoImpl si = new SelectionInfoImpl(IColorConstant.SHAPE_SELECTION_FG, IColorConstant.HANDLE_FG, IColorConstant.HANDLE_BG, LineStyle.DASH);
            si.setPrimarySelectionBackgroundColor(IColorConstant.LIGHT_ORANGE);
            si.setSecondarySelectionBackgroundColor(IColorConstant.LIGHT_ORANGE);
            return si;
        }

        public String getToolTip(GraphicsAlgorithm ga) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(ga.getPictogramElement());
            if (bp == null) {
                return super.getToolTip(ga);
            }
            return bp.getToolTip(ga);
        }
    }

    private class FeatureProviderSwitch
    extends RoomSwitch<IFeatureProvider> {
        private ContainerShape parent = null;

        private FeatureProviderSwitch() {
        }

        public IFeatureProvider doSwitch(EObject theEObject) {
            if (theEObject == null) {
                return null;
            }
            if (theEObject.eIsProxy()) {
                if (RoomFragmentProvider.isState((EObject)theEObject)) {
                    return ProviderDispatcher.this.stateSupport.getFeatureProvider();
                }
                if (RoomFragmentProvider.isTrPoint((EObject)theEObject)) {
                    return ProviderDispatcher.this.trPointSupport.getFeatureProvider();
                }
                if (RoomFragmentProvider.isChoicePoint((EObject)theEObject)) {
                    return ProviderDispatcher.this.choicePointSupport.getFeatureProvider();
                }
                if (RoomFragmentProvider.isStateGraph((EObject)theEObject)) {
                    return ProviderDispatcher.this.stateGraphSupport.getFeatureProvider();
                }
                if (RoomFragmentProvider.isTransition((EObject)theEObject)) {
                    return ProviderDispatcher.this.transitionSupport.getFeatureProvider();
                }
                if (RoomFragmentProvider.isTransition((EObject)theEObject)) {
                    return ProviderDispatcher.this.transitionSupport.getFeatureProvider();
                }
            }
            return (IFeatureProvider)super.doSwitch(theEObject);
        }

        public IFeatureProvider caseStateGraph(StateGraph object) {
            if (this.parent != null && this.parent.getLink() != null) {
                EObject bo;
                if (this.parent.getLink().getBusinessObjects().size() > 0 && (bo = (EObject)this.parent.getLink().getBusinessObjects().get(0)) instanceof StateGraph) {
                    return ProviderDispatcher.this.initialPointSupport.getFeatureProvider();
                }
                this.parent = null;
            }
            return ProviderDispatcher.this.stateGraphSupport.getFeatureProvider();
        }

        public IFeatureProvider caseTrPoint(TrPoint object) {
            return ProviderDispatcher.this.trPointSupport.getFeatureProvider();
        }

        public IFeatureProvider caseChoicePoint(ChoicePoint object) {
            return ProviderDispatcher.this.choicePointSupport.getFeatureProvider();
        }

        public IFeatureProvider caseState(State object) {
            return ProviderDispatcher.this.stateSupport.getFeatureProvider();
        }

        public IFeatureProvider caseTransition(Transition object) {
            return ProviderDispatcher.this.transitionSupport.getFeatureProvider();
        }

        public IFeatureProvider caseRefinedTransition(RefinedTransition object) {
            return ProviderDispatcher.this.transitionSupport.getFeatureProvider();
        }

        public IFeatureProvider defaultCase(EObject object) {
            return null;
        }

        public ICreateFeature[] getCreateFeatures() {
            return (ICreateFeature[])ProviderDispatcher.concatAll(ProviderDispatcher.this.stateSupport.getFeatureProvider().getCreateFeatures(), new ICreateFeature[][]{ProviderDispatcher.this.initialPointSupport.getFeatureProvider().getCreateFeatures(), ProviderDispatcher.this.trPointSupport.getFeatureProvider().getCreateFeatures(), ProviderDispatcher.this.choicePointSupport.getFeatureProvider().getCreateFeatures()});
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return ProviderDispatcher.this.transitionSupport.getFeatureProvider().getCreateConnectionFeatures();
        }

        public void setParentContainer(ContainerShape parent) {
            this.parent = parent;
        }
    }

    private class ToolBehaviorProviderSwitch
    extends RoomSwitch<IToolBehaviorProvider> {
        private ContainerShape parent = null;

        private ToolBehaviorProviderSwitch() {
        }

        public IToolBehaviorProvider doSwitch(EObject theEObject) {
            if (theEObject == null) {
                return null;
            }
            if (theEObject.eIsProxy()) {
                if (RoomFragmentProvider.isState((EObject)theEObject)) {
                    return ProviderDispatcher.this.stateGraphSupport.getToolBehaviorProvider();
                }
                if (RoomFragmentProvider.isTrPoint((EObject)theEObject)) {
                    return ProviderDispatcher.this.trPointSupport.getToolBehaviorProvider();
                }
                if (RoomFragmentProvider.isChoicePoint((EObject)theEObject)) {
                    return ProviderDispatcher.this.choicePointSupport.getToolBehaviorProvider();
                }
                if (RoomFragmentProvider.isStateGraph((EObject)theEObject)) {
                    return ProviderDispatcher.this.stateGraphSupport.getToolBehaviorProvider();
                }
                if (RoomFragmentProvider.isTransition((EObject)theEObject)) {
                    return ProviderDispatcher.this.transitionSupport.getToolBehaviorProvider();
                }
            }
            return (IToolBehaviorProvider)super.doSwitch(theEObject);
        }

        public IToolBehaviorProvider caseStateGraph(StateGraph object) {
            if (this.parent != null && this.parent.getLink() != null) {
                EObject bo;
                if (this.parent.getLink().getBusinessObjects().size() > 0 && (bo = (EObject)this.parent.getLink().getBusinessObjects().get(0)) instanceof StateGraph) {
                    return ProviderDispatcher.this.initialPointSupport.getToolBehaviorProvider();
                }
                this.parent = null;
            }
            return ProviderDispatcher.this.stateGraphSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseTrPoint(TrPoint object) {
            return ProviderDispatcher.this.trPointSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseChoicePoint(ChoicePoint object) {
            return ProviderDispatcher.this.choicePointSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseState(State object) {
            return ProviderDispatcher.this.stateSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseTransition(Transition object) {
            return ProviderDispatcher.this.transitionSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider defaultCase(EObject object) {
            return null;
        }

        public void setParentContainer(ContainerShape parent) {
            this.parent = parent;
        }
    }
}

