/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.editor;

import java.io.File;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.behavior.DiagramAccess;
import org.eclipse.etrice.ui.behavior.editor.BehaviorEditor;
import org.eclipse.etrice.ui.common.editor.DiagramExporter;
import org.eclipse.etrice.ui.common.editor.RoomDiagramEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class BehaviorExporter {
    private static final String SUFFIX = "_behavior";

    public static void export(ActorClass ac, String folder) {
        DiagramAccess da = new DiagramAccess();
        boolean wasOpen = false;
        BehaviorEditor editor = (BehaviorEditor)da.findDiagramEditor((StructureClass)ac);
        if (editor != null) {
            wasOpen = true;
        } else {
            editor = (BehaviorEditor)da.openDiagramEditor((StructureClass)ac);
        }
        if (editor != null) {
            String filename = String.valueOf(folder) + File.separatorChar + ac.getName() + SUFFIX;
            DiagramExporter.export((RoomDiagramEditor)editor, (String)filename);
            BehaviorExporter.exportSubGraphsRecursively(ac.getStateMachine(), editor, String.valueOf(folder) + File.separatorChar + ac.getName());
            if (!wasOpen) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
            }
        }
    }

    private static void exportSubGraphsRecursively(StateGraph sg, BehaviorEditor editor, String basename) {
        if (sg == null) {
            return;
        }
        for (State state : sg.getStates()) {
            if (!RoomHelpers.hasDirectSubStructure((State)state)) continue;
            if (editor.showStateGraph(state.getSubgraph())) {
                String filename = String.valueOf(basename) + "_" + RoomNameProvider.getStatePathName((State)state) + SUFFIX;
                DiagramExporter.export((RoomDiagramEditor)editor, (String)filename);
            }
            BehaviorExporter.exportSubGraphsRecursively(state.getSubgraph(), editor, basename);
        }
    }
}

