/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateGraphNode;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.ui.behavior.DiagramAccess;
import org.eclipse.etrice.ui.behavior.commands.StateGraphContext;
import org.eclipse.etrice.ui.behavior.support.IPositionProvider;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;

public class DefaultPositionProvider
implements IPositionProvider {
    private HashMap<String, Position> obj2pos = new HashMap();
    private HashMap<String, ArrayList<Position>> trans2points = new HashMap();
    private double scaleX;
    private double scaleY;

    public DefaultPositionProvider(ActorClass ac) {
        this.mapPositions(ac.getBase());
    }

    @Override
    public void setScale(double sx, double sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    @Override
    public IPositionProvider.PosAndSize getPosition(StateGraphNode node) {
        Position pos = this.obj2pos.get(RoomNameProvider.getFullPath((StateGraphItem)node));
        if (pos == null) {
            return null;
        }
        int margin = this.getMargin(node);
        IPositionProvider.PosAndSize pt = new IPositionProvider.PosAndSize((int)(pos.x * this.scaleX) + margin, (int)(pos.y * this.scaleY) + margin, (int)(pos.sx * this.scaleX), (int)(pos.sy * this.scaleY));
        return pt;
    }

    @Override
    public List<IPositionProvider.Pos> getPoints(Transition trans) {
        ArrayList<IPositionProvider.Pos> result = new ArrayList<IPositionProvider.Pos>();
        ArrayList<Position> list = this.trans2points.get(RoomNameProvider.getFullPath((StateGraphItem)trans));
        if (list != null) {
            for (Position p : list) {
                IPositionProvider.Pos pos = new IPositionProvider.Pos((int)(p.x * this.scaleX), (int)(p.y * this.scaleY));
                result.add(pos);
            }
        }
        return result;
    }

    @Override
    public <T extends StateGraphNode> List<IPositionProvider.PosAndSize> getPositions(List<T> nodes) {
        int delta;
        ArrayList<IPositionProvider.PosAndSize> result = new ArrayList<IPositionProvider.PosAndSize>(nodes.size());
        if (nodes.isEmpty()) {
            return result;
        }
        int n = 0;
        for (StateGraphNode node : nodes) {
            IPositionProvider.PosAndSize pt = this.getPosition(node);
            result.add(pt);
            if (pt != null) continue;
            ++n;
        }
        int pos = delta = (int)(this.scaleX / (double)(n + 1));
        int h = 40;
        if (nodes.get(0) instanceof State) {
            h = 165;
        } else if (nodes.get(0) instanceof ChoicePoint) {
            h = 290;
        } else if (nodes.get(0) instanceof TrPoint) {
            h = 40;
        } else assert (false) : "unexpected sub type";
        int i = 0;
        while (i < nodes.size()) {
            if (result.get(i) == null) {
                IPositionProvider.PosAndSize pt = new IPositionProvider.PosAndSize(pos, h, 0, 0);
                result.set(i, pt);
                pos += delta;
            }
            ++i;
        }
        return result;
    }

    private void mapPositions(ActorClass ac) {
        EObject obj;
        if (ac == null) {
            return;
        }
        Diagram diagram = new DiagramAccess().getDiagram((StructureClass)ac);
        if (diagram == null) {
            return;
        }
        StateGraphContext tree = StateGraphContext.createContextTree(SupportUtil.getActorClass(diagram));
        HashMap<StateGraph, Position> sg2sz = new HashMap<StateGraph, Position>();
        ILinkService linkService = Graphiti.getLinkService();
        for (Shape sgShape : diagram.getChildren()) {
            if (!(sgShape instanceof ContainerShape)) continue;
            obj = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)sgShape);
            GraphicsAlgorithm borderRect = (GraphicsAlgorithm)sgShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
            double width = borderRect.getWidth();
            double height = borderRect.getHeight();
            Position sz = new Position();
            sz.sx = width;
            sz.sy = height;
            sg2sz.put((StateGraph)obj, sz);
            for (Shape sgItemShape : ((ContainerShape)sgShape).getChildren()) {
                GraphicsAlgorithm ga;
                obj = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)sgItemShape);
                if (!(obj instanceof StateGraphNode) || (ga = sgItemShape.getGraphicsAlgorithm()) == null) continue;
                int margin = this.getMargin((StateGraphNode)obj);
                Position pos = new Position();
                pos.x = (double)ga.getX() / width;
                pos.y = (double)ga.getY() / height;
                pos.sx = (double)(ga.getWidth() - 2 * margin) / width;
                pos.sy = (double)(ga.getHeight() - 2 * margin) / height;
                this.obj2pos.put(RoomNameProvider.getFullPath((StateGraphItem)((StateGraphItem)obj)), pos);
            }
        }
        for (Connection conn : diagram.getConnections()) {
            ConnectionDecorator cd;
            obj = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)conn);
            if (!(obj instanceof Transition) || !((cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1)).getGraphicsAlgorithm() instanceof Text)) continue;
            Transition trans = (Transition)obj;
            StateGraph sg = tree.getContext((StateGraphItem)trans).getStateGraph();
            Position sz = (Position)sg2sz.get(sg);
            ArrayList<Position> points = new ArrayList<Position>();
            this.trans2points.put(RoomNameProvider.getFullPath((StateGraphItem)((Transition)obj)), points);
            Position pos = new Position();
            pos.x = (double)cd.getGraphicsAlgorithm().getX() / sz.sx;
            pos.y = (double)cd.getGraphicsAlgorithm().getY() / sz.sy;
            points.add(pos);
            if (!(conn instanceof FreeFormConnection)) continue;
            for (Point bp : ((FreeFormConnection)conn).getBendpoints()) {
                pos = new Position();
                pos.x = (double)bp.getX() / sz.sx;
                pos.y = (double)bp.getY() / sz.sy;
                points.add(pos);
            }
        }
        this.mapPositions(ac.getBase());
    }

    private int getMargin(StateGraphNode node) {
        if (node instanceof State) {
            return 30;
        }
        if (node instanceof TrPoint) {
            return 40;
        }
        return 0;
    }

    private static class Position {
        double x;
        double y;
        double sx;
        double sy;

        private Position() {
        }
    }
}

