/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.ui.linking.GlobalNonPlatformURIEditorOpener;
import org.eclipse.etrice.ui.common.Activator;
import org.eclipse.etrice.ui.common.editor.RoomDiagramEditor;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class DiagramAccessBase {
    private static final String DIAGRAMS_FOLDER_NAME = "diagrams";

    public Diagram getDiagram(StructureClass sc) {
        Resource diagRes;
        Resource resource = sc.eResource();
        if (resource == null) {
            return null;
        }
        URI uri = resource.getURI();
        String modelName = ((RoomModel)sc.eContainer()).getName();
        URI diagURI = null;
        boolean exists = false;
        if (uri.isPlatformResource()) {
            uri = uri.trimSegments(1);
            IFolder parentFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(uri.toPlatformString(true)));
            IFolder diagramFolder = parentFolder.getFolder(DIAGRAMS_FOLDER_NAME);
            IFile diagramFile = diagramFolder.getFile(String.valueOf(modelName) + "." + sc.getName() + this.getFileExtension());
            diagURI = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
            exists = diagramFile.exists();
        } else {
            File diagramFile = new File(uri.toFileString());
            diagramFile = new File(String.valueOf(diagramFile.getParent()) + File.separator + DIAGRAMS_FOLDER_NAME + File.separator + modelName + "." + sc.getName() + this.getFileExtension());
            diagURI = URI.createFileURI((String)diagramFile.getPath());
            exists = diagramFile.exists();
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        if (exists) {
            diagRes = rs.getResource(diagURI, true);
            if (diagRes.getContents().isEmpty()) {
                return null;
            }
            if (diagRes.getContents().get(0) instanceof Diagram) {
                Diagram diagram = (Diagram)diagRes.getContents().get(0);
                this.updateDiagram(diagram, false);
                return diagram;
            }
        } else {
            diagRes = rs.createResource(diagURI);
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            boolean snap = store.getBoolean("SnapToGrid");
            boolean useGrid = store.getBoolean("UseGrid");
            int horUnit = useGrid ? store.getInt("HorGridUnit") : 0;
            int verUnit = useGrid ? store.getInt("VerGridUnit") : 0;
            Diagram diagram = Graphiti.getPeCreateService().createDiagram(this.getDiagramTypeId(), this.getDiagramName(sc), horUnit, verUnit, snap);
            diagRes.getContents().add((Object)diagram);
            this.populateDiagram(sc, diagram);
            try {
                diagRes.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return diagram;
        }
        return null;
    }

    private void populateDiagram(StructureClass ac, Diagram diagram) {
        ResourceSet rs = diagram.eResource().getResourceSet();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)rs);
        if (editingDomain == null) {
            editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(rs);
        }
        URI boUri = EcoreUtil.getURI((EObject)ac);
        ac = (StructureClass)editingDomain.getResourceSet().getEObject(boUri, true);
        editingDomain.getCommandStack().execute(this.getInitialCommand(ac, diagram, editingDomain));
        editingDomain.dispose();
    }

    private void updateDiagram(Diagram diagram, boolean doSave) {
        Command updateCommand;
        ResourceSet rs = diagram.eResource().getResourceSet();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)rs);
        if (editingDomain == null) {
            editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(rs);
        }
        if ((updateCommand = this.getUpdateCommand(diagram, editingDomain)) != null) {
            editingDomain.getCommandStack().execute(updateCommand);
            if (doSave) {
                try {
                    diagram.eResource().save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        editingDomain.dispose();
    }

    public RoomDiagramEditor findDiagramEditor(StructureClass sc) {
        IFileEditorInput input = this.getEditorInput(sc);
        return (RoomDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)input);
    }

    public RoomDiagramEditor openDiagramEditor(StructureClass sc) {
        IFileEditorInput input = this.getEditorInput(sc);
        try {
            return (RoomDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, this.getEditorId());
        }
        catch (PartInitException e) {
            String error = "Error while opening diagram editor";
            System.err.println(error);
            return null;
        }
    }

    private IFileEditorInput getEditorInput(StructureClass sc) {
        Diagram diagram = this.getDiagram(sc);
        URI uri = diagram.eResource().getURI();
        String platformString = null;
        if (uri.isPlatform()) {
            platformString = uri.toPlatformString(true);
        } else {
            uri = GlobalNonPlatformURIEditorOpener.getPlatformURI((URI)uri);
            platformString = uri.toPlatformString(true);
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString));
        FileEditorInput input = new FileEditorInput(file);
        return input;
    }

    protected abstract String getDiagramName(StructureClass var1);

    protected abstract String getDiagramTypeId();

    protected abstract String getEditorId();

    protected abstract String getFileExtension();

    protected abstract Command getInitialCommand(StructureClass var1, Diagram var2, TransactionalEditingDomain var3);

    protected abstract Command getUpdateCommand(Diagram var1, TransactionalEditingDomain var2);
}

