/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.dialogs;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.common.dialogs.AbstractPropertyDialog;
import org.eclipse.etrice.ui.structure.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class ActorContainerRefPropertyDialog
extends AbstractPropertyDialog {
    private ActorContainerRef ref;
    private IScope scope;
    private StructureClass sc;
    private boolean newRef;

    public ActorContainerRefPropertyDialog(Shell shell, ActorContainerRef ref, IScope scope, StructureClass sc, boolean newRef) {
        super(shell, "Edit Reference");
        this.ref = ref;
        this.scope = scope;
        this.sc = sc;
        this.newRef = newRef;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point size = this.getShell().getSize();
        this.getShell().setSize((int)((double)size.x * 1.2), size.y);
    }

    protected void createContent(IManagedForm mform, Composite body, DataBindingContext bindingContext) {
        NameValidator nv = new NameValidator();
        ProtocolValidator pv = new ProtocolValidator();
        boolean refIsActor = this.sc instanceof ActorContainerClass;
        boolean containerIsActor = this.sc instanceof ActorClass;
        ArrayList<IEObjectDescription> actors = new ArrayList<IEObjectDescription>();
        for (IEObjectDescription desc : this.scope.getAllElements()) {
            EObject obj = desc.getEObjectOrProxy();
            if (refIsActor && obj instanceof ActorClass) {
                if (containerIsActor) {
                    if (ValidationUtil.isReferencing((ActorClass)((ActorClass)obj), (ActorClass)((ActorClass)this.sc))) continue;
                    actors.add(desc);
                    continue;
                }
                actors.add(desc);
                continue;
            }
            if (refIsActor || !(obj instanceof SubSystemClass) || obj == this.sc) continue;
            actors.add(desc);
        }
        Text name = this.createText(body, "&Name:", (EObject)this.ref, RoomPackage.eINSTANCE.getActorContainerRef_Name(), nv);
        Combo refClass = refIsActor ? this.createComboUsingDesc(body, "Actor &Class:", (EObject)this.ref, ActorClass.class, RoomPackage.eINSTANCE.getActorRef_Type(), actors, RoomPackage.eINSTANCE.getRoomClass_Name(), pv) : this.createComboUsingDesc(body, "SubSystem &Class:", (EObject)this.ref, SubSystemClass.class, RoomPackage.eINSTANCE.getSubSystemRef_Type(), actors, RoomPackage.eINSTANCE.getRoomClass_Name(), pv);
        this.createDecorator((Control)name, "invalid name");
        this.createDecorator((Control)refClass, "no class selected");
        if (!this.newRef) {
            refClass.setEnabled(false);
            this.createInfoDecorator((Control)refClass, "class fixed for exisiting ref");
        }
        if (this.ref instanceof ActorRef) {
            Text size = this.createText(body, "&Multiplicity", (EObject)this.ref, RoomPackage.eINSTANCE.getActorRef_Size(), new SizeValidator());
            if (this.hasInterfacePortWithMultiplicityAny(((ActorRef)this.ref).getType())) {
                size.setEnabled(false);
                this.createInfoDecorator((Control)size, "size fixed since actor has interface ports with multiplicity *");
            } else {
                this.createDecorator((Control)size, "multiplicity");
            }
        }
        name.selectAll();
        name.setFocus();
    }

    private boolean hasInterfacePortWithMultiplicityAny(ActorClass ac) {
        if (ac == null) {
            return false;
        }
        for (Port p : ac.getIfPorts()) {
            if (p.getMultiplicity() >= 0) continue;
            return true;
        }
        return false;
    }

    protected Image getImage() {
        return Activator.getImage("icons/Structure.gif");
    }

    class NameValidator
    implements IValidator {
        NameValidator() {
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String name = (String)value;
                if (name.isEmpty()) {
                    return ValidationStatus.error((String)"name must not be empty");
                }
                if (ActorContainerRefPropertyDialog.this.sc instanceof ActorClass) {
                    if (this.nameExists((ActorClass)ActorContainerRefPropertyDialog.this.sc, name)) {
                        return ValidationStatus.error((String)"name already exists");
                    }
                } else if (ActorContainerRefPropertyDialog.this.sc instanceof SubSystemClass) {
                    SubSystemClass ssc = (SubSystemClass)ActorContainerRefPropertyDialog.this.sc;
                    for (ActorRef ar : ssc.getActorRefs()) {
                        if (ar == ActorContainerRefPropertyDialog.this.ref || !ar.getName().equals(name)) continue;
                        return ValidationStatus.error((String)"name already exists");
                    }
                } else if (ActorContainerRefPropertyDialog.this.sc instanceof LogicalSystem) {
                    LogicalSystem ssc = (LogicalSystem)ActorContainerRefPropertyDialog.this.sc;
                    for (SubSystemRef ssr : ssc.getSubSystems()) {
                        if (ssr == ActorContainerRefPropertyDialog.this.ref || !ssr.getName().equals(name)) continue;
                        return ValidationStatus.error((String)"name already exists");
                    }
                } else assert (false) : "unexpected type";
                return Status.OK_STATUS;
            }
            return Status.OK_STATUS;
        }

        private boolean nameExists(ActorClass ac, String name) {
            for (ActorRef ar : ac.getActorRefs()) {
                if (ar == ActorContainerRefPropertyDialog.this.ref || !ar.getName().equals(name)) continue;
                return true;
            }
            if (ac.getBase() != null) {
                return this.nameExists(ac.getBase(), name);
            }
            return false;
        }
    }

    class ProtocolValidator
    implements IValidator {
        ProtocolValidator() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                return ValidationStatus.error((String)"select a class");
            }
            return Status.OK_STATUS;
        }
    }

    class SizeValidator
    implements IValidator {
        public IStatus validate(Object value) {
            int m;
            if (value instanceof Integer && (m = ((Integer)value).intValue()) <= 0) {
                return ValidationStatus.error((String)"multiplicity must not be positive");
            }
            return Status.OK_STATUS;
        }
    }
}

