/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.common.support.CommonSupportUtil;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.structure.DiagramAccess;
import org.eclipse.etrice.ui.structure.DiagramTypeProvider;
import org.eclipse.etrice.ui.structure.dialogs.ActorContainerRefPropertyDialog;
import org.eclipse.etrice.ui.structure.support.InterfaceItemSupport;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class ActorContainerRefSupport {
    private static final int LINE_WIDTH = 1;
    public static final int DEFAULT_SIZE_X = 180;
    public static final int DEFAULT_SIZE_Y = 80;
    public static final int MIN_SIZE_X = 100;
    public static final int MIN_SIZE_Y = 60;
    public static final int MARGIN = 30;
    private static final int SIZE_FRAME_SIZE = 25;
    private static final int REPLICATED_RECT_OFFSET = 3;
    public static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    public static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    public static final IColorConstant BACKGROUND = new ColorConstant(200, 200, 200);
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    private static void createRefFigure(ActorContainerRef ar, Diagram diagram, ContainerShape containerShape, Rectangle invisibleRectangle, Color lineColor, Color bgColor) {
        invisibleRectangle.getGraphicsAlgorithmChildren().clear();
        if (!containerShape.getChildren().isEmpty()) {
            Shape shape = (Shape)containerShape.getChildren().get(0);
            if (shape.getGraphicsAlgorithm() instanceof Text) {
                containerShape.getChildren().remove(0);
            }
            if ((shape = (Shape)containerShape.getChildren().get(0)).getGraphicsAlgorithm() instanceof Text) {
                containerShape.getChildren().remove(0);
            }
        }
        int width = invisibleRectangle.getWidth() - 60;
        int height = invisibleRectangle.getHeight() - 60;
        IGaService gaService = Graphiti.getGaService();
        if (ar instanceof ActorRef && ((ActorRef)ar).getSize() > 1) {
            Rectangle rect = gaService.createRectangle((GraphicsAlgorithmContainer)invisibleRectangle);
            rect.setForeground(lineColor);
            rect.setBackground(bgColor);
            rect.setLineWidth(Integer.valueOf(1));
            gaService.setLocationAndSize((GraphicsAlgorithm)rect, 33, 27, width, height);
        }
        Rectangle borderRect = gaService.createRectangle((GraphicsAlgorithmContainer)invisibleRectangle);
        borderRect.setForeground(lineColor);
        borderRect.setBackground(bgColor);
        borderRect.setLineWidth(Integer.valueOf(1));
        gaService.setLocationAndSize((GraphicsAlgorithm)borderRect, 30, 30, width, height);
        if (ar instanceof ActorRef && ((ActorRef)ar).getSize() > 1) {
            Rectangle sizeFrame = gaService.createRectangle((GraphicsAlgorithmContainer)invisibleRectangle);
            sizeFrame.setForeground(lineColor);
            sizeFrame.setBackground(bgColor);
            sizeFrame.setLineWidth(Integer.valueOf(1));
            gaService.setLocationAndSize((GraphicsAlgorithm)sizeFrame, 30 + width - 25, 30, 25, 25);
        }
        ActorContainerRefSupport.addSubStructureHint(ar, borderRect, lineColor);
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        if (containerShape.getAnchors().isEmpty()) {
            ChopboxAnchor anchor = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
            anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)borderRect);
        } else {
            ((Anchor)containerShape.getAnchors().get(0)).setReferencedGraphicsAlgorithm((GraphicsAlgorithm)borderRect);
        }
        Shape labelShape = peCreateService.createShape(containerShape, false);
        Text label = gaService.createDefaultText(diagram, (GraphicsAlgorithmContainer)labelShape, RoomNameProvider.getRefLabelName((ActorContainerRef)ar));
        label.setForeground(lineColor);
        label.setBackground(lineColor);
        label.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        label.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        gaService.setLocationAndSize((GraphicsAlgorithm)label, 30, 30, width, height);
        if (ar instanceof ActorRef && ((ActorRef)ar).getSize() > 1) {
            labelShape = peCreateService.createShape(containerShape, false);
            Integer size = ((ActorRef)ar).getSize();
            Text label2 = gaService.createDefaultText(diagram, (GraphicsAlgorithmContainer)labelShape, size.toString());
            label2.setForeground(lineColor);
            label2.setBackground(lineColor);
            label2.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
            label2.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
            gaService.setLocationAndSize((GraphicsAlgorithm)label2, 30 + width - 25, 30, 25, 25);
        }
    }

    private static void addSubStructureHint(ActorContainerRef acr, Rectangle borderRect, Color lineColor) {
        int x = borderRect.getWidth() - 35;
        int y = borderRect.getHeight() - 30;
        IGaService gaService = Graphiti.getGaService();
        Rectangle hint1 = gaService.createRectangle((GraphicsAlgorithmContainer)borderRect);
        hint1.setForeground(lineColor);
        hint1.setFilled(Boolean.valueOf(false));
        hint1.setLineWidth(Integer.valueOf(1));
        gaService.setLocationAndSize((GraphicsAlgorithm)hint1, x + 5, y, 20, 10);
        Rectangle hint2 = gaService.createRectangle((GraphicsAlgorithmContainer)borderRect);
        hint2.setForeground(lineColor);
        hint2.setFilled(Boolean.valueOf(false));
        hint2.setLineWidth(Integer.valueOf(1));
        gaService.setLocationAndSize((GraphicsAlgorithm)hint2, x, y + 15, 20, 10);
        if (!ActorContainerRefSupport.hasSubStructure(acr)) {
            hint1.setLineVisible(Boolean.valueOf(false));
            hint2.setLineVisible(Boolean.valueOf(false));
        }
    }

    private static boolean hasSubStructure(ActorContainerRef acr) {
        return acr instanceof ActorRef ? !((ActorRef)acr).getType().getActorRefs().isEmpty() : acr instanceof SubSystemRef && !((SubSystemRef)acr).getType().getActorRefs().isEmpty();
    }

    public ActorContainerRefSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    private class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return rectangle;
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            return new FeatureProvider.OpenRefStructureDiagram(this.getDiagramTypeProvider().getFeatureProvider());
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            ICreateConnectionFeature[] features;
            IContextButtonPadData data = super.getContextButtonPad(context);
            PictogramElement pe = context.getPictogramElement();
            CreateConnectionContext ccc = new CreateConnectionContext();
            ccc.setSourcePictogramElement(pe);
            Anchor anchor = null;
            if (pe instanceof AnchorContainer) {
                anchor = (Anchor)((ContainerShape)pe).getAnchors().get(0);
            }
            ccc.setSourceAnchor(anchor);
            ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
            button.setText("Create Layer Connection");
            button.setIconId("org.eclipse.etrice.ui.structure.layer_connection");
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = this.getFeatureProvider().getCreateConnectionFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
                if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                    button.addDragAndDropFeature((IFeature)feature);
                }
                ++n2;
            }
            if (button.getDragAndDropFeatures().size() > 0) {
                data.getDomainSpecificContextButtons().add(button);
            }
            return data;
        }
    }

    private static class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public ICreateFeature[] getCreateFeatures() {
            return new ICreateFeature[]{new CreateFeature(this.fp, true), new CreateFeature(this.fp, false)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public ILayoutFeature getLayoutFeature(ILayoutContext context) {
            return new LayoutFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            return new MoveShapeFeature(this.fp);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new ResizeFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            return new ICustomFeature[]{new PropertyFeature(this.fp), new OpenRefStructureDiagram(this.fp), new OpenRefBehaviorDiagram(this.fp)};
        }

        protected static boolean isInherited(ActorContainerRef ar, EObject parent) {
            return ar.eContainer() != parent;
        }

        protected static void updateSubStructureHint(ActorContainerRef acr, GraphicsAlgorithm borderRect) {
            boolean hasSubStructure = ActorContainerRefSupport.hasSubStructure(acr);
            GraphicsAlgorithm hint = (GraphicsAlgorithm)borderRect.getGraphicsAlgorithmChildren().get(0);
            hint.setLineVisible(Boolean.valueOf(hasSubStructure));
            hint = (GraphicsAlgorithm)borderRect.getGraphicsAlgorithmChildren().get(1);
            hint.setLineVisible(Boolean.valueOf(hasSubStructure));
        }

        private static void updateLabel(ActorContainerRef acr, PictogramElement pe) {
            ContainerShape container = (ContainerShape)pe;
            GraphicsAlgorithm ga = ((Shape)container.getChildren().get(0)).getGraphicsAlgorithm();
            if (ga instanceof Text) {
                ((Text)ga).setValue(RoomNameProvider.getRefLabelName((ActorContainerRef)acr));
            }
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                EObject obj;
                return context.getNewObject() instanceof ActorContainerRef && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof StructureClass;
            }

            public PictogramElement add(IAddContext context) {
                ActorContainerRef ar = (ActorContainerRef)context.getNewObject();
                ContainerShape acShape = context.getTargetContainer();
                ContainerShape containerShape = Graphiti.getPeCreateService().createContainerShape(acShape, true);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "obj-type", "ref");
                EObject parent = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)acShape);
                boolean inherited = FeatureProvider.isInherited(ar, parent);
                Color lineColor = this.manageColor(inherited ? INHERITED_COLOR : LINE_COLOR);
                int width = context.getWidth() <= 0 ? 180 : context.getWidth();
                int height = context.getHeight() <= 0 ? 80 : context.getHeight();
                Rectangle invisibleRectangle = Graphiti.getGaService().createInvisibleRectangle((PictogramElement)containerShape);
                Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX() - (width / 2 + 30), context.getY() - (height / 2 + 30), width + 60, height + 60);
                ActorContainerRefSupport.createRefFigure(ar, this.getDiagram(), containerShape, invisibleRectangle, lineColor, this.manageColor(BACKGROUND));
                this.link((PictogramElement)containerShape, ar);
                if (inherited) {
                    InterfaceItemSupport.createInheritedRefItems(ar, containerShape, FeatureProvider.this.fp);
                } else {
                    InterfaceItemSupport.createRefItems(ar, containerShape, FeatureProvider.this.fp);
                }
                this.layoutPictogramElement((PictogramElement)containerShape);
                return containerShape;
            }
        }

        private class CreateFeature
        extends AbstractCreateFeature {
            private boolean actorRef;
            private boolean doneChanges;

            public CreateFeature(IFeatureProvider fp, boolean actorRef) {
                super(fp, actorRef ? "ActorRef" : "SubSystemRef", "create " + (actorRef ? "ActorRef" : "SubSystemRef"));
                this.doneChanges = false;
                this.actorRef = actorRef;
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.structure.ref";
            }

            public boolean canCreate(ICreateContext context) {
                if (context.getTargetContainer().getLink() != null && context.getTargetContainer().getLink().getBusinessObjects().size() == 1) {
                    EObject obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0);
                    if (obj instanceof ActorContainerClass) {
                        return this.actorRef;
                    }
                    if (obj instanceof LogicalSystem) {
                        return !this.actorRef;
                    }
                }
                return false;
            }

            public Object[] create(ICreateContext context) {
                StructureClass sc = (StructureClass)context.getTargetContainer().getLink().getBusinessObjects().get(0);
                ActorRef newRef = null;
                if (sc instanceof ActorContainerClass) {
                    ActorContainerClass acc = (ActorContainerClass)sc;
                    ActorRef ar = RoomFactory.eINSTANCE.createActorRef();
                    acc.getActorRefs().add((Object)ar);
                    newRef = ar;
                } else if (sc instanceof LogicalSystem) {
                    LogicalSystem sys = (LogicalSystem)sc;
                    SubSystemRef ssr = RoomFactory.eINSTANCE.createSubSystemRef();
                    sys.getSubSystems().add((Object)ssr);
                    newRef = ssr;
                }
                newRef.setName(RoomNameProvider.getUniqueActorContainerRefName((StructureClass)sc));
                IScopeProvider scopeProvider = ((DiagramTypeProvider)this.getFeatureProvider().getDiagramTypeProvider()).getScopeProvider();
                EReference reference = newRef instanceof ActorRef ? RoomPackage.eINSTANCE.getActorRef_Type() : RoomPackage.eINSTANCE.getSubSystemRef_Type();
                IScope scope = scopeProvider.getScope(newRef.eContainer().eContainer(), reference);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ActorContainerRefPropertyDialog dlg = new ActorContainerRefPropertyDialog(shell, (ActorContainerRef)newRef, scope, sc, true);
                if (dlg.open() != 0) {
                    if (sc instanceof ActorContainerClass) {
                        ((ActorContainerClass)sc).getActorRefs().remove((Object)newRef);
                    } else if (sc instanceof LogicalSystem) {
                        ((LogicalSystem)sc).getSubSystems().remove((Object)newRef);
                    }
                    return EMPTY;
                }
                this.addGraphicalRepresentation((IAreaContext)context, newRef);
                this.doneChanges = true;
                return new Object[]{newRef};
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof ActorContainerRef) {
                    ActorContainerRef ar = (ActorContainerRef)bo;
                    ContainerShape acShape = (ContainerShape)context.getPictogramElement().eContainer();
                    EObject parent = (EObject)acShape.getLink().getBusinessObjects().get(0);
                    return !FeatureProvider.isInherited(ar, parent);
                }
                return false;
            }

            public void preDelete(IDeleteContext context) {
                super.preDelete(context);
                if (!(context.getPictogramElement() instanceof ContainerShape)) {
                    return;
                }
                ContainerShape container = (ContainerShape)context.getPictogramElement();
                CommonSupportUtil.deleteConnectionsRecursive((ContainerShape)container, (IFeatureProvider)this.getFeatureProvider());
            }
        }

        private class LayoutFeature
        extends AbstractLayoutFeature {
            public LayoutFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canLayout(ILayoutContext context) {
                PictogramElement pe = context.getPictogramElement();
                if (!(pe instanceof ContainerShape)) {
                    return false;
                }
                EList businessObjects = pe.getLink().getBusinessObjects();
                return businessObjects.size() == 1 && businessObjects.get(0) instanceof ActorContainerRef;
            }

            public boolean layout(ILayoutContext context) {
                boolean anythingChanged = false;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
                int w = containerGa.getWidth();
                int h = containerGa.getHeight();
                if (containerGa.getGraphicsAlgorithmChildren().size() == 1) {
                    GraphicsAlgorithm borderRect = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    int nw = w - 60;
                    int nh = h - 60;
                    borderRect.setWidth(nw);
                    borderRect.setHeight(nh);
                    Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                    if (bo instanceof ActorContainerRef) {
                        ActorContainerRef acr = (ActorContainerRef)bo;
                        while (!borderRect.getGraphicsAlgorithmChildren().isEmpty()) {
                            EcoreUtil.delete((EObject)((EObject)borderRect.getGraphicsAlgorithmChildren().get(0)), (boolean)true);
                        }
                        EObject parent = (EObject)containerShape.getContainer().getLink().getBusinessObjects().get(0);
                        Color lineColor = this.manageColor(FeatureProvider.isInherited(acr, parent) ? INHERITED_COLOR : LINE_COLOR);
                        ActorContainerRefSupport.addSubStructureHint(acr, (Rectangle)borderRect, lineColor);
                    }
                    if (!containerShape.getChildren().isEmpty()) {
                        GraphicsAlgorithm childGA = ((Shape)containerShape.getChildren().get(0)).getGraphicsAlgorithm();
                        assert (childGA instanceof Text) : "label expected";
                        childGA.setWidth(nw);
                        childGA.setHeight(nh);
                    }
                    anythingChanged = true;
                }
                return anythingChanged;
            }
        }

        private class MoveShapeFeature
        extends DefaultMoveShapeFeature {
            public MoveShapeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canMoveShape(IMoveShapeContext context) {
                Object bo;
                boolean canMove = super.canMoveShape(context);
                if (canMove && (bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement())) instanceof ActorContainerRef) {
                    ActorContainerRef ar = (ActorContainerRef)bo;
                    ContainerShape acShape = context.getTargetContainer();
                    EObject parent = (EObject)acShape.getLink().getBusinessObjects().get(0);
                    return !FeatureProvider.isInherited(ar, parent);
                }
                return canMove;
            }
        }

        private static class OpenRefBehaviorDiagram
        extends AbstractCustomFeature {
            public OpenRefBehaviorDiagram(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Open Ref Behavior";
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                return pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorRef;
            }

            public void execute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorContainerRef) {
                    ActorContainerRef ref = (ActorContainerRef)bo;
                    org.eclipse.etrice.ui.behavior.DiagramAccess diagramAccess = new org.eclipse.etrice.ui.behavior.DiagramAccess();
                    if (ref instanceof ActorRef) {
                        diagramAccess.openDiagramEditor((StructureClass)((ActorRef)ref).getType());
                    }
                }
            }

            public boolean hasDoneChanges() {
                return false;
            }
        }

        private static class OpenRefStructureDiagram
        extends AbstractCustomFeature {
            public OpenRefStructureDiagram(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Open Ref Structure";
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                return pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorContainerRef;
            }

            public void execute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorContainerRef) {
                    ActorContainerRef ref = (ActorContainerRef)bo;
                    DiagramAccess diagramAccess = new DiagramAccess();
                    if (ref instanceof ActorRef) {
                        diagramAccess.openDiagramEditor((StructureClass)((ActorRef)ref).getType());
                    } else if (ref instanceof SubSystemRef) {
                        diagramAccess.openDiagramEditor((StructureClass)((SubSystemRef)ref).getType());
                    }
                }
            }

            public boolean hasDoneChanges() {
                return false;
            }
        }

        private static class PropertyFeature
        extends AbstractCustomFeature {
            private boolean doneChanges = false;

            public PropertyFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Edit Reference...";
            }

            public String getDescription() {
                return "Edit Reference Properties";
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorContainerRef) {
                    EObject parent = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)pes[0].eContainer());
                    return !FeatureProvider.isInherited((ActorContainerRef)bo, parent);
                }
                return false;
            }

            public void execute(ICustomContext context) {
                ContainerShape containerShape = (ContainerShape)context.getPictogramElements()[0];
                ActorContainerRef acr = (ActorContainerRef)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                StructureClass sc = (StructureClass)acr.eContainer();
                IScopeProvider scopeProvider = ((DiagramTypeProvider)this.getFeatureProvider().getDiagramTypeProvider()).getScopeProvider();
                EReference reference = acr instanceof ActorRef ? RoomPackage.eINSTANCE.getActorRef_Type() : RoomPackage.eINSTANCE.getSubSystemRef_Type();
                IScope scope = scopeProvider.getScope(acr.eContainer().eContainer(), reference);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ActorContainerRefPropertyDialog dlg = new ActorContainerRefPropertyDialog(shell, acr, scope, sc, false);
                if (dlg.open() != 0) {
                    return;
                }
                this.doneChanges = true;
                EObject parent = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape.getContainer());
                boolean inherited = FeatureProvider.isInherited(acr, parent);
                Color lineColor = this.manageColor(inherited ? INHERITED_COLOR : LINE_COLOR);
                ActorContainerRefSupport.createRefFigure(acr, this.getDiagram(), containerShape, (Rectangle)containerShape.getGraphicsAlgorithm(), lineColor, this.manageColor(BACKGROUND));
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class ResizeFeature
        extends DefaultResizeShapeFeature {
            public ResizeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canResizeShape(IResizeShapeContext context) {
                if (!super.canResizeShape(context)) {
                    return false;
                }
                int width = context.getWidth() - 30;
                int height = context.getHeight() - 30;
                return width <= 0 || height <= 0 || width >= 130 && height >= 90;
            }

            public void resizeShape(IResizeShapeContext context) {
                GraphicsAlgorithm containerGa;
                Shape shape = context.getShape();
                if (shape.getGraphicsAlgorithm() != null && (containerGa = shape.getGraphicsAlgorithm()).getGraphicsAlgorithmChildren().size() == 1) {
                    GraphicsAlgorithm ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    double sx = (double)(context.getWidth() - 60) / (double)ga.getWidth();
                    double sy = (double)(context.getHeight() - 60) / (double)ga.getHeight();
                    for (Shape childShape : ((ContainerShape)context.getShape()).getChildren()) {
                        Object childBo = this.getBusinessObjectForPictogramElement((PictogramElement)childShape);
                        if (!(childBo instanceof InterfaceItem)) continue;
                        ga = childShape.getGraphicsAlgorithm();
                        ga.setX((int)((double)ga.getX() * sx));
                        ga.setY((int)((double)ga.getY() * sy));
                    }
                }
                super.resizeShape(context);
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                return bo instanceof ActorContainerRef;
            }

            public IReason updateNeeded(IUpdateContext context) {
                GraphicsAlgorithm ga;
                GraphicsAlgorithm borderRect;
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"Ref deleted from model");
                }
                ActorContainerRef acr = (ActorContainerRef)bo;
                String reason = "";
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof ActorClass) {
                    ActorClass ac = (ActorClass)bo;
                    boolean found = false;
                    do {
                        if (ac == acr.eContainer()) {
                            found = true;
                        }
                        ac = ac.getBase();
                    } while (!found && ac != null);
                    if (!found) {
                        reason = String.valueOf(reason) + "Ref not inherited anymore\n";
                    }
                }
                boolean hasSubStruct = ActorContainerRefSupport.hasSubStructure(acr);
                GraphicsAlgorithm invisibleRect = containerShape.getGraphicsAlgorithm();
                if (!invisibleRect.getGraphicsAlgorithmChildren().isEmpty() && !(borderRect = (GraphicsAlgorithm)invisibleRect.getGraphicsAlgorithmChildren().get(0)).getGraphicsAlgorithmChildren().isEmpty()) {
                    GraphicsAlgorithm hint = (GraphicsAlgorithm)borderRect.getGraphicsAlgorithmChildren().get(0);
                    if (hasSubStruct && !hint.getLineVisible().booleanValue()) {
                        reason = String.valueOf(reason) + "state has sub structure now\n";
                    }
                    if (!hasSubStruct && hint.getLineVisible().booleanValue()) {
                        reason = String.valueOf(reason) + "state has no sub structure anymore\n";
                    }
                }
                if (!containerShape.getChildren().isEmpty() && (ga = ((Shape)containerShape.getChildren().get(0)).getGraphicsAlgorithm()) instanceof Text && bo instanceof ActorContainerRef) {
                    String label = RoomNameProvider.getRefLabelName((ActorContainerRef)((ActorContainerRef)bo));
                    if (!((Text)ga).getValue().equals(label)) {
                        reason = String.valueOf(reason) + "Class name is out of date\n";
                    }
                }
                ActorClass acc = acr instanceof ActorRef ? ((ActorRef)acr).getType() : ((SubSystemRef)acr).getType();
                List interfaceItems = RoomHelpers.getInterfaceItems((StructureClass)acc, (boolean)true);
                List<InterfaceItem> presentItems = SupportUtil.getInterfaceItems(containerShape, FeatureProvider.this.fp);
                int missing = 0;
                for (InterfaceItem interfaceItem : interfaceItems) {
                    if (presentItems.contains(interfaceItem)) continue;
                    ++missing;
                }
                if (missing > 0) {
                    reason = String.valueOf(reason) + missing + " interface item(s) missing\n";
                }
                if (!reason.isEmpty()) {
                    return Reason.createTrueReason((String)reason.substring(0, reason.length() - 1));
                }
                return Reason.createFalseReason();
            }

            public boolean update(IUpdateContext context) {
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext((PictogramElement)containerShape);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                ActorContainerRef acr = (ActorContainerRef)bo;
                GraphicsAlgorithm invisibleRect = containerShape.getGraphicsAlgorithm();
                if (!invisibleRect.getGraphicsAlgorithmChildren().isEmpty()) {
                    GraphicsAlgorithm borderRect = (GraphicsAlgorithm)invisibleRect.getGraphicsAlgorithmChildren().get(0);
                    FeatureProvider.updateSubStructureHint(acr, (GraphicsAlgorithm)((Rectangle)borderRect));
                }
                FeatureProvider.updateLabel(acr, context.getPictogramElement());
                InterfaceItemSupport.createRefItems(acr, containerShape, FeatureProvider.this.fp);
                return true;
            }
        }
    }
}

