/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.etrice.abstractexec.behavior.Activator;
import org.eclipse.etrice.abstractexec.behavior.HandledMessage;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InSemanticsRule;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.SemanticsRule;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class ActiveRules {
    private HashMap<InterfaceItem, List<SemanticsRule>> rules;
    private static boolean traceRules = false;
    private static int traceLevel = 0;
    private static final int TRACE_DETAILS = 2;

    static {
        if (Activator.getDefault().isDebugging()) {
            String value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/rules");
            if (value != null && value.equalsIgnoreCase(Boolean.toString(true))) {
                traceRules = true;
            }
            if ((value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/rules/level")) != null) {
                traceLevel = Integer.parseInt(value);
            }
        }
    }

    public ActiveRules() {
        this.rules = new HashMap();
    }

    private ActiveRules(HashMap<InterfaceItem, List<SemanticsRule>> r) {
        this.rules = r;
    }

    public Set<InterfaceItem> getPortList() {
        return this.rules.keySet();
    }

    public List<SemanticsRule> getRulesForPort(InterfaceItem port) {
        return this.rules.get(port);
    }

    public List<HandledMessage> consumeMessages(List<HandledMessage> msgList) {
        ArrayList<HandledMessage> wrongMsgList = new ArrayList<HandledMessage>();
        for (HandledMessage msg : msgList) {
            List<SemanticsRule> localRules = this.rules.get(msg.getIfitem());
            if (localRules == null) continue;
            SemanticsRule match = null;
            for (SemanticsRule rule : localRules) {
                if (rule.getMsg() != msg.getMsg()) continue;
                match = rule;
                break;
            }
            if (match != null) {
                if (traceRules && traceLevel >= 2) {
                    System.out.println("  found match for " + msg.getMsg().getName());
                }
                localRules.clear();
                localRules.addAll((Collection<SemanticsRule>)match.getFollowUps());
                continue;
            }
            wrongMsgList.add(msg);
        }
        return wrongMsgList;
    }

    public boolean merge(ActiveRules ar) {
        boolean added_at_least_one = false;
        for (Map.Entry<InterfaceItem, List<SemanticsRule>> entry : ar.rules.entrySet()) {
            for (SemanticsRule rule : entry.getValue()) {
                InterfaceItem ifitem = entry.getKey();
                if (this.rules.containsKey(ifitem)) {
                    if (this.rules.get(ifitem).contains(rule)) continue;
                    this.rules.get(ifitem).add(rule);
                    added_at_least_one = true;
                    continue;
                }
                ArrayList<SemanticsRule> tempList = new ArrayList<SemanticsRule>();
                tempList.add(rule);
                this.rules.put(ifitem, tempList);
                added_at_least_one = true;
            }
        }
        if (traceRules && traceLevel >= 2) {
            System.out.println("  merge changed rules");
        }
        return added_at_least_one;
    }

    public ActiveRules createCopy() {
        HashMap<InterfaceItem, List<SemanticsRule>> newRules = new HashMap<InterfaceItem, List<SemanticsRule>>();
        for (InterfaceItem ifitem : this.rules.keySet()) {
            newRules.put(ifitem, new ArrayList(this.rules.get(ifitem)));
        }
        return new ActiveRules(newRules);
    }

    public void buildInitLocalRules(ExpandedActorClass xpAct) {
        List portList = RoomHelpers.getAllInterfaceItems((ActorClass)xpAct.getActorClass());
        for (InterfaceItem ifitem : portList) {
            ProtocolClass pc;
            GeneralProtocolClass gpc = ifitem.getGeneralProtocol();
            if (!(gpc instanceof ProtocolClass) || (pc = (ProtocolClass)gpc).getSemantics() == null) continue;
            this.rules.put(ifitem, new ArrayList(pc.getSemantics().getRules()));
        }
    }

    public void print() {
        for (InterfaceItem port : this.rules.keySet()) {
            System.out.println("      Rules for Port " + port.getName() + ":");
            for (SemanticsRule rule : this.rules.get(port)) {
                this.printRule(rule, "        ");
            }
        }
    }

    public void printRule(SemanticsRule rule, String indent) {
        if (rule instanceof InSemanticsRule) {
            System.out.println(String.valueOf(indent) + "in: " + rule.getMsg().getName());
        } else {
            System.out.println(String.valueOf(indent) + "out: " + rule.getMsg().getName());
        }
        for (SemanticsRule sr : rule.getFollowUps()) {
            this.printRule(sr, String.valueOf(indent) + "  ");
        }
    }
}

