/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.etricegen.ActiveTrigger;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.room.EntryPoint;
import org.eclipse.etrice.core.room.GuardedTransition;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateGraphNode;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionPoint;
import org.eclipse.etrice.core.room.TransitionTerminal;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;

public class ReachabilityCheck {
    private static RoomExtensions roomExt;
    Queue<StateGraphNode> queue;
    public Set<StateGraphItem> visited;
    private Set<State> visitedSubStates;
    private ExpandedActorClass xpAct;

    public ReachabilityCheck(ExpandedActorClass xpac) {
        roomExt = new RoomExtensions();
        this.queue = new LinkedList<StateGraphNode>();
        this.xpAct = xpac;
        this.visited = new HashSet<StateGraphItem>();
        this.visitedSubStates = new HashSet<State>();
    }

    public void computeReachability() {
        StateGraph graph = this.xpAct.getStateMachine();
        this.addStartingPoints(graph, true);
        this.doTraversal();
        this.visited.addAll(this.visitedSubStates);
    }

    private void addStartingPoints(StateGraph graph, boolean add_initial) {
        EList transitions = graph.getTransitions();
        EList trPoint = graph.getTrPoints();
        if (add_initial) {
            for (Transition trans : transitions) {
                if (!(trans instanceof InitialTransition)) continue;
                this.visited.add((StateGraphItem)trans);
                StateGraphNode cur = RoomHelpers.getNode((TransitionTerminal)trans.getTo());
                if (this.visited.contains(cur)) break;
                this.queue.add(cur);
                break;
            }
        }
        for (TrPoint tp : trPoint) {
            if (!(tp instanceof TransitionPoint) || this.visited.contains(tp)) continue;
            this.queue.add((StateGraphNode)tp);
        }
    }

    private void doTraversal() {
        while (!this.queue.isEmpty()) {
            StateGraphNode node = this.queue.poll();
            if (this.visited.contains(node)) continue;
            this.visit(node);
        }
    }

    public boolean isReachable(StateGraphItem item) {
        return this.visited.contains(item);
    }

    private void visit(StateGraphNode node) {
        this.visited.add((StateGraphItem)node);
        if (node instanceof State) {
            State st = (State)node;
            if (RoomHelpers.hasDirectSubStructure((State)st)) {
                this.addStartingPoints(st.getSubgraph(), true);
            } else {
                for (ActiveTrigger trigger : this.xpAct.getActiveTriggers(st)) {
                    for (TriggeredTransition trans : trigger.getTransitions()) {
                        this.visit((Transition)trans);
                    }
                }
                for (Transition trans : roomExt.getOutgoingTransitionsHierarchical(this.xpAct, st)) {
                    if (!(trans instanceof GuardedTransition)) continue;
                    this.visit(trans);
                }
            }
        } else {
            if (node instanceof EntryPoint) {
                State container = (State)node.eContainer().eContainer();
                this.visitedSubStates.add(container);
            }
            for (Transition trans : this.xpAct.getOutgoingTransitions(node)) {
                this.visit(trans);
            }
        }
    }

    private void visit(Transition trans) {
        this.visited.add((StateGraphItem)trans);
        StateGraphNode target = RoomHelpers.getNode((TransitionTerminal)trans.getTo());
        if (!this.visited.contains(target)) {
            this.queue.add(target);
        }
    }
}

