/**
 * Copyright (c) 2012 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Juergen Haug (initial contribution)
 */
package org.eclipse.etrice.core.postprocessing;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.postprocessing.PostprocessingHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.GeneratedMetamodel;

@SuppressWarnings("all")
public class DocuPostprocessor {
  public void process(final GeneratedMetamodel metamodel) {
    final EPackage pckg = metamodel.getEPackage();
    EClass cls = PostprocessingHelpers.getClass(pckg, "ConfigModel");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("The root object for the ROOM Config model. It gives access to");
    _builder.newLine();
    _builder.append("the {@link SubSystemConfig sub system class},");
    _builder.newLine();
    _builder.append("{@link ActorClassConfig actor class}, {@link ProtocolClassConfig protocol class} and");
    _builder.newLine();
    _builder.append("{@link ActorInstanceConfig actor instance} configurations and the room model {@link Import imports}.");
    _builder.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder.toString());
    EAttribute _attribute = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("The model name is a dot separated fully qualified name and is");
    _builder_1.newLine();
    _builder_1.append("used to provide a name space.");
    _builder_1.newLine();
    PostprocessingHelpers.setDocumentation(_attribute, _builder_1.toString());
    EReference _reference = PostprocessingHelpers.getReference(cls, "imports");
    StringConcatenation _builder_2 = new StringConcatenation();
    _builder_2.append("This is a list of all imported room models. The config elements reference these imports.");
    _builder_2.newLine();
    PostprocessingHelpers.setDocumentation(_reference, _builder_2.toString());
    EReference _reference_1 = PostprocessingHelpers.getReference(cls, "configElements");
    StringConcatenation _builder_3 = new StringConcatenation();
    _builder_3.append("This is a list of all top level config elements");
    _builder_3.newLine();
    PostprocessingHelpers.setDocumentation(_reference_1, _builder_3.toString());
    EClass _class = PostprocessingHelpers.getClass(pckg, "ConfigElement");
    cls = _class;
    StringConcatenation _builder_4 = new StringConcatenation();
    _builder_4.append("This is the super class of the top level config elements");
    _builder_4.newLine();
    _builder_4.append("<ul>");
    _builder_4.newLine();
    _builder_4.append("\t");
    _builder_4.append("<li>{@link SubSystemConfig}</li>");
    _builder_4.newLine();
    _builder_4.append("\t");
    _builder_4.append("<li>{@link ActorClassConfig}</li>");
    _builder_4.newLine();
    _builder_4.append("\t");
    _builder_4.append("<li>{@link ActorInstanceConfig}</li>");
    _builder_4.newLine();
    _builder_4.append("\t");
    _builder_4.append("<li>{@link ProtocolClassConfig}</li>");
    _builder_4.newLine();
    _builder_4.append("</ul>");
    _builder_4.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_4.toString());
    EClass _class_1 = PostprocessingHelpers.getClass(pckg, "SubSystemConfig");
    cls = _class_1;
    StringConcatenation _builder_5 = new StringConcatenation();
    _builder_5.append("This class defines settings with a sub system scope.");
    _builder_5.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_5.toString());
    EReference _reference_2 = PostprocessingHelpers.getReference(cls, "root");
    StringConcatenation _builder_6 = new StringConcatenation();
    _builder_6.append("This is the logical system that contains the {@link #org.eclipse.etrice.core.room.SubSystemRef sub system reference}.");
    _builder_6.newLine();
    PostprocessingHelpers.setDocumentation(_reference_2, _builder_6.toString());
    EReference _reference_3 = PostprocessingHelpers.getReference(cls, "subSystem");
    StringConcatenation _builder_7 = new StringConcatenation();
    _builder_7.append("This is the sub system reference.");
    _builder_7.newLine();
    PostprocessingHelpers.setDocumentation(_reference_3, _builder_7.toString());
    EReference _reference_4 = PostprocessingHelpers.getReference(cls, "dynConfig");
    StringConcatenation _builder_8 = new StringConcatenation();
    _builder_8.append("This is the dynamic configuration. It is available within the {@link #getSubSystem sub system}.");
    _builder_8.newLine();
    PostprocessingHelpers.setDocumentation(_reference_4, _builder_8.toString());
    EClass _class_2 = PostprocessingHelpers.getClass(pckg, "DynamicConfig");
    cls = _class_2;
    StringConcatenation _builder_9 = new StringConcatenation();
    _builder_9.append("The dynamic configuration provides a configuration at runtime.");
    _builder_9.newLine();
    _builder_9.append("The source of the configuration is abstracted by an interface.");
    _builder_9.newLine();
    _builder_9.append("<br>");
    _builder_9.newLine();
    _builder_9.append("This feature is experimental and implemented for target language java only.");
    _builder_9.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_9.toString());
    EAttribute _attribute_1 = PostprocessingHelpers.getAttribute(cls, "filePath");
    StringConcatenation _builder_10 = new StringConcatenation();
    _builder_10.append("This is the file path of the configuration. In this case the source of the configuration is a simple file.");
    _builder_10.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_1, _builder_10.toString());
    EAttribute _attribute_2 = PostprocessingHelpers.getAttribute(cls, "userCode1");
    StringConcatenation _builder_11 = new StringConcatenation();
    _builder_11.append("Defines the import statement for the implemenation of the configuration source.");
    _builder_11.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_2, _builder_11.toString());
    EAttribute _attribute_3 = PostprocessingHelpers.getAttribute(cls, "userCode2");
    StringConcatenation _builder_12 = new StringConcatenation();
    _builder_12.append("This is the constructor statement for the implemenation of the configuration source.");
    _builder_12.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_3, _builder_12.toString());
    EAttribute _attribute_4 = PostprocessingHelpers.getAttribute(cls, "polling");
    StringConcatenation _builder_13 = new StringConcatenation();
    _builder_13.append("Defines the time interval in milliseconds to query changes from the configuration source.");
    _builder_13.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_4, _builder_13.toString());
    EClass _class_3 = PostprocessingHelpers.getClass(pckg, "ActorClassConfig");
    cls = _class_3;
    StringConcatenation _builder_14 = new StringConcatenation();
    _builder_14.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.ActorClass actor class}.");
    _builder_14.newLine();
    _builder_14.append("The configuration defines the default values for all instances of the {@link #getActor actor}.");
    _builder_14.newLine();
    _builder_14.append("The values are applied at generation time.");
    _builder_14.newLine();
    _builder_14.append("The config sub elements are:");
    _builder_14.newLine();
    _builder_14.append("<ul>");
    _builder_14.newLine();
    _builder_14.append("\t");
    _builder_14.append("<li>{@link AttrClassConfig attribute class config}</li>");
    _builder_14.newLine();
    _builder_14.append("</ul>\t\t\t\t");
    _builder_14.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_14.toString());
    EReference _reference_5 = PostprocessingHelpers.getReference(cls, "actor");
    StringConcatenation _builder_15 = new StringConcatenation();
    _builder_15.append("This is the actor class.");
    _builder_15.newLine();
    PostprocessingHelpers.setDocumentation(_reference_5, _builder_15.toString());
    EReference _reference_6 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_16 = new StringConcatenation();
    _builder_16.append("This is a list of all attribute configurations.");
    _builder_16.newLine();
    PostprocessingHelpers.setDocumentation(_reference_6, _builder_16.toString());
    EClass _class_4 = PostprocessingHelpers.getClass(pckg, "ProtocolClassConfig");
    cls = _class_4;
    StringConcatenation _builder_17 = new StringConcatenation();
    _builder_17.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.ProtocolClass protocol class}.");
    _builder_17.newLine();
    _builder_17.append("The config sub elements are:");
    _builder_17.newLine();
    _builder_17.append("<ul>");
    _builder_17.newLine();
    _builder_17.append("\t");
    _builder_17.append("<li>a {@link PortClassConfig port class config} for the regular port class</li>");
    _builder_17.newLine();
    _builder_17.append("\t");
    _builder_17.append("<li>a {@link PortClassConfig port class config} for the conjugate port class</li>");
    _builder_17.newLine();
    _builder_17.append("</ul>");
    _builder_17.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_17.toString());
    EReference _reference_7 = PostprocessingHelpers.getReference(cls, "protocol");
    StringConcatenation _builder_18 = new StringConcatenation();
    _builder_18.append("This is the protocol class.");
    _builder_18.newLine();
    PostprocessingHelpers.setDocumentation(_reference_7, _builder_18.toString());
    EReference _reference_8 = PostprocessingHelpers.getReference(cls, "regular");
    StringConcatenation _builder_19 = new StringConcatenation();
    _builder_19.append("This is the configuration for the regular part of the protocol.");
    _builder_19.newLine();
    PostprocessingHelpers.setDocumentation(_reference_8, _builder_19.toString());
    EReference _reference_9 = PostprocessingHelpers.getReference(cls, "conjugated");
    StringConcatenation _builder_20 = new StringConcatenation();
    _builder_20.append("This is the configuration for the conjugated part of the protocol.");
    _builder_20.newLine();
    PostprocessingHelpers.setDocumentation(_reference_9, _builder_20.toString());
    EClass _class_5 = PostprocessingHelpers.getClass(pckg, "PortClassConfig");
    cls = _class_5;
    StringConcatenation _builder_21 = new StringConcatenation();
    _builder_21.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.PortClass port class}.");
    _builder_21.newLine();
    _builder_21.append("The configuration defines the default values for all instances of the port.");
    _builder_21.newLine();
    _builder_21.append("The values are applied at generation time.");
    _builder_21.newLine();
    _builder_21.append("The config sub elements are:");
    _builder_21.newLine();
    _builder_21.append("<ul>");
    _builder_21.newLine();
    _builder_21.append("\t");
    _builder_21.append("<li>{@link AttrClassConfig attribute class config}</li>");
    _builder_21.newLine();
    _builder_21.append("</ul>");
    _builder_21.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_21.toString());
    EReference _reference_10 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_22 = new StringConcatenation();
    _builder_22.append("This is a list of all attribute configurations.");
    _builder_22.newLine();
    PostprocessingHelpers.setDocumentation(_reference_10, _builder_22.toString());
    EClass _class_6 = PostprocessingHelpers.getClass(pckg, "ActorInstanceConfig");
    cls = _class_6;
    StringConcatenation _builder_23 = new StringConcatenation();
    _builder_23.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.ActorRef actor instance}.");
    _builder_23.newLine();
    _builder_23.append("The configuration defines values for this actor instance and overrides the default values from the corresponding class config.");
    _builder_23.newLine();
    _builder_23.append("The values are applied at generation time.");
    _builder_23.newLine();
    _builder_23.append("The config sub elements are:");
    _builder_23.newLine();
    _builder_23.append("<ul>");
    _builder_23.newLine();
    _builder_23.append("\t");
    _builder_23.append("<li>{@link AttrInstanceConfig attribute instance config}</li>");
    _builder_23.newLine();
    _builder_23.append("</ul>\t\t\t\t");
    _builder_23.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_23.toString());
    EReference _reference_11 = PostprocessingHelpers.getReference(cls, "root");
    StringConcatenation _builder_24 = new StringConcatenation();
    _builder_24.append("This is the logical system that contains the {@link #getSubSystem sub system}.");
    _builder_24.newLine();
    PostprocessingHelpers.setDocumentation(_reference_11, _builder_24.toString());
    EReference _reference_12 = PostprocessingHelpers.getReference(cls, "subSystem");
    StringConcatenation _builder_25 = new StringConcatenation();
    _builder_25.append("This is the sub system that contains the {@link #getRefPath actor instance}.");
    _builder_25.newLine();
    PostprocessingHelpers.setDocumentation(_reference_12, _builder_25.toString());
    EReference _reference_13 = PostprocessingHelpers.getReference(cls, "path");
    StringConcatenation _builder_26 = new StringConcatenation();
    _builder_26.append("This is the path of the actor instance relative to the {@link #getSubSystem sub system}.");
    _builder_26.newLine();
    PostprocessingHelpers.setDocumentation(_reference_13, _builder_26.toString());
    EReference _reference_14 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_27 = new StringConcatenation();
    _builder_27.append("This is a list of all attribute configurations.");
    _builder_27.newLine();
    PostprocessingHelpers.setDocumentation(_reference_14, _builder_27.toString());
    EReference _reference_15 = PostprocessingHelpers.getReference(cls, "ports");
    StringConcatenation _builder_28 = new StringConcatenation();
    _builder_28.append("This is a list of all port configurations.");
    _builder_28.newLine();
    PostprocessingHelpers.setDocumentation(_reference_15, _builder_28.toString());
    EClass _class_7 = PostprocessingHelpers.getClass(pckg, "PortInstanceConfig");
    cls = _class_7;
    StringConcatenation _builder_29 = new StringConcatenation();
    _builder_29.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.InterfaceItem interface item} (e.g. port instance).");
    _builder_29.newLine();
    _builder_29.append("The configuration defines values for this interface item and overrides the default values from the corresponding class config.");
    _builder_29.newLine();
    _builder_29.append("The values are applied at generation time.");
    _builder_29.newLine();
    _builder_29.append("The config sub elements are:");
    _builder_29.newLine();
    _builder_29.append("<ul>");
    _builder_29.newLine();
    _builder_29.append("\t");
    _builder_29.append("<li>{@link AttrInstanceConfig attribute instance config}</li>");
    _builder_29.newLine();
    _builder_29.append("</ul>\t\t\t\t");
    _builder_29.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_29.toString());
    EReference _reference_16 = PostprocessingHelpers.getReference(cls, "item");
    StringConcatenation _builder_30 = new StringConcatenation();
    _builder_30.append("This is the interface item.");
    _builder_30.newLine();
    PostprocessingHelpers.setDocumentation(_reference_16, _builder_30.toString());
    EReference _reference_17 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_31 = new StringConcatenation();
    _builder_31.append("This is a list of all attribute configurations.");
    _builder_31.newLine();
    PostprocessingHelpers.setDocumentation(_reference_17, _builder_31.toString());
    EClass _class_8 = PostprocessingHelpers.getClass(pckg, "AttrConfig");
    cls = _class_8;
    StringConcatenation _builder_32 = new StringConcatenation();
    _builder_32.append("It is the super class of");
    _builder_32.newLine();
    _builder_32.append("<ul>");
    _builder_32.newLine();
    _builder_32.append("\t");
    _builder_32.append("<li>{@link AttrClassConfig}</li>");
    _builder_32.newLine();
    _builder_32.append("\t");
    _builder_32.append("<li>{@link AttrInstanceConfig}</li>");
    _builder_32.newLine();
    _builder_32.append("</ul>\t\t\t\t");
    _builder_32.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_32.toString());
    EReference _reference_18 = PostprocessingHelpers.getReference(cls, "attribute");
    StringConcatenation _builder_33 = new StringConcatenation();
    _builder_33.append("This is the attribute.");
    _builder_33.newLine();
    PostprocessingHelpers.setDocumentation(_reference_18, _builder_33.toString());
    EReference _reference_19 = PostprocessingHelpers.getReference(cls, "value");
    StringConcatenation _builder_34 = new StringConcatenation();
    _builder_34.append("This is the value of {@link #getAttribute attribute}.");
    _builder_34.newLine();
    PostprocessingHelpers.setDocumentation(_reference_19, _builder_34.toString());
    EClass _class_9 = PostprocessingHelpers.getClass(pckg, "AttrClassConfig");
    cls = _class_9;
    StringConcatenation _builder_35 = new StringConcatenation();
    _builder_35.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.Attribute attribute}.");
    _builder_35.newLine();
    _builder_35.append("The configuration defines a default value for all instances of the attribute.");
    _builder_35.newLine();
    _builder_35.append("The values are applied at generation time.");
    _builder_35.newLine();
    _builder_35.append("<br>If the type of the given {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} is");
    _builder_35.newLine();
    _builder_35.append("<ul>");
    _builder_35.newLine();
    _builder_35.append("\t");
    _builder_35.append("<li>primitive, then a {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} might exist and {@link #getAttributes attributes} is empty</li>");
    _builder_35.newLine();
    _builder_35.append("\t");
    _builder_35.append("<li>compound attribute (e.g. {@link org.eclipse.etrice.core.room.DataClass data class}), then {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} is null and configurations for children {@link #getAttributes attributes} might exist</li>");
    _builder_35.newLine();
    _builder_35.append("</ul>\t\t\t\t");
    _builder_35.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_35.toString());
    EReference _reference_20 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_36 = new StringConcatenation();
    _builder_36.append("This is a list of attribute configurations of children attributes, in case the {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} is compound.");
    _builder_36.newLine();
    PostprocessingHelpers.setDocumentation(_reference_20, _builder_36.toString());
    EReference _reference_21 = PostprocessingHelpers.getReference(cls, "min");
    StringConcatenation _builder_37 = new StringConcatenation();
    _builder_37.append("This is the lower bound of {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} , in case the {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} has a numerical value.");
    _builder_37.newLine();
    PostprocessingHelpers.setDocumentation(_reference_21, _builder_37.toString());
    EReference _reference_22 = PostprocessingHelpers.getReference(cls, "max");
    StringConcatenation _builder_38 = new StringConcatenation();
    _builder_38.append("This is the upper bound of {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} , in case the {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} has a numerical value.");
    _builder_38.newLine();
    PostprocessingHelpers.setDocumentation(_reference_22, _builder_38.toString());
    EClass _class_10 = PostprocessingHelpers.getClass(pckg, "AttrInstanceConfig");
    cls = _class_10;
    StringConcatenation _builder_39 = new StringConcatenation();
    _builder_39.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.Attribute attribute}.");
    _builder_39.newLine();
    _builder_39.append("The configuration defines values for this attribute instance and overrides the default values from the corresponding class config.");
    _builder_39.newLine();
    _builder_39.append("The values are applied at generation time.");
    _builder_39.newLine();
    _builder_39.append("<br>If the type of the given {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} is");
    _builder_39.newLine();
    _builder_39.append("<ul>");
    _builder_39.newLine();
    _builder_39.append("\t");
    _builder_39.append("<li>primitive, then a {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} might exist and {@link #getAttributes attributes} is empty</li>");
    _builder_39.newLine();
    _builder_39.append("\t");
    _builder_39.append("<li>compound attribute (e.g. {@link org.eclipse.etrice.core.room.DataClass data class}), then {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} is null and configurations for children {@link #getAttributes attributes} might exist</li>");
    _builder_39.newLine();
    _builder_39.append("</ul>\t\t\t\t");
    _builder_39.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_39.toString());
    EReference _reference_23 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_40 = new StringConcatenation();
    _builder_40.append("This is a list of attribute configurations of children attributes, in case the {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} is compound.");
    _builder_40.newLine();
    PostprocessingHelpers.setDocumentation(_reference_23, _builder_40.toString());
    EAttribute _attribute_5 = PostprocessingHelpers.getAttribute(cls, "dynConfig");
    StringConcatenation _builder_41 = new StringConcatenation();
    _builder_41.append("If the dynamic configuration options is activated for this attribute, then the values are set at runtime by the means of the {@link DynamicConfig dynamic config}.");
    _builder_41.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_5, _builder_41.toString());
    EAttribute _attribute_6 = PostprocessingHelpers.getAttribute(cls, "readOnly");
    StringConcatenation _builder_42 = new StringConcatenation();
    _builder_42.append("Controls the behavior of the dynamic configuration. If set to false, then {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} is updated (overwritten) if changes occur in the external configuration, ");
    _builder_42.newLine();
    _builder_42.append("otherwise set to true, then changes in {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} (that occur from within the system) are recorded to the external configuration.");
    _builder_42.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_6, _builder_42.toString());
    EClass _class_11 = PostprocessingHelpers.getClass(pckg, "LiteralArray");
    cls = _class_11;
    StringConcatenation _builder_43 = new StringConcatenation();
    _builder_43.append("Aggregates one or more {@link Literal literals}.\t\t");
    _builder_43.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_43.toString());
    EReference _reference_24 = PostprocessingHelpers.getReference(cls, "literals");
    StringConcatenation _builder_44 = new StringConcatenation();
    _builder_44.append("This is a list of literals.");
    _builder_44.newLine();
    PostprocessingHelpers.setDocumentation(_reference_24, _builder_44.toString());
    EClass _class_12 = PostprocessingHelpers.getClass(pckg, "Literal");
    cls = _class_12;
    StringConcatenation _builder_45 = new StringConcatenation();
    _builder_45.append("It is the super class of");
    _builder_45.newLine();
    _builder_45.append("<ul>");
    _builder_45.newLine();
    _builder_45.append("\t");
    _builder_45.append("<li>{@link BooleanLiteral}</li>");
    _builder_45.newLine();
    _builder_45.append("\t");
    _builder_45.append("<li>{@link NumberLiteral}</li>");
    _builder_45.newLine();
    _builder_45.append("\t");
    _builder_45.append("<li>{@link StringLiteral}</li>");
    _builder_45.newLine();
    _builder_45.append("</ul>");
    _builder_45.newLine();
    _builder_45.append("that represents a primitive value.");
    _builder_45.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_45.toString());
    EClass _class_13 = PostprocessingHelpers.getClass(pckg, "RefPath");
    cls = _class_13;
    StringConcatenation _builder_46 = new StringConcatenation();
    _builder_46.append("A path of strings that are interpreted as {@link org.eclipse.etrice.core.room.ActorRef}s starting at a {@link org.eclipse.etrice.core.room.SubSystemClass}.");
    _builder_46.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_46.toString());
    EAttribute _attribute_7 = PostprocessingHelpers.getAttribute(cls, "refs");
    StringConcatenation _builder_47 = new StringConcatenation();
    _builder_47.append("This is a path in the instance tree where each segment corresponds to the name of the");
    _builder_47.newLine();
    _builder_47.append("corresponding {@link ActorContainerRef}.");
    _builder_47.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_7, _builder_47.toString());
    EClass _class_14 = PostprocessingHelpers.getClass(pckg, "Import");
    cls = _class_14;
    StringConcatenation _builder_48 = new StringConcatenation();
    _builder_48.append("The import declares an imported {@link org.eclipse.etrice.core.room.RoomModel room model} (given as a URI) and");
    _builder_48.newLine();
    _builder_48.append("an optional imported namespace.");
    _builder_48.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_48.toString());
    EAttribute _attribute_8 = PostprocessingHelpers.getAttribute(cls, "importedNamespace");
    StringConcatenation _builder_49 = new StringConcatenation();
    _builder_49.append("The imported name space has to be a dot separated qualified name followed by .*.");
    _builder_49.newLine();
    _builder_49.append("Example: my.namespace.*");
    _builder_49.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_8, _builder_49.toString());
    EAttribute _attribute_9 = PostprocessingHelpers.getAttribute(cls, "importURI");
    StringConcatenation _builder_50 = new StringConcatenation();
    _builder_50.append("The import URI can be a relative or absolute file system path.");
    _builder_50.newLine();
    _builder_50.append("It may contain environment variables in ${} which will be expanded.");
    _builder_50.newLine();
    _builder_50.append("<p>");
    _builder_50.newLine();
    _builder_50.append("Examples:");
    _builder_50.newLine();
    _builder_50.append("<ul>");
    _builder_50.newLine();
    _builder_50.append("  ");
    _builder_50.append("<li>import model \"AnotherModel.room\"</li>");
    _builder_50.newLine();
    _builder_50.append("  ");
    _builder_50.append("<li>import my.namespace.* from \"AnotherModel.room\"</li>");
    _builder_50.newLine();
    _builder_50.append("  ");
    _builder_50.append("<li>import my.namespace.* from \"../../AnotherProject/models/AnotherModel.room\"</li>");
    _builder_50.newLine();
    _builder_50.append("  ");
    _builder_50.append("<li>import my.namespace.* from \"/${ROOM_MODELS}/SomeModel.room\"</li>");
    _builder_50.newLine();
    _builder_50.append("</ul>");
    _builder_50.newLine();
    _builder_50.append("</p>");
    _builder_50.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_9, _builder_50.toString());
  }
}
