/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.etmap.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.etmap.eTMap.Mapping;
import org.eclipse.etrice.core.etmap.eTMap.MappingModel;
import org.eclipse.etrice.core.etmap.eTMap.SubSystemMapping;
import org.eclipse.etrice.core.etmap.eTMap.ThreadMapping;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.room.ActorInstanceMapping;
import org.eclipse.etrice.core.room.LogicalThread;
import org.eclipse.etrice.core.room.RefPath;
import org.eclipse.etrice.core.room.SubSystemClass;

public class ETMapUtil {
    private static PathToPThread path2pthread = new PathToPThread();
    private static PathToNodeRef path2ndref = new PathToNodeRef();
    private static NodeRefToSubSysInstances ndref2ssipaths = new NodeRefToSubSysInstances();
    private static HashSet<NodeRef> noderefs = new HashSet();

    public static Collection<NodeRef> getNodeRefs() {
        return noderefs;
    }

    public static List<String> getSubSystemInstancePaths(NodeRef nr) {
        return (List)ndref2ssipaths.get(nr);
    }

    public static NodeRef getNodeRef(StructureInstance si) {
        String path = si.getPath();
        NodeRef nodeRef = (NodeRef)path2ndref.get(path);
        return nodeRef;
    }

    public static PhysicalThread getPhysicalThread(ActorInstance ai) {
        String path = ai.getPath();
        PhysicalThread thread = (PhysicalThread)path2pthread.get(path);
        return thread;
    }

    public static String dumpMappings() {
        StringBuilder result = new StringBuilder();
        ArrayList keys = new ArrayList(path2pthread.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            NodeRef node = (NodeRef)path2ndref.get(key);
            result.append("\n" + key + "\t -> " + node.getName() + ":" + ((PhysicalThread)path2pthread.get(key)).getName());
        }
        return result.toString();
    }

    public static void processModels(Root genmodel, ResourceSet rs, IDiagnostician diagnostician) {
        path2pthread.clear();
        path2ndref.clear();
        ndref2ssipaths.clear();
        noderefs.clear();
        for (Resource res : rs.getResources()) {
            if (res.getContents().isEmpty() || !(res.getContents().get(0) instanceof MappingModel)) continue;
            ETMapUtil.processMappings(genmodel, (MappingModel)res.getContents().get(0));
        }
        for (Map.Entry p2t : path2pthread.entrySet()) {
            String path = (String)p2t.getKey();
            StructureInstance si = genmodel.getInstance(path);
            if (!(si instanceof ActorInstance)) continue;
            switch (((ActorInstance)si).getActorClass().getCommType()) {
                case EVENT_DRIVEN: {
                    if (((PhysicalThread)p2t.getValue()).getExecmode() != ExecMode.POLLED) break;
                    ETMapUtil.error(diagnostician, path, "event driven", (PhysicalThread)p2t.getValue(), "polled thread");
                    break;
                }
                case DATA_DRIVEN: {
                    if (((PhysicalThread)p2t.getValue()).getExecmode() != ExecMode.BLOCKED) break;
                    ETMapUtil.error(diagnostician, path, "data driven", (PhysicalThread)p2t.getValue(), "blocked thread");
                    break;
                }
                case ASYNCHRONOUS: {
                    if (((PhysicalThread)p2t.getValue()).getExecmode() == ExecMode.BLOCKED) {
                        ETMapUtil.error(diagnostician, path, "asynchronous", (PhysicalThread)p2t.getValue(), "blocked thread");
                        break;
                    }
                    if (((PhysicalThread)p2t.getValue()).getExecmode() != ExecMode.POLLED) break;
                    ETMapUtil.error(diagnostician, path, "asynchronous", (PhysicalThread)p2t.getValue(), "polled thread");
                    break;
                }
            }
        }
    }

    private static void error(IDiagnostician diagnostician, String inst, String inst_comm_type, PhysicalThread thread, String thread_comm_type) {
        NodeRef nr = (NodeRef)path2ndref.get(inst);
        diagnostician.error(String.valueOf(inst_comm_type) + " actor instance '" + inst + "' mapped to " + thread_comm_type + " '" + thread.getName() + "' of node '" + nr.getName() + "'", null, null);
    }

    private static void processMappings(Root genmodel, MappingModel mdl) {
        for (Mapping mp : mdl.getMappings()) {
            for (SubSystemMapping ssmp : mp.getSubsysMappings()) {
                String path = String.valueOf('/') + mp.getLogicalSys().getName() + '/' + ssmp.getLogicalSubSys().getName();
                path2ndref.put(path, ssmp.getNode());
                ndref2ssipaths.put(ssmp.getNode(), path);
                noderefs.add(ssmp.getNode());
                LThreadToPThread lthread2pthread = new LThreadToPThread();
                for (ThreadMapping tmp : ssmp.getThreadMappings()) {
                    lthread2pthread.put(tmp.getLogicalThread(), tmp.getPhysicalThread());
                }
                SubSystemClass subsys = ssmp.getLogicalSubSys().getType();
                ETMapUtil.createThreadMappings((EList<ActorInstanceMapping>)subsys.getActorInstanceMappings(), path, lthread2pthread);
            }
        }
        ETMapUtil.addImplicitMappings(genmodel);
    }

    private static void createThreadMappings(EList<ActorInstanceMapping> mappings, String parentPath, LThreadToPThread lthread2pthread) {
        for (ActorInstanceMapping aim : mappings) {
            String path = String.valueOf(parentPath) + ETMapUtil.getPath(aim.getPath());
            path2pthread.put(path, (PhysicalThread)lthread2pthread.get(aim.getThread()));
            ETMapUtil.createThreadMappings((EList<ActorInstanceMapping>)aim.getActorInstanceMappings(), path, lthread2pthread);
        }
    }

    private static void addImplicitMappings(Root genmodel) {
        for (SystemInstance si : genmodel.getSystemInstances()) {
            for (SubSystemInstance ssi : si.getInstances()) {
                NodeRef node = (NodeRef)path2ndref.get(ssi.getPath());
                if (node == null) continue;
                PhysicalThread dflt = ETMapUtil.getDefaultThread(node);
                ETMapUtil.addImplicitMappings((StructureInstance)ssi, dflt, node);
            }
        }
    }

    private static void addImplicitMappings(StructureInstance si, PhysicalThread dflt, NodeRef node) {
        for (ActorInstance ai : si.getInstances()) {
            String path = ai.getPath();
            path2ndref.put(path, node);
            PhysicalThread thread = (PhysicalThread)path2pthread.get(path);
            if (thread == null) {
                thread = dflt;
                path2pthread.put(path, dflt);
            }
            ETMapUtil.addImplicitMappings((StructureInstance)ai, thread, node);
        }
    }

    private static PhysicalThread getDefaultThread(NodeRef node) {
        for (PhysicalThread thread : node.getType().getThreads()) {
            if (!thread.isDefault()) continue;
            return thread;
        }
        return null;
    }

    private static String getPath(RefPath path) {
        StringBuilder result = new StringBuilder();
        for (String ref : path.getRefs()) {
            result.append(String.valueOf('/') + ref);
        }
        return result.toString();
    }

    private static class LThreadToPThread
    extends HashMap<LogicalThread, PhysicalThread> {
        private LThreadToPThread() {
        }
    }

    private static class NodeRefToSubSysInstances
    extends HashMap<NodeRef, List<String>> {
        private NodeRefToSubSysInstances() {
        }

        @Override
        void put(NodeRef nr, String path) {
            ArrayList<String> list = (ArrayList<String>)this.get(nr);
            if (list == null) {
                list = new ArrayList<String>();
                this.put(nr, list);
            }
            list.add(path);
        }
    }

    private static class PathToNodeRef
    extends HashMap<String, NodeRef> {
        private PathToNodeRef() {
        }
    }

    private static class PathToPThread
    extends HashMap<String, PhysicalThread> {
        private PathToPThread() {
        }
    }
}

