/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.etphys.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.etrice.core.etphys.eTPhys.Import;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.RuntimeClass;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.ui.label.StylerFactory;

public class ETPhysLabelProvider
extends DefaultEObjectLabelProvider {
    private static final String KEYWORD_COLOR = "KEYWORD_COLOR";
    @Inject
    private StylerFactory stylerFactory;
    private StyledString.Styler keywordStyler = null;
    private StyledString.Styler typeStyler = null;

    @Inject
    public ETPhysLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    String text(RuntimeClass rc) {
        return String.valueOf(rc.getName()) + "(" + rc.getThreadModel().getLiteral() + ")";
    }

    StyledString text(NodeRef ref) {
        String cls = ref.getType() != null ? " : " + ref.getType().getName() : "";
        StyledString txt = new StyledString("NodeRef " + ref.getName() + cls);
        if (!cls.isEmpty()) {
            txt.setStyle(txt.length() - cls.length() + 2, cls.length() - 2, this.getTypeStyler());
        }
        return txt;
    }

    StyledString text(Import im) {
        if (im.getImportedNamespace() == null) {
            StyledString txt = new StyledString("import model " + im.getImportURI());
            txt.setStyle(0, 12, this.getKeywordStyler());
            return txt;
        }
        StyledString txt = new StyledString("import ns " + im.getImportedNamespace());
        txt.setStyle(0, 9, this.getKeywordStyler());
        return txt;
    }

    private StyledString.Styler getKeywordStyler() {
        if (this.keywordStyler == null) {
            FontDescriptor font = JFaceResources.getFontDescriptor((String)"org.eclipse.jface.textfont");
            FontDescriptor boldFont = font.setStyle(1);
            this.keywordStyler = this.stylerFactory.createStyler(boldFont, KEYWORD_COLOR, null);
        }
        return this.keywordStyler;
    }

    private StyledString.Styler getTypeStyler() {
        if (this.typeStyler == null) {
            FontDescriptor font = JFaceResources.getFontDescriptor((String)"org.eclipse.jface.textfont");
            FontDescriptor italicFont = font.setStyle(2);
            this.typeStyler = this.stylerFactory.createStyler(italicFont, null, null);
        }
        return this.typeStyler;
    }
}

