/**
 */
package org.eclipse.etrice.core.room;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Message</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * <br>A message in ROOM is part of a {@link ProtocolClass}. Messages are exchanged via {@link Port}s.
 * For event driven protocols the message is an object that is deliverd using a message
 * service of the runtime. For data driven systems only messages holding data are valid. In this
 * case the conjugate port is the one holding (and writing) the data and the regular port is
 * reading the data.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.etrice.core.room.Message#isPriv <em>Priv</em>}</li>
 *   <li>{@link org.eclipse.etrice.core.room.Message#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.etrice.core.room.Message#getData <em>Data</em>}</li>
 *   <li>{@link org.eclipse.etrice.core.room.Message#getDocu <em>Docu</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.etrice.core.room.RoomPackage#getMessage()
 * @model
 * @generated
 */
public interface Message extends EObject
{
  /**
   * Returns the value of the '<em><b>Priv</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * <br>If this flag is {@code true} then the message is treated as private for this protocol
   * and can only be sent by a PortClass.
   * 
   * <!-- end-model-doc -->
   * @return the value of the '<em>Priv</em>' attribute.
   * @see #setPriv(boolean)
   * @see org.eclipse.etrice.core.room.RoomPackage#getMessage_Priv()
   * @model
   * @generated
   */
  boolean isPriv();

  /**
   * Sets the value of the '{@link org.eclipse.etrice.core.room.Message#isPriv <em>Priv</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Priv</em>' attribute.
   * @see #isPriv()
   * @generated
   */
  void setPriv(boolean value);

  /**
   * Returns the value of the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * <br>By this name the message is referred to in the model.
   * 
   * <!-- end-model-doc -->
   * @return the value of the '<em>Name</em>' attribute.
   * @see #setName(String)
   * @see org.eclipse.etrice.core.room.RoomPackage#getMessage_Name()
   * @model
   * @generated
   */
  String getName();

  /**
   * Sets the value of the '{@link org.eclipse.etrice.core.room.Message#getName <em>Name</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Name</em>' attribute.
   * @see #getName()
   * @generated
   */
  void setName(String value);

  /**
   * Returns the value of the '<em><b>Data</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * <br>This is a reference to optional message data.
   * 
   * <!-- end-model-doc -->
   * @return the value of the '<em>Data</em>' containment reference.
   * @see #setData(VarDecl)
   * @see org.eclipse.etrice.core.room.RoomPackage#getMessage_Data()
   * @model containment="true"
   * @generated
   */
  VarDecl getData();

  /**
   * Sets the value of the '{@link org.eclipse.etrice.core.room.Message#getData <em>Data</em>}' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Data</em>' containment reference.
   * @see #getData()
   * @generated
   */
  void setData(VarDecl value);

  /**
   * Returns the value of the '<em><b>Docu</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * <br>This is an optional documentation.
   * 
   * <!-- end-model-doc -->
   * @return the value of the '<em>Docu</em>' containment reference.
   * @see #setDocu(Documentation)
   * @see org.eclipse.etrice.core.room.RoomPackage#getMessage_Docu()
   * @model containment="true"
   * @generated
   */
  Documentation getDocu();

  /**
   * Sets the value of the '{@link org.eclipse.etrice.core.room.Message#getDocu <em>Docu</em>}' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Docu</em>' containment reference.
   * @see #getDocu()
   * @generated
   */
  void setDocu(Documentation value);

} // Message
