/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.contentassist;

import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.core.room.util.RelativePathHelpers;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class ImportModelAssist {
    public static void addPaths(final AbstractContentProposalProvider provider, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, final String extension) {
        final IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getFullPath();
        Path modelPath = new Path(context.getRootModel().eResource().getURI().toPlatformString(false));
        modelPath = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)modelPath).getLocation();
        final URI modelURI = URI.createFileURI((String)modelPath.toOSString()).trimSegments(1);
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() != 1) {
                    return true;
                }
                if (proxy.getName().endsWith(extension)) {
                    IPath relModelPath = proxy.requestFullPath();
                    relModelPath = ResourcesPlugin.getWorkspace().getRoot().getFile(relModelPath).getLocation();
                    URI relURI = URI.createFileURI((String)relModelPath.toOSString());
                    String relPath = RelativePathHelpers.getRelativePath((URI)modelURI, (URI)relURI, (boolean)true);
                    if (relPath == null) {
                        relPath = "file:/" + relURI.toFileString().replaceAll("\\\\", "/");
                    }
                    IPath relWorkspacePath = proxy.requestFullPath().makeRelativeTo(rootPath);
                    String proposal = "\"" + relPath + "\"";
                    String displayString = String.valueOf(relModelPath.lastSegment()) + " - " + relWorkspacePath;
                    acceptor.accept(provider.createCompletionProposal(proposal, new StyledString(displayString), null, context));
                }
                return false;
            }
        };
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(visitor, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

