/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.linking;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.ui.editor.GlobalURIEditorOpener;

public class GlobalNonPlatformURIEditorOpener
extends GlobalURIEditorOpener {
    public IEditorPart open(URI referenceOwnerURI, EReference reference, int indexInList, boolean select) {
        URI platformURI = GlobalNonPlatformURIEditorOpener.getPlatformURI(referenceOwnerURI);
        if (platformURI != null) {
            return super.open(platformURI, reference, indexInList, select);
        }
        return this.openExternalFile(referenceOwnerURI);
    }

    public IEditorPart open(URI uri, boolean select) {
        URI platformURI = GlobalNonPlatformURIEditorOpener.getPlatformURI(uri);
        if (platformURI != null) {
            return super.open(platformURI, select);
        }
        return this.openExternalFile(uri);
    }

    public static URI getPlatformURI(URI uri) {
        if (uri.isPlatform()) {
            return uri;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocationURI(java.net.URI.create(uri.toString()));
        if (files.length != 0) {
            String pluri = files[0].toString();
            uri = URI.createPlatformResourceURI((String)pluri.substring(2), (boolean)true).appendFragment(uri.fragment());
        }
        return uri;
    }

    private IEditorPart openExternalFile(URI referenceOwnerURI) {
        URI folder = referenceOwnerURI.trimSegments(1);
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(folder.toFileString()));
        if (!(fileStore = fileStore.getFileStore((IPath)new Path(referenceOwnerURI.lastSegment()))).fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            IWorkbenchPage page = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                return IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
        return null;
    }
}

