/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.naming;

import java.util.HashMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class RoomQualifiedNameProvider
extends DefaultDeclarativeQualifiedNameProvider {
    private HashMap<RefinedState, String> rs2uuid = new HashMap();

    public QualifiedName qualifiedName(RefinedState rs) {
        String uuid = this.rs2uuid.get(rs);
        if (uuid == null) {
            uuid = EcoreUtil.generateUUID();
            this.rs2uuid.put(rs, uuid);
        }
        return this.getFullyQualifiedName(rs.eContainer()).append(uuid);
    }

    public QualifiedName qualifiedName(Message m) {
        ProtocolClass pc = (ProtocolClass)m.eContainer();
        String list = pc.getIncomingMessages().contains((Object)m) ? "in" : "out";
        return this.getFullyQualifiedName(pc).append(list).append(m.getName());
    }

    public QualifiedName qualifiedName(StateGraph sg) {
        if (sg.eContainer() instanceof State) {
            return this.getFullyQualifiedName(sg.eContainer()).append("subgraph");
        }
        if (sg.eContainer() instanceof ActorClass) {
            return this.getFullyQualifiedName(sg.eContainer()).append("sm");
        }
        assert (false) : "unexpected state graph container";
        return null;
    }

    public QualifiedName qualifiedName(PortClass pc) {
        ProtocolClass p = (ProtocolClass)pc.eContainer();
        return this.getFullyQualifiedName(p).append(p.getRegular() == pc ? "regular" : "conjugated");
    }

    public QualifiedName qualifiedName(StandardOperation op) {
        if (op.isDestructor()) {
            return this.getFullyQualifiedName(op.eContainer()).append("~" + op.getName());
        }
        return this.getFullyQualifiedName(op.eContainer()).append(op.getName());
    }
}

