/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.validation.IRoomValidator;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class ValidatorExtensionManager
extends AbstractDeclarativeValidator {
    @Check
    public void checkObject(EObject object) {
        Registry.getInstance().validate(object, this.getCheckMode(), this.getMessageAcceptor());
    }

    public void register(EValidatorRegistrar registrar) {
    }

    public static class Registry {
        private static final String PACKAGE = String.valueOf(RoomPackage.class.getPackage().getName()) + ".";
        private static final String IVALIDATOR_ID = "org.eclipse.etrice.core.room.validation";
        private static Registry instance = null;
        private HashMap<String, ArrayList<IRoomValidator>> fastClass2Ext = new HashMap();
        private HashMap<String, ArrayList<IRoomValidator>> normalClass2Ext = new HashMap();
        private HashMap<String, ArrayList<IRoomValidator>> expensiveClass2Ext = new HashMap();
        private ArrayList<ValidatorInfo> infos = new ArrayList();
        private ArrayList<ValidatorInfo> excludedInfos = new ArrayList();
        private HashSet<IRoomValidator> excluded = new HashSet();

        public static Registry getInstance() {
            if (instance == null) {
                instance = new Registry();
            }
            return instance;
        }

        public void loadValidatorExtensions() {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(IVALIDATOR_ID);
            HashMap<String, ArrayList<String>> cls2sub = new HashMap<String, ArrayList<String>>();
            for (EClassifier cls : RoomPackage.eINSTANCE.getEClassifiers()) {
                if (!(cls instanceof EClass)) continue;
                EList superTypes = ((EClass)cls).getESuperTypes();
                for (EClass sup : superTypes) {
                    this.put(sup.getName(), ((EClass)cls).getName(), cls2sub);
                }
            }
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    Object ext = e.createExecutableExtension("class");
                    if (ext instanceof IRoomValidator) {
                        HashMap<String, ArrayList<IRoomValidator>> map;
                        EClassifier cls;
                        IRoomValidator validator = (IRoomValidator)ext;
                        this.infos.add(new ValidatorInfo(validator, String.valueOf(e.getName()) + "@" + e.getNamespaceIdentifier()));
                        String mode = e.getAttribute("mode");
                        String classToCheck = e.getAttribute("classToCheck");
                        if (classToCheck.startsWith(PACKAGE)) {
                            classToCheck = classToCheck.substring(PACKAGE.length());
                        }
                        if ((cls = RoomPackage.eINSTANCE.getEClassifier(classToCheck)) instanceof EClass && (map = this.getMap(mode)) != null) {
                            this.put(map, ((EClass)cls).getName(), (IRoomValidator)ext);
                            ArrayList<String> subTypes = cls2sub.get(cls.getName());
                            if (subTypes != null) {
                                for (String type : subTypes) {
                                    this.put(map, type, (IRoomValidator)ext);
                                }
                            }
                        }
                    } else {
                        System.out.println("ValidatorExtensionManager: unexpected extension");
                    }
                }
                catch (CoreException ex) {
                    System.out.println(ex.getMessage());
                }
                ++n2;
            }
        }

        public void exclude(ValidatorInfo info) {
            this.excludedInfos.add(info);
            this.excluded.add(info.getValidator());
        }

        public void include(ValidatorInfo info) {
            this.excludedInfos.remove(info);
            this.excluded.remove(info.getValidator());
        }

        public ArrayList<ValidatorInfo> getInfos() {
            return this.infos;
        }

        public ArrayList<ValidatorInfo> getExcludedInfos() {
            return this.excludedInfos;
        }

        public void validate(EObject object, CheckMode checkMode, ValidationMessageAcceptor messageAcceptor) {
            HashSet<IRoomValidator> executed = new HashSet<IRoomValidator>(this.excluded);
            if (checkMode.shouldCheck(CheckType.FAST)) {
                this.validate(object, messageAcceptor, this.fastClass2Ext, executed);
            }
            if (checkMode.shouldCheck(CheckType.NORMAL)) {
                this.validate(object, messageAcceptor, this.normalClass2Ext, executed);
            }
            if (checkMode.shouldCheck(CheckType.EXPENSIVE)) {
                this.validate(object, messageAcceptor, this.expensiveClass2Ext, executed);
            }
        }

        private void validate(EObject object, ValidationMessageAcceptor messageAcceptor, HashMap<String, ArrayList<IRoomValidator>> map, HashSet<IRoomValidator> executed) {
            ArrayList<IRoomValidator> validators = map.get(object.eClass().getName());
            if (validators != null) {
                for (IRoomValidator validator : validators) {
                    if (executed.contains(validator)) continue;
                    executed.add(validator);
                    this.executeExtension(validator, object, messageAcceptor);
                }
            }
        }

        private void put(String cls, String sub, HashMap<String, ArrayList<String>> cls2sub) {
            ArrayList<String> list = cls2sub.get(cls);
            if (list == null) {
                list = new ArrayList();
                cls2sub.put(cls, list);
            }
            list.add(sub);
        }

        private void put(HashMap<String, ArrayList<IRoomValidator>> map, String cls, IRoomValidator val) {
            ArrayList<IRoomValidator> list = map.get(cls);
            if (list == null) {
                list = new ArrayList();
                map.put(cls, list);
            }
            list.add(val);
        }

        private HashMap<String, ArrayList<IRoomValidator>> getMap(String mode) {
            if (mode.equals(CheckType.FAST.name())) {
                return this.fastClass2Ext;
            }
            if (mode.equals(CheckType.NORMAL.name())) {
                return this.normalClass2Ext;
            }
            if (mode.equals(CheckType.EXPENSIVE.name())) {
                return this.normalClass2Ext;
            }
            return null;
        }

        private void executeExtension(final IRoomValidator validator, final EObject object, final ValidationMessageAcceptor messageAcceptor) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    System.out.println("Exception in IRoomValidator " + validator.getName());
                }

                public void run() throws Exception {
                    validator.validate(object, messageAcceptor);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    public static class ValidatorInfo {
        public static final String SEP = "@";
        private IRoomValidator validator;
        private String id;

        public ValidatorInfo(IRoomValidator validator, String id) {
            this.validator = validator;
            this.id = id;
        }

        public IRoomValidator getValidator() {
            return this.validator;
        }

        public String getName() {
            return this.validator.getName();
        }

        public String getDescription() {
            return this.validator.getDescription();
        }

        public String getId() {
            return this.id;
        }
    }
}

