/*******************************************************************************
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 		Thomas Schuetz (changed for C code generator)
 * 
 *******************************************************************************/

package org.eclipse.etrice.generator.c.gen

import com.google.inject.Inject
import com.google.inject.Singleton
import org.eclipse.etrice.core.genmodel.base.ILogger
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass
import org.eclipse.etrice.core.genmodel.etricegen.Root
import org.eclipse.etrice.core.room.ActorCommunicationType
import org.eclipse.etrice.core.room.CommunicationType
import org.eclipse.etrice.core.room.ProtocolClass
import org.eclipse.etrice.generator.base.IGeneratorFileIo
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator
import org.eclipse.etrice.generator.generic.ILanguageExtension
import org.eclipse.etrice.generator.generic.ProcedureHelpers
import org.eclipse.etrice.generator.generic.RoomExtensions

import static extension org.eclipse.etrice.core.room.util.RoomHelpers.*
import org.eclipse.etrice.generator.base.GlobalGeneratorSettings

@Singleton
class ActorClassGen extends GenericActorClassGenerator {
	
	@Inject protected extension RoomExtensions
	@Inject extension CExtensions
	@Inject extension ProcedureHelpers
	@Inject extension StateMachineGen

	@Inject protected ILanguageExtension langExt
	@Inject IGeneratorFileIo fileIO
	@Inject ILogger logger
	
	def doGenerate(Root root) {
		for (xpac: root.xpActorClasses) {
			val path = xpac.actorClass.generationTargetPath+xpac.actorClass.getPath
			val infopath = xpac.actorClass.generationInfoPath+xpac.actorClass.getPath
			var file = xpac.actorClass.getCHeaderFileName
			
			// header file
			fileIO.generateFile("generating ActorClass header", path, infopath, file, root.generateHeaderFile(xpac))

			// source file
			if (xpac.actorClass.isBehaviorAnnotationPresent("BehaviorManual")) {
				logger.logInfo("omitting ActorClass source for '"+xpac.actorClass.name+"' since @BehaviorManual is specified")
			}
			else {
				file = xpac.actorClass.getCSourceFileName
				fileIO.generateFile("generating ActorClass source", path, infopath, file, root.generateSourceFile(xpac))
			}
		}
	}
	
	def private generateHeaderFile(Root root, ExpandedActorClass xpac) {
		val ac = xpac.actorClass
		val eventPorts = ac.allEndPorts.filter(p|(p.protocol as ProtocolClass).commType==CommunicationType::EVENT_DRIVEN)
		val sendPorts = ac.allEndPorts.filter(p|(p.protocol as ProtocolClass).commType==CommunicationType::DATA_DRIVEN && p.conjugated)
		val recvPorts = ac.allEndPorts.filter(p|(p.protocol as ProtocolClass).commType==CommunicationType::DATA_DRIVEN && !p.conjugated)
		val dataDriven = ac.commType==ActorCommunicationType::DATA_DRIVEN
		val async = ac.commType==ActorCommunicationType::ASYNCHRONOUS
		val hasConstData = !(eventPorts.empty && recvPorts.empty && ac.allSAPs.empty && ac.allServiceImplementations.empty)
							|| GlobalGeneratorSettings::generateMSCInstrumentation
		val hasVarData = !(sendPorts.empty && ac.allAttributes.empty && xpac.stateMachine.empty && !hasConstData)
		
	'''
		/**
		 * @author generated by eTrice
		 *
		 * Header File of ActorClass ac.name
		 * 
		 */

		generateIncludeGuardBegin(ac)
		
		#include "etDatatypes.h"
		#include "messaging/etMessage.h"
		
		FOR dataClass : root.getReferencedDataClasses(ac)
			#include dataClass.includePath
		ENDFOR
		FOR pc : root.getReferencedProtocolClasses(ac)
			#include pc.includePath
		ENDFOR
		
		ac.userCode(1)
		
		typedef struct ac.name ac.name;
		
		/* const part of ActorClass (ROM) */
		IF hasConstData
			typedef struct ac.name_const {
				IF GlobalGeneratorSettings::generateMSCInstrumentation
					const char* instName;
					
				ENDIF
				/* simple ports */
				FOR ep : eventPorts
					IF ep.multiplicity==1
						const ep.getPortClassName() ep.name;
					ENDIF
				ENDFOR
				
				/* data receive ports */
				FOR ep : recvPorts
					IF ep.multiplicity==1
						const ep.getPortClassName() ep.name;
					ENDIF
				ENDFOR

				/* saps */
				FOR sap: ac.allSAPs
					const sap.getPortClassName() sap.name;
				ENDFOR
				
				/* replicated ports */
				FOR ep : ac.allEndPorts
					IF ep.multiplicity!=1
						const etReplPort ep.name;
					ENDIF
				ENDFOR
				
				/* services */
				FOR svc : ac.allServiceImplementations
					const etReplPort svc.spp.name;
				ENDFOR
			} ac.name_const;
		ELSE
			/* this actor class has no ports and thus no constant data */
		ENDIF
		
		IF !xpac.stateMachine.empty
			
			xpac.genHeaderConstants
		ENDIF
		
		/* variable part of ActorClass (RAM) */
		IF hasVarData
			struct ac.name {
				IF hasConstData
					const ac.name_const* const constData;
					
				ENDIF
				/* data send ports */
				FOR ep : sendPorts
					IF ep.multiplicity==1
						ep.getPortClassName() ep.name;
					ENDIF
				ENDFOR
				
				ac.allAttributes.attributes
				
				IF !xpac.stateMachine.empty
					
					xpac.genDataMembers
				ENDIF
			};
		ELSE
			struct ac.name {
				/* This actor class has no data at all.
				   But the private actor instance data is passed to all life cycle functions.
				   By introducing the dummy data we keep this case simple
				*/
				int dummy;
			};
		ENDIF

		void ac.name_init(ac.name* self);

		void ac.name_receiveMessage(void* self, const void* ifitem, const etMessage* msg);
		
		IF dataDriven || async
			void ac.name_execute(ac.name* self);
		ENDIF
		
		ac.operations.operationsDeclaration(ac.name)
		
		ac.userCode(2)
		
		generateIncludeGuardEnd(ac)
		
	'''
	}
	
	def private generateSourceFile(Root root, ExpandedActorClass xpac) {
		val ac = xpac.actorClass
		val async = ac.commType==ActorCommunicationType::ASYNCHRONOUS
		val eventDriven = ac.commType==ActorCommunicationType::EVENT_DRIVEN
		val dataDriven = ac.commType==ActorCommunicationType::DATA_DRIVEN
		val handleEvents = async || eventDriven
		
	'''
		/**
		 * @author generated by eTrice
		 *
		 * Source File of ActorClass ac.name
		 * 
		 */

		#include "ac.getCHeaderFileName"
		
		#include "modelbase/etActor.h"
		#include "debugging/etLogger.h"
		#include "debugging/etMSCLogger.h"
		#include "etUnit/etUnit.h"
		#include "osal/etMemory.h"

		FOR pc : root.getReferencedProtocolClasses(ac)
			#include pc.includePath
		ENDFOR
		
		ac.userCode(3)

		/* interface item IDs */
		xpac.genInterfaceItemConstants

		IF !xpac.stateMachine.empty
			xpac.genStateMachine()
		ENDIF
		
		void ac.name_init(ac.name* self){
			ET_MSC_LOGGER_SYNC_ENTRY("ac.name", "init")
			IF !xpac.stateMachine.empty
				xpac.genInitialization
			ENDIF
			ET_MSC_LOGGER_SYNC_EXIT
		}
		
		
		void ac.name_receiveMessage(void* self, const void* ifitem, const etMessage* msg){
			ET_MSC_LOGGER_SYNC_ENTRY("ac.name", "_receiveMessage")
			IF !xpac.stateMachine.empty
				
				langExt.operationScope(ac.name, false)receiveEvent(selfIF handleEvents, (etPort*)ifitem, msg->evtID, (void*)(((char*)msg)+MEM_CEIL(sizeof(etMessage)))ENDIF);
			ENDIF
			
			ET_MSC_LOGGER_SYNC_EXIT
		}
		
		IF dataDriven || async
			void ac.name_execute(ac.name* self) {
				ET_MSC_LOGGER_SYNC_ENTRY("ac.name", "_execute")
				IF !xpac.stateMachine.empty
					
					langExt.operationScope(ac.name, false)receiveEvent(selfIF handleEvents, NULL, 0, NULLENDIF);
				ENDIF
				
				ET_MSC_LOGGER_SYNC_EXIT
			}
		ENDIF
		
		ac.operationsImplementation
		
		'''
	}
}
