/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.etmap.ETMapStandaloneSetup;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.ETPhysStandaloneSetup;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.base.GlobalGeneratorSettings;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.IncrementalGenerationFileIo;
import org.eclipse.etrice.generator.c.gen.Validator;
import org.eclipse.etrice.generator.c.setup.GeneratorModule;
import org.eclipse.etrice.generator.doc.gen.MainGen;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;

public class Main
extends AbstractGenerator {
    public static final String OPTION_LIB = "-lib";
    public static final String OPTION_NOEXIT = "-noexit";
    public static final String OPTION_GEN_INST_DIAG = "-genInstDiag";
    public static final String OPTION_SAVE_GEN_MODEL = "-saveGenModel";
    public static final String OPTION_GEN_INCREMENTAL = "-inc";
    public static final String OPTION_GEN_DIR = "-genDir";
    public static final String OPTION_GEN_INFO_DIR = "-genInfoDir";
    public static final String OPTION_GEN_DOC_DIR = "-genDocDir";
    public static final String OPTION_DEBUG = "-debug";
    public static final String OPTION_MSC = "-msc_instr";
    public static final String OPTION_VERBOSE_RT = "-gen_as_verbose";
    @Inject
    private IGenerator mainGenerator;
    @Inject
    protected MainGen mainDocGenerator;
    @Inject
    private Validator validator;
    @Inject
    protected IDataConfiguration dataConfig;

    private static void printUsage() {
        output.println(String.valueOf(Main.class.getName()) + " [-saveGenModel <genmodel path>] [-genInstDiag] [-lib] [-inc] [-debug] [-genDir <generation directory>] [-genInfoDir <generation info directory>] [-genInfoDir <gen documentation directory>] <list of model file paths>");
        output.println("      <list of model file paths>         # model file paths may be specified as");
        output.println("                                         # e.g. C:\\path\\to\\model\\mymodel.room");
        output.println("      -saveGenModel <genmodel path>      # if specified the generator model will be saved to this location");
        output.println("      -genInstDiag                       # if specified an instance diagram is created for each subsystem");
        output.println("      -lib                               # if specified all classes are generated and no instances");
        output.println("      -noexit                            # if specified the JVM is not exited");
        output.println("      -inc                               # if specified the generation is incremental");
        output.println("      -genDir <generation directory>     # the directory for generated files");
        output.println("      -genInfoDir <generation info dir>  # the directory for generated info files");
        output.println("      -genDocDir <gen documentation dir> # the directory for generated documentation files");
    }

    public static void main(String[] args) {
        int ret = Main.createAndRunGenerator((Module)new GeneratorModule(), (String[])args);
        if (Main.isTerminateOnError() && ret != 0) {
            System.exit(ret);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int runGenerator(String[] args) {
        if (args.length == 0) {
            return this.usageError("no arguments!");
        }
        String genModelPath = null;
        ArrayList<String> uriList = new ArrayList<String>();
        boolean genInstDiag = false;
        boolean asLibrary = false;
        boolean debug = false;
        IncrementalGenerationFileIo.setGenerateIncremental((boolean)false);
        RoomExtensions.setDefaultGenDir();
        RoomExtensions.setDefaultGenInfoDir();
        RoomExtensions.setDefaultGenDocDir();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(OPTION_SAVE_GEN_MODEL)) {
                if (++i >= args.length) return this.usageError("-saveGenModel needs path");
                genModelPath = String.valueOf(args[i]) + "/genmodel.egm";
            } else if (args[i].equals(OPTION_GEN_DIR)) {
                if (++i >= args.length) return this.usageError("-genDir needs directory");
                RoomExtensions.setGenDir((String)args[i]);
            } else if (args[i].equals(OPTION_GEN_INFO_DIR)) {
                if (++i >= args.length) return this.usageError("-genInfoDir needs directory");
                RoomExtensions.setGenInfoDir((String)args[i]);
            } else if (args[i].equals(OPTION_GEN_DOC_DIR)) {
                if (++i >= args.length) return this.usageError("-genDocDir needs directory");
                RoomExtensions.setGenDocDir((String)args[i]);
            } else if (args[i].equals(OPTION_GEN_INCREMENTAL)) {
                IncrementalGenerationFileIo.setGenerateIncremental((boolean)true);
            } else if (args[i].equals(OPTION_GEN_INST_DIAG)) {
                genInstDiag = true;
            } else if (args[i].equals(OPTION_LIB)) {
                asLibrary = true;
            } else if (args[i].equals(OPTION_NOEXIT)) {
                Main.setTerminateOnError((boolean)false);
            } else if (args[i].equals(OPTION_MSC)) {
                GlobalGeneratorSettings.setGenerateMSCInstrumentation((boolean)true);
            } else if (args[i].equals(OPTION_VERBOSE_RT)) {
                GlobalGeneratorSettings.setGenerateWithVerboseOutput((boolean)true);
            } else if (args[i].equals(OPTION_DEBUG)) {
                debug = true;
            } else {
                uriList.add(args[i]);
            }
            ++i;
        }
        this.setupRoomModel();
        this.dataConfig.doSetup();
        this.setupMappingModel();
        this.setupPhysicalModel();
        if (this.runGenerator(uriList, genModelPath, genInstDiag, asLibrary, debug)) return 0;
        return 1;
    }

    protected void setupMappingModel() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ETMapStandaloneSetup.doSetup();
        }
    }

    protected void setupPhysicalModel() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ETPhysStandaloneSetup.doSetup();
        }
    }

    protected int usageError(String text) {
        this.logger.logError(String.valueOf(Main.class.getName()) + " - aborting: " + text, null);
        Main.printUsage();
        return 1;
    }

    protected boolean runGenerator(List<String> uriList, String genModelPath, boolean genInstDiag, boolean asLibrary, boolean debug) {
        if (!this.loadModels(uriList)) {
            this.logger.logInfo("loading of models failed");
            this.logger.logError("-- terminating", null);
            return false;
        }
        if (!this.validateModels()) {
            this.logger.logInfo("validation failed");
            this.logger.logError("-- terminating", null);
            return false;
        }
        if (!this.dataConfig.setResources(this.getResourceSet(), (ILogger)this.logger)) {
            this.logger.logInfo("configuration errors");
            this.logger.logError("-- terminating", null);
            return false;
        }
        Root genModel = this.createGeneratorModel(asLibrary, genModelPath);
        if (this.diagnostician.isFailed() || genModel == null) {
            this.logger.logInfo("errors during build of generator model");
            this.logger.logError("-- terminating", null);
            return false;
        }
        if (!this.validator.validate(genModel)) {
            this.logger.logInfo("validation failed during build of generator model");
            this.logger.logError("-- terminating", null);
            return false;
        }
        ETMapUtil.processModels((Root)genModel, (ResourceSet)this.getResourceSet(), (IDiagnostician)this.diagnostician);
        if (debug) {
            this.logger.logInfo("-- begin dump of mappings");
            this.logger.logInfo(ETMapUtil.dumpMappings());
            this.logger.logInfo("-- end dump of mappings");
        }
        if (this.diagnostician.isFailed() || genModel == null) {
            this.logger.logInfo("errors in mapping");
            this.logger.logError("-- terminating", null);
            return false;
        }
        this.logger.logInfo("-- starting code generation");
        this.fileAccess.setOutputPath("src-gen/");
        this.mainGenerator.doGenerate(genModel.eResource(), (IFileSystemAccess)this.fileAccess);
        if (genInstDiag) {
            this.mainDocGenerator.doGenerate(genModel);
        }
        if (this.diagnostician.isFailed()) {
            this.logger.logInfo("errors during code generation");
            this.logger.logError("-- terminating", null);
            return false;
        }
        this.logger.logInfo("-- finished code generation");
        return true;
    }
}

