/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class NodeRunnerGen {
    @Inject
    @Extension
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;

    public void doGenerate(Root root) {
        boolean first = true;
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                String _name = nr.getName();
                String _plus = String.valueOf(_name) + "_";
                String _name_1 = ssi.getName();
                String clsname = String.valueOf(_plus) + _name_1;
                SubSystemClass _subSystemClass = ssi.getSubSystemClass();
                String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)_subSystemClass);
                SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
                String _path = this._roomExtensions.getPath((RoomClass)_subSystemClass_1);
                String _plus_1 = String.valueOf(_generationTargetPath) + _path;
                this.fileAccess.setOutputPath(_plus_1);
                String _plus_2 = String.valueOf(clsname) + "_Runner.c";
                CharSequence _generateSourceFile = this.generateSourceFile(root, ssi, first);
                this.fileAccess.generateFile(_plus_2, _generateSourceFile);
                first = false;
            }
        }
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance ssi, boolean first) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((StructureInstance)ssi);
        String _name = nr.getName();
        String _plus = String.valueOf(_name) + "_";
        String _name_1 = ssi.getName();
        String clsname = String.valueOf(_plus) + _name_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* this class contains the main function running Node ");
        String _name_2 = nr.getName();
        _builder.append((Object)_name_2, " ");
        _builder.append((Object)" with SubSystem ");
        String _name_3 = ssi.getName();
        _builder.append((Object)_name_3, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* it instantiates Node ");
        String _name_4 = nr.getName();
        _builder.append((Object)_name_4, " ");
        _builder.append((Object)" with SubSystem ");
        String _name_5 = ssi.getName();
        _builder.append((Object)_name_5, " ");
        _builder.append((Object)" and starts and ends the lifecycle");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName(nr, ssi);
        _builder.append((Object)_cHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"osal/etPlatformLifecycle.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* main function");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* creates component and starts and stops the lifecycle");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"int main(int argc, char** argv) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etBool runAsTest = FALSE;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (argc>1 && strcmp(argv[1], \"-headless\")==0)");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"runAsTest = TRUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (argc>1 && strcmp(argv[1], \"-run_as_test\")==0)");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"runAsTest = TRUE;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etUserEntry(); /* platform specific */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfo(\"***   T H E   B E G I N   ***\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_OPEN(\"main\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* startup sequence  of lifecycle */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_init(); \t\t/* lifecycle init */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_start(); \t/* lifecycle start */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etUserPreRun(); /* platform specific */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* run Scheduler */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_run(runAsTest);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etUserPostRun(); /* platform specific */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* shutdown sequence of lifecycle */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_stop(); \t\t/* lifecycle stop */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_destroy(); \t/* lifecycle destroy */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_CLOSE");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfo(\"***   T H E   E N D   ***\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"etUserExit(); /* platform specific */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return 0;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

