/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LogicalThread;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.base.Indexed;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.ConfigGenAddon;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.etrice.generator.java.gen.VariableServiceGen;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class SubSystemClassGen {
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    private IDataConfiguration dataConfigExt;
    @Inject
    private ConfigGenAddon configGenAddon;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    private VariableServiceGen varService;
    @Inject
    private IDiagnostician diagnostician;

    public void doGenerate(Root root) {
        EList _subSystemInstances = root.getSubSystemInstances();
        for (SubSystemInstance ssi : _subSystemInstances) {
            SubSystemClass _subSystemClass = ssi.getSubSystemClass();
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)_subSystemClass);
            SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
            String _path = this._roomExtensions.getPath((RoomClass)_subSystemClass_1);
            String path = String.valueOf(_generationTargetPath) + _path;
            SubSystemClass _subSystemClass_2 = ssi.getSubSystemClass();
            String _generationInfoPath = this._roomExtensions.getGenerationInfoPath((EObject)_subSystemClass_2);
            SubSystemClass _subSystemClass_3 = ssi.getSubSystemClass();
            String _path_1 = this._roomExtensions.getPath((RoomClass)_subSystemClass_3);
            String infopath = String.valueOf(_generationInfoPath) + _path_1;
            SubSystemClass _subSystemClass_4 = ssi.getSubSystemClass();
            String file = this._javaExtensions.getJavaFileName((RoomClass)_subSystemClass_4);
            this.checkDataPorts(ssi);
            CharSequence _generate = this.generate(root, ssi);
            this.fileIO.generateFile("generating SubSystemClass implementation", path, infopath, file, _generate);
            boolean _hasVariableService = this.dataConfigExt.hasVariableService(ssi);
            if (!_hasVariableService) continue;
            this.varService.doGenerate(root, ssi);
        }
    }

    public CharSequence generate(Root root, SubSystemInstance comp) {
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = comp.getSubSystemClass();
        EList models = root.getReferencedModels((RoomClass)cc);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _package = this._roomExtensions.getPackage((RoomClass)cc);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.config.IVariableService;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.IRTObject;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.MessageService;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.MessageServiceController;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.RTServices;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.ActorClassBase;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.SubSystemClassBase;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBase;");
        _builder.newLine();
        _builder.newLine();
        for (RoomModel model : models) {
            _builder.append((Object)"import ");
            String _name = model.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode((ActorContainerClass)cc, 1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = cc.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" extends SubSystemClassBase {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public final int THREAD__DEFAULT = 0;");
        _builder.newLine();
        EList _threads = cc.getThreads();
        Iterable _indexed = Indexed.indexed((Iterable)_threads);
        for (Indexed thread : _indexed) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public final int ");
            LogicalThread _value = (LogicalThread)thread.getValue();
            String _threadId = this.getThreadId(_value);
            _builder.append((Object)_threadId, "\t");
            _builder.append((Object)" = ");
            int _index1 = thread.getIndex1();
            _builder.append((Object)_index1, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode((ActorContainerClass)cc, 2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = cc.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)"(IRTObject parent, String name) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(parent, name);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void receiveEvent(InterfaceItemBase ifitem, int evt, Object data){");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void instantiateMessageServices() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"RTServices.getInstance().getMsgSvcCtrl().addMsgSvc(new MessageService(this, 0, THREAD__DEFAULT, \"MessageService_Main\"));");
        _builder.newLine();
        EList _threads_1 = cc.getThreads();
        for (LogicalThread thread_1 : _threads_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"RTServices.getInstance().getMsgSvcCtrl().addMsgSvc(new MessageService(this, 0, ");
            String _threadId_1 = this.getThreadId(thread_1);
            _builder.append((Object)_threadId_1, "\t\t");
            _builder.append((Object)", \"MessageService_");
            String _name_3 = thread_1.getName();
            _builder.append((Object)_name_3, "\t\t");
            _builder.append((Object)"\" /*, thread_prio */));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void instantiateActors() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"MessageServiceController msgSvcCtrl = RTServices.getInstance().getMsgSvcCtrl();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// thread mappings");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"msgSvcCtrl.addPathToThread(\"");
        String _path = comp.getPath();
        _builder.append((Object)_path, "\t\t");
        _builder.append((Object)"\", THREAD__DEFAULT);");
        _builder.newLineIfNotEmpty();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            boolean _notEquals;
            int _threadId_2 = ai.getThreadId();
            boolean bl = _notEquals = _threadId_2 != 0;
            if (!_notEquals) continue;
            _builder.append((Object)"\t\t");
            _builder.append((Object)"msgSvcCtrl.addPathToThread(\"");
            String _path_1 = ai.getPath();
            _builder.append((Object)_path_1, "\t\t");
            _builder.append((Object)"\", ");
            EList _threads_2 = cc.getThreads();
            int _threadId_3 = ai.getThreadId();
            int _minus = _threadId_3 - 1;
            LogicalThread _get = (LogicalThread)_threads_2.get(_minus);
            String _threadId_4 = this.getThreadId(_get);
            _builder.append((Object)_threadId_4, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// port to peer port mappings");
        _builder.newLine();
        EList _allContainedInstances_1 = comp.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_1) {
            EList _orderedIfItemInstances = ai_1.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances) {
                boolean _greaterThan;
                EList _peers = pi.getPeers();
                int _size = _peers.size();
                boolean bl = _greaterThan = _size > 0;
                if (!_greaterThan) continue;
                _builder.append((Object)"\t\t");
                _builder.append((Object)"msgSvcCtrl.addPathToPeers(\"");
                String _path_2 = pi.getPath();
                _builder.append((Object)_path_2, "\t\t");
                _builder.append((Object)"\", ");
                EList _peers_1 = pi.getPeers();
                boolean _hasElements = false;
                for (InterfaceItemInstance peer : _peers_1) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)",", "\t\t");
                    }
                    _builder.append((Object)"\"");
                    String _path_3 = peer.getPath();
                    _builder.append((Object)_path_3, "\t\t");
                    _builder.append((Object)"\"");
                }
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// sub actors");
        _builder.newLine();
        EList _actorRefs = cc.getActorRefs();
        for (ActorRef sub : _actorRefs) {
            boolean _greaterThan_1;
            int _size_1 = sub.getSize();
            boolean bl = _greaterThan_1 = _size_1 > 1;
            if (_greaterThan_1) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"for (int i=0; i<");
                int _size_2 = sub.getSize();
                _builder.append((Object)_size_2, "\t\t");
                _builder.append((Object)"; ++i)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"new ");
                ActorClass _type = sub.getType();
                String _name_4 = _type.getName();
                _builder.append((Object)_name_4, "\t\t\t");
                _builder.append((Object)"(this, \"");
                String _name_5 = sub.getName();
                _builder.append((Object)_name_5, "\t\t\t");
                _builder.append((Object)"_\"+i); ");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"new ");
            ActorClass _type_1 = sub.getType();
            String _name_6 = _type_1.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append((Object)"(this, \"");
            String _name_7 = sub.getName();
            _builder.append((Object)_name_7, "\t\t");
            _builder.append((Object)"\"); ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// apply instance attribute configurations");
        _builder.newLine();
        EList _allContainedInstances_2 = comp.getAllContainedInstances();
        for (ActorInstance ai_2 : _allContainedInstances_2) {
            boolean _greaterThan_2;
            _builder.append((Object)"\t\t");
            CharSequence cfg = this.configGenAddon.genActorInstanceConfig(ai_2, "inst");
            _builder.newLineIfNotEmpty();
            int _length = cfg.length();
            boolean bl = _greaterThan_2 = _length > 0;
            if (!_greaterThan_2) continue;
            _builder.append((Object)"\t\t");
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            ActorClass _actorClass = ai_2.getActorClass();
            String _name_8 = _actorClass.getName();
            _builder.append((Object)_name_8, "\t\t\t");
            _builder.append((Object)" inst = (");
            ActorClass _actorClass_1 = ai_2.getActorClass();
            String _name_9 = _actorClass_1.getName();
            _builder.append((Object)_name_9, "\t\t\t");
            _builder.append((Object)") getObject(\"");
            String _path_4 = ai_2.getPath();
            _builder.append((Object)_path_4, "\t\t\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"if (inst!=null) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)cfg, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void init(){");
        _builder.newLine();
        boolean _hasVariableService = this.dataConfigExt.hasVariableService(comp);
        if (_hasVariableService) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"variableService = new ");
            String _name_10 = cc.getName();
            _builder.append((Object)_name_10, "\t\t");
            _builder.append((Object)"VariableService(this);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super.init();");
        _builder.newLine();
        boolean _hasVariableService_1 = this.dataConfigExt.hasVariableService(comp);
        if (_hasVariableService_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"variableService.init();");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void stop(){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super.stop();");
        _builder.newLine();
        boolean _hasVariableService_2 = this.dataConfigExt.hasVariableService(comp);
        if (_hasVariableService_2) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"variableService.stop();");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String getThreadId(LogicalThread thread) {
        String _name = thread.getName();
        String _upperCase = _name.toUpperCase();
        String _plus = "THREAD_" + _upperCase;
        return _plus;
    }

    private void checkDataPorts(SubSystemInstance comp) {
        HashSet<String> _hashSet;
        HashSet<String> found = _hashSet = new HashSet<String>();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            int thread = ai.getThreadId();
            EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances) {
                ProtocolClass _protocol = pi.getProtocol();
                CommunicationType _commType = _protocol.getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                if (!_equals) continue;
                EList _peers = pi.getPeers();
                for (InterfaceItemInstance peer : _peers) {
                    boolean _not;
                    boolean _lessThan;
                    boolean _notEquals;
                    EObject _eContainer = peer.eContainer();
                    ActorInstance peer_ai = (ActorInstance)_eContainer;
                    int peer_thread = peer_ai.getThreadId();
                    boolean bl = _notEquals = thread != peer_thread;
                    if (!_notEquals) continue;
                    String path = pi.getPath();
                    String ppath = peer.getPath();
                    String _xifexpression = null;
                    int _compareTo = path.compareTo(ppath);
                    boolean bl2 = _lessThan = _compareTo < 0;
                    if (_lessThan) {
                        String _plus_1;
                        String _plus = String.valueOf(path) + " and ";
                        _xifexpression = _plus_1 = String.valueOf(_plus) + ppath;
                    } else {
                        String _plus_3;
                        String _plus_2 = String.valueOf(ppath) + " and ";
                        _xifexpression = _plus_3 = String.valueOf(_plus_2) + path;
                    }
                    String pair = _xifexpression;
                    boolean _contains = found.contains(pair);
                    boolean bl3 = _not = !_contains;
                    if (!_not) continue;
                    found.add(pair);
                    String _plus_4 = String.valueOf(pair) + ": data ports placed on different threads (not supported yet)";
                    InterfaceItem _interfaceItem = pi.getInterfaceItem();
                    InterfaceItem _interfaceItem_1 = pi.getInterfaceItem();
                    EStructuralFeature _eContainingFeature = _interfaceItem_1.eContainingFeature();
                    this.diagnostician.error(_plus_4, (EObject)_interfaceItem, _eContainingFeature);
                }
            }
        }
    }
}

