/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public abstract class GeneratorConfigTab
extends AbstractLaunchConfigurationTab {
    public static final String GEN_INSTANCE_DIAGRAM = "GenInstanceDiagram";
    public static final String GEN_DOCUMENTATION = "GenDocumentation";
    public static final String GEN_MODEL_PATH = "GenModelPath";
    public static final String SAVE_GEN_MODEL = "SaveGenModel";
    public static final String LIB = "Lib";
    public static final String DEBUG = "Debug";
    public static final String MSC = "MSC";
    public static final String VERBOSE = "Verbose";
    private Button libButton;
    private Button documentationButton;
    private Button saveGenModel;
    private Text genModelPath;
    private Button browsePath;
    private Button debugButton;
    private Button mscButton;
    private Button verboseButton;

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        mainComposite.setLayout((Layout)layout);
        this.libButton = this.createCheckButton(mainComposite, "generate all classes as library");
        this.libButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.libButton.addSelectionListener((SelectionListener)new UpdateConfig());
        this.saveGenModel = this.createCheckButton(mainComposite, "save generator model");
        this.saveGenModel.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.saveGenModel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorConfigTab.this.handleSaveGenModelSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GeneratorConfigTab.this.handleSaveGenModelSelected();
            }
        });
        this.genModelPath = new Text(mainComposite, 2052);
        this.genModelPath.setLayoutData((Object)new GridData(768));
        this.genModelPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneratorConfigTab.this.validate();
                GeneratorConfigTab.this.setDirty(true);
                GeneratorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.browsePath = this.createPushButton(mainComposite, "Browse...", null);
        this.browsePath.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorConfigTab.this.handlePathButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GeneratorConfigTab.this.handlePathButtonSelected();
            }
        });
        this.documentationButton = this.createCheckButton(mainComposite, "generate documentation");
        this.documentationButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.documentationButton.addSelectionListener((SelectionListener)new UpdateConfig());
        this.debugButton = this.createCheckButton(mainComposite, "debug output");
        this.debugButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.debugButton.addSelectionListener((SelectionListener)new UpdateConfig());
        this.mscButton = this.createCheckButton(mainComposite, "generate instrumentation for MSC generation");
        this.mscButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.mscButton.addSelectionListener((SelectionListener)new UpdateConfig());
        this.verboseButton = this.createCheckButton(mainComposite, "generate instrumentation for verbose output");
        this.verboseButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.verboseButton.addSelectionListener((SelectionListener)new UpdateConfig());
        this.addFurtherControls(mainComposite);
    }

    protected void addFurtherControls(Composite mainComposite) {
    }

    protected void handleSaveGenModelSelected() {
        boolean save = this.saveGenModel.getSelection();
        this.genModelPath.setEnabled(save);
        this.browsePath.setEnabled(save);
        this.validate();
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void validate() {
        if (this.saveGenModel.getSelection() && this.genModelPath.getText().trim().isEmpty()) {
            this.setErrorMessage("generator model path must not be empty");
            return;
        }
        this.setErrorMessage(null);
    }

    protected void handlePathButtonSelected() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "select a container for the generator model");
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String fname = path.toString();
            fname = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", fname);
            this.genModelPath.setText(fname);
            this.setErrorMessage(null);
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.libButton.setSelection(configuration.getAttribute(LIB, false));
            boolean save = configuration.getAttribute(SAVE_GEN_MODEL, false);
            this.saveGenModel.setSelection(save);
            this.genModelPath.setEnabled(save);
            this.browsePath.setEnabled(save);
            this.genModelPath.setText(configuration.getAttribute(GEN_MODEL_PATH, ""));
            boolean genDocu = configuration.getAttribute(GEN_DOCUMENTATION, false);
            if (configuration.getAttribute(GEN_INSTANCE_DIAGRAM, false)) {
                genDocu = true;
            }
            this.documentationButton.setSelection(genDocu);
            this.debugButton.setSelection(configuration.getAttribute(DEBUG, false));
            this.mscButton.setSelection(configuration.getAttribute(MSC, true));
            this.verboseButton.setSelection(configuration.getAttribute(VERBOSE, false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(LIB, this.libButton.getSelection());
        configuration.setAttribute(SAVE_GEN_MODEL, this.saveGenModel.getSelection());
        configuration.setAttribute(GEN_MODEL_PATH, this.genModelPath.getText());
        configuration.setAttribute(GEN_INSTANCE_DIAGRAM, this.documentationButton.getSelection());
        configuration.setAttribute(GEN_DOCUMENTATION, this.documentationButton.getSelection());
        configuration.setAttribute(DEBUG, this.debugButton.getSelection());
        configuration.setAttribute(MSC, this.mscButton.getSelection());
        configuration.setAttribute(VERBOSE, this.verboseButton.getSelection());
    }

    public boolean canSave() {
        if (this.saveGenModel.getSelection()) {
            return !this.genModelPath.getText().trim().isEmpty();
        }
        return true;
    }

    protected class UpdateConfig
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            GeneratorConfigTab.this.validate();
            GeneratorConfigTab.this.setDirty(true);
            GeneratorConfigTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

