/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.commons.io.FileUtils;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.generator.base.IGeneratorFileIo;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.util.RuntimeIOException;

public class IncrementalGenerationFileIo
implements IGeneratorFileIo {
    @Inject
    JavaIoFileSystemAccess fileAccess;
    @Inject
    ILogger logger;
    private static boolean generateIncremental = false;

    public static boolean isGenerateIncremental() {
        return generateIncremental;
    }

    public static void setGenerateIncremental(boolean generateIncremental) {
        IncrementalGenerationFileIo.generateIncremental = generateIncremental;
    }

    @Override
    public void generateFile(String desc, String path, String infopath, String file, CharSequence contents) {
        long oldCRC = 0L;
        boolean genInc = generateIncremental;
        if (genInc) {
            this.fileAccess.setOutputPath(infopath);
            try {
                CharSequence val = this.fileAccess.readTextFile(String.valueOf(file) + ".info", "DEFAULT_OUTPUT");
                oldCRC = Long.parseLong(val.toString());
            }
            catch (RuntimeIOException val) {
            }
            catch (NumberFormatException val) {
                // empty catch block
            }
        }
        boolean write = true;
        long newCRC = 0L;
        if (genInc) {
            CRC32 crc32 = new CRC32();
            crc32.update(contents.toString().getBytes());
            newCRC = crc32.getValue();
            if (oldCRC == newCRC) {
                write = false;
            } else {
                this.fileAccess.generateFile(String.valueOf(file) + ".info", (CharSequence)("" + newCRC));
            }
        }
        if (write) {
            this.logger.logInfo(String.valueOf(desc) + " '" + file + "' in '" + path + "'");
            this.fileAccess.setOutputPath(path);
            this.fileAccess.generateFile(file, contents);
            if (genInc) {
                this.fileAccess.setOutputPath(infopath);
                this.fileAccess.generateFile(file, contents);
            }
        } else {
            this.logger.logInfo(String.valueOf(desc) + " (unchanged) '" + file + "' in '" + path + "'");
            File src = new File(String.valueOf(infopath) + file);
            File dst = new File(String.valueOf(path) + file);
            try {
                FileUtils.copyFile((File)src, (File)dst, (boolean)true);
            }
            catch (IOException e) {
                this.fileAccess.setOutputPath(path);
                this.fileAccess.generateFile(file, contents);
            }
        }
    }
}

