/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SAPInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ServiceImplInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphNode;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionPoint;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class RoomExtensions {
    private static String genDir = "/src-gen/";
    private static String genInfoDir = "/src-gen-info/";
    private static String genDocDir = "/doc-gen/";

    public static String setDefaultGenDir() {
        genDir = "/src-gen/";
        String _genDir = "/src-gen/";
        return _genDir;
    }

    public static String setDefaultGenInfoDir() {
        genInfoDir = "/src-gen-info/";
        String _genInfoDir = "/src-gen-info/";
        return _genInfoDir;
    }

    public static String setDefaultGenDocDir() {
        genDocDir = "/doc-gen/";
        String _genDocDir = "/doc-gen/";
        return _genDocDir;
    }

    public static String setGenDir(String dir) {
        String _plus_1;
        String _plus = "/" + dir;
        String _genDir = genDir = (_plus_1 = String.valueOf(_plus) + "/");
        return _genDir;
    }

    public static String setGenInfoDir(String dir) {
        String _plus_1;
        String _plus = "/" + dir;
        String _genInfoDir = genInfoDir = (_plus_1 = String.valueOf(_plus) + "/");
        return _genInfoDir;
    }

    public static String setGenDocDir(String dir) {
        String _plus_1;
        String _plus = "/" + dir;
        String _genDocDir = genDocDir = (_plus_1 = String.valueOf(_plus) + "/");
        return _genDocDir;
    }

    public <T> List<T> union(Iterable<T> l, T e) {
        ArrayList<T> _arrayList;
        ArrayList<T> ret = _arrayList = new ArrayList<T>();
        Iterables.addAll(ret, l);
        ret.add(e);
        return ret;
    }

    public <T> List<T> union(Iterable<T> l1, Iterable<T> l2) {
        ArrayList _arrayList;
        ArrayList ret = _arrayList = new ArrayList();
        Iterables.addAll(ret, l1);
        Iterables.addAll(ret, l2);
        return ret;
    }

    public List<Port> punion(Iterable<Port> in1, Iterable<ExternalPort> in2) {
        ArrayList<Port> _arrayList;
        final ArrayList<Port> ret = _arrayList = new ArrayList<Port>();
        Procedures.Procedure1<ExternalPort> _function = new Procedures.Procedure1<ExternalPort>(){

            public void apply(ExternalPort e) {
                Port _ifport = e.getIfport();
                ret.add(_ifport);
            }
        };
        IterableExtensions.forEach(in2, (Procedures.Procedure1)_function);
        Iterables.addAll(ret, in1);
        return ret;
    }

    public <T> List<T> minus(List<T> l1, List<T> l2) {
        ArrayList<T> _arrayList;
        ArrayList<T> ret = _arrayList = new ArrayList<T>(l1);
        ret.removeAll(l2);
        return ret;
    }

    public String getGenerationPathSegment() {
        return genDir;
    }

    public String getGenerationInfoSegment() {
        return genInfoDir;
    }

    public String getDocGenerationPathSegment() {
        return genDocDir;
    }

    public String getModelPath(EObject e) {
        Resource res = e.eResource();
        boolean _equals = Objects.equal((Object)res, null);
        if (_equals) {
            return "";
        }
        URI _uRI = res.getURI();
        return _uRI.toFileString();
    }

    public String getPackage(RoomClass rc) {
        EObject _eContainer = rc.eContainer();
        return ((RoomModel)_eContainer).getName();
    }

    public String getPathFromPackage(String packageName) {
        String _replaceAll = packageName.replaceAll("\\.", "/");
        return String.valueOf(_replaceAll) + "/";
    }

    public String getPath(RoomClass rc) {
        String _package = this.getPackage(rc);
        String _pathFromPackage = this.getPathFromPackage(_package);
        return _pathFromPackage;
    }

    public String getProjectPath(EObject e) {
        boolean _and;
        boolean _not;
        Resource res = e.eResource();
        boolean _equals = Objects.equal((Object)res, null);
        if (_equals) {
            return "";
        }
        URI _uRI = res.getURI();
        String _fileString = _uRI.toFileString();
        File _file = new File(_fileString);
        File tmpf = _file;
        boolean _isFile = tmpf.isFile();
        boolean bl = _not = !_isFile;
        if (_not) {
            return "";
        }
        boolean isProject = false;
        boolean _dowhile = false;
        do {
            boolean _not_1;
            String[] contents;
            File _parentFile;
            tmpf = _parentFile = tmpf.getParentFile();
            String[] stringArray = contents = tmpf.list();
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                boolean _equals_1 = f.equals(".project");
                if (_equals_1) {
                    isProject = true;
                }
                ++n2;
            }
            _and = false;
            boolean bl2 = _not_1 = !isProject;
            if (!_not_1) {
                _and = false;
                continue;
            }
            File _parentFile2 = tmpf.getParentFile();
            boolean _notEquals = !Objects.equal((Object)_parentFile2, null);
            boolean bl3 = _and = _not_1 && _notEquals;
        } while (_dowhile = _and);
        return tmpf.getAbsolutePath();
    }

    public String getGenerationTargetPath(EObject e) {
        String _projectPath = this.getProjectPath(e);
        String _generationPathSegment = this.getGenerationPathSegment();
        return String.valueOf(_projectPath) + _generationPathSegment;
    }

    public String getGenerationInfoPath(EObject e) {
        String _projectPath = this.getProjectPath(e);
        String _generationInfoSegment = this.getGenerationInfoSegment();
        return String.valueOf(_projectPath) + _generationInfoSegment;
    }

    public String getDocGenerationTargetPath(EObject e) {
        String _projectPath = this.getProjectPath(e);
        String _docGenerationPathSegment = this.getDocGenerationPathSegment();
        return String.valueOf(_projectPath) + _docGenerationPathSegment;
    }

    public String getPathName(String path) {
        String _replaceAll = path.replaceAll("/", "_");
        return _replaceAll;
    }

    protected String _getPortClassName(Port p) {
        String _xifexpression = null;
        GeneralProtocolClass _protocol = p.getProtocol();
        if (_protocol instanceof ProtocolClass) {
            String _portClassName;
            GeneralProtocolClass _protocol_1 = p.getProtocol();
            boolean _isConjugated = p.isConjugated();
            boolean _isReplicated = p.isReplicated();
            _xifexpression = _portClassName = this.getPortClassName((ProtocolClass)_protocol_1, _isConjugated, _isReplicated);
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    protected String _getPortClassName(ExternalPort p) {
        Port _ifport = p.getIfport();
        return this.getPortClassName((EObject)_ifport);
    }

    protected String _getPortClassName(SAPRef sap) {
        ProtocolClass _protocol = sap.getProtocol();
        return this.getPortClassName(_protocol, true);
    }

    protected String _getPortClassName(SPPRef spp) {
        ProtocolClass _protocol = spp.getProtocol();
        return this.getPortClassName(_protocol, false, true);
    }

    protected String _getPortClassName(ServiceImplementation svc) {
        SPPRef _spp = svc.getSpp();
        ProtocolClass _protocol = _spp.getProtocol();
        return this.getPortClassName(_protocol, false, true);
    }

    public String getPortClassName(ProtocolClass p, boolean conj) {
        String _portClassName = this.getPortClassName(p, conj, false);
        return _portClassName;
    }

    public String getPortClassName(ProtocolClass p, boolean conj, boolean repl) {
        String _name = p.getName();
        String _xifexpression = null;
        _xifexpression = conj ? "Conj" : "";
        String _plus = String.valueOf(_name) + _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = repl ? "Repl" : "";
        String _plus_1 = String.valueOf(_plus) + _xifexpression_1;
        String _plus_2 = String.valueOf(_plus_1) + "Port";
        return _plus_2;
    }

    public PortClass getPortClass(ProtocolClass pc, boolean conj) {
        if (conj) {
            return pc.getConjugate();
        }
        return pc.getRegular();
    }

    public boolean handlesSend(ProtocolClass pc, boolean conj) {
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            return false;
        }
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List _allMessages = RoomHelpers.getAllMessages((ProtocolClass)pc, (boolean)conj);
            boolean _contains = _allMessages.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public boolean handlesReceive(ProtocolClass pc, boolean conj) {
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            return false;
        }
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            boolean _not = !conj;
            List _allMessages = RoomHelpers.getAllMessages((ProtocolClass)pc, (boolean)_not);
            boolean _contains = _allMessages.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public boolean isConjugated(InterfaceItemInstance iii) {
        if (iii instanceof PortInstance) {
            Port _port = ((PortInstance)iii).getPort();
            return _port.isConjugated();
        }
        if (iii instanceof SAPInstance) {
            return true;
        }
        if (iii instanceof ServiceImplInstance) {
            return false;
        }
        return false;
    }

    public List<MessageHandler> getReceiveHandlers(ProtocolClass pc, boolean conj) {
        ArrayList<MessageHandler> _arrayList_1;
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            ArrayList<MessageHandler> _arrayList = new ArrayList<MessageHandler>();
            return _arrayList;
        }
        ArrayList<MessageHandler> res = _arrayList_1 = new ArrayList<MessageHandler>();
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            boolean _not = !conj;
            List _allMessages = RoomHelpers.getAllMessages((ProtocolClass)pc, (boolean)_not);
            boolean _contains = _allMessages.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            res.add(hdlr);
        }
        return res;
    }

    public List<MessageHandler> getSendHandlers(ProtocolClass pc, boolean conj) {
        ArrayList<MessageHandler> _arrayList_1;
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            ArrayList<MessageHandler> _arrayList = new ArrayList<MessageHandler>();
            return _arrayList;
        }
        ArrayList<MessageHandler> res = _arrayList_1 = new ArrayList<MessageHandler>();
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List _allMessages = RoomHelpers.getAllMessages((ProtocolClass)pc, (boolean)conj);
            boolean _contains = _allMessages.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            res.add(hdlr);
        }
        return res;
    }

    public MessageHandler getSendHandler(final Message m, boolean conj) {
        EObject _eContainer = m.eContainer();
        List<MessageHandler> _sendHandlers = this.getSendHandlers((ProtocolClass)_eContainer, conj);
        Functions.Function1<MessageHandler, Boolean> _function = new Functions.Function1<MessageHandler, Boolean>(){

            public Boolean apply(MessageHandler e) {
                Message _msg = e.getMsg();
                boolean _equals = Objects.equal((Object)_msg, (Object)m);
                return _equals;
            }
        };
        return (MessageHandler)IterableExtensions.findFirst(_sendHandlers, (Functions.Function1)_function);
    }

    public boolean isIncoming(Message m) {
        EObject _eContainer = m.eContainer();
        List _allIncomingMessages = RoomHelpers.getAllIncomingMessages((ProtocolClass)((ProtocolClass)_eContainer));
        return _allIncomingMessages.contains(m);
    }

    public String getCodeName(Message m) {
        boolean _isIncoming = this.isIncoming(m);
        if (_isIncoming) {
            String _name = m.getName();
            return "IN_" + _name;
        }
        String _name_1 = m.getName();
        return "OUT_" + _name_1;
    }

    public List<State> getLeafStatesLast(List<State> states) {
        List<State> _union;
        List<State> _xblockexpression = null;
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                boolean _isLeaf = RoomHelpers.isLeaf((State)s);
                return _isLeaf;
            }
        };
        Iterable leaf = IterableExtensions.filter(states, (Functions.Function1)_function);
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                boolean _isLeaf = RoomHelpers.isLeaf((State)s);
                boolean _not = !_isLeaf;
                return _not;
            }
        };
        Iterable nonLeaf = IterableExtensions.filter(states, (Functions.Function1)_function_1);
        _xblockexpression = _union = this.union(nonLeaf, leaf);
        return _xblockexpression;
    }

    public List<State> getAllLeafStates(ActorClass ac) {
        StateGraph _stateMachine = ac.getStateMachine();
        List _leafStateList = RoomHelpers.getLeafStateList((StateGraph)_stateMachine);
        return _leafStateList;
    }

    public List<State> getAllBaseStatesLeavesLast(ActorClass ac) {
        List _allBaseStates = RoomHelpers.getAllBaseStates((ActorClass)ac);
        List<State> _leafStatesLast = this.getLeafStatesLast(_allBaseStates);
        return _leafStatesLast;
    }

    public boolean overridesStop(ActorClass ac) {
        Functions.Function1<StandardOperation, Boolean> _function;
        boolean _or = false;
        EList _operations = ac.getOperations();
        boolean _exists = IterableExtensions.exists((Iterable)_operations, (Functions.Function1)(_function = new Functions.Function1<StandardOperation, Boolean>(){

            public Boolean apply(StandardOperation e) {
                boolean _and = false;
                boolean _and_1 = false;
                String _name = e.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)"stop");
                if (!_equals) {
                    _and_1 = false;
                } else {
                    EList _arguments = e.getArguments();
                    boolean _isEmpty = _arguments.isEmpty();
                    boolean bl = _and_1 = _equals && _isEmpty;
                }
                if (!_and_1) {
                    _and = false;
                } else {
                    RefableType _returntype = e.getReturntype();
                    boolean _equals_1 = Objects.equal((Object)_returntype, null);
                    _and = _and_1 && _equals_1;
                }
                return _and;
            }
        }));
        if (_exists) {
            _or = true;
        } else {
            boolean _notEquals;
            boolean _and = false;
            ActorClass _base = ac.getBase();
            boolean bl = _notEquals = !Objects.equal((Object)_base, null);
            if (!_notEquals) {
                _and = false;
            } else {
                ActorClass _base_1 = ac.getBase();
                boolean _overridesStop = this.overridesStop(_base_1);
                _and = _notEquals && _overridesStop;
            }
            _or = _exists || _and;
        }
        return _or;
    }

    public int getNumberOfInheritedStates(ActorClass ac) {
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            return 0;
        }
        ActorClass _base_1 = ac.getBase();
        StateGraph _stateMachine = _base_1.getStateMachine();
        List _stateList = RoomHelpers.getStateList((StateGraph)_stateMachine);
        int _size = _stateList.size();
        ActorClass _base_2 = ac.getBase();
        int _numberOfInheritedStates = this.getNumberOfInheritedStates(_base_2);
        return _size + _numberOfInheritedStates;
    }

    public int getNumberOfInheritedBaseStates(ActorClass ac) {
        ActorClass _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            return 0;
        }
        ActorClass _base_1 = ac.getBase();
        StateGraph _stateMachine = _base_1.getStateMachine();
        List _baseStateList = RoomHelpers.getBaseStateList((StateGraph)_stateMachine);
        int _size = _baseStateList.size();
        ActorClass _base_2 = ac.getBase();
        int _numberOfInheritedBaseStates = this.getNumberOfInheritedBaseStates(_base_2);
        return _size + _numberOfInheritedBaseStates;
    }

    public List<Transition> getOutgoingTransitionsHierarchical(ExpandedActorClass ac, State s) {
        ArrayList<Transition> _arrayList;
        ArrayList<Transition> result = _arrayList = new ArrayList<Transition>();
        EList _outgoingTransitions = ac.getOutgoingTransitions((StateGraphNode)s);
        result.addAll((Collection<Transition>)_outgoingTransitions);
        EObject _eContainer = s.eContainer();
        StateGraph sg = (StateGraph)_eContainer;
        EList _trPoints = sg.getTrPoints();
        for (TrPoint tp : _trPoints) {
            if (!(tp instanceof TransitionPoint)) continue;
            EList _outgoingTransitions_1 = ac.getOutgoingTransitions((StateGraphNode)tp);
            result.addAll((Collection<Transition>)_outgoingTransitions_1);
        }
        EObject _eContainer_1 = sg.eContainer();
        if (_eContainer_1 instanceof State) {
            EObject _eContainer_2 = sg.eContainer();
            List<Transition> _outgoingTransitionsHierarchical = this.getOutgoingTransitionsHierarchical(ac, (State)_eContainer_2);
            result.addAll(_outgoingTransitionsHierarchical);
        }
        return result;
    }

    public String getPortClassName(EObject p) {
        if (p instanceof Port) {
            return this._getPortClassName((Port)p);
        }
        if (p instanceof SAPRef) {
            return this._getPortClassName((SAPRef)p);
        }
        if (p instanceof SPPRef) {
            return this._getPortClassName((SPPRef)p);
        }
        if (p instanceof ExternalPort) {
            return this._getPortClassName((ExternalPort)p);
        }
        if (p instanceof ServiceImplementation) {
            return this._getPortClassName((ServiceImplementation)p);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(p).toString());
    }
}

