/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.inject.Inject;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.ITransitionChainVisitor;
import org.eclipse.etrice.core.genmodel.etricegen.TransitionChain;
import org.eclipse.etrice.core.room.CPBranchTransition;
import org.eclipse.etrice.core.room.ContinuationTransition;
import org.eclipse.etrice.core.room.GuardedTransition;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.base.CodegenHelpers;
import org.eclipse.etrice.generator.generic.ILanguageExtension;

public class TransitionChainVisitor
implements ITransitionChainVisitor {
    @Inject
    private ILanguageExtension langExt;
    private ExpandedActorClass xpac;
    private boolean dataDriven;

    protected TransitionChainVisitor(ExpandedActorClass xpac) {
        this.xpac = xpac;
    }

    protected void init(TransitionChain tc) {
        this.dataDriven = false;
        if (tc.getTransition() instanceof GuardedTransition) {
            this.dataDriven = true;
        } else if (tc.getTransition() instanceof InitialTransition) {
            this.dataDriven = true;
        }
    }

    public String genActionOperationCall(Transition tr) {
        if (tr.getAction() != null && !tr.getAction().getCommands().isEmpty()) {
            if (tr instanceof InitialTransition) {
                return String.valueOf(CodegenHelpers.getActionCodeOperationName(tr)) + "(" + this.langExt.selfPointer(false) + ");\n";
            }
            if (this.dataDriven) {
                return String.valueOf(CodegenHelpers.getActionCodeOperationName(tr)) + "(" + this.langExt.selfPointer(false) + ");\n";
            }
            String[] result = this.langExt.generateArglistAndTypedData(this.xpac.getData(tr));
            String dataArg = result[0];
            return String.valueOf(CodegenHelpers.getActionCodeOperationName(tr)) + "(" + this.langExt.selfPointer(true) + "ifitem" + dataArg + ");\n";
        }
        return "";
    }

    public String genEntryOperationCall(State state) {
        return String.valueOf(CodegenHelpers.getEntryCodeOperationName(state)) + "(" + this.langExt.selfPointer(false) + ");\n";
    }

    public String genExitOperationCall(State state) {
        return String.valueOf(CodegenHelpers.getExitCodeOperationName(state)) + "(" + this.langExt.selfPointer(false) + ");\n";
    }

    public String genElseIfBranch(CPBranchTransition tr, boolean isFirst) {
        String result = "";
        if (!isFirst) {
            result = "}\nelse ";
        }
        result = String.valueOf(result) + "if (" + AbstractGenerator.getInstance().getTranslatedCode(tr.getCondition()) + ") {\n";
        return result;
    }

    public String genElseBranch(ContinuationTransition tr) {
        String result = "}\nelse {\n";
        return result;
    }

    public String genEndIf() {
        return "}\n";
    }

    public String genReturnState(State state, boolean executeEntryCode) {
        if (executeEntryCode) {
            return "return " + CodegenHelpers.getGenStateId(state) + ";";
        }
        return "return " + CodegenHelpers.getGenStateId(state) + " + STATE_MAX;";
    }

    public String genTypedData(TransitionChain tc) {
        String[] result = this.langExt.generateArglistAndTypedData(tc.getData());
        return result[1];
    }
}

