/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.ChoicepointTerminal;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.EntryPoint;
import org.eclipse.etrice.core.room.ExitPoint;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateGraphNode;
import org.eclipse.etrice.core.room.StateTerminal;
import org.eclipse.etrice.core.room.SubStateTrPointTerminal;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.TrPointTerminal;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionTerminal;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.behavior.commands.StateGraphContext;
import org.eclipse.etrice.ui.behavior.support.ContextSwitcher;
import org.eclipse.etrice.ui.behavior.support.IPositionProvider;
import org.eclipse.etrice.ui.common.support.CommonSupportUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.ILinkService;

public class SupportUtil {
    private static final String INITIAL = "init";
    private static final String STATE = "state:";
    private static final String TP = "tp:";
    private static final String CP = "cp:";
    private static final String SEP = ".";

    public static EObject getOwnObject(EObject obj, ResourceSet rs) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        EObject own = rs.getEObject(uri, true);
        assert (own != null) : "own object must exist";
        return own;
    }

    public static boolean isInherited(StateGraphItem item, ContainerShape cs) {
        EObject container = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)cs);
        if (container instanceof StateGraph) {
            StateGraph sg = (StateGraph)container;
            return item.eContainer() != sg;
        }
        if (container instanceof State) {
            assert (item instanceof EntryPoint || item instanceof ExitPoint) : "this MUST be an entry or exit point";
            State s = (State)container;
            ContainerShape sCont = cs.getContainer();
            EObject cls = (EObject)sCont.getLink().getBusinessObjects().get(0);
            return s.eContainer() != cls;
        }
        return false;
    }

    public static boolean isInherited(Diagram diag, EObject obj) {
        return RoomHelpers.getActorClass((EObject)obj) != SupportUtil.getActorClass(diag);
    }

    public static boolean showAsInherited(Diagram diag, State obj) {
        if (obj instanceof RefinedState) {
            return true;
        }
        return RoomHelpers.getActorClass((StateGraphItem)obj) != SupportUtil.getActorClass(diag);
    }

    public static Diagram getDiagram(GraphicsAlgorithm ga) {
        if (ga.eContainer() instanceof GraphicsAlgorithm) {
            return SupportUtil.getDiagram((GraphicsAlgorithm)ga.eContainer());
        }
        return SupportUtil.getDiagram(ga.getPictogramElement());
    }

    public static Diagram getDiagram(PictogramElement pe) {
        while (pe.eContainer() != null) {
            if (pe.eContainer() instanceof Diagram) {
                return (Diagram)pe.eContainer();
            }
            pe = (PictogramElement)pe.eContainer();
        }
        return null;
    }

    public static ActorClass getActorClass(Diagram diag) {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diag);
        if (bo instanceof ActorClass) {
            return (ActorClass)bo;
        }
        return null;
    }

    public static StateGraph insertRefinedState(StateGraph sg, ActorClass ac, ContainerShape targetContainer, IFeatureProvider fp) {
        sg = SupportUtil.getSubGraphOfRefinedStateFor((State)sg.eContainer(), ac);
        fp.link((PictogramElement)targetContainer, (Object)sg);
        return sg;
    }

    public static void undoInsertRefinedState(StateGraph sg, ActorClass ac, ContainerShape targetContainer, IFeatureProvider fp) {
        RefinedState rs = (RefinedState)sg.eContainer();
        fp.link((PictogramElement)targetContainer, (Object)rs.getTarget().getSubgraph());
        if (!RoomHelpers.hasDetailCode((DetailCode)rs.getEntryCode()) && !RoomHelpers.hasDetailCode((DetailCode)rs.getExitCode())) {
            ac.getStateMachine().getStates().remove((Object)rs);
        }
    }

    public static StateGraph getSubGraphOfRefinedStateFor(State s, ActorClass ac) {
        RefinedState rs = SupportUtil.getRefinedStateFor(s, ac);
        if (rs.getSubgraph() == null) {
            rs.setSubgraph(RoomFactory.eINSTANCE.createStateGraph());
        }
        return rs.getSubgraph();
    }

    public static RefinedState getRefinedStateFor(State s, ActorClass ac) {
        HashMap<State, RefinedState> target2rs = new HashMap<State, RefinedState>();
        for (State st : ac.getStateMachine().getStates()) {
            if (!(st instanceof RefinedState)) continue;
            target2rs.put(((RefinedState)st).getTarget(), (RefinedState)st);
        }
        RefinedState rs = null;
        if (target2rs.containsKey(s)) {
            rs = (RefinedState)target2rs.get(s);
        } else {
            StateGraph sg = null;
            State parent = s;
            while (parent.eContainer().eContainer() instanceof State) {
                parent = (State)s.eContainer().eContainer();
                if (!target2rs.containsKey(parent)) continue;
                RefinedState bestFitting = (RefinedState)target2rs.get(parent);
                if (bestFitting.getSubgraph() == null) {
                    bestFitting.setSubgraph(RoomFactory.eINSTANCE.createStateGraph());
                }
                sg = bestFitting.getSubgraph();
                break;
            }
            if (sg == null) {
                sg = ac.getStateMachine();
            }
            rs = RoomFactory.eINSTANCE.createRefinedState();
            rs.setTarget(s);
            sg.getStates().add((Object)rs);
        }
        return rs;
    }

    public static State getTargettingState(State state, Diagram diagram) {
        ActorClass ac = SupportUtil.getActorClass(diagram);
        return RoomHelpers.getTargettingState((State)state, (ActorClass)ac);
    }

    public static ContainerShape getStateGraphContainer(ContainerShape shape) {
        while (shape != null) {
            ContainerShape parent = shape.getContainer();
            if (parent instanceof Diagram) {
                return shape;
            }
            shape = parent;
        }
        return null;
    }

    public static StateGraph getStateGraph(ContainerShape cs, IFeatureProvider fp) {
        ContainerShape shape = SupportUtil.getStateGraphContainer(cs);
        Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)shape);
        if (bo instanceof StateGraph) {
            return (StateGraph)bo;
        }
        assert (false) : "state graph expected";
        return null;
    }

    public static TransitionTerminal getTransitionTerminal(Anchor anchor, IFeatureProvider fp) {
        if (anchor != null) {
            Object obj = fp.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent());
            if (obj instanceof TrPoint) {
                Object parent = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)anchor.getParent().eContainer()));
                if (parent instanceof State) {
                    State state = parent instanceof RefinedState ? ((RefinedState)parent).getTarget() : (State)parent;
                    SubStateTrPointTerminal sstpt = RoomFactory.eINSTANCE.createSubStateTrPointTerminal();
                    sstpt.setState(state);
                    sstpt.setTrPoint((TrPoint)obj);
                    return sstpt;
                }
                TrPointTerminal tpt = RoomFactory.eINSTANCE.createTrPointTerminal();
                tpt.setTrPoint((TrPoint)obj);
                return tpt;
            }
            if (obj instanceof State) {
                State state = obj instanceof RefinedState ? ((RefinedState)obj).getTarget() : (State)obj;
                StateTerminal st = RoomFactory.eINSTANCE.createStateTerminal();
                st.setState(state);
                return st;
            }
            if (obj instanceof ChoicePoint) {
                ChoicepointTerminal ct = RoomFactory.eINSTANCE.createChoicepointTerminal();
                ct.setCp((ChoicePoint)obj);
                return ct;
            }
        }
        return null;
    }

    public static boolean isInitialPoint(Anchor anchor, IFeatureProvider fp) {
        Object parent;
        Object obj;
        return anchor != null && (obj = fp.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof StateGraph && (parent = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)anchor.getParent().eContainer()))) instanceof StateGraph;
    }

    public static boolean canConnect(Anchor asrc, Anchor atgt, ContainerShape cs, IFeatureProvider fp) {
        return SupportUtil.canConnect(asrc, atgt, null, cs, fp);
    }

    public static boolean canConnect(Anchor asrc, Anchor atgt, Transition trans, ContainerShape cs, IFeatureProvider fp) {
        TransitionTerminal src = SupportUtil.getTransitionTerminal(asrc, fp);
        TransitionTerminal tgt = SupportUtil.getTransitionTerminal(atgt, fp);
        if (src == null && !SupportUtil.isInitialPoint(asrc, fp)) {
            return false;
        }
        if (tgt == null) {
            return false;
        }
        StateGraph sg = SupportUtil.getStateGraph(cs, fp);
        if (sg == null) {
            return false;
        }
        return ValidationUtil.isConnectable((TransitionTerminal)src, (TransitionTerminal)tgt, (Transition)trans, (StateGraph)sg).isOk();
    }

    public static void deleteSubStructureRecursive(State s, ActorClass ac, Diagram diagram, IFeatureProvider fp) {
        if (RoomHelpers.hasSubStructure((State)s, (ActorClass)ac)) {
            StateGraph subgraph = s.getSubgraph();
            for (State st : subgraph.getStates()) {
                SupportUtil.deleteSubStructureRecursive(st, ac, diagram, fp);
            }
            ContainerShape subShape = ContextSwitcher.getContext(diagram, subgraph);
            CommonSupportUtil.deleteConnectionsRecursive((ContainerShape)subShape, (IFeatureProvider)fp);
            EcoreUtil.delete((EObject)subShape, (boolean)true);
        }
    }

    public static List<State> getStates(ContainerShape shape, IFeatureProvider fp) {
        return SupportUtil.getStates(shape, fp, null, null);
    }

    private static List<State> getStates(ContainerShape shape, IFeatureProvider fp, Map<String, Anchor> item2anchor, List<Shape> stateShapes) {
        ArrayList<State> items = new ArrayList<State>();
        for (Shape ch : shape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof State)) continue;
            items.add((State)bo);
            if (item2anchor != null) {
                item2anchor.put(SupportUtil.getKey((EObject)((State)bo)), (Anchor)ch.getAnchors().get(0));
            }
            if (stateShapes == null) continue;
            stateShapes.add(ch);
        }
        return items;
    }

    public static List<ChoicePoint> getChoicePoints(ContainerShape shape, IFeatureProvider fp) {
        return SupportUtil.getChoicePoints(shape, fp, null, null);
    }

    private static List<ChoicePoint> getChoicePoints(ContainerShape shape, IFeatureProvider fp, Map<String, Anchor> item2anchor, List<Shape> cpShapes) {
        ArrayList<ChoicePoint> items = new ArrayList<ChoicePoint>();
        for (Shape ch : shape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof ChoicePoint)) continue;
            items.add((ChoicePoint)bo);
            if (item2anchor != null) {
                item2anchor.put(SupportUtil.getKey((EObject)((ChoicePoint)bo)), (Anchor)ch.getAnchors().get(0));
            }
            if (cpShapes == null) continue;
            cpShapes.add(ch);
        }
        return items;
    }

    public static List<TrPoint> getTrPoints(StateGraph sg, ContainerShape shape, IFeatureProvider fp) {
        return SupportUtil.getTrPoints(sg, shape, fp, null, null);
    }

    private static List<TrPoint> getTrPoints(StateGraph sg, ContainerShape shape, IFeatureProvider fp, Map<String, Anchor> item2anchor, List<Shape> tpShapes) {
        ArrayList<TrPoint> items = new ArrayList<TrPoint>();
        for (Shape ch : shape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof TrPoint)) continue;
            items.add((TrPoint)bo);
            if (item2anchor != null) {
                item2anchor.put(SupportUtil.getKey((EObject)((TrPoint)bo)), (Anchor)ch.getAnchors().get(0));
            }
            if (tpShapes == null) continue;
            tpShapes.add(ch);
        }
        return items;
    }

    public static List<Transition> getTransitions(Diagram diagram, IFeatureProvider fp) {
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        for (Connection conn : diagram.getConnections()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)conn);
            if (!(bo instanceof Transition)) continue;
            transitions.add((Transition)bo);
        }
        return transitions;
    }

    private static Map<Transition, Connection> getTransitionsMap(ContainerShape sgShape, IFeatureProvider fp) {
        Diagram diagram = (Diagram)sgShape.eContainer();
        HashMap<Transition, Connection> transitions = new HashMap<Transition, Connection>();
        for (Connection conn : diagram.getConnections()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)conn);
            if (!(bo instanceof Transition) || !EcoreUtil.isAncestor((EObject)sgShape, (EObject)conn.getStart())) continue;
            transitions.put((Transition)bo, conn);
        }
        return transitions;
    }

    private static void getSubTpAnchors(ContainerShape sgShape, HashMap<String, Anchor> node2anchor) {
        for (Shape childShape : sgShape.getChildren()) {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)childShape);
            if (!(bo instanceof State)) continue;
            SupportUtil.getAnchors((State)bo, (PictogramElement)childShape, node2anchor);
        }
    }

    public static ContainerShape addStateGraph(StateGraphContext ctx, Diagram diagram, IFeatureProvider fp) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)ctx.getStateGraph());
        addContext.setTargetContainer((ContainerShape)diagram);
        IPositionProvider.PosAndSize graphPosAndSize = ctx.getPositionProvider().getGraphPosAndSize(ctx.getStateGraph());
        if (graphPosAndSize != null) {
            addContext.setX(graphPosAndSize.getX());
            addContext.setY(graphPosAndSize.getY());
            addContext.setWidth(graphPosAndSize.getWidth());
            addContext.setHeight(graphPosAndSize.getHeight());
        } else {
            addContext.setX(40);
            addContext.setY(40);
        }
        ContainerShape sgShape = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        if (sgShape == null) {
            return null;
        }
        HashMap<String, Anchor> node2anchor = new HashMap<String, Anchor>();
        GraphicsAlgorithm borderRect = (GraphicsAlgorithm)sgShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
        ctx.getPositionProvider().setScale(borderRect.getWidth(), borderRect.getHeight());
        SupportUtil.addInitialPointIff(ctx, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        SupportUtil.addStateGraphNodes(ctx.getTrPoints(), ctx.getPositionProvider(), sgShape, fp, node2anchor);
        SupportUtil.addStateGraphNodes(ctx.getStates(), ctx.getPositionProvider(), sgShape, fp, node2anchor);
        SupportUtil.addStateGraphNodes(ctx.getChPoints(), ctx.getPositionProvider(), sgShape, fp, node2anchor);
        for (StateGraphContext sub : ctx.getChildren()) {
            SupportUtil.addStateGraph(sub, diagram, fp);
        }
        SupportUtil.getSubTpAnchors(sgShape, node2anchor);
        SupportUtil.addTransitions(ctx.getTransitions(), ctx.getPositionProvider(), sgShape, fp, node2anchor);
        return sgShape;
    }

    private static void addInitialPointIff(StateGraphContext ctx, IPositionProvider positionProvider, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        StateGraph sg = ctx.getInitialPoint();
        if (sg == null) {
            sg = positionProvider.getInitialPoint(ctx.getStateGraph());
        }
        if (sg == null) {
            return;
        }
        IPositionProvider.PosAndSize pos = positionProvider.getPosition(sg);
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)sg);
        addContext.setTargetContainer(sgShape);
        if (pos != null) {
            addContext.setX(pos.getX());
            addContext.setY(pos.getY());
            if (pos.getWidth() > 0 && pos.getHeight() > 0) {
                addContext.setWidth(pos.getWidth());
                addContext.setHeight(pos.getHeight());
            }
        } else {
            addContext.setX(120);
            addContext.setY(120);
        }
        ContainerShape pe = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        assert (pe != null) : "initial point should have been created";
        assert (!pe.getAnchors().isEmpty()) : "initial point should have an anchor";
        node2anchor.put(INITIAL, (Anchor)pe.getAnchors().get(0));
    }

    public static void updateStateGraph(StateGraph sg, StateGraphContext ctx, ContainerShape sgShape, IFeatureProvider fp) {
        Object expected;
        State item;
        HashMap<String, Anchor> node2anchor = new HashMap<String, Anchor>();
        GraphicsAlgorithm borderRect = (GraphicsAlgorithm)sgShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
        ctx.getPositionProvider().setScale(borderRect.getWidth(), borderRect.getHeight());
        ArrayList<Object> shapes = new ArrayList<Shape>();
        List<State> present = SupportUtil.getStates(sgShape, fp, node2anchor, shapes);
        SupportUtil.checkDuplicates(present);
        Object expected2 = ctx.getStates();
        ArrayList<State> toAdd = new ArrayList<State>();
        ArrayList<State> toUpdate = new ArrayList<State>();
        Iterator iterator = expected2.iterator();
        while (iterator.hasNext()) {
            item = (State)iterator.next();
            if (present.contains(item)) {
                toUpdate.add(item);
                continue;
            }
            toAdd.add(item);
        }
        SupportUtil.addStateGraphNodes(toAdd, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        SupportUtil.updateStateGraphNodes(toUpdate, shapes, ctx.getPositionProvider(), fp);
        shapes = new ArrayList();
        present = SupportUtil.getTrPoints(sg, sgShape, fp, node2anchor, shapes);
        SupportUtil.checkDuplicates(present);
        expected2 = ctx.getTrPoints();
        toAdd = new ArrayList();
        toUpdate = new ArrayList();
        iterator = expected2.iterator();
        while (iterator.hasNext()) {
            item = (TrPoint)iterator.next();
            if (present.contains(item)) {
                toUpdate.add(item);
                continue;
            }
            toAdd.add(item);
        }
        SupportUtil.addStateGraphNodes(toAdd, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        SupportUtil.updateStateGraphNodes(toUpdate, shapes, ctx.getPositionProvider(), fp);
        shapes = new ArrayList();
        present = SupportUtil.getChoicePoints(sgShape, fp, node2anchor, shapes);
        SupportUtil.checkDuplicates(present);
        expected2 = ctx.getChPoints();
        toAdd = new ArrayList();
        toUpdate = new ArrayList();
        iterator = expected2.iterator();
        while (iterator.hasNext()) {
            item = (ChoicePoint)iterator.next();
            if (present.contains(item)) {
                toUpdate.add(item);
                continue;
            }
            toAdd.add(item);
        }
        SupportUtil.addStateGraphNodes(toAdd, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        SupportUtil.updateStateGraphNodes(toUpdate, shapes, ctx.getPositionProvider(), fp);
        SupportUtil.getSubTpAnchors(sgShape, node2anchor);
        Object present2 = null;
        for (Shape ch : sgShape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof StateGraph)) continue;
            present2 = ch;
        }
        if (present2 != null) {
            node2anchor.put(INITIAL, (Anchor)present2.getAnchors().get(0));
        }
        if ((expected = ctx.getInitialPoint()) == null) {
            expected = ctx.getPositionProvider().getInitialPoint(ctx.getStateGraph());
        }
        if (expected != null && present2 == null) {
            SupportUtil.addInitialPointIff(ctx, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        } else {
            SupportUtil.updateInitialPoint((Shape)present2, ctx.getPositionProvider(), fp);
        }
        present2 = SupportUtil.getTransitionsMap(sgShape, fp);
        expected = ctx.getTransitions();
        ArrayList<Transition> toAdd2 = new ArrayList<Transition>();
        Iterator iterator2 = expected.iterator();
        while (iterator2.hasNext()) {
            Transition trans = (Transition)iterator2.next();
            if (present2.containsKey(trans)) continue;
            toAdd2.add(trans);
        }
        SupportUtil.addTransitions(toAdd2, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        SupportUtil.updateTransitions((Map<Transition, Connection>)present2, ctx.getPositionProvider(), sgShape, fp, node2anchor);
    }

    private static void checkDuplicates(List<? extends StateGraphItem> items) {
        for (StateGraphItem stateGraphItem : items) {
            if (items.indexOf(stateGraphItem) == items.lastIndexOf(stateGraphItem)) continue;
            Assert.isTrue((items.indexOf(stateGraphItem) == items.lastIndexOf(stateGraphItem) ? 1 : 0) != 0, (String)("multiple occurrences of " + RoomNameProvider.getFullPath((StateGraphItem)stateGraphItem)));
        }
    }

    private static void addTransitions(List<Transition> transitions, IPositionProvider positionProvider, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        for (Transition trans : transitions) {
            String from = trans instanceof InitialTransition ? INITIAL : SupportUtil.getKey((EObject)((NonInitialTransition)trans).getFrom());
            String to = SupportUtil.getKey((EObject)trans.getTo());
            Anchor src = node2anchor.get(from);
            Anchor dst = node2anchor.get(to);
            assert (src != null && dst != null) : "transition endpoints must be present";
            AddConnectionContext context = new AddConnectionContext(src, dst);
            context.setNewObject((Object)trans);
            PictogramElement pe = fp.addIfPossible((IAddContext)context);
            if (!(pe instanceof FreeFormConnection)) continue;
            FreeFormConnection conn = (FreeFormConnection)pe;
            conn.getBendpoints().clear();
            List<IPositionProvider.Pos> points = positionProvider.getPoints(trans);
            if (points != null && !points.isEmpty()) {
                Iterator<IPositionProvider.Pos> it = points.iterator();
                IPositionProvider.Pos pos = it.next();
                ConnectionDecorator cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1);
                Graphiti.getGaService().setLocation(cd.getGraphicsAlgorithm(), pos.getX(), pos.getY());
                while (it.hasNext()) {
                    pos = it.next();
                    Point pt = Graphiti.getGaService().createPoint(pos.getX(), pos.getY());
                    conn.getBendpoints().add((Object)pt);
                }
                continue;
            }
            if (src != dst) continue;
            ILocation begin = Graphiti.getPeService().getLocationRelativeToDiagram(conn.getStart());
            Point pt = Graphiti.getGaService().createPoint(begin.getX(), begin.getY() + 120);
            conn.getBendpoints().add((Object)pt);
        }
    }

    private static void addStateGraphNodes(List<? extends StateGraphNode> nodes, IPositionProvider positionProvider, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        List<IPositionProvider.PosAndSize> positions = positionProvider.getPositions(nodes);
        int idx = 0;
        for (StateGraphNode stateGraphNode : nodes) {
            SupportUtil.addStateGraphNode(stateGraphNode, sgShape, positions.get(idx), fp, node2anchor);
            ++idx;
        }
    }

    private static void addStateGraphNode(StateGraphNode tp, ContainerShape sgShape, IPositionProvider.PosAndSize pos, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)tp);
        addContext.setTargetContainer(sgShape);
        addContext.setX(pos.getX());
        addContext.setY(pos.getY());
        if (pos.getWidth() > 0 && pos.getHeight() > 0) {
            addContext.setWidth(pos.getWidth());
            addContext.setHeight(pos.getHeight());
        }
        ContainerShape pe = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        assert (pe != null) : String.valueOf(tp.eClass().getName()) + " should have been created";
        assert (!pe.getAnchors().isEmpty()) : String.valueOf(tp.eClass().getName()) + " should have an anchor";
        node2anchor.put(SupportUtil.getKey((EObject)tp), (Anchor)pe.getAnchors().get(0));
    }

    private static void updateInitialPoint(Shape shape, IPositionProvider positionProvider, IFeatureProvider fp) {
        if (shape == null) {
            return;
        }
        StateGraph sg = (StateGraph)fp.getBusinessObjectForPictogramElement((PictogramElement)shape);
        IPositionProvider.PosAndSize ps = positionProvider.getPosition(sg);
        if (ps == null) {
            return;
        }
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        Graphiti.getLayoutService().setLocationAndSize(ga, ps.getX(), ps.getY(), ps.getWidth(), ps.getHeight());
        LayoutContext lc = new LayoutContext((PictogramElement)shape);
        fp.layoutIfPossible((ILayoutContext)lc);
    }

    private static void updateStateGraphNodes(List<? extends StateGraphNode> nodes, List<Shape> shapes, IPositionProvider positionProvider, IFeatureProvider fp) {
        ILinkService linkService = Graphiti.getLinkService();
        IGaService gaService = Graphiti.getGaService();
        block0: for (StateGraphNode stateGraphNode : nodes) {
            IPositionProvider.PosAndSize ps = positionProvider.getPosition(stateGraphNode);
            if (ps == null) continue;
            for (Shape shape : shapes) {
                EObject bo = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)shape);
                if (bo != stateGraphNode) continue;
                GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
                int margin = 0;
                if (stateGraphNode instanceof State) {
                    margin = 30;
                } else if (stateGraphNode instanceof TrPoint) {
                    margin = 40;
                }
                gaService.setLocationAndSize(ga, ps.getX() - margin, ps.getY() - margin, ps.getWidth() + 2 * margin, ps.getHeight() + 2 * margin);
                LayoutContext lc = new LayoutContext((PictogramElement)shape);
                fp.layoutIfPossible((ILayoutContext)lc);
                continue block0;
            }
        }
    }

    private static void updateTransitions(Map<Transition, Connection> transitions, IPositionProvider positionProvider, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        for (Map.Entry<Transition, Connection> e : transitions.entrySet()) {
            Transition trans = e.getKey();
            Connection conn = e.getValue();
            String from = trans instanceof InitialTransition ? INITIAL : SupportUtil.getKey((EObject)((NonInitialTransition)trans).getFrom());
            String to = SupportUtil.getKey((EObject)trans.getTo());
            Anchor newSrc = node2anchor.get(from);
            Anchor newDst = node2anchor.get(to);
            assert (newSrc != null && newDst != null) : "transition endpoints must be present";
            if (conn.getStart() != newSrc) {
                conn.setStart(newSrc);
            }
            if (conn.getEnd() != newDst) {
                conn.setEnd(newDst);
            }
            List<IPositionProvider.Pos> points = positionProvider.getPoints(trans);
            Iterator<IPositionProvider.Pos> it = points.iterator();
            if (points == null || points.isEmpty()) continue;
            IPositionProvider.Pos pos = it.next();
            ConnectionDecorator cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1);
            Graphiti.getGaService().setLocation(cd.getGraphicsAlgorithm(), pos.getX(), pos.getY());
            if (!(conn instanceof FreeFormConnection)) continue;
            FreeFormConnection fconn = (FreeFormConnection)conn;
            fconn.getBendpoints().clear();
            ArrayList<Point> bendpoints = new ArrayList<Point>();
            while (it.hasNext()) {
                pos = it.next();
                Point pt = Graphiti.getGaService().createPoint(pos.getX(), pos.getY());
                bendpoints.add(pt);
            }
            fconn.getBendpoints().addAll(bendpoints);
        }
    }

    private static void getAnchors(State state, PictogramElement stateShape, HashMap<String, Anchor> node2anchor) {
        if (stateShape instanceof ContainerShape) {
            node2anchor.put(SupportUtil.getKey((EObject)state), (Anchor)((ContainerShape)stateShape).getAnchors().get(0));
            for (Shape child : ((ContainerShape)stateShape).getChildren()) {
                EObject obj;
                ContainerShape childShape;
                if (!(child instanceof ContainerShape) || (childShape = (ContainerShape)child).getAnchors().isEmpty() || childShape.getLink().getBusinessObjects().isEmpty() || !((obj = (EObject)childShape.getLink().getBusinessObjects().get(0)) instanceof EntryPoint) && !(obj instanceof ExitPoint)) continue;
                node2anchor.put(SupportUtil.getKey(obj, true), (Anchor)childShape.getAnchors().get(0));
            }
        }
    }

    private static String getKey(EObject obj) {
        return SupportUtil.getKey(obj, false);
    }

    private static String getKey(EObject obj, boolean subTp) {
        if (obj instanceof TrPoint) {
            TrPoint tp = (TrPoint)obj;
            if (!subTp) {
                return TP + tp.getName();
            }
            if (tp.eContainer().eContainer() instanceof State) {
                State s = (State)tp.eContainer().eContainer();
                return TP + tp.getName() + SEP + s.getName();
            }
            assert (false) : "State expected";
        } else {
            if (obj instanceof State) {
                return STATE + ((State)obj).getName();
            }
            if (obj instanceof ChoicePoint) {
                return CP + ((ChoicePoint)obj).getName();
            }
            if (obj instanceof TransitionTerminal) {
                TransitionTerminal tt = (TransitionTerminal)obj;
                if (tt instanceof ChoicepointTerminal) {
                    return CP + ((ChoicepointTerminal)tt).getCp().getName();
                }
                if (tt instanceof StateTerminal) {
                    return STATE + ((StateTerminal)tt).getState().getName();
                }
                if (tt instanceof SubStateTrPointTerminal) {
                    SubStateTrPointTerminal sstt = (SubStateTrPointTerminal)tt;
                    return TP + sstt.getTrPoint().getName() + SEP + sstt.getState().getName();
                }
                if (tt instanceof TrPointTerminal) {
                    return TP + ((TrPointTerminal)tt).getTrPoint().getName();
                }
                assert (false) : "unexpected sub type";
            }
        }
        assert (false) : "unexpected type";
        return null;
    }
}

