/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.layout.preferences;

import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.KimlUiPlugin;
import de.cau.cs.kieler.kiml.ui.LayoutOptionValidator;
import de.cau.cs.kieler.kiml.ui.LayouterHintDialog;
import de.cau.cs.kieler.kiml.ui.Messages;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutDataService;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;

public final class ETricePreferenceUtil {
    public static final int OPTIONS_TABLE_HEIGHT = 300;

    private ETricePreferenceUtil() {
    }

    public static OptionsTableProvider.DataEntry getEntry(List<OptionsTableProvider.DataEntry> entries, int index) {
        ListIterator<OptionsTableProvider.DataEntry> entryIter = entries.listIterator();
        int i = 0;
        while (entryIter.hasNext()) {
            OptionsTableProvider.DataEntry entry = entryIter.next();
            if (entry.getValue() == null) continue;
            if (i == index) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public static void showEditDialog(Shell shell, OptionsTableProvider.DataEntry entry) {
        LayoutOptionData<?> optionData = entry.getOptionData();
        if (entry.getValue() != null) {
            if (optionData.equals((Object)LayoutOptions.ALGORITHM)) {
                String result;
                LayouterHintDialog dialog = new LayouterHintDialog(shell, null);
                if (dialog.open() == 0 && (result = dialog.getSelectedHint()) != null) {
                    entry.setValue(result);
                }
            } else {
                String value = entry.getValue().toString();
                InputDialog dialog = new InputDialog(shell, Messages.getString((String)"kiml.ui.23"), Messages.getString((String)"kiml.ui.24"), value, (IInputValidator)new LayoutOptionValidator(optionData));
                if (dialog.open() == 0) {
                    String result = dialog.getValue().trim();
                    switch (optionData.getType()) {
                        case ENUM: 
                        case REMOTE_ENUM: {
                            entry.setValue(optionData.parseValue(result.toUpperCase()));
                            break;
                        }
                        default: {
                            entry.setValue(optionData.parseValue(result));
                        }
                    }
                }
            }
        }
    }

    public static enum ElementType {
        EDIT_PART,
        MODEL_ELEM,
        DIAG_TYPE;


        public String getDescription() {
            switch (this) {
                case EDIT_PART: {
                    return Messages.getString((String)"kiml.ui.54");
                }
                case MODEL_ELEM: {
                    return Messages.getString((String)"kiml.ui.55");
                }
                case DIAG_TYPE: {
                    return Messages.getString((String)"kiml.ui.56");
                }
            }
            return null;
        }
    }

    public static class NewOptionDialog
    extends Dialog {
        private ElementType elementType;
        private Text elementText;
        private String elementValue;
        private Button elementBrowseButton;
        private Text optionText;
        private String optionValue;
        private static final int HORIZONTAL_GAP = 8;
        private static final int MINIMUM_WIDTH = 500;

        protected NewOptionDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.getString((String)"kiml.ui.46"));
        }

        public boolean close() {
            this.elementValue = this.elementText.getText();
            this.optionValue = this.optionText.getText();
            return super.close();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createTypeGroup(composite);
            this.createElementGroup(composite);
            this.createOptionGroup(composite);
            return composite;
        }

        protected void createTypeGroup(Composite parent) {
            Group group = new Group(parent, 0);
            group.setText(Messages.getString((String)"kiml.ui.42"));
            GridLayout layout = new GridLayout(1, false);
            layout.horizontalSpacing = 8;
            group.setLayout((Layout)layout);
            String[][] labelsAndValues = new String[][]{{Messages.getString((String)"kiml.ui.43"), ElementType.EDIT_PART.toString()}, {Messages.getString((String)"kiml.ui.44"), ElementType.MODEL_ELEM.toString()}, {Messages.getString((String)"kiml.ui.45"), ElementType.DIAG_TYPE.toString()}};
            int i = 0;
            while (i < labelsAndValues.length) {
                Button radio = new Button((Composite)group, 16400);
                radio.setSelection(i == 0);
                String[] labelAndValue = labelsAndValues[i];
                radio.setText(labelAndValue[0]);
                radio.setData((Object)labelAndValue[1]);
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        NewOptionDialog.this.elementType = ElementType.valueOf((String)event.widget.getData());
                        NewOptionDialog.this.elementBrowseButton.setEnabled(NewOptionDialog.this.elementType == ElementType.DIAG_TYPE || NewOptionDialog.this.elementType == ElementType.MODEL_ELEM);
                    }
                });
                ++i;
            }
            this.elementType = ElementType.EDIT_PART;
            GridData gridData = new GridData(4, 128, true, false);
            gridData.minimumWidth = 500;
            group.setLayoutData((Object)gridData);
        }

        protected void createElementGroup(Composite parent) {
            Group group = new Group(parent, 0);
            group.setText(Messages.getString((String)"kiml.ui.47"));
            group.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label((Composite)group, 64);
            label.setText(Messages.getString((String)"kiml.ui.53"));
            GridData labelLayoutData = new GridData(16384, 4, false, false, 2, 1);
            labelLayoutData.widthHint = 492;
            label.setLayoutData((Object)labelLayoutData);
            this.elementText = new Text((Composite)group, 2052);
            this.elementText.setLayoutData((Object)new GridData(4, 128, true, false));
            this.elementBrowseButton = new Button((Composite)group, 0x1000008);
            this.elementBrowseButton.setEnabled(false);
            this.elementBrowseButton.setText(Messages.getString((String)"kiml.ui.48"));
            this.elementBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String id;
                    String string = id = NewOptionDialog.this.elementType == ElementType.DIAG_TYPE ? NewOptionDialog.this.showBrowseDiagtDialog() : NewOptionDialog.this.showBrowseModelElementDialog();
                    if (id != null) {
                        NewOptionDialog.this.elementText.setText(id);
                    }
                }
            });
            GridData gridData = new GridData(4, 128, true, false);
            gridData.minimumWidth = 500;
            group.setLayoutData((Object)gridData);
        }

        protected void createOptionGroup(Composite parent) {
            Group group = new Group(parent, 0);
            group.setText(Messages.getString((String)"kiml.ui.49"));
            group.setLayout((Layout)new GridLayout(2, false));
            this.optionText = new Text((Composite)group, 2052);
            this.optionText.setLayoutData((Object)new GridData(4, 128, true, false));
            Button browseButton = new Button((Composite)group, 0x1000008);
            browseButton.setText(Messages.getString((String)"kiml.ui.48"));
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String id = NewOptionDialog.this.showBrowseOptionDialog();
                    if (id != null) {
                        NewOptionDialog.this.optionText.setText(id);
                    }
                }
            });
            GridData gridData = new GridData(4, 128, true, false);
            gridData.minimumWidth = 500;
            group.setLayoutData((Object)gridData);
        }

        protected String showBrowseDiagtDialog() {
            Object[] result;
            ListDialog dialog = new ListDialog(this.getShell());
            dialog.setTitle(Messages.getString((String)"kiml.ui.57"));
            dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            dialog.setLabelProvider((ILabelProvider)new LabelProvider());
            List diagramTypes = EclipseLayoutInfoService.getInstance().getDiagramTypes();
            Object[] input = new SelectionData[diagramTypes.size()];
            int i = 0;
            for (Pair type : diagramTypes) {
                SelectionData seld = new SelectionData((Pair<String, String>)type);
                input[i++] = seld;
            }
            Arrays.sort(input);
            dialog.setInput((Object)input);
            if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
                return ((SelectionData)result[0]).id;
            }
            return null;
        }

        protected String showBrowseModelElementDialog() {
            return "null";
        }

        protected String showBrowseOptionDialog() {
            Object[] result;
            ListDialog dialog = new ListDialog(this.getShell());
            dialog.setTitle(Messages.getString((String)"kiml.ui.50"));
            dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    if (element instanceof SelectionData) {
                        KimlUiPlugin.Images images = KimlUiPlugin.getDefault().getImages();
                        switch (((SelectionData)element).type) {
                            case STRING: 
                            case OBJECT: {
                                return images.getPropText();
                            }
                            case BOOLEAN: {
                                return images.getPropTrue();
                            }
                            case ENUM: 
                            case REMOTE_ENUM: {
                                return images.getPropChoice();
                            }
                            case INT: {
                                return images.getPropInt();
                            }
                            case FLOAT: {
                                return images.getPropFloat();
                            }
                        }
                    }
                    return null;
                }
            });
            Collection data = EclipseLayoutDataService.getInstance().getOptionData();
            ArrayList<SelectionData> inputList = new ArrayList<SelectionData>(data.size());
            for (LayoutOptionData optionData : data) {
                if (optionData.getTargets().isEmpty()) continue;
                inputList.add(new SelectionData(optionData));
            }
            Object[] input = inputList.toArray(new SelectionData[0]);
            Arrays.sort(input);
            dialog.setInput((Object)input);
            if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
                return ((SelectionData)result[0]).id;
            }
            return null;
        }

        public OptionsTableProvider.DataEntry createDataEntry() {
            if (this.elementValue != null && this.optionValue != null) {
                String name;
                if (this.elementType == ElementType.DIAG_TYPE) {
                    name = EclipseLayoutInfoService.getInstance().getDiagramTypeName(this.elementValue);
                } else {
                    int dotIndex = this.elementValue.lastIndexOf(46);
                    name = this.elementValue.substring(dotIndex + 1);
                }
                LayoutOptionData optionData = LayoutDataService.getInstance().getOptionData(this.optionValue);
                if (optionData != null) {
                    Object value = optionData.getDefault();
                    if (value == null) {
                        value = optionData.getDefaultDefault();
                    }
                    if (name != null && value != null) {
                        return new OptionsTableProvider.DataEntry(name, this.elementValue, this.elementType, optionData, value);
                    }
                }
            }
            return null;
        }

        protected static final class SelectionData
        implements Comparable<SelectionData> {
            private String id;
            private String name;
            private LayoutOptionData.Type type;

            public String getId() {
                return this.id;
            }

            public SelectionData(LayoutOptionData<?> optionData) {
                this.id = optionData.getId();
                this.name = optionData.getName();
                this.type = optionData.getType();
            }

            public SelectionData(Pair<String, String> diagramType) {
                this.id = (String)diagramType.getFirst();
                this.name = (String)diagramType.getSecond();
            }

            public boolean equals(Object object) {
                if (object instanceof SelectionData) {
                    SelectionData other = (SelectionData)object;
                    return this.id.equals(other.id) && this.name.equals(other.name);
                }
                return false;
            }

            public int hashCode() {
                return this.id.hashCode() + this.name.hashCode();
            }

            public String toString() {
                return String.valueOf(this.name) + " (" + this.id + ")";
            }

            @Override
            public int compareTo(SelectionData other) {
                int nameComp = this.name.compareTo(other.name);
                if (nameComp == 0) {
                    return this.id.compareTo(other.id);
                }
                return nameComp;
            }
        }
    }

    public static class OptionsTableProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        private static final int COL_ELEMENT = 0;
        private static final int COL_TYPE = 1;
        private static final int COL_OPTION = 2;
        private static final int COL_VALUE = 3;

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof DataEntry && columnIndex == 3) {
                DataEntry entry = (DataEntry)element;
                KimlUiPlugin.Images images = KimlUiPlugin.getDefault().getImages();
                switch (entry.optionData.getType()) {
                    case STRING: {
                        return images.getPropText();
                    }
                    case BOOLEAN: {
                        if (((Boolean)entry.value).booleanValue()) {
                            return images.getPropTrue();
                        }
                        return images.getPropFalse();
                    }
                    case ENUM: 
                    case REMOTE_ENUM: {
                        return images.getPropChoice();
                    }
                    case INT: {
                        return images.getPropInt();
                    }
                    case FLOAT: {
                        return images.getPropFloat();
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof DataEntry) {
                DataEntry entry = (DataEntry)element;
                switch (columnIndex) {
                    case 0: {
                        return entry.elementName;
                    }
                    case 1: {
                        return entry.type.getDescription();
                    }
                    case 2: {
                        return entry.optionData.getName();
                    }
                    case 3: {
                        if (entry.optionData.getType() == LayoutOptionData.Type.ENUM && entry.value instanceof Integer) {
                            return entry.optionData.getEnumValue(((Integer)entry.value).intValue()).toString();
                        }
                        return entry.value.toString();
                    }
                }
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                ArrayList list = new ArrayList((List)inputElement);
                ListIterator listIter = list.listIterator();
                while (listIter.hasNext()) {
                    DataEntry next = (DataEntry)listIter.next();
                    if (next.value != null) continue;
                    listIter.remove();
                }
                return list.toArray();
            }
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public static class DataEntry {
            private String elementName;
            private String elementId;
            private ElementType type;
            private LayoutOptionData<?> optionData;
            private Object value;

            public DataEntry(String name, String id, ElementType thetype, LayoutOptionData<?> theoptionData, Object thevalue) {
                this.elementName = name;
                this.elementId = id;
                this.type = thetype;
                this.optionData = theoptionData;
                this.value = thevalue;
            }

            public String getElementName() {
                return this.elementName;
            }

            public String getElementId() {
                return this.elementId;
            }

            public ElementType getType() {
                return this.type;
            }

            public LayoutOptionData<?> getOptionData() {
                return this.optionData;
            }

            public Object getValue() {
                return this.value;
            }

            public void setValue(Object thevalue) {
                this.value = thevalue;
            }

            public boolean equals(Object object) {
                if (object instanceof DataEntry) {
                    DataEntry other = (DataEntry)object;
                    return this.elementId.equals(other.elementId) && this.optionData.equals(other.optionData);
                }
                return false;
            }

            public int hashCode() {
                return this.elementId.hashCode() + this.optionData.hashCode();
            }
        }
    }
}

